/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeAction;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OptimizeImportsAction
extends AnAction {
    @NonNls
    private static final String HELP_ID = "editing.manageImports";
    private static boolean myProcessVcsChangedFilesInTests;

    public OptimizeImportsAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            OptimizeImportsAction.$$$reportNull$$$0(0);
        }
        OptimizeImportsAction.actionPerformedImpl(event.getDataContext());
    }

    public static void actionPerformedImpl(@NotNull DataContext dataContext2) {
        PsiDirectory dir;
        Project project2;
        if (dataContext2 == null) {
            OptimizeImportsAction.$$$reportNull$$$0(1);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2)) == null) {
            return;
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        Editor editor2 = BaseCodeInsightAction.getInjectedEditor(project2, (Editor)CommonDataKeys.EDITOR.getData(dataContext2));
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext2);
        PsiFile file2 = null;
        if (editor2 != null) {
            file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
            if (file2 == null) {
                return;
            }
            dir = file2.getContainingDirectory();
        } else {
            if (files2 != null && ReformatCodeAction.containsOnlyFiles(files2)) {
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance(project2).ensureFilesWritable(Arrays.asList(files2));
                if (!operationStatus.hasReadonlyFiles()) {
                    new OptimizeImportsProcessor(project2, ReformatCodeAction.convertToPsiFiles(files2, project2), null).run();
                }
                return;
            }
            Project projectContext = (Project)PlatformCoreDataKeys.PROJECT_CONTEXT.getData(dataContext2);
            Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext2);
            if (projectContext != null || moduleContext != null) {
                boolean hasChanges;
                String text2;
                if (moduleContext != null) {
                    text2 = CodeInsightBundle.message("process.scope.module", moduleContext.getName());
                    hasChanges = VcsFacade.getInstance().hasChanges(moduleContext);
                } else {
                    text2 = CodeInsightBundle.message("process.scope.project", projectContext.getPresentableUrl());
                    hasChanges = VcsFacade.getInstance().hasChanges(projectContext);
                }
                Boolean isProcessVcsChangedText = OptimizeImportsAction.isProcessVcsChangedText(project2, text2, hasChanges);
                if (isProcessVcsChangedText == null) {
                    return;
                }
                if (moduleContext != null) {
                    OptimizeImportsProcessor processor = new OptimizeImportsProcessor(project2, moduleContext);
                    processor.setProcessChangedTextOnly(isProcessVcsChangedText);
                    processor.run();
                } else {
                    new OptimizeImportsProcessor(projectContext).run();
                }
                return;
            }
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
            if (element == null) {
                return;
            }
            if (element instanceof PsiDirectoryContainer) {
                dir = ArrayUtil.getFirstElement(((PsiDirectoryContainer)element).getDirectories());
            } else if (element instanceof PsiDirectory) {
                dir = (PsiDirectory)element;
            } else {
                file2 = element.getContainingFile();
                if (file2 == null) {
                    return;
                }
                dir = file2.getContainingDirectory();
            }
        }
        boolean processDirectory = false;
        boolean processOnlyVcsChangedFiles = false;
        if (!ApplicationManager.getApplication().isUnitTestMode() && file2 == null && dir != null) {
            String message = CodeInsightBundle.message("process.scope.directory", dir.getName());
            OptimizeImportsDialog dialog = new OptimizeImportsDialog(project2, message, VcsFacade.getInstance().hasChanges(dir));
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            processDirectory = true;
            processOnlyVcsChangedFiles = dialog.isProcessOnlyVcsChangedFiles();
        }
        if (processDirectory) {
            new OptimizeImportsProcessor(project2, dir, true, processOnlyVcsChangedFiles).run();
        } else {
            OptimizeImportsProcessor optimizer = new OptimizeImportsProcessor(project2, file2);
            if (editor2 != null && EditorSettingsExternalizable.getInstance().isShowNotificationAfterOptimizeImports()) {
                optimizer.setCollectInfo(true);
                optimizer.setPostRunnable(() -> {
                    LayoutCodeInfoCollector collector2 = optimizer.getInfoCollector();
                    if (collector2 != null) {
                        String info2 = collector2.getOptimizeImportsNotification();
                        if (!editor2.isDisposed() && UIUtil.isShowing(editor2.getContentComponent())) {
                            String message = info2 != null ? info2 : CodeInsightBundle.message("hint.text.no.unused.imports.found", new Object[0]);
                            FileInEditorProcessor.showHint(editor2, message, null);
                        }
                    }
                });
            }
            optimizer.run();
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OptimizeImportsAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            OptimizeImportsAction.$$$reportNull$$$0(3);
        }
        if (!LanguageImportStatements.INSTANCE.hasAnyExtensions()) {
            event.getPresentation().setVisible(false);
            return;
        }
        Presentation presentation2 = event.getPresentation();
        boolean available = OptimizeImportsAction.isActionAvailable(event);
        if (event.isFromContextMenu()) {
            presentation2.setEnabledAndVisible(available);
        } else {
            presentation2.setEnabled(available);
        }
    }

    private static boolean isActionAvailable(@NotNull AnActionEvent event) {
        DataContext dataContext2;
        Project project2;
        if (event == null) {
            OptimizeImportsAction.$$$reportNull$$$0(4);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2 = event.getDataContext())) == null) {
            return false;
        }
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext2);
        Editor editor2 = BaseCodeInsightAction.getInjectedEditor(project2, (Editor)CommonDataKeys.EDITOR.getData(dataContext2), false);
        if (editor2 != null) {
            PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
            if (file2 == null || !OptimizeImportsAction.isOptimizeImportsAvailable(file2)) {
                return false;
            }
        } else if (files2 != null && ReformatCodeAction.containsOnlyFiles(files2)) {
            boolean anyHasOptimizeImports = false;
            for (VirtualFile virtualFile2 : files2) {
                PsiFile file3 = PsiManager.getInstance(project2).findFile(virtualFile2);
                if (file3 == null) {
                    return false;
                }
                if (!OptimizeImportsAction.isOptimizeImportsAvailable(file3)) continue;
                anyHasOptimizeImports = true;
                break;
            }
            if (!anyHasOptimizeImports) {
                return false;
            }
        } else if ((files2 == null || files2.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(dataContext2) == null && PlatformCoreDataKeys.PROJECT_CONTEXT.getData(dataContext2) == null) {
            PsiFile file4;
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
            if (element == null) {
                return false;
            }
            if (!(element instanceof PsiDirectory || (file4 = element.getContainingFile()) != null && OptimizeImportsAction.isOptimizeImportsAvailable(file4))) {
                return false;
            }
        }
        return true;
    }

    private static boolean isOptimizeImportsAvailable(@NotNull PsiFile file2) {
        if (file2 == null) {
            OptimizeImportsAction.$$$reportNull$$$0(5);
        }
        return !LanguageImportStatements.INSTANCE.forFile(file2).isEmpty();
    }

    private static Boolean isProcessVcsChangedText(Project project2, @NlsContexts.Label String text2, boolean hasChanges) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return myProcessVcsChangedFilesInTests;
        }
        OptimizeImportsDialog dialog = new OptimizeImportsDialog(project2, text2, hasChanges);
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog.isProcessOnlyVcsChangedFiles();
    }

    @TestOnly
    protected static void setProcessVcsChangedFilesInTests(boolean value) {
        myProcessVcsChangedFilesInTests = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/OptimizeImportsAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/OptimizeImportsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedImpl";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isActionAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOptimizeImportsAvailable";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }

    private static class OptimizeImportsDialog
    extends DialogWrapper {
        private final boolean myContextHasChanges;
        private final @NlsContexts.Label String myText;
        private JCheckBox myOnlyVcsCheckBox;
        private final LastRunReformatCodeOptionsProvider myLastRunOptions;

        OptimizeImportsDialog(Project project2, @NlsContexts.Label String text2, boolean hasChanges) {
            super(project2, false);
            this.myText = text2;
            this.myContextHasChanges = hasChanges;
            this.myLastRunOptions = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
            this.setOKButtonText(CodeInsightBundle.message("reformat.code.accept.button.text", new Object[0]));
            this.setTitle(CodeInsightBundle.message("process.optimize.imports", new Object[0]));
            this.init();
        }

        boolean isProcessOnlyVcsChangedFiles() {
            return this.myOnlyVcsCheckBox.isSelected();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel();
            BoxLayout layout = new BoxLayout(panel2, 1);
            panel2.setLayout(layout);
            panel2.add(new JLabel(this.myText));
            this.myOnlyVcsCheckBox = new JCheckBox(CodeInsightBundle.message("process.scope.changed.files", new Object[0]));
            boolean lastRunVcsChangedTextEnabled = this.myLastRunOptions.getLastTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
            this.myOnlyVcsCheckBox.setEnabled(this.myContextHasChanges);
            this.myOnlyVcsCheckBox.setSelected(this.myContextHasChanges && lastRunVcsChangedTextEnabled);
            this.myOnlyVcsCheckBox.setBorder(JBUI.Borders.emptyLeft(10));
            panel2.add(this.myOnlyVcsCheckBox);
            return panel2;
        }

        @Nullable
        protected String getHelpId() {
            return OptimizeImportsAction.HELP_ID;
        }
    }
}

