/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.application.options.colors.ReaderModeStatsCollector;
import com.intellij.codeInsight.actions.ReaderModeActionProvider;
import com.intellij.codeInsight.actions.ReaderModeConfigurable;
import com.intellij.codeInsight.actions.ReaderModeSettings;
import com.intellij.codeInsight.actions.ReaderModeSettingsListener;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.markup.InspectionWidgetActionProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/actions/ReaderModeActionProvider;", "Lcom/intellij/openapi/editor/markup/InspectionWidgetActionProvider;", "()V", "createAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "ReaderModeAction", "intellij.platform.lang.impl"})
final class ReaderModeActionProvider
implements InspectionWidgetActionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ColorKey FOREGROUND;

    @Nullable
    public AnAction createAction(@NotNull Editor editor2) {
        AnAction anAction;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project2 = editor2.getProject();
        if (project2 == null || project2.isDefault()) {
            anAction = null;
        } else {
            AnAction[] anActionArray = new AnAction[]{(AnAction)new ReaderModeAction(editor2), (AnAction)Separator.create()};
            AnAction[] anActionArray2 = anActionArray;
            anAction = (AnAction)new DefaultActionGroup(anActionArray2){

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    return ActionUpdateThread.BGT;
                }

                public void update(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    e.getPresentation().setEnabledAndVisible(false);
                    if (Experiments.getInstance().isFeatureEnabled("editor.reader.mode")) {
                        Project project2 = e.getProject();
                        if (project2 == null) {
                            return;
                        }
                        Project p = project2;
                        if (p.isInitialized()) {
                            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
                            if (editor2 == null) {
                                return;
                            }
                            Editor textEditor = editor2;
                            PsiFile psiFile = PsiDocumentManager.getInstance(p).getPsiFile(textEditor.getDocument());
                            VirtualFile file2 = psiFile != null ? psiFile.getVirtualFile() : null;
                            e.getPresentation().setEnabledAndVisible(ReaderModeSettings.Companion.matchMode(p, file2, textEditor));
                        }
                    }
                }
            };
        }
        return anAction;
    }

    static {
        ColorKey colorKey = ColorKey.createColorKey("ActionButton.iconTextForeground", UIUtil.getContextHelpForeground());
        Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"createColorKey(\"ActionBu\u2026tContextHelpForeground())");
        FOREGROUND = colorKey;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/actions/ReaderModeActionProvider$ReaderModeAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.platform.lang.impl"})
    private static final class ReaderModeAction
    extends DumbAwareToggleAction
    implements CustomComponentAction {
        @NotNull
        private final Editor editor;

        public ReaderModeAction(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            super(LangBundle.messagePointer("action.ReaderModeProvider.text", new Object[0]), LangBundle.messagePointer("action.ReaderModeProvider.description", new Object[0]), null);
            this.editor = editor2;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            JBDimension jBDimension;
            block3: {
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                jBDimension = JBUI.size(18);
                JBDimension it = jBDimension = new ActionButtonWithText(this, presentation2, place, jBDimension){
                    final /* synthetic */ ReaderModeAction this$0;
                    {
                        this.this$0 = $receiver;
                        super((AnAction)$receiver, $presentation, $place, (Dimension)$super_call_param$1);
                    }

                    protected int iconTextSpace() {
                        return JBUI.scale(2);
                    }

                    protected void updateToolTipText() {
                        Project project2 = ReaderModeAction.access$getEditor$p(this.this$0).getProject();
                        if (Registry.is("ide.helptooltip.enabled") && project2 != null) {
                            HelpTooltip.dispose((Component)((Component)((Object)this)));
                            new HelpTooltip().setTitle(this.myPresentation.getDescription()).setDescription(LangBundle.message("action.ReaderModeProvider.description", new Object[0])).setLink(LangBundle.message("action.ReaderModeProvider.link.configure", new Object[0]), () -> createCustomComponent.1.updateToolTipText$lambda$0(project2)).installOn((JComponent)((Object)this));
                        } else {
                            this.setToolTipText(this.myPresentation.getDescription());
                        }
                    }

                    @NotNull
                    public Insets getInsets() {
                        JBInsets jBInsets = JBUI.insets(2);
                        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(2)");
                        return jBInsets;
                    }

                    @NotNull
                    protected Insets getMargins() {
                        Insets[] insetsArray = new Insets[]{super.getMargins(), Intrinsics.areEqual((Object)this.myPresentation.getIcon(), (Object)AllIcons.General.ReaderMode) ? JBInsets.emptyInsets() : JBUI.insetsRight(5)};
                        JBInsets jBInsets = JBInsets.addInsets(insetsArray);
                        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"addInsets(\n          sup\u2026.insetsRight(5)\n        )");
                        return jBInsets;
                    }

                    public void updateUI() {
                        super.updateUI();
                        if (!SystemInfo.isWindows) {
                            this.setFont(new FontUIResource(this.getFont().deriveFont(this.getFont().getStyle(), (float)this.getFont().getSize() - (float)JBUIScale.scale(2))));
                        }
                    }

                    private static final void updateToolTipText$lambda$0(Project $project) {
                        ShowSettingsUtil.getInstance().showSettingsDialog($project, ReaderModeConfigurable.class);
                    }
                };
                boolean bl = false;
                it.setForeground(JBColor.lazy(() -> ReaderModeAction.createCustomComponent$lambda$2$lambda$0(this)));
                if (!SystemInfo.isWindows) {
                    it.setFont(new FontUIResource(it.getFont().deriveFont(it.getFont().getStyle(), (float)it.getFont().getSize() - (float)JBUIScale.scale(2))));
                }
                Project project2 = this.editor.getProject();
                if (project2 == null) break block3;
                Project p = project2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
                if (ReaderModeSettings.Companion.getInstance(p).getEnabled() && !ProjectUtil.isNotificationSilentMode((Project)p)) {
                    MessageBusConnection connection = p.getMessageBus().connect(p);
                    String string2 = LangBundle.message("text.reader.mode.got.it.popup", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"text.reader.mode.got.it.popup\")");
                    GotItTooltip gotItTooltip = new GotItTooltip("reader.mode.got.it", string2, (Disposable)p);
                    String string3 = LangBundle.message("title.reader.mode.got.it.popup", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"title.reader.mode.got.it.popup\")");
                    GotItTooltip gotItTooltip2 = gotItTooltip.withHeader(string3);
                    if (gotItTooltip2.canShow()) {
                        Topic<DaemonCodeAnalyzer.DaemonListener> topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
                        Intrinsics.checkNotNullExpressionValue(topic, (String)"DAEMON_EVENT_TOPIC");
                        connection.subscribe(topic, new DaemonCodeAnalyzer.DaemonListener(this, gotItTooltip2, (Object)it, connection){
                            final /* synthetic */ ReaderModeAction this$0;
                            final /* synthetic */ GotItTooltip $gotItTooltip;
                            final /* synthetic */ createCustomComponent.1 $it;
                            final /* synthetic */ MessageBusConnection $connection;
                            {
                                this.this$0 = $receiver;
                                this.$gotItTooltip = $gotItTooltip;
                                this.$it = $it;
                                this.$connection = $connection;
                            }

                            public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
                                block2: {
                                    Object v0;
                                    Object object;
                                    ReaderModeAction readerModeAction;
                                    Iterable iterable;
                                    block1: {
                                        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                                        iterable = fileEditors;
                                        readerModeAction = this.this$0;
                                        object = iterable;
                                        for (T t : object) {
                                            FileEditor fe = (FileEditor)t;
                                            boolean bl = false;
                                            if (!(fe instanceof TextEditor && Intrinsics.areEqual((Object)ReaderModeAction.access$getEditor$p(readerModeAction), (Object)((TextEditor)fe).getEditor()))) continue;
                                            v0 = t;
                                            break block1;
                                        }
                                        v0 = null;
                                    }
                                    FileEditor fileEditor = v0;
                                    if (fileEditor == null) break block2;
                                    iterable = fileEditor;
                                    readerModeAction = this.$gotItTooltip;
                                    object = this.$it;
                                    MessageBusConnection messageBusConnection = this.$connection;
                                    boolean bl = false;
                                    readerModeAction.setOnBalloonCreated((Function1)new Function1<Balloon, Unit>(messageBusConnection){
                                        final /* synthetic */ MessageBusConnection $connection;
                                        {
                                            this.$connection = $connection;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull Balloon balloon) {
                                            Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
                                            balloon.addListener(new JBPopupListener(this.$connection){
                                                final /* synthetic */ MessageBusConnection $connection;
                                                {
                                                    this.$connection = $connection;
                                                }

                                                public void onClosed(@NotNull LightweightWindowEvent event) {
                                                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                                    this.$connection.disconnect();
                                                }
                                            });
                                        }
                                    }).show((JComponent)object, GotItTooltip.BOTTOM_MIDDLE);
                                }
                            }
                        });
                    }
                }
            }
            return (JComponent)((Object)jBDimension);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return true;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            boolean newEnabled = !ReaderModeSettings.Companion.getInstance(project3).getEnabled();
            ReaderModeSettings.Companion.getInstance(project3).setEnabled(newEnabled);
            project3.getMessageBus().syncPublisher(ReaderModeSettingsListener.TOPIC).modeChanged(project3);
            ReaderModeStatsCollector.Companion.readerModeSwitched(newEnabled);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            Presentation presentation3 = presentation2;
            if (!ReaderModeSettings.Companion.getInstance(project3).getEnabled()) {
                presentation3.setText(null);
                presentation3.setIcon(AllIcons.General.ReaderMode);
                presentation3.setHoveredIcon(null);
                presentation3.setDescription(LangBundle.message("action.ReaderModeProvider.text.enter", new Object[0]));
            } else {
                presentation3.setText(LangBundle.message("action.ReaderModeProvider.text", new Object[0]));
                presentation3.setIcon(EmptyIcon.ICON_16);
                presentation3.setHoveredIcon(AllIcons.Actions.CloseDarkGrey);
                presentation3.setDescription(LangBundle.message("action.ReaderModeProvider.text.exit", new Object[0]));
            }
        }

        private static final Color createCustomComponent$lambda$2$lambda$0(ReaderModeAction this$0) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Color color = this$0.editor.getColorsScheme().getColor(Companion.getFOREGROUND());
            if (color == null) {
                color = Companion.getFOREGROUND().getDefaultColor();
            }
            return color;
        }

        public static final /* synthetic */ Editor access$getEditor$p(ReaderModeAction $this) {
            return $this.editor;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/actions/ReaderModeActionProvider$Companion;", "", "()V", "FOREGROUND", "Lcom/intellij/openapi/editor/colors/ColorKey;", "Lorg/jetbrains/annotations/NotNull;", "getFOREGROUND", "()Lcom/intellij/openapi/editor/colors/ColorKey;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorKey getFOREGROUND() {
            return FOREGROUND;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

