/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.actions.LayoutCodeDialog;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShowReformatFileDialog
extends AnAction
implements DumbAware {
    @NonNls
    private static final String HELP_ID = "editing.codeReformatting";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowReformatFileDialog.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ShowReformatFileDialog.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext2 = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (project2 == null || editor2 == null) {
            presentation2.setEnabled(false);
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (file2 == null || file2.getVirtualFile() == null) {
            presentation2.setEnabled(false);
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
            presentation2.setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            ShowReformatFileDialog.$$$reportNull$$$0(2);
        }
        DataContext dataContext2 = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (project2 == null || editor2 == null) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (file2 == null || file2.getVirtualFile() == null) {
            return;
        }
        boolean hasSelection = editor2.getSelectionModel().hasSelection();
        LayoutCodeDialog dialog = new LayoutCodeDialog(project2, file2, hasSelection, HELP_ID);
        dialog.show();
        if (dialog.isOK()) {
            new FileInEditorProcessor(file2, editor2, dialog.getRunOptions()).processCode();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/ShowReformatFileDialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/ShowReformatFileDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }
}

