/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.codeInsight.actions.ReaderModeSettings;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.ui.SimpleTextAttributes;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u0014\u001a\u00020\u000fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/actions/VisualFormattingSchemesCombo;", "Lcom/intellij/application/options/schemes/SchemesCombo;", "Lcom/intellij/psi/codeStyle/CodeStyleScheme;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "codeStyleSchemesModel", "Lcom/intellij/application/options/codeStyle/CodeStyleSchemesModel;", "getSchemeAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "scheme", "getVisualFormattingLayerScheme", "settings", "Lcom/intellij/codeInsight/actions/ReaderModeSettings;", "isProjectScheme", "", "onApply", "", "onIsModified", "onReset", "supportsProjectSchemes", "intellij.platform.lang.impl"})
public final class VisualFormattingSchemesCombo
extends SchemesCombo<CodeStyleScheme> {
    @NotNull
    private final CodeStyleSchemesModel codeStyleSchemesModel;

    public VisualFormattingSchemesCombo(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.codeStyleSchemesModel = new CodeStyleSchemesModel(project2);
    }

    protected boolean supportsProjectSchemes() {
        return true;
    }

    protected boolean isProjectScheme(@NotNull CodeStyleScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return this.codeStyleSchemesModel.isProjectScheme(scheme);
    }

    @NotNull
    protected SimpleTextAttributes getSchemeAttributes(@Nullable CodeStyleScheme scheme) {
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        return simpleTextAttributes;
    }

    public final void onReset(@NotNull ReaderModeSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.resetSchemes(this.codeStyleSchemesModel.getAllSortedSchemes());
        this.selectScheme((Scheme)this.getVisualFormattingLayerScheme(settings));
    }

    public final void onApply(@NotNull ReaderModeSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CodeStyleScheme selected = (CodeStyleScheme)this.getSelectedScheme();
        settings.setVisualFormattingChosenScheme(selected != null ? new ReaderModeSettings.Scheme(selected.getName(), this.codeStyleSchemesModel.isProjectScheme(selected)) : new ReaderModeSettings.Scheme(null, false, 3, null));
    }

    public final boolean onIsModified(@NotNull ReaderModeSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CodeStyleScheme selected = (CodeStyleScheme)this.getSelectedScheme();
        return selected == null || !Intrinsics.areEqual((Object)selected.getName(), (Object)settings.getVisualFormattingChosenScheme().getName()) || this.codeStyleSchemesModel.isProjectScheme(selected) != settings.getVisualFormattingChosenScheme().isProjectLevel();
    }

    private final CodeStyleScheme getVisualFormattingLayerScheme(ReaderModeSettings settings) {
        CodeStyleScheme codeStyleScheme;
        Object v2;
        block2: {
            List<CodeStyleScheme> list2 = this.codeStyleSchemesModel.getSchemes();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"codeStyleSchemesModel.schemes");
            Iterable iterable = list2;
            for (Object t : iterable) {
                CodeStyleScheme it = (CodeStyleScheme)t;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)settings.getVisualFormattingChosenScheme().getName(), (Object)it.getName()) && settings.getVisualFormattingChosenScheme().isProjectLevel() == this.codeStyleSchemesModel.isProjectScheme(it);
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        if ((codeStyleScheme = (CodeStyleScheme)v2) == null) {
            CodeStyleScheme codeStyleScheme2 = CodeStyleSchemes.getInstance().getDefaultScheme();
            codeStyleScheme = codeStyleScheme2;
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleScheme2, (String)"getInstance().defaultScheme");
        }
        return codeStyleScheme;
    }
}

