/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions.onSave;

import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.onSave.ActionOnSaveInfoBase;
import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class RearrangeCodeOnSaveActionInfo
extends ActionOnSaveInfoBase {
    private static final String REARRANGE_CODE_ON_SAVE_PROPERTY = "rearrange.code.on.save";
    private static final boolean REARRANGE_CODE_ON_SAVE_DEFAULT = false;

    public static boolean isRearrangeCodeOnSaveEnabled(@NotNull Project project2) {
        if (project2 == null) {
            RearrangeCodeOnSaveActionInfo.$$$reportNull$$$0(0);
        }
        return PropertiesComponent.getInstance(project2).getBoolean(REARRANGE_CODE_ON_SAVE_PROPERTY, false);
    }

    public RearrangeCodeOnSaveActionInfo(@NotNull ActionOnSaveContext context2) {
        if (context2 == null) {
            RearrangeCodeOnSaveActionInfo.$$$reportNull$$$0(1);
        }
        super(context2, CodeInsightBundle.message("actions.on.save.page.checkbox.rearrange.code", new Object[0]), REARRANGE_CODE_ON_SAVE_PROPERTY, false);
    }

    @NotNull
    public List<? extends ActionLink> getActionLinks() {
        ActionLink link = new ActionLink(CodeInsightBundle.message("actions.on.save.page.link.configure.arrangement.rules", new Object[0]));
        link.addActionListener(e -> this.showArrangementSettingsPopup(link));
        List<ActionLink> list2 = List.of(link);
        if (list2 == null) {
            RearrangeCodeOnSaveActionInfo.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private void showArrangementSettingsPopup(@NotNull ActionLink link) {
        if (link == null) {
            RearrangeCodeOnSaveActionInfo.$$$reportNull$$$0(3);
        }
        List<ArrangementStandardSettingsAware.ArrangementTabInfo> arrangementTabInfos = RearrangeCodeOnSaveActionInfo.getArrangementTabInfos();
        JBPopupFactory.getInstance().createPopupChooserBuilder(arrangementTabInfos).setTitle(CodeInsightBundle.message("actions.on.save.page.popup.title.arrangement.settings", new Object[0])).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
                Component result2 = super.getListCellRendererComponent((JList<?>)list2, value, index2, isSelected, cellHasFocus);
                ArrangementStandardSettingsAware.ArrangementTabInfo tabInfo = (ArrangementStandardSettingsAware.ArrangementTabInfo)value;
                this.setText(tabInfo.languageDisplayName);
                this.setIcon(ObjectUtils.notNull(tabInfo.icon, EmptyIcon.ICON_16));
                this.setBorder(JBUI.Borders.empty(3));
                return result2;
            }
        }).setItemChosenCallback(tabInfo -> {
            String configurableId = CodeStyleConfigurableWrapper.getConfigurableId(tabInfo.configurableId);
            Configurable configurable2 = this.getSettings().find(configurableId);
            this.getSettings().select(configurable2).doWhenDone(() -> {
                if (configurable2 instanceof CodeStyleConfigurableWrapper) {
                    ((CodeStyleConfigurableWrapper)configurable2).selectTab(ApplicationBundle.message((String)"arrangement.title.settings.tab", (Object[])new Object[0]));
                }
            });
        }).createPopup().show(new RelativePoint((Component)link, new Point(0, link.getHeight() + JBUI.scale(4))));
    }

    @NotNull
    private static List<ArrangementStandardSettingsAware.ArrangementTabInfo> getArrangementTabInfos() {
        ArrayList<ArrangementStandardSettingsAware.ArrangementTabInfo> arrangementTabInfos = new ArrayList<ArrangementStandardSettingsAware.ArrangementTabInfo>();
        ExtensionPoint extensionPoint = Rearranger.EXTENSION.getPoint();
        if (extensionPoint != null) {
            for (KeyedLazyInstance instance2 : extensionPoint.getExtensionList()) {
                Rearranger rearranger = (Rearranger)instance2.getInstance();
                if (!(rearranger instanceof ArrangementStandardSettingsAware)) continue;
                arrangementTabInfos.addAll(((ArrangementStandardSettingsAware)rearranger).getArrangementTabInfos());
            }
        }
        arrangementTabInfos.sort(Comparator.comparing(info2 -> info2.languageDisplayName));
        ArrayList<ArrangementStandardSettingsAware.ArrangementTabInfo> arrayList = arrangementTabInfos;
        if (arrayList == null) {
            RearrangeCodeOnSaveActionInfo.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/onSave/RearrangeCodeOnSaveActionInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/onSave/RearrangeCodeOnSaveActionInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionLinks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrangementTabInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRearrangeCodeOnSaveEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showArrangementSettingsPopup";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4 -> new IllegalStateException(string2);
        };
    }
}

