/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/codeVision/CodeVisionProvidersWatcher;", "", "()V", "providersWaitingTime", "", "", "", "dropProvider", "", "groupId", "reportProvider", "time", "shouldConsiderProvider", "", "Companion", "intellij.platform.lang.impl"})
public final class CodeVisionProvidersWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Long> providersWaitingTime = new LinkedHashMap();
    public static final int Threshold = 30;
    public static final int MinThreshold = 10;

    public final void reportProvider(@NotNull String groupId, long time2) {
        Long providerTime;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        long timeInSeconds = TimeUnit.SECONDS.convert(time2, TimeUnit.NANOSECONDS);
        if (timeInSeconds >= 30L) {
            this.providersWaitingTime.put(groupId, this.providersWaitingTime.containsKey(groupId) ? (timeInSeconds + time2) / (long)2 : time2);
        }
        if ((providerTime = this.providersWaitingTime.get(groupId)) != null && providerTime < 10L) {
            this.providersWaitingTime.remove(groupId);
        }
    }

    public final boolean shouldConsiderProvider(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Long time2 = this.providersWaitingTime.get(groupId);
        return time2 == null || time2 < 30L;
    }

    public final void dropProvider(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        this.providersWaitingTime.remove(groupId);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/codeVision/CodeVisionProvidersWatcher$Companion;", "", "()V", "MinThreshold", "", "Threshold", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

