/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.model;

import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.EditorCodeVisionContextKt;
import com.intellij.codeInsight.codeVision.ui.RdSwingKt;
import com.intellij.codeInsight.codeVision.ui.model.AdditionalKt;
import com.intellij.codeInsight.codeVision.ui.model.CodeVisionListData;
import com.intellij.codeInsight.codeVision.ui.model.ProjectCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.model.SwingScheduler;
import com.intellij.codeInsight.codeVision.ui.renderers.CodeVisionRenderer;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionTheme;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.AdditionalApiKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0011H\u0002J$\u0010#\u001a\u0004\u0018\u00010\u000f2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010\r2\b\u0010&\u001a\u0004\u0018\u00010\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lcom/intellij/codeInsight/codeVision/ui/model/CodeVisionSelectionController;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "projectModel", "Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "hovered", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/intellij/openapi/editor/Inlay;", "hoveredEntry", "Lcom/intellij/codeInsight/codeVision/CodeVisionEntry;", "lensPopupActive", "", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getProjectModel", "()Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel;", "checkEditorMousePosition", "editorMousePosition", "Ljava/awt/Point;", "clearHovered", "", "entryPressHandler", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "showTooltip", "lt", "entry", "updateCursor", "hasHoveredEntry", "updateHovered", "hoveredInlay", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "mouseOnInlay", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nCodeVisionSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeVisionSelectionController.kt\ncom/intellij/codeInsight/codeVision/ui/model/CodeVisionSelectionController\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,205:1\n19#2,4:206\n19#2,4:210\n10#2:214\n*S KotlinDebug\n*F\n+ 1 CodeVisionSelectionController.kt\ncom/intellij/codeInsight/codeVision/ui/model/CodeVisionSelectionController\n*L\n119#1:206,4\n123#1:210,4\n40#1:214\n*E\n"})
public final class CodeVisionSelectionController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final ProjectCodeVisionModel projectModel;
    @NotNull
    private final Property<Inlay<?>> hovered;
    @NotNull
    private final Property<CodeVisionEntry> hoveredEntry;
    @NotNull
    private final Property<Boolean> lensPopupActive;
    @NotNull
    private static final HashMap<Editor, CodeVisionSelectionController> map = new HashMap();
    @NotNull
    private static final Logger logger;

    private CodeVisionSelectionController(Lifetime lifetime, EditorImpl editor2, ProjectCodeVisionModel projectModel) {
        this.lifetime = lifetime;
        this.editor = editor2;
        this.projectModel = projectModel;
        this.hovered = this.projectModel.getHoveredInlay();
        this.hoveredEntry = this.projectModel.getHoveredEntry();
        this.lensPopupActive = this.projectModel.getLensPopupActive();
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"editor.contentComponent");
        PropertyCombinatorsKt.map(RdSwingKt.windowAncestor((JComponent)editorComponentImpl), (Function1)1.INSTANCE).view(this.lifetime, (Function2)new Function2<Lifetime, Boolean, Unit>(){

            public final void invoke(@NotNull Lifetime ltmain, boolean inHierarchy) {
                Intrinsics.checkNotNullParameter((Object)ltmain, (String)"ltmain");
                if (inHierarchy) {
                    SourceExKt.adviseWithPrev((ISource)((ISource)hovered), (Lifetime)ltmain, (Function2)1.INSTANCE);
                    hovered.view(ltmain, new Function2<Lifetime, Inlay<?>, Unit>(){

                        public final void invoke(@NotNull Lifetime lt, @Nullable Inlay<?> inlay) {
                            Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                            hoveredEntry.view(lt, (Function2)new Function2<Lifetime, CodeVisionEntry, Unit>(){

                                public final void invoke(@NotNull Lifetime entryLifetime, @Nullable CodeVisionEntry codeVisionEntry) {
                                    Intrinsics.checkNotNullParameter((Object)entryLifetime, (String)"entryLifetime");
                                    Inlay inlay = (Inlay)hovered.getValue();
                                    if (inlay != null) {
                                        inlay.repaint();
                                    }
                                    RdSwingKt.mousePressed((Editor)this.getEditor()).advise(entryLifetime, (Function1)new Function1<EditorMouseEvent, Unit>(){

                                        public final void invoke(@NotNull EditorMouseEvent it) {
                                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                            this.entryPressHandler(it);
                                        }
                                    });
                                    RdSwingKt.mouseReleased((Editor)this.getEditor()).advise(entryLifetime, (Function1)new Function1<EditorMouseEvent, Unit>(){

                                        public final void invoke(@NotNull EditorMouseEvent it) {
                                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                            MouseEvent mouseEvent = it.getMouseEvent();
                                            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"it.mouseEvent");
                                            MouseEvent mouseEvent2 = mouseEvent;
                                            if (this.checkEditorMousePosition(mouseEvent2.getPoint()) == null) {
                                                return;
                                            }
                                            if (mouseEvent2.isPopupTrigger()) {
                                                it.consume();
                                            }
                                        }
                                    });
                                }
                            });
                            lensPopupActive.view(lt, (Function2)new Function2<Lifetime, Boolean, Unit>(){

                                public final void invoke(@NotNull Lifetime activePopupLifetime, boolean popupActive) {
                                    Intrinsics.checkNotNullParameter((Object)activePopupLifetime, (String)"activePopupLifetime");
                                    if (!popupActive) {
                                        IPropertyView iPropertyView = (IPropertyView)hoveredEntry;
                                        Duration duration = Duration.ofMillis(1000L);
                                        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(1000)");
                                        InterfacesKt.viewNotNull((IViewable)((IViewable)AdditionalApiKt.asProperty((ISource)AdditionalApiKt.debounceNotNull((IPropertyView)iPropertyView, (Duration)duration, (IScheduler)SwingScheduler.INSTANCE), null)), (Lifetime)activePopupLifetime, (Function2)((Function2)new Function2<Lifetime, CodeVisionEntry, Unit>(){

                                            public final void invoke(@NotNull Lifetime lt1, @NotNull CodeVisionEntry it) {
                                                Intrinsics.checkNotNullParameter((Object)lt1, (String)"lt1");
                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                this.showTooltip(lt1, it);
                                            }
                                        }));
                                    }
                                }
                            });
                        }
                    });
                    PropertyCombinatorsKt.map((IPropertyView)((IPropertyView)hoveredEntry), (Function1)3.INSTANCE).advise(ltmain, (Function1)new Function1<Boolean, Unit>(){

                        public final void invoke(boolean hasHoveredEntry) {
                            this.updateCursor(hasHoveredEntry);
                        }
                    });
                    RdSwingKt.mousePoint((Editor)this.getEditor()).advise(ltmain, (Function1)new Function1<Point, Unit>(){

                        public final void invoke(@Nullable Point it) {
                            this.checkEditorMousePosition(it);
                        }
                    });
                } else {
                    Inlay inlay = (Inlay)hovered.getValue();
                    if (Intrinsics.areEqual((Object)(inlay != null ? inlay.getEditor() : null), (Object)this.getEditor())) {
                        this.clearHovered();
                    }
                }
            }
        });
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final ProjectCodeVisionModel getProjectModel() {
        return this.projectModel;
    }

    private final void entryPressHandler(EditorMouseEvent event) {
        MouseEvent mouseEvent = event.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"event.mouseEvent");
        MouseEvent mouseEvent2 = mouseEvent;
        CodeVisionEntry codeVisionEntry = this.checkEditorMousePosition(mouseEvent2.getPoint());
        if (codeVisionEntry == null) {
            return;
        }
        CodeVisionEntry entry = codeVisionEntry;
        this.editor.getContentComponent().requestFocus();
        event.consume();
        Object object = (Inlay)this.hovered.getValue();
        if (object == null || (object = (CodeVisionListData)object.getUserData(CodeVisionListData.KEY)) == null || (object = ((CodeVisionListData)object).getRangeCodeVisionModel()) == null) {
            return;
        }
        Object rangeLensesModel = object;
        entry.putUserData(EditorCodeVisionContextKt.getCodeVisionEntryMouseEventKey(), mouseEvent2);
        if (SwingUtilities.isLeftMouseButton(mouseEvent2)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("entryPressHandler :: isLeftMouseButton");
            }
            ((RangeCodeVisionModel)rangeLensesModel).handleLensClick(entry);
        } else if (SwingUtilities.isRightMouseButton(mouseEvent2)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("entryPressHandler :: isRightMouseButton");
            }
            ((RangeCodeVisionModel)rangeLensesModel).handleLensRightClick();
        }
    }

    private final void updateCursor(boolean hasHoveredEntry) {
        Cursor cursor;
        Cursor cursor2 = cursor = hasHoveredEntry ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(0);
        if (!Intrinsics.areEqual((Object)this.editor.getContentComponent().getCursor(), (Object)cursor)) {
            UIUtil.setCursor((Component)this.editor.getContentComponent(), cursor);
        }
    }

    private final void showTooltip(Lifetime lt, CodeVisionEntry entry) {
        String text2 = AdditionalKt.tooltipText(entry);
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        LifetimeDefinition ld = lt.createNested();
        Inlay inlay = (Inlay)this.hovered.getValue();
        if (inlay == null) {
            return;
        }
        Inlay inlay2 = inlay;
        Rectangle rectangle = inlay2.getBounds();
        if (rectangle == null) {
            return;
        }
        Rectangle inlayBounds = rectangle;
        EditorCustomElementRenderer editorCustomElementRenderer = inlay2.getRenderer();
        Intrinsics.checkNotNull((Object)editorCustomElementRenderer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.codeVision.ui.renderers.CodeVisionRenderer");
        CodeVisionRenderer renderer = (CodeVisionRenderer)editorCustomElementRenderer;
        Rectangle rectangle2 = renderer.entryBounds(inlay2, entry);
        if (rectangle2 == null) {
            return;
        }
        Rectangle entryBounds = rectangle2;
        int x = inlayBounds.x + entryBounds.x + entryBounds.width / 2;
        int y = inlayBounds.y + inlayBounds.height / 2;
        JComponent jComponent = inlay2.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"inlay.editor.contentComponent");
        JComponent contentComponent = jComponent;
        JComponent jComponent2 = inlay2.getEditor().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"inlay.editor.component");
        JComponent component2 = jComponent2;
        RelativePoint relativePoint = new RelativePoint(contentComponent, new Point(x, y));
        IdeTooltip tooltip = new IdeTooltip((Component)component2, relativePoint.getPoint(component2), (JComponent)new JLabel(text2), new Object[0]);
        IdeTooltip currentTooltip = IdeTooltipManager.getInstance().show(tooltip, false, false);
        ScrollingModel scrollingModel = inlay2.getEditor().getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"inlay.editor.scrollingModel");
        RdSwingKt.visibleAreaChanged(scrollingModel).advise((Lifetime)ld, (Function1)new Function1<VisibleAreaEvent, Unit>(ld){
            final /* synthetic */ LifetimeDefinition $ld;
            {
                this.$ld = $ld;
                super(1);
            }

            public final void invoke(@NotNull VisibleAreaEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$ld, (boolean)false, (int)1, null);
            }
        });
        ld.onTermination((Function0)new Function0<Unit>(currentTooltip){
            final /* synthetic */ IdeTooltip $currentTooltip;
            {
                this.$currentTooltip = $currentTooltip;
                super(0);
            }

            public final void invoke() {
                this.$currentTooltip.hide();
            }
        });
    }

    private final CodeVisionEntry checkEditorMousePosition(Point editorMousePosition) {
        if (editorMousePosition == null) {
            this.clearHovered();
            return null;
        }
        Inlay hoveredInlay = this.editor.getInlayModel().getElementAt(editorMousePosition);
        return this.updateHovered((Inlay<EditorCustomElementRenderer>)hoveredInlay, editorMousePosition);
    }

    private final CodeVisionEntry updateHovered(Inlay<EditorCustomElementRenderer> hoveredInlay, Point mouseOnInlay) {
        if (mouseOnInlay == null || hoveredInlay == null || !(hoveredInlay.getRenderer() instanceof CodeVisionRenderer)) {
            this.clearHovered();
            return null;
        }
        Rectangle rectangle = hoveredInlay.getBounds();
        if (rectangle == null) {
            CodeVisionSelectionController $this$updateHovered_u24lambda_u242 = this;
            boolean bl = false;
            $this$updateHovered_u24lambda_u242.clearHovered();
            return null;
        }
        Rectangle bounds = rectangle;
        if (CodeVisionTheme.Companion.yInInlayBounds(mouseOnInlay.y, bounds)) {
            EditorCustomElementRenderer editorCustomElementRenderer = hoveredInlay.getRenderer();
            Intrinsics.checkNotNull((Object)editorCustomElementRenderer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.codeVision.ui.renderers.CodeVisionRenderer");
            CodeVisionRenderer renderer = (CodeVisionRenderer)editorCustomElementRenderer;
            CodeVisionEntry entry = renderer.hoveredEntry(hoveredInlay, mouseOnInlay.x - bounds.x, mouseOnInlay.y - bounds.y);
            this.hovered.set(hoveredInlay);
            this.hoveredEntry.set((Object)entry);
            return entry;
        }
        this.clearHovered();
        return null;
    }

    private final void clearHovered() {
        this.hovered.set(null);
        this.hoveredEntry.set(null);
    }

    public /* synthetic */ CodeVisionSelectionController(Lifetime lifetime, EditorImpl editor2, ProjectCodeVisionModel projectModel, DefaultConstructorMarker $constructor_marker) {
        this(lifetime, editor2, projectModel);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeVisionSelectionController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        CodeVisionSelectionController.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/model/CodeVisionSelectionController$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "map", "Ljava/util/HashMap;", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/codeInsight/codeVision/ui/model/CodeVisionSelectionController;", "Lkotlin/collections/HashMap;", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "projectModel", "Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor2, @NotNull ProjectCodeVisionModel projectModel) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)projectModel, (String)"projectModel");
            CodeVisionSelectionController controller = (CodeVisionSelectionController)map.get(editor2);
            if (controller != null) {
                return;
            }
            Disposable disposable = editor2.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"editor.disposable");
            Lifetime lifetime = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
            controller = new CodeVisionSelectionController(lifetime, editor2, projectModel, null);
            ((Map)map).put(editor2, controller);
            lifetime.onTermination((Function0)new Function0<Unit>(editor2){
                final /* synthetic */ EditorImpl $editor;
                {
                    this.$editor = $editor;
                    super(0);
                }

                public final void invoke() {
                    CodeVisionSelectionController.access$getMap$cp().remove(this.$editor);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

