/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.model;

import com.intellij.codeInsight.codeVision.CodeVisionAnchorKind;
import com.intellij.codeInsight.codeVision.CodeVisionBundle;
import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.CodeVisionHost;
import com.intellij.codeInsight.codeVision.CodeVisionInitializer;
import com.intellij.codeInsight.codeVision.CodeVisionProvider;
import com.intellij.codeInsight.codeVision.settings.CodeVisionSettings;
import com.intellij.codeInsight.codeVision.ui.model.AdditionalCodeVisionEntry;
import com.intellij.codeInsight.codeVision.ui.model.CodeVisionListData;
import com.intellij.codeInsight.codeVision.ui.popup.CodeVisionPopup;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.ViewableMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0007J\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0007J&\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020!J\b\u0010+\u001a\u00020!H\u0002J\b\u0010,\u001a\u00020!H\u0002R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "hoveredEntry", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/intellij/codeInsight/codeVision/CodeVisionEntry;", "getHoveredEntry", "()Lcom/jetbrains/rd/util/reactive/Property;", "hoveredInlay", "Lcom/intellij/openapi/editor/Inlay;", "getHoveredInlay", "lensPopupActive", "", "getLensPopupActive", "maxVisibleLensCount", "Lcom/jetbrains/rd/util/reactive/ViewableMap;", "Lcom/intellij/codeInsight/codeVision/CodeVisionAnchorKind;", "", "getMaxVisibleLensCount", "()Lcom/jetbrains/rd/util/reactive/ViewableMap;", "moreEntry", "Lcom/intellij/codeInsight/codeVision/ui/model/AdditionalCodeVisionEntry;", "getMoreEntry", "()Lcom/intellij/codeInsight/codeVision/ui/model/AdditionalCodeVisionEntry;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCodeVisionHost", "Lcom/intellij/codeInsight/codeVision/CodeVisionHost;", "getLensIndex", "lens", "handleLensClick", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/util/TextRange;", "entry", "handleLensExtraAction", "actionId", "", "handleLensRightClick", "showContextPopup", "showMore", "Companion", "intellij.platform.lang.impl"})
public final class ProjectCodeVisionModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ViewableMap<CodeVisionAnchorKind, Integer> maxVisibleLensCount;
    @NotNull
    private final Property<Inlay<?>> hoveredInlay;
    @NotNull
    private final Property<CodeVisionEntry> hoveredEntry;
    @NotNull
    private final Property<Boolean> lensPopupActive;
    @NotNull
    private final AdditionalCodeVisionEntry moreEntry;
    @NotNull
    public static final String MORE_PROVIDER_ID = "!More";
    @NotNull
    public static final String HIDE_PROVIDER_ID = "!Hide";
    @NotNull
    public static final String HIDE_ALL = "!HideAll";

    private ProjectCodeVisionModel(Project project2) {
        this.project = project2;
        this.maxVisibleLensCount = new ViewableMap();
        this.hoveredInlay = new Property(null);
        this.hoveredEntry = new Property(null);
        this.lensPopupActive = new Property((Object)false);
        this.moreEntry = new AdditionalCodeVisionEntry(MORE_PROVIDER_ID, CodeVisionBundle.Companion.message("more", new Object[0]), null, null, 12, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ViewableMap<CodeVisionAnchorKind, Integer> getMaxVisibleLensCount() {
        return this.maxVisibleLensCount;
    }

    @NotNull
    public final Property<Inlay<?>> getHoveredInlay() {
        return this.hoveredInlay;
    }

    @NotNull
    public final Property<CodeVisionEntry> getHoveredEntry() {
        return this.hoveredEntry;
    }

    @NotNull
    public final Property<Boolean> getLensPopupActive() {
        return this.lensPopupActive;
    }

    @NotNull
    public final AdditionalCodeVisionEntry getMoreEntry() {
        return this.moreEntry;
    }

    private final CodeVisionHost getCodeVisionHost() {
        return CodeVisionInitializer.Companion.getInstance(this.project).getCodeVisionHost();
    }

    public final void handleLensClick(@NotNull Editor editor2, @NotNull TextRange range, @NotNull CodeVisionEntry entry) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (Intrinsics.areEqual((Object)entry.getProviderId(), (Object)MORE_PROVIDER_ID)) {
            this.showMore();
            return;
        }
        this.getCodeVisionHost().handleLensClick(editor2, range, entry);
    }

    public final void handleLensRightClick() {
        this.showContextPopup();
    }

    public final void handleLensExtraAction(@NotNull Editor editor2, @NotNull TextRange range, @NotNull CodeVisionEntry entry, @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        if (Intrinsics.areEqual((Object)actionId, (Object)HIDE_PROVIDER_ID)) {
            CodeVisionProvider<?> codeVisionProvider = CodeVisionInitializer.Companion.getInstance(this.project).getCodeVisionHost().getProviderById(entry.getProviderId());
            if (codeVisionProvider == null || (codeVisionProvider = codeVisionProvider.getGroupId()) == null) {
                codeVisionProvider = entry.getProviderId();
            }
            CodeVisionProvider<?> id = codeVisionProvider;
            CodeVisionSettings.Companion.instance().setProviderEnabled((String)((Object)id), false);
            CodeVisionInitializer.Companion.getInstance(this.project).getCodeVisionHost().getInvalidateProviderSignal().fire((Object)new CodeVisionHost.LensInvalidateSignal(null, null, 2, null));
            return;
        }
        if (Intrinsics.areEqual((Object)actionId, (Object)HIDE_ALL)) {
            CodeVisionSettings.Companion.instance().setCodeVisionEnabled(false);
            CodeVisionInitializer.Companion.getInstance(this.project).getCodeVisionHost().getInvalidateProviderSignal().fire((Object)new CodeVisionHost.LensInvalidateSignal(null, null, 2, null));
            return;
        }
        this.getCodeVisionHost().handleLensExtraAction(editor2, range, entry, actionId);
    }

    public final int getLensIndex(@NotNull CodeVisionEntry lens) {
        Intrinsics.checkNotNullParameter((Object)lens, (String)"lens");
        return this.getCodeVisionHost().getNumber(lens.getProviderId()) + 1;
    }

    private final void showMore() {
        Inlay inlay = (Inlay)this.hoveredInlay.getValue();
        if (inlay == null) {
            return;
        }
        Inlay inlay2 = inlay;
        CodeVisionListData codeVisionListData = (CodeVisionListData)inlay2.getUserData(CodeVisionListData.KEY);
        if (codeVisionListData == null) {
            return;
        }
        CodeVisionListData model2 = codeVisionListData;
        CodeVisionPopup.Companion.showMorePopup(model2.getLifetime(), inlay2, this.moreEntry, CodeVisionPopup.Disposition.MOUSE_POPUP_DISPOSITION, model2.getRangeCodeVisionModel(), this.project);
    }

    private final void showContextPopup() {
        Inlay inlay = (Inlay)this.hoveredInlay.getValue();
        if (inlay == null) {
            return;
        }
        Inlay inlay2 = inlay;
        CodeVisionEntry codeVisionEntry = (CodeVisionEntry)this.hoveredEntry.getValue();
        if (codeVisionEntry == null) {
            return;
        }
        CodeVisionEntry entry = codeVisionEntry;
        if (Intrinsics.areEqual((Object)entry.getProviderId(), (Object)MORE_PROVIDER_ID)) {
            this.showMore();
            return;
        }
        CodeVisionListData codeVisionListData = (CodeVisionListData)inlay2.getUserData(CodeVisionListData.KEY);
        if (codeVisionListData == null) {
            return;
        }
        CodeVisionListData model2 = codeVisionListData;
        CodeVisionPopup.Companion.showContextPopup(model2.getLifetime(), inlay2, entry, CodeVisionPopup.Disposition.MOUSE_POPUP_DISPOSITION, model2, this.project);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel$Companion;", "", "()V", "HIDE_ALL", "", "HIDE_PROVIDER_ID", "MORE_PROVIDER_ID", "getInstance", "Lcom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nProjectCodeVisionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectCodeVisionModel.kt\ncom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,105:1\n29#2,3:106\n*S KotlinDebug\n*F\n+ 1 ProjectCodeVisionModel.kt\ncom/intellij/codeInsight/codeVision/ui/model/ProjectCodeVisionModel$Companion\n*L\n19#1:106,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectCodeVisionModel getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = project2;
            boolean $i$f$service = false;
            Class<ProjectCodeVisionModel> serviceClass$iv = ProjectCodeVisionModel.class;
            ProjectCodeVisionModel projectCodeVisionModel = $this$service$iv.getService(serviceClass$iv);
            if (projectCodeVisionModel == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return projectCodeVisionModel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

