/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.model.richText;

import com.intellij.codeInsight.codeVision.ui.model.richText.RichString;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u00182\b\b\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020\u0000H\u0016J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u0004H\u0017J\f\u0010%\u001a\u00020\u0004*\u00020#H\u0002J\f\u0010&\u001a\u00020\u0004*\u00020\u001dH\u0002R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\b0\u000fj\b\u0012\u0004\u0012\u00020\b`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;", "", "()V", "text", "", "(Ljava/lang/String;)V", "parts", "", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichString;", "(Ljava/lang/String;Ljava/util/Collection;)V", "length", "", "getLength", "()I", "myParts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "myString", "", "getParts", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "addStyle", "", "style", "textRange", "Lcom/intellij/openapi/util/TextRange;", "append", "Lcom/intellij/ui/SimpleTextAttributes;", "calculateStyle", "textAttributes", "clone", "setForeColor", "fgColor", "Ljava/awt/Color;", "toString", "dumpColor", "dumpStyleAndFont", "intellij.platform.lang.impl"})
public class RichText
implements Cloneable {
    @Nls
    @NotNull
    private String myString;
    @NotNull
    private ArrayList<RichString> myParts;

    public RichText(@Nls @NotNull String text2, @NotNull Collection<RichString> parts) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        this.myString = text2;
        this.myParts = new ArrayList<RichString>(parts);
    }

    @NotNull
    public final List<RichString> getParts() {
        return this.myParts;
    }

    @Nls
    @NotNull
    public final String getText() {
        return this.myString;
    }

    public final int getLength() {
        return this.getText().length();
    }

    public RichText() {
        this("", CollectionsKt.emptyList());
    }

    public RichText(@Nls @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this();
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        this.append(text2, simpleTextAttributes);
    }

    public final void append(@Nls @NotNull String text2, @NotNull SimpleTextAttributes style) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        TextRange range = new TextRange(this.myString.length(), this.myString.length() + text2.length());
        this.myString = this.myString + text2;
        this.myParts.add(new RichString(range, style, this));
    }

    public final void setForeColor(@NotNull Color fgColor) {
        Intrinsics.checkNotNullParameter((Object)fgColor, (String)"fgColor");
        for (RichString part : this.getParts()) {
            SimpleTextAttributes attributes = part.getAttributes();
            int style = attributes.getStyle();
            Color bgColor = attributes.getBgColor();
            Color waveColor = attributes.getWaveColor();
            SimpleTextAttributes simpleTextAttributes = attributes.derive(style, fgColor, bgColor, waveColor);
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"attributes.derive(style,\u2026olor, bgColor, waveColor)");
            part.setAttributes(simpleTextAttributes);
        }
    }

    public final void addStyle(@SimpleTextAttributes.StyleAttributeConstant int style, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        int n = this.getLength();
        int n2 = textRange.getStartOffset();
        if (!(0 <= n2 ? n2 < n : false)) {
            throw new IllegalArgumentException("textRange");
        }
        n = this.getLength();
        n2 = textRange.getEndOffset();
        if (!(0 <= n2 ? n2 <= n : false)) {
            throw new IllegalArgumentException("textRange");
        }
        ArrayList<RichString> newParts = new ArrayList<RichString>();
        for (RichString part : this.myParts) {
            TextRange partRange = part.component1();
            SimpleTextAttributes attributes = part.component2();
            TextRange intersection = textRange.intersection(partRange);
            if (intersection == null) {
                newParts.add(part);
                continue;
            }
            if (partRange.getStartOffset() != intersection.getStartOffset()) {
                newParts.add(new RichString(new TextRange(partRange.getStartOffset(), intersection.getStartOffset()), attributes, this));
            }
            SimpleTextAttributes newAttributes = attributes.derive(attributes.getStyle() | style, null, null, null);
            Intrinsics.checkNotNullExpressionValue((Object)newAttributes, (String)"newAttributes");
            newParts.add(new RichString(intersection, newAttributes, this));
            if (intersection.getEndOffset() == partRange.getEndOffset()) continue;
            newParts.add(new RichString(new TextRange(intersection.getEndOffset(), partRange.getEndOffset()), attributes, this));
        }
        this.myParts = newParts;
    }

    @NotNull
    public RichText clone() {
        RichText copy2 = new RichText();
        copy2.myString = this.myString;
        for (RichString richString : this.myParts) {
            TextRange textRange = richString.component1();
            SimpleTextAttributes attributes = richString.component2();
            copy2.myParts.add(new RichString(textRange, attributes, copy2));
        }
        return copy2;
    }

    @Nls
    @NotNull
    public String toString() {
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        for (RichString p : this.myParts) {
            SimpleTextAttributes a = p.component2();
            String style = this.calculateStyle(a);
            htmlBuilder.append(HtmlChunk.span(style).addText(p.getText()));
        }
        String string2 = htmlBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"htmlBuilder.toString()");
        return string2;
    }

    private final String calculateStyle(SimpleTextAttributes textAttributes) {
        Color waveColor;
        Color fgColor;
        StringBuilder styleBuilder = new StringBuilder();
        Color bgColor = textAttributes.getBgColor();
        if (bgColor != null) {
            styleBuilder.append("background-color:" + this.dumpColor(bgColor));
        }
        if ((fgColor = textAttributes.getFgColor()) != null) {
            styleBuilder.append("color:" + this.dumpColor(fgColor));
        }
        if ((waveColor = textAttributes.getWaveColor()) != null) {
            styleBuilder.append("wave-color:" + this.dumpColor(waveColor));
        }
        styleBuilder.append(this.dumpStyleAndFont(textAttributes));
        String string2 = styleBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"styleBuilder.toString()");
        return string2;
    }

    private final String dumpStyleAndFont(SimpleTextAttributes $this$dumpStyleAndFont) {
        String font = switch ($this$dumpStyleAndFont.getFontStyle()) {
            case 0 -> "font-style: plain;";
            case 2 -> "font-style: italic;";
            case 1 -> "font-weight: bold;";
            default -> "";
        };
        String decoration = $this$dumpStyleAndFont.isSearchMatch() ? "text-decoration: searchMatch;" : ($this$dumpStyleAndFont.isStrikeout() ? "text-decoration: strikeout;" : ($this$dumpStyleAndFont.isWaved() ? "text-decoration: waved;" : ($this$dumpStyleAndFont.isUnderline() ? "text-decoration: underline;" : ($this$dumpStyleAndFont.isBoldDottedLine() ? "text-decoration: boldDottedLine;" : ($this$dumpStyleAndFont.isOpaque() ? "text-decoration: opaque;" : ($this$dumpStyleAndFont.isSmaller() ? "text-decoration: smaller;" : ""))))));
        return font + decoration;
    }

    private final String dumpColor(Color $this$dumpColor) {
        return "rgb(" + $this$dumpColor.getRed() + "," + $this$dumpColor.getGreen() + "," + $this$dumpColor.getBlue() + ");";
    }
}

