/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.popup.layouter;

import com.intellij.codeInsight.codeVision.ui.popup.layouter.Anchoring2D;
import com.intellij.codeInsight.codeVision.ui.popup.layouter.AnchoringRect;
import com.intellij.codeInsight.codeVision.ui.popup.layouter.LayoutResult;
import com.intellij.codeInsight.codeVision.ui.popup.layouter.RectangleDocker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.ui.ScreenUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006%"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/popup/layouter/DockingLayouter;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "anchor", "Lcom/intellij/codeInsight/codeVision/ui/popup/layouter/AnchoringRect;", "dispositions", "", "Lcom/intellij/codeInsight/codeVision/ui/popup/layouter/Anchoring2D;", "project", "Lcom/intellij/openapi/project/Project;", "padding", "", "promoteRecentlyUsedDisposition", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/codeInsight/codeVision/ui/popup/layouter/AnchoringRect;Ljava/util/List;Lcom/intellij/openapi/project/Project;IZ)V", "layout", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/intellij/codeInsight/codeVision/ui/popup/layouter/LayoutResult;", "getLayout", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "myDispositions", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "size", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "Ljava/awt/Dimension;", "getSize", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "getScreenRectangle", "Ljava/awt/Rectangle;", "point", "Ljava/awt/Point;", "updateLayout", "", "anchorRect", "intellij.platform.lang.impl"})
public final class DockingLayouter {
    @NotNull
    private final AnchoringRect anchor;
    @NotNull
    private final Project project;
    private final int padding;
    private final boolean promoteRecentlyUsedDisposition;
    @NotNull
    private final IProperty<LayoutResult> layout;
    @NotNull
    private final IOptProperty<Dimension> size;
    @NotNull
    private final List<Anchoring2D> myDispositions;

    public DockingLayouter(@NotNull Lifetime lifetime, @NotNull AnchoringRect anchor, @NotNull List<Anchoring2D> dispositions, @NotNull Project project2, int padding, boolean promoteRecentlyUsedDisposition) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter(dispositions, (String)"dispositions");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.anchor = anchor;
        this.project = project2;
        this.padding = padding;
        this.promoteRecentlyUsedDisposition = promoteRecentlyUsedDisposition;
        this.layout = (IProperty)new Property(null);
        this.size = (IOptProperty)new OptProperty();
        this.myDispositions = new ArrayList(dispositions);
        SourceExKt.adviseNotNull((ISource)((ISource)this.layout), (Lifetime)lifetime, (Function1)((Function1)new Function1<LayoutResult, Unit>(){

            public final void invoke(@NotNull LayoutResult result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (promoteRecentlyUsedDisposition) {
                    Anchoring2D promoted = result2.getDisposition();
                    myDispositions.remove(promoted);
                    myDispositions.add(0, promoted);
                }
            }
        }));
        this.size.view(lifetime, (Function2)new Function2<Lifetime, Dimension, Unit>(){

            public final void invoke(@NotNull Lifetime lt, final @NotNull Dimension sz) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                Intrinsics.checkNotNullParameter((Object)sz, (String)"sz");
                anchor.getRectangle().advise(lt, (Function1)new Function1<Rectangle, Unit>(){

                    public final void invoke(@Nullable Rectangle rect2) {
                        this.updateLayout(sz, rect2);
                    }
                });
            }
        });
    }

    public /* synthetic */ DockingLayouter(Lifetime lifetime, AnchoringRect anchoringRect, List list2, Project project2, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        if ((n2 & 0x20) != 0) {
            bl = true;
        }
        this(lifetime, anchoringRect, list2, project2, n, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final IProperty<LayoutResult> getLayout() {
        return this.layout;
    }

    @NotNull
    public final IOptProperty<Dimension> getSize() {
        return this.size;
    }

    private final void updateLayout(Dimension size, Rectangle anchorRect) {
        if (anchorRect == null) {
            this.layout.set(null);
            return;
        }
        Point point = anchorRect.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"anchorRect.location");
        Rectangle screenRect = this.getScreenRectangle(point);
        this.layout.set((Object)new RectangleDocker(anchorRect, size, this.myDispositions, screenRect, this.padding).layout());
    }

    private final Rectangle getScreenRectangle(Point point) {
        GraphicsDevice device;
        if (!SystemInfo.isWindows) {
            Rectangle rectangle = ScreenUtil.getScreenRectangle(point);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(point)");
            return rectangle;
        }
        IdeFocusManager ideFocusManager = IdeFocusManager.findInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"findInstance()");
        IdeFocusManager instance2 = ideFocusManager;
        IdeFrame lastFocusedFrame = instance2.getLastFocusedFrame();
        if (lastFocusedFrame instanceof IdeFrameEx && ((IdeFrameEx)lastFocusedFrame).isInFullScreen() && (device = ScreenUtil.getScreenDevice(new Rectangle(point, new Dimension(1, 1)))) != null && device.getDefaultConfiguration() != null) {
            Rectangle rectangle = device.getDefaultConfiguration().getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"device.defaultConfiguration.bounds");
            return rectangle;
        }
        Rectangle rectangle = ScreenUtil.getScreenRectangle(point);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(point)");
        return rectangle;
    }
}

