/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.popup.layouter;

import com.intellij.codeInsight.codeVision.ui.model.SwingScheduler;
import com.intellij.codeInsight.codeVision.ui.popup.layouter.AnchoringRect;
import com.intellij.codeInsight.codeVision.ui.popup.layouter.EditorAnchoringRect;
import com.intellij.codeInsight.codeVision.ui.popup.layouter.RectangleUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.util.AdditionalApiKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.time.Duration;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u0016R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/popup/layouter/EditorAnchoringRect;", "Lcom/intellij/codeInsight/codeVision/ui/popup/layouter/AnchoringRect;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "documentOffset", "", "delegate", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;ILkotlin/jvm/functions/Function1;)V", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "rectangle", "Lcom/jetbrains/rd/util/reactive/IProperty;", "getRectangle", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "calculateRectangle", "visibleAreaChanged", "Lcom/jetbrains/rd/util/reactive/ISource;", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "Lcom/intellij/openapi/editor/ScrollingModel;", "Companion", "intellij.platform.lang.impl"})
public final class EditorAnchoringRect
implements AnchoringRect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Function1<Rectangle, Rectangle> delegate;
    @NotNull
    private final RangeMarker rangeMarker;
    @NotNull
    private final IProperty<Rectangle> rectangle;

    public EditorAnchoringRect(@NotNull Lifetime lifetime, @NotNull Editor editor2, int documentOffset, @NotNull Function1<? super Rectangle, ? extends Rectangle> delegate2) {
        Object outerLifetime;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(delegate2, (String)"delegate");
        this.editor = editor2;
        this.delegate = delegate2;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        RangeMarker rangeMarker = document2.createRangeMarker(documentOffset, documentOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"document.createRangeMark\u2026ntOffset, documentOffset)");
        this.rangeMarker = rangeMarker;
        this.rectangle = (IProperty)new Property((Object)this.calculateRectangle());
        ScrollingModel scrollingModel = this.editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"editor.scrollingModel");
        ISource<VisibleAreaEvent> visibleAreaChanged2 = this.visibleAreaChanged(scrollingModel);
        Editor editor3 = this.editor;
        Object object = editor3 instanceof EditorImpl ? (EditorImpl)editor3 : null;
        if (object == null || (object = object.getDisposable()) == null || (object = LifetimeDisposableExKt.createLifetime((Disposable)object)) == null) {
            Project project2 = this.editor.getProject();
            object = project2 != null ? LifetimeDisposableExKt.createLifetime((Disposable)project2) : null;
        }
        Lifetime lt = (outerLifetime = object) != null ? (Lifetime)RLifetimeKt.intersect((Lifetime)lifetime, (Lifetime)outerLifetime) : lifetime;
        Duration duration = Duration.ofMillis(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(10)");
        AdditionalApiKt.throttleLast(visibleAreaChanged2, (Duration)duration, (IScheduler)SwingScheduler.INSTANCE).advise(lt, (Function1)new Function1<VisibleAreaEvent, Unit>(){

            public final void invoke(@NotNull VisibleAreaEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.getRectangle().set((Object)this.calculateRectangle());
            }
        });
    }

    public /* synthetic */ EditorAnchoringRect(Lifetime lifetime, Editor editor2, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(lifetime, editor2, n, (Function1<? super Rectangle, ? extends Rectangle>)function1);
    }

    @NotNull
    public IProperty<Rectangle> getRectangle() {
        return this.rectangle;
    }

    @NotNull
    public final ISource<VisibleAreaEvent> visibleAreaChanged(@NotNull ScrollingModel $this$visibleAreaChanged) {
        Intrinsics.checkNotNullParameter((Object)$this$visibleAreaChanged, (String)"<this>");
        return (ISource)new ISource<VisibleAreaEvent>($this$visibleAreaChanged){
            final /* synthetic */ ScrollingModel $this_visibleAreaChanged;
            {
                this.$this_visibleAreaChanged = $receiver;
            }

            public void advise(@NotNull Lifetime lifetime, @NotNull Function1<? super VisibleAreaEvent, Unit> handler2) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter(handler2, (String)"handler");
                VisibleAreaListener visibleAreaListener = arg_0 -> visibleAreaChanged.1.advise$lambda$0(handler2, arg_0);
                this.$this_visibleAreaChanged.addVisibleAreaListener(visibleAreaListener);
                lifetime.onTermination((Function0)new Function0<Unit>(this.$this_visibleAreaChanged, visibleAreaListener){
                    final /* synthetic */ ScrollingModel $this_visibleAreaChanged;
                    final /* synthetic */ VisibleAreaListener $visibleAreaListener;
                    {
                        this.$this_visibleAreaChanged = $receiver;
                        this.$visibleAreaListener = $visibleAreaListener;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_visibleAreaChanged.removeVisibleAreaListener(this.$visibleAreaListener);
                    }
                });
            }

            private static final void advise$lambda$0(Function1 $handler, VisibleAreaEvent it) {
                Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $handler.invoke((Object)it);
            }
        };
    }

    private final Rectangle calculateRectangle() {
        Rectangle rectangle;
        Point point;
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!(!this.editor.isDisposed())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!this.rangeMarker.isValid()) {
            return null;
        }
        TextRange range = new TextRange(this.rangeMarker.getStartOffset(), this.rangeMarker.getEndOffset());
        if (range.isEmpty()) {
            Point point2 = this.editor.offsetToXY(range.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"editor.offsetToXY(range.startOffset)");
            point = point2;
            rectangle = new Rectangle(point, new Dimension(JBUI.scale(1), this.editor.getLineHeight() + JBUI.scale(1)));
        } else {
            Point point3 = this.editor.offsetToXY(range.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"editor.offsetToXY(range.startOffset)");
            Point start = point3;
            Point point4 = this.editor.offsetToXY(range.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point4, (String)"editor.offsetToXY(range.endOffset)");
            Point end = point4;
            rectangle = RectangleUtilsKt.rectangleFromLTRBNonNegative(start.x, start.y - this.editor.getLineHeight(), end.x, end.y);
        }
        Rectangle rect2 = rectangle;
        Rectangle rectangle2 = RectangleUtilsKt.map(rect2, (Function1<? super Rectangle, ? extends Rectangle>)((Function1)new Function1<Rectangle, Rectangle>(this){
            final /* synthetic */ EditorAnchoringRect this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Rectangle invoke(@NotNull Rectangle it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return RectangleUtilsKt.map(it, (Function1<? super Rectangle, ? extends Rectangle>)EditorAnchoringRect.access$getDelegate$p(this.this$0));
            }
        }));
        if (rectangle2 == null) {
            return null;
        }
        rect2 = rectangle2;
        point = rect2.getLocation();
        SwingUtilities.convertPointToScreen(point, this.editor.getContentComponent());
        return new Rectangle(point, new Dimension(rect2.width, rect2.height));
    }

    public static final /* synthetic */ Function1 access$getDelegate$p(EditorAnchoringRect $this) {
        return $this.delegate;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/popup/layouter/EditorAnchoringRect$Companion;", "", "()V", "create", "Lcom/intellij/codeInsight/codeVision/ui/popup/layouter/EditorAnchoringRect;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "offset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "delegate", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "createHorizontalSmartClipRect", "Lcom/intellij/codeInsight/codeVision/ui/popup/layouter/AnchoringRect;", "createSmartClipRect", "horizontalSmartClipDelegate", "smartClipDelegate", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Rectangle, Rectangle> horizontalSmartClipDelegate(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (Function1)new Function1<Rectangle, Rectangle>(editor2){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                    super(1);
                }

                @Nullable
                public final Rectangle invoke(@NotNull Rectangle it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Rectangle rectangle = this.$editor.getScrollingModel().getVisibleArea();
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"editor.scrollingModel.visibleArea");
                    Rectangle visibleArea = rectangle;
                    return visibleArea.y >= it.y + this.$editor.getLineHeight() || visibleArea.y + visibleArea.height <= it.y - this.$editor.getLineHeight() / 2 ? null : RectangleUtilsKt.horizontalSmartClip(it, visibleArea);
                }
            };
        }

        private final Function1<Rectangle, Rectangle> smartClipDelegate(Editor editor2) {
            return (Function1)new Function1<Rectangle, Rectangle>(editor2){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                    super(1);
                }

                @NotNull
                public final Rectangle invoke(@NotNull Rectangle it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Rectangle rectangle = this.$editor.getScrollingModel().getVisibleArea();
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"editor.scrollingModel.visibleArea");
                    Rectangle visibleArea = rectangle;
                    return RectangleUtilsKt.smartClip(it, visibleArea);
                }
            };
        }

        @NotNull
        public final EditorAnchoringRect create(@NotNull Lifetime lifetime, int offset2, @NotNull Editor editor2, @NotNull Function1<? super Rectangle, ? extends Rectangle> delegate2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(delegate2, (String)"delegate");
            return new EditorAnchoringRect(lifetime, editor2, offset2, delegate2);
        }

        public static /* synthetic */ EditorAnchoringRect create$default(Companion companion, Lifetime lifetime, int n, Editor editor2, Function1 function1, int n2, Object object) {
            if ((n2 & 8) != 0) {
                function1 = create.1.INSTANCE;
            }
            return companion.create(lifetime, n, editor2, (Function1<? super Rectangle, ? extends Rectangle>)function1);
        }

        @NotNull
        public final AnchoringRect createSmartClipRect(@NotNull Lifetime lifetime, int offset2, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return this.create(lifetime, offset2, editor2, this.smartClipDelegate(editor2));
        }

        @NotNull
        public final AnchoringRect createHorizontalSmartClipRect(@NotNull Lifetime lifetime, int offset2, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return this.create(lifetime, offset2, editor2, this.horizontalSmartClipDelegate(editor2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

