/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.renderers;

import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.ui.model.CodeVisionListData;
import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.renderers.CodeVisionListRenderer;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionListPainter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0014J&\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0014\u0010\u0012\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/renderers/BlockCodeVisionListRenderer;", "Lcom/intellij/codeInsight/codeVision/ui/renderers/CodeVisionListRenderer;", "()V", "calcHeightInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcWidthInPixels", "entryBounds", "Ljava/awt/Rectangle;", "element", "Lcom/intellij/codeInsight/codeVision/CodeVisionEntry;", "getPoint", "Ljava/awt/Point;", "targetPoint", "hoveredEntry", "x", "y", "painterPosition", "intellij.platform.lang.impl"})
public final class BlockCodeVisionListRenderer
extends CodeVisionListRenderer {
    public BlockCodeVisionListRenderer() {
        super(null, 1, null);
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        CodeVisionListData userData;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        CodeVisionListData codeVisionListData = userData = (CodeVisionListData)inlay.getUserData(CodeVisionListData.KEY);
        boolean bl = codeVisionListData != null ? !codeVisionListData.isPainted() : false;
        if (bl) {
            return 0;
        }
        int painterPosition = this.painterPosition(inlay);
        CodeVisionListPainter codeVisionListPainter = this.getPainter();
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"inlay.editor");
        return codeVisionListPainter.size((Editor)editor2, (RangeCodeVisionModel.InlayState)this.inlayState(inlay), (CodeVisionListData)((CodeVisionListData)inlay.getUserData(CodeVisionListData.KEY))).width + painterPosition;
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        CodeVisionListPainter codeVisionListPainter = this.getPainter();
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"inlay.editor");
        return codeVisionListPainter.size((Editor)editor2, (RangeCodeVisionModel.InlayState)this.inlayState(inlay), (CodeVisionListData)((CodeVisionListData)inlay.getUserData(CodeVisionListData.KEY))).height;
    }

    @Override
    @NotNull
    protected Point getPoint(@NotNull Inlay<?> inlay, @NotNull Point targetPoint) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)targetPoint, (String)"targetPoint");
        int painterPosition = this.painterPosition(inlay);
        return new Point(targetPoint.x + painterPosition, targetPoint.y);
    }

    @Override
    @Nullable
    public CodeVisionEntry hoveredEntry(@NotNull Inlay<?> inlay, int x, int y) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        CodeVisionListPainter codeVisionListPainter = this.getPainter();
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"inlay.editor");
        return codeVisionListPainter.hoveredEntry(editor2, this.inlayState(inlay), (CodeVisionListData)inlay.getUserData(CodeVisionListData.KEY), x - this.painterPosition(inlay), y);
    }

    @Override
    @Nullable
    public Rectangle entryBounds(@NotNull Inlay<?> inlay, @NotNull CodeVisionEntry element) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        CodeVisionListPainter codeVisionListPainter = this.getPainter();
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"inlay.editor");
        Rectangle rectangle = codeVisionListPainter.hoveredEntryBounds(editor2, this.inlayState(inlay), (CodeVisionListData)inlay.getUserData(CodeVisionListData.KEY), element);
        if (rectangle == null) {
            return null;
        }
        Rectangle hoveredEntryBounds = rectangle;
        hoveredEntryBounds.x += this.painterPosition(inlay);
        return hoveredEntryBounds;
    }

    private final int painterPosition(Inlay<?> inlay) {
        if (!inlay.isValid()) {
            return 0;
        }
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"inlay.editor");
        Editor editor3 = editor2;
        int lineStartOffset = DocumentUtil.getLineStartOffset(inlay.getOffset(), editor3.getDocument());
        int shiftForward = CharArrayUtil.shiftForward(editor3.getDocument().getImmutableCharSequence(), lineStartOffset, " \t");
        return editor3.offsetToXY((int)shiftForward).x;
    }
}

