/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.renderers.painters;

import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.ui.model.AdditionalCodeVisionEntry;
import com.intellij.codeInsight.codeVision.ui.model.CodeVisionListData;
import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionStringPainter;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionTheme;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.DelimiterPainter;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.ICodeVisionEntryBasePainter;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.ICodeVisionGraphicPainter;
import com.intellij.codeInsight.codeVision.ui.renderers.providers.CodeVisionPainterProvidersKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0002J2\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J*\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u000eJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002JB\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u001cH\u0016J\"\u0010\u001d\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionListPainter;", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/ICodeVisionEntryBasePainter;", "Lcom/intellij/codeInsight/codeVision/ui/model/CodeVisionListData;", "delimiterPainter", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/ICodeVisionGraphicPainter;", "theme", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;", "(Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/ICodeVisionGraphicPainter;Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;)V", "loadingPainter", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionStringPainter;", "getTheme", "()Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;", "getRelativeBounds", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionEntry;", "Ljava/awt/Rectangle;", "editor", "Lcom/intellij/openapi/editor/Editor;", "state", "Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;", "value", "hoveredEntry", "x", "", "y", "hoveredEntryBounds", "element", "isHovered", "", "size", "loadingSize", "Ljava/awt/Dimension;", "paint", "", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "g", "Ljava/awt/Graphics;", "point", "Ljava/awt/Point;", "hovered", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nCodeVisionListPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeVisionListPainter.kt\ncom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionListPainter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1549#2:168\n1620#2,3:169\n*S KotlinDebug\n*F\n+ 1 CodeVisionListPainter.kt\ncom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionListPainter\n*L\n118#1:168\n118#1:169,3\n*E\n"})
public final class CodeVisionListPainter
implements ICodeVisionEntryBasePainter<CodeVisionListData> {
    @NotNull
    private final ICodeVisionGraphicPainter delimiterPainter;
    @NotNull
    private final CodeVisionTheme theme;
    @NotNull
    private CodeVisionStringPainter loadingPainter;

    public CodeVisionListPainter(@NotNull ICodeVisionGraphicPainter delimiterPainter, @Nullable CodeVisionTheme theme) {
        Intrinsics.checkNotNullParameter((Object)delimiterPainter, (String)"delimiterPainter");
        this.delimiterPainter = delimiterPainter;
        CodeVisionTheme codeVisionTheme = theme;
        if (codeVisionTheme == null) {
            codeVisionTheme = new CodeVisionTheme(0, 0, 0, 0, 0, 31, null);
        }
        this.theme = codeVisionTheme;
        this.loadingPainter = new CodeVisionStringPainter("Loading...", null, 2, null);
    }

    public /* synthetic */ CodeVisionListPainter(ICodeVisionGraphicPainter iCodeVisionGraphicPainter, CodeVisionTheme codeVisionTheme, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iCodeVisionGraphicPainter = new DelimiterPainter();
        }
        if ((n & 2) != 0) {
            codeVisionTheme = null;
        }
        this(iCodeVisionGraphicPainter, codeVisionTheme);
    }

    @NotNull
    public final CodeVisionTheme getTheme() {
        return this.theme;
    }

    private final Map<CodeVisionEntry, Rectangle> getRelativeBounds(Editor editor2, RangeCodeVisionModel.InlayState state, CodeVisionListData value) {
        HashMap map2 = new HashMap();
        if (value == null) {
            return map2;
        }
        int x = this.theme.getLeft();
        int y = 0;
        int delimiterWidth = this.delimiterPainter.size((Editor)editor2, (RangeCodeVisionModel.InlayState)state).width;
        Iterator<CodeVisionEntry> iterator2 = value.getVisibleLens().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            CodeVisionEntry it = iterator2.next();
            ICodeVisionEntryBasePainter<CodeVisionEntry> painter = CodeVisionPainterProvidersKt.painter(it);
            Dimension size = painter.size(editor2, state, it);
            ((Map)map2).put(it, new Rectangle(x, y, size.width, size.height));
            x += size.width;
            if (index2 >= value.getVisibleLens().size() - 1) continue;
            x += delimiterWidth;
        }
        AdditionalCodeVisionEntry moreEntry = value.getProjectModel().getMoreEntry();
        Dimension size = CodeVisionPainterProvidersKt.painter(moreEntry).size(editor2, state, moreEntry);
        ((Map)map2).put(moreEntry, new Rectangle(x += delimiterWidth, y, size.width, size.height));
        return map2;
    }

    @Override
    public void paint(@NotNull Editor editor2, @NotNull TextAttributes textAttributes, @NotNull Graphics g, @Nullable CodeVisionListData value, @NotNull Point point, @NotNull RangeCodeVisionModel.InlayState state, boolean hovered2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        int x = point.x + this.theme.getLeft();
        int y = point.y + this.theme.getTop() + ((EditorImpl)editor2).getAscent();
        if (value == null || value.getVisibleLens().isEmpty()) {
            this.loadingPainter.paint(editor2, textAttributes, g, new Point(x, y), state, hovered2);
            return;
        }
        Map<CodeVisionEntry, Rectangle> relativeBounds = this.getRelativeBounds(editor2, state, value);
        int delimiterWidth = this.delimiterPainter.size((Editor)editor2, (RangeCodeVisionModel.InlayState)state).width;
        Iterator<CodeVisionEntry> iterator2 = value.getVisibleLens().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Rectangle size;
            int index2 = n++;
            CodeVisionEntry it = iterator2.next();
            ICodeVisionEntryBasePainter<CodeVisionEntry> painter = CodeVisionPainterProvidersKt.painter(it);
            if (relativeBounds.get(it) == null) continue;
            painter.paint(editor2, textAttributes, g, it, new Point(x, y), state, value.isHoveredEntry(it));
            x += size.width;
            if (index2 >= value.getVisibleLens().size() - 1 && !hovered2) continue;
            this.delimiterPainter.paint(editor2, textAttributes, g, new Point(x, y), state, false);
            x += delimiterWidth;
        }
        if (hovered2) {
            AdditionalCodeVisionEntry moreEntry = value.getProjectModel().getMoreEntry();
            CodeVisionPainterProvidersKt.painter(moreEntry).paint(editor2, textAttributes, g, moreEntry, new Point(x, y), state, value.isHoveredEntry(moreEntry));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Dimension size(@NotNull Editor editor2, @NotNull RangeCodeVisionModel.InlayState state, @Nullable CodeVisionListData value) {
        Dimension dimension;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (value == null) {
            return this.loadingSize(editor2, state);
        }
        AdditionalCodeVisionEntry moreEntry = value.getProjectModel().getMoreEntry();
        int settingsWidth = CodeVisionPainterProvidersKt.painter((CodeVisionEntry)((CodeVisionEntry)moreEntry)).size((Editor)editor2, (RangeCodeVisionModel.InlayState)state, (CodeVisionEntry)moreEntry).width;
        Iterable $this$map$iv = value.getVisibleLens();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CodeVisionEntry codeVisionEntry = (CodeVisionEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CodeVisionPainterProvidersKt.painter((CodeVisionEntry)it).size((Editor)editor2, (RangeCodeVisionModel.InlayState)state, (CodeVisionEntry)it).width);
        }
        List list2 = (List)destination$iv$iv;
        if (value.getVisibleLens().isEmpty()) {
            dimension = this.loadingSize(editor2, state);
        } else {
            int delimiterWidth = this.delimiterPainter.size((Editor)editor2, (RangeCodeVisionModel.InlayState)state).width;
            dimension = new Dimension(CollectionsKt.sumOfInt((Iterable)list2) + (delimiterWidth * list2.size() - 1) + this.theme.getLeft() + this.theme.getRight() + settingsWidth, editor2.getLineHeight() + this.theme.getTop() + this.theme.getBottom());
        }
        return dimension;
    }

    private final Dimension loadingSize(Editor editor2, RangeCodeVisionModel.InlayState state) {
        return new Dimension(this.loadingPainter.size((Editor)editor2, (RangeCodeVisionModel.InlayState)state).width + this.theme.getLeft() + this.theme.getRight(), editor2.getLineHeight() + this.theme.getTop() + this.theme.getBottom());
    }

    private final boolean isHovered(int x, int y, Rectangle size) {
        return x >= size.x && x <= size.x + size.width;
    }

    @Nullable
    public final CodeVisionEntry hoveredEntry(@NotNull Editor editor2, @NotNull RangeCodeVisionModel.InlayState state, @Nullable CodeVisionListData value, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Map<CodeVisionEntry, Rectangle> relativeBounds = this.getRelativeBounds(editor2, state, value);
        for (Map.Entry<CodeVisionEntry, Rectangle> entry : relativeBounds.entrySet()) {
            CodeVisionEntry codeVisionEntry;
            if (!this.isHovered(x, y, entry.getValue())) continue;
            if (Intrinsics.areEqual((Object)entry.getKey().getProviderId(), (Object)"!More")) {
                CodeVisionListData codeVisionListData = value;
                if (codeVisionListData != null) {
                    CodeVisionListData it = codeVisionListData;
                    boolean bl = false;
                    codeVisionEntry = it.isMoreLensActive() ? entry.getKey() : null;
                } else {
                    codeVisionEntry = null;
                }
            } else {
                codeVisionEntry = entry.getKey();
            }
            return codeVisionEntry;
        }
        return null;
    }

    @Nullable
    public final Rectangle hoveredEntryBounds(@NotNull Editor editor2, @NotNull RangeCodeVisionModel.InlayState state, @Nullable CodeVisionListData value, @NotNull CodeVisionEntry element) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getRelativeBounds(editor2, state, value).get(element);
    }

    public CodeVisionListPainter() {
        this(null, null, 3, null);
    }
}

