/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.renderers.painters;

import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.model.richText.RichString;
import com.intellij.codeInsight.codeVision.ui.model.richText.RichText;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionTheme;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionThemeInfoProvider;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.ICodeVisionEntryBasePainter;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.paint.EffectPainter2D;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001&B%\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJE\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ)\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0%H\u0082\bR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionRichTextPainter;", "T", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/ICodeVisionEntryBasePainter;", "printer", "Lkotlin/Function1;", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;", "theme", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;", "(Lkotlin/jvm/functions/Function1;Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;)V", "getPrinter", "()Lkotlin/jvm/functions/Function1;", "getTheme", "()Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "g", "Ljava/awt/Graphics;", "value", "point", "Ljava/awt/Point;", "state", "Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;", "hovered", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/TextAttributes;Ljava/awt/Graphics;Ljava/lang/Object;Ljava/awt/Point;Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;Z)V", "size", "Ljava/awt/Dimension;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;Ljava/lang/Object;)Ljava/awt/Dimension;", "withColor", "Ljava/awt/Graphics2D;", "targetColor", "Ljava/awt/Color;", "block", "Lkotlin/Function0;", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nCodeVisionRichTextPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeVisionRichTextPainter.kt\ncom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionRichTextPainter\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n79#1,5:108\n79#1,5:113\n79#1,5:119\n39#2,3:104\n39#2,3:124\n1855#3:107\n1856#3:118\n1855#3,2:127\n*S KotlinDebug\n*F\n+ 1 CodeVisionRichTextPainter.kt\ncom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionRichTextPainter\n*L\n58#1:108,5\n63#1:113,5\n72#1:119,5\n35#1:104,3\n89#1:124,3\n49#1:107\n49#1:118\n91#1:127,2\n*E\n"})
public final class CodeVisionRichTextPainter<T>
implements ICodeVisionEntryBasePainter<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<T, RichText> printer;
    @NotNull
    private final CodeVisionTheme theme;
    @NotNull
    private static final Logger logger;

    public CodeVisionRichTextPainter(@NotNull Function1<? super T, ? extends RichText> printer, @Nullable CodeVisionTheme theme) {
        Intrinsics.checkNotNullParameter(printer, (String)"printer");
        this.printer = printer;
        CodeVisionTheme codeVisionTheme = theme;
        if (codeVisionTheme == null) {
            codeVisionTheme = new CodeVisionTheme(0, 0, 0, 0, 0, 31, null);
        }
        this.theme = codeVisionTheme;
    }

    public /* synthetic */ CodeVisionRichTextPainter(Function1 function1, CodeVisionTheme codeVisionTheme, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            codeVisionTheme = null;
        }
        this(function1, codeVisionTheme);
    }

    @NotNull
    public final Function1<T, RichText> getPrinter() {
        return this.printer;
    }

    @NotNull
    public final CodeVisionTheme getTheme() {
        return this.theme;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(@NotNull Editor editor2, @NotNull TextAttributes textAttributes, @NotNull Graphics g, T value, @NotNull Point point, @NotNull RangeCodeVisionModel.InlayState state, boolean hovered2) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        List<RichString> richSegments = ((RichText)this.printer.invoke(value)).getParts();
        boolean $i$f$service = false;
        Class<CodeVisionThemeInfoProvider> serviceClass$iv = CodeVisionThemeInfoProvider.class;
        CodeVisionThemeInfoProvider codeVisionThemeInfoProvider = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (codeVisionThemeInfoProvider == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        CodeVisionThemeInfoProvider themeInfoProvider = codeVisionThemeInfoProvider;
        boolean inSelectedBlock = Intrinsics.areEqual((Object)textAttributes.getBackgroundColor(), (Object)editor2.getSelectionModel().getTextAttributes().getBackgroundColor());
        Graphics2D graphics2D = (Graphics2D)g;
        if (inSelectedBlock) {
            color = editor2.getSelectionModel().getTextAttributes().getForegroundColor();
            if (color == null) {
                Color color2 = editor2.getColorsScheme().getDefaultForeground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"editor.colorsScheme.defaultForeground");
            }
        } else {
            color = themeInfoProvider.foregroundColor(editor2, hovered2);
        }
        graphics2D.setColor(color);
        int x = point.x + this.theme.getLeft();
        int y = point.y + this.theme.getTop();
        int xOffset = 0;
        xOffset = x;
        Color underlineColor = null;
        Iterable $this$forEach$iv = richSegments;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            RichString it = (RichString)element$iv;
            boolean bl = false;
            if (it.getAttributes().getBgColor() != null) {
                logger.error("Rich text renderer doesn't support background colors currently");
            }
            if (it.getAttributes().getWaveColor() != null) {
                logger.error("Rich text renderer doesn't support effect colors currently");
            }
            Color foregroundColor = it.getAttributes().getFgColor();
            if (underlineColor == null) {
                underlineColor = foregroundColor;
            } else if (!Intrinsics.areEqual((Object)underlineColor, (Object)foregroundColor)) {
                underlineColor = ((Graphics2D)g).getColor();
            }
            Font font = themeInfoProvider.font(editor2, it.getAttributes().getFontStyle());
            ((Graphics2D)g).setFont(font);
            CodeVisionRichTextPainter codeVisionRichTextPainter = this;
            Object g$iv = (Graphics2D)g;
            boolean $i$f$withColor = false;
            Color curColor$iv = ((Graphics)g$iv).getColor();
            Color color3 = foregroundColor;
            if (color3 == null) {
                color3 = ((Graphics)g$iv).getColor();
            }
            ((Graphics)g$iv).setColor(color3);
            boolean bl2 = false;
            g.drawString(it.getText(), xOffset, y);
            ((Graphics)g$iv).setColor(curColor$iv);
            FontMetrics metrics = ((Graphics2D)g).getFontMetrics();
            if (it.getAttributes().isStrikeout()) {
                g$iv = this;
                Graphics2D g$iv2 = (Graphics2D)g;
                boolean $i$f$withColor2 = false;
                Color curColor$iv2 = g$iv2.getColor();
                Color color4 = foregroundColor;
                if (color4 == null) {
                    color4 = g$iv2.getColor();
                }
                g$iv2.setColor(color4);
                boolean bl3 = false;
                EffectPainter2D.STRIKE_THROUGH.paint((Graphics2D)g, (double)xOffset, (double)(y + JBUI.scale(1)), (double)metrics.stringWidth(it.getText()), 5.0, (Object)((Graphics2D)g).getFont());
                g$iv2.setColor(curColor$iv2);
            }
            xOffset += metrics.stringWidth(it.getText());
        }
        if (hovered2) {
            void g$iv;
            Dimension size = this.size(editor2, state, value);
            CodeVisionRichTextPainter $i$f$forEach2 = this;
            Graphics2D graphics2D2 = (Graphics2D)g;
            Color targetColor$iv = underlineColor;
            boolean $i$f$withColor = false;
            Color curColor$iv = g$iv.getColor();
            Color color5 = targetColor$iv;
            if (color5 == null) {
                color5 = g$iv.getColor();
            }
            g$iv.setColor(color5);
            boolean bl = false;
            EffectPainter2D.LINE_UNDERSCORE.paint((Graphics2D)g, (double)x, (double)(y + JBUI.scale(1)), (double)size.width, 5.0, (Object)((Graphics2D)g).getFont());
            g$iv.setColor(curColor$iv);
        }
    }

    private final void withColor(Graphics2D g, Color targetColor, Function0<Unit> block) {
        boolean $i$f$withColor = false;
        Color curColor = g.getColor();
        Color color = targetColor;
        if (color == null) {
            color = g.getColor();
        }
        g.setColor(color);
        block.invoke();
        g.setColor(curColor);
    }

    @Override
    @NotNull
    public Dimension size(@NotNull Editor editor2, @NotNull RangeCodeVisionModel.InlayState state, T value) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        List<RichString> richSegments = ((RichText)this.printer.invoke(value)).getParts();
        int width = 0;
        width = this.theme.getLeft();
        int height = 0;
        height = this.theme.getTop();
        boolean $i$f$service = false;
        Class<CodeVisionThemeInfoProvider> serviceClass$iv = CodeVisionThemeInfoProvider.class;
        CodeVisionThemeInfoProvider codeVisionThemeInfoProvider = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (codeVisionThemeInfoProvider == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        CodeVisionThemeInfoProvider themeInfoProvider = codeVisionThemeInfoProvider;
        Iterable $this$forEach$iv = richSegments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RichString it = (RichString)element$iv;
            boolean bl = false;
            Font font = themeInfoProvider.font(editor2, it.getAttributes().getFontStyle());
            FontMetrics metrics = editor2.getComponent().getFontMetrics(font);
            width += metrics.stringWidth(it.getText());
            height = Math.max(height, metrics.getHeight());
        }
        return new Dimension(width + this.theme.getRight(), height + this.theme.getBottom());
    }

    static {
        Logger logger = Logger.getInstance(CodeVisionRichTextPainter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(CodeVisionRichTextPainter::class.java)");
        CodeVisionRichTextPainter.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionRichTextPainter$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

