/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.renderers.painters;

import com.intellij.codeInsight.daemon.impl.HintUtil;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionThemeInfoProvider;", "", "()V", "font", "Ljava/awt/Font;", "editor", "Lcom/intellij/openapi/editor/Editor;", "style", "", "foregroundColor", "Ljava/awt/Color;", "hovered", "", "lensFontSize", "", "intellij.platform.lang.impl"})
public class CodeVisionThemeInfoProvider {
    @NotNull
    public Color foregroundColor(@NotNull Editor editor2, boolean hovered2) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (hovered2) {
            Color color2 = JBUI.CurrentTheme.Link.Foreground.ENABLED;
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"{\n      JBUI.CurrentThem\u2026.Foreground.ENABLED\n    }");
        } else {
            Color color3 = editor2.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLAY_TEXT_WITHOUT_BACKGROUND).getForegroundColor();
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"{\n      editor.colorsSch\u2026ND).foregroundColor\n    }");
        }
        return color;
    }

    @NotNull
    public Font font(@NotNull Editor editor2, int style) {
        Font font;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        float size = this.lensFontSize(editor2);
        if (EditorSettingsExternalizable.getInstance().isUseEditorFontInInlays()) {
            Font editorFont = EditorUtil.getEditorFont();
            Font font2 = editorFont.deriveFont(style, size);
            font = font2;
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"{\n      val editorFont =\u2026eFont(style, size)\n\n    }");
        } else {
            Font font3 = UIUtil.getLabelFont().deriveFont(style, size);
            font = font3;
            Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"{\n      UIUtil.getLabelF\u2026veFont(style, size)\n    }");
        }
        return font;
    }

    public static /* synthetic */ Font font$default(CodeVisionThemeInfoProvider codeVisionThemeInfoProvider, Editor editor2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: font");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return codeVisionThemeInfoProvider.font(editor2, n);
    }

    public float lensFontSize(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return HintUtil.INSTANCE.getSize(editor2);
    }
}

