/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.ui.renderers.painters;

import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionTheme;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionThemeInfoProvider;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.ICodeVisionEntryBasePainter;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.paint.EffectPainter2D;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJE\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionVisionTextPainter;", "T", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/ICodeVisionEntryBasePainter;", "printer", "Lkotlin/Function1;", "", "theme", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;", "(Lkotlin/jvm/functions/Function1;Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;)V", "getPrinter", "()Lkotlin/jvm/functions/Function1;", "getTheme", "()Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionTheme;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "g", "Ljava/awt/Graphics;", "value", "point", "Ljava/awt/Point;", "state", "Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;", "hovered", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/TextAttributes;Ljava/awt/Graphics;Ljava/lang/Object;Ljava/awt/Point;Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;Z)V", "size", "Ljava/awt/Dimension;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;Ljava/lang/Object;)Ljava/awt/Dimension;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nCodeVisionVisionTextPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeVisionVisionTextPainter.kt\ncom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionVisionTextPainter\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,62:1\n39#2,3:63\n39#2,3:66\n*S KotlinDebug\n*F\n+ 1 CodeVisionVisionTextPainter.kt\ncom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionVisionTextPainter\n*L\n31#1:63,3\n54#1:66,3\n*E\n"})
public class CodeVisionVisionTextPainter<T>
implements ICodeVisionEntryBasePainter<T> {
    @NotNull
    private final Function1<T, String> printer;
    @NotNull
    private final CodeVisionTheme theme;

    public CodeVisionVisionTextPainter(@NotNull Function1<? super T, String> printer, @Nullable CodeVisionTheme theme) {
        Intrinsics.checkNotNullParameter(printer, (String)"printer");
        this.printer = printer;
        CodeVisionTheme codeVisionTheme = theme;
        if (codeVisionTheme == null) {
            codeVisionTheme = new CodeVisionTheme(0, 0, 0, 0, 0, 31, null);
        }
        this.theme = codeVisionTheme;
    }

    public /* synthetic */ CodeVisionVisionTextPainter(Function1 function1, CodeVisionTheme codeVisionTheme, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            codeVisionTheme = null;
        }
        this(function1, codeVisionTheme);
    }

    @NotNull
    public final Function1<T, String> getPrinter() {
        return this.printer;
    }

    @NotNull
    public final CodeVisionTheme getTheme() {
        return this.theme;
    }

    @Override
    public void paint(@NotNull Editor editor2, @NotNull TextAttributes textAttributes, @NotNull Graphics g, T value, @NotNull Point point, @NotNull RangeCodeVisionModel.InlayState state, boolean hovered2) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        boolean $i$f$service = false;
        Class<CodeVisionThemeInfoProvider> serviceClass$iv = CodeVisionThemeInfoProvider.class;
        CodeVisionThemeInfoProvider codeVisionThemeInfoProvider = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (codeVisionThemeInfoProvider == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        CodeVisionThemeInfoProvider themeInfoProvider = codeVisionThemeInfoProvider;
        boolean inSelectedBlock = Intrinsics.areEqual((Object)textAttributes.getBackgroundColor(), (Object)editor2.getSelectionModel().getTextAttributes().getBackgroundColor());
        Graphics2D graphics2D = (Graphics2D)g;
        if (inSelectedBlock) {
            color = editor2.getSelectionModel().getTextAttributes().getForegroundColor();
            if (color == null) {
                Color color2 = editor2.getColorsScheme().getDefaultForeground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"editor.colorsScheme.defaultForeground");
            }
        } else {
            color = themeInfoProvider.foregroundColor(editor2, hovered2);
        }
        graphics2D.setColor(color);
        ((Graphics2D)g).setFont(CodeVisionThemeInfoProvider.font$default(themeInfoProvider, editor2, 0, 2, null));
        int x = point.x + this.theme.getLeft();
        int y = point.y + this.theme.getTop();
        g.drawString((String)this.printer.invoke(value), x, y);
        if (hovered2) {
            Dimension size = this.size(editor2, state, value);
            EffectPainter2D.LINE_UNDERSCORE.paint((Graphics2D)g, (double)x, (double)(y += JBUI.scale(1)), (double)size.width, 5.0, (Object)((Graphics2D)g).getFont());
        }
    }

    @Override
    @NotNull
    public Dimension size(@NotNull Editor editor2, @NotNull RangeCodeVisionModel.InlayState state, T value) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        boolean $i$f$service = false;
        Class<CodeVisionThemeInfoProvider> serviceClass$iv = CodeVisionThemeInfoProvider.class;
        CodeVisionThemeInfoProvider codeVisionThemeInfoProvider = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (codeVisionThemeInfoProvider == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        FontMetrics fontMetrics = editor2.getComponent().getFontMetrics(CodeVisionThemeInfoProvider.font$default(codeVisionThemeInfoProvider, editor2, 0, 2, null));
        return new Dimension(fontMetrics.stringWidth((String)this.printer.invoke(value)) + this.theme.getLeft() + this.theme.getRight(), fontMetrics.getHeight() + this.theme.getTop() + this.theme.getBottom());
    }

    public CodeVisionVisionTextPainter() {
        this(null, null, 3, null);
    }
}

