/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompositeDeclarativeInsertHandler;
import com.intellij.codeInsight.completion.DeclarativeInsertHandler2;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.SingleInsertionDeclarativeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class AddSpaceInsertHandler
implements InsertHandler<LookupElement> {
    private static final String VALID_COMPLETION_CHARS = "\u0000\n\t\r(,.:=";
    public static final InsertHandler<LookupElement> INSTANCE = CompositeDeclarativeInsertHandler.Companion.withUniversalHandler("\u0000\n\t\r(,.:=", new SingleInsertionDeclarativeInsertHandler(" ", DeclarativeInsertHandler2.PopupOptions.DoNotShow.INSTANCE));
    public static final InsertHandler<LookupElement> INSTANCE_WITH_AUTO_POPUP = CompositeDeclarativeInsertHandler.Companion.withUniversalHandler("\u0000\n\t\r(,.:=", new SingleInsertionDeclarativeInsertHandler(" ", DeclarativeInsertHandler2.PopupOptions.MemberLookup.INSTANCE));
    private final String myIgnoreOnChars;
    private final boolean myTriggerAutoPopup;

    public AddSpaceInsertHandler(boolean triggerAutoPopup) {
        this("", triggerAutoPopup);
    }

    public AddSpaceInsertHandler(String ignoreOnChars, boolean triggerAutoPopup) {
        this.myIgnoreOnChars = ignoreOnChars;
        this.myTriggerAutoPopup = triggerAutoPopup;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        if (context2 == null) {
            AddSpaceInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            AddSpaceInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor2 = context2.getEditor();
        char completionChar = context2.getCompletionChar();
        if (completionChar == ' ' || StringUtil.containsChar(this.myIgnoreOnChars, completionChar)) {
            return;
        }
        Project project2 = editor2.getProject();
        if (project2 != null) {
            if (!AddSpaceInsertHandler.isCharAtSpace(editor2)) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)" ");
                PsiDocumentManager.getInstance(project2).commitDocument(editor2.getDocument());
            } else if (this.shouldOverwriteExistingSpace(editor2)) {
                editor2.getCaretModel().moveToOffset(editor2.getCaretModel().getOffset() + 1);
            }
            if (this.myTriggerAutoPopup) {
                AutoPopupController.getInstance(project2).autoPopupMemberLookup(editor2, null);
            }
        }
    }

    protected boolean shouldOverwriteExistingSpace(Editor editor2) {
        return true;
    }

    private static boolean isCharAtSpace(Editor editor2) {
        int startOffset = editor2.getCaretModel().getOffset();
        Document document = editor2.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == ' ';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/AddSpaceInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

