/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.completion.CompletionFinalSorter;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionPreselectSkipper;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.LookupElementListPresenter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.diagnostic.telemetry.TraceKt;
import com.intellij.diagnostic.telemetry.TraceManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import io.opentelemetry.api.trace.Tracer;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCompletionLookupArranger
extends LookupArranger
implements CompletionLookupArranger {
    private static final Logger LOG = Logger.getInstance(BaseCompletionLookupArranger.class);
    private static final Key<LookupElementPresentation> DEFAULT_PRESENTATION = Key.create("PRESENTATION_INVARIANT");
    private static final Comparator<LookupElementPresentation> PRESENTATION_COMPARATOR = Comparator.comparing(LookupElementPresentation::getItemText, NaturalComparator.INSTANCE).thenComparing(p -> StringUtil.notNullize(p.getTailText()).length()).thenComparing(LookupElementPresentation::getTailText, NaturalComparator.INSTANCE).thenComparing(LookupElementPresentation::getTypeText, NaturalComparator.INSTANCE);
    private static final Comparator<LookupElement> BY_PRESENTATION_COMPARATOR = Comparator.comparing(DEFAULT_PRESENTATION::get, PRESENTATION_COMPARATOR);
    static final int MAX_PREFERRED_COUNT = 5;
    public static final Key<Object> FORCE_MIDDLE_MATCH = Key.create("FORCE_MIDDLE_MATCH");
    private final List<LookupElement> myFrozenItems = new ArrayList<LookupElement>();
    private final int myLimit = Registry.intValue("ide.completion.variant.limit");
    private boolean myOverflow;
    private volatile CompletionLocation myLocation;
    protected final CompletionProcessEx myProcess;
    private final Map<CompletionSorterImpl, Classifier<LookupElement>> myClassifiers = Collections.synchronizedMap(new LinkedHashMap());
    private final Key<CompletionSorterImpl> mySorterKey = Key.create("SORTER_KEY");
    private final CompletionFinalSorter myFinalSorter = CompletionFinalSorter.newSorter();
    private volatile int myPrefixChanges;
    private String myLastLookupPrefix;
    private final CompletionPreselectSkipper[] mySkippers = CompletionPreselectSkipper.EP_NAME.getExtensions();
    private final Set<LookupElement> mySkippedItems = Collections.newSetFromMap(new IdentityHashMap());
    private final ThreadLocal<Boolean> isInBatchUpdate = new ThreadLocal();
    private final List<Pair<LookupElement, LookupElementPresentation>> batchItems = new ArrayList<Pair<LookupElement, LookupElementPresentation>>();

    public BaseCompletionLookupArranger(CompletionProcessEx process2) {
        this.myProcess = process2;
    }

    private MultiMap<CompletionSorterImpl, LookupElement> groupItemsBySorter(Iterable<? extends LookupElement> source) {
        MultiMap<CompletionSorterImpl, LookupElement> inputBySorter = MultiMap.createLinked();
        for (LookupElement lookupElement : source) {
            inputBySorter.putValue(this.obtainSorter(lookupElement), lookupElement);
        }
        for (CompletionSorterImpl completionSorterImpl : inputBySorter.keySet()) {
            inputBySorter.put(completionSorterImpl, this.sortByPresentation(inputBySorter.get(completionSorterImpl)));
        }
        return inputBySorter;
    }

    @NotNull
    private CompletionSorterImpl obtainSorter(LookupElement element) {
        CompletionSorterImpl completionSorterImpl = element.getUserData(this.mySorterKey);
        if (completionSorterImpl == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(0);
        }
        return completionSorterImpl;
    }

    @Override
    @NotNull
    public synchronized Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items2, boolean hideSingleValued) {
        if (items2 == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(1);
        }
        IdentityHashMap<LookupElement, SmartList<Pair>> map2 = new IdentityHashMap<LookupElement, SmartList<Pair>>();
        MultiMap<CompletionSorterImpl, LookupElement> inputBySorter = this.groupItemsBySorter(items2);
        int sorterNumber = 0;
        for (CompletionSorterImpl sorter : inputBySorter.keySet()) {
            ++sorterNumber;
            Collection<LookupElement> thisSorterItems = inputBySorter.get(sorter);
            for (LookupElement element : thisSorterItems) {
                map2.put(element, new SmartList<Pair>(new Pair<String, Boolean>("frozen", this.myFrozenItems.contains(element)), new Pair<String, Integer>("sorter", sorterNumber)));
            }
            ProcessingContext processingContext = this.createContext();
            for (Classifier<LookupElement> classifier = this.myClassifiers.get(sorter); classifier != null; classifier = classifier.getNext()) {
                ReferenceOpenHashSet<LookupElement> itemSet = new ReferenceOpenHashSet<LookupElement>(thisSorterItems);
                List<LookupElement> unsortedItems = ContainerUtil.filter(this.myItems, itemSet::contains);
                List<Pair<LookupElement, Object>> pairs = classifier.getSortingWeights(unsortedItems, processingContext);
                if (hideSingleValued && BaseCompletionLookupArranger.haveSameWeights(pairs)) continue;
                for (Pair<LookupElement, Object> pair : pairs) {
                    ((List)map2.get(pair.first)).add(Pair.create(classifier.getPresentableName(), pair.second));
                }
            }
        }
        Reference2ObjectLinkedOpenHashMap<LookupElement, List<Pair<String, Object>>> result2 = new Reference2ObjectLinkedOpenHashMap<LookupElement, List<Pair<String, Object>>>();
        Map<LookupElement, List<Pair<String, Object>>> additional = this.myFinalSorter.getRelevanceObjects(items2);
        for (LookupElement lookupElement : items2) {
            List<Pair<String, Object>> mainRelevance = (List<Pair<String, Object>>)map2.get(lookupElement);
            List<Pair<String, Object>> additionalRelevance = additional.get(lookupElement);
            result2.put(lookupElement, additionalRelevance == null ? mainRelevance : ContainerUtil.concat(mainRelevance, additionalRelevance));
        }
        Reference2ObjectLinkedOpenHashMap<LookupElement, List<Pair<String, Object>>> reference2ObjectLinkedOpenHashMap = result2;
        if (reference2ObjectLinkedOpenHashMap == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(2);
        }
        return reference2ObjectLinkedOpenHashMap;
    }

    void associateSorter(LookupElement element, CompletionSorterImpl sorter) {
        element.putUserData(this.mySorterKey, sorter);
    }

    private static boolean haveSameWeights(List<? extends Pair<LookupElement, Object>> pairs) {
        if (pairs.isEmpty()) {
            return true;
        }
        for (int i2 = 1; i2 < pairs.size(); ++i2) {
            if (Comparing.equal(pairs.get((int)i2).second, pairs.get((int)0).second)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addElement(@NotNull LookupElement element, @NotNull CompletionSorter sorter, @NotNull PrefixMatcher prefixMatcher, @NotNull LookupElementPresentation presentation2) {
        if (element == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(3);
        }
        if (sorter == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(4);
        }
        if (prefixMatcher == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(5);
        }
        if (presentation2 == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(6);
        }
        this.registerMatcher(element, prefixMatcher);
        this.associateSorter(element, (CompletionSorterImpl)sorter);
        this.addElement(element, presentation2);
    }

    @Override
    public void addElement(@NotNull CompletionResult result2) {
        if (result2 == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(7);
        }
        LookupElementPresentation presentation2 = new LookupElementPresentation();
        result2.getLookupElement().renderElement(presentation2);
        this.addElement(result2.getLookupElement(), result2.getSorter(), result2.getPrefixMatcher(), presentation2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addElement(LookupElement element, LookupElementPresentation presentation2) {
        boolean shouldSkip = this.shouldSkip(element);
        presentation2.freeze();
        element.putUserData(DEFAULT_PRESENTATION, presentation2);
        CompletionSorterImpl sorter = this.obtainSorter(element);
        ProcessingContext context2 = this.createContext();
        Classifier classifier = this.myClassifiers.computeIfAbsent(sorter, s -> s.buildClassifier(new EmptyClassifier()));
        classifier.addElement(element, context2);
        boolean batchUpdate = Boolean.TRUE.equals(this.isInBatchUpdate.get());
        if (batchUpdate) {
            BaseCompletionLookupArranger baseCompletionLookupArranger = this;
            synchronized (baseCompletionLookupArranger) {
                if (shouldSkip) {
                    this.mySkippedItems.add(element);
                }
                this.batchItems.add(new Pair<LookupElement, LookupElementPresentation>(element, presentation2));
            }
        }
        BaseCompletionLookupArranger baseCompletionLookupArranger = this;
        synchronized (baseCompletionLookupArranger) {
            if (shouldSkip) {
                this.mySkippedItems.add(element);
            }
            super.addElement(element, presentation2);
        }
        this.trimToLimit(context2);
    }

    @ApiStatus.Internal
    public void batchUpdate(Runnable runnable) {
        if (Boolean.TRUE.equals(this.isInBatchUpdate.get())) {
            runnable.run();
        } else {
            this.isInBatchUpdate.set(true);
            try {
                runnable.run();
            }
            finally {
                this.isInBatchUpdate.remove();
            }
            if (!this.batchItems.isEmpty()) {
                this.flushBatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBatch() {
        BaseCompletionLookupArranger baseCompletionLookupArranger = this;
        synchronized (baseCompletionLookupArranger) {
            for (Pair<LookupElement, LookupElementPresentation> pair : this.batchItems) {
                super.addElement((LookupElement)pair.first, (LookupElementPresentation)pair.second);
            }
            this.batchItems.clear();
        }
        this.trimToLimit(this.createContext());
    }

    @Override
    public synchronized void prefixReplaced(@NotNull Lookup lookup2, @NotNull String newPrefix) {
        if (lookup2 == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(8);
        }
        if (newPrefix == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(9);
        }
        super.prefixReplaced(lookup2, newPrefix);
    }

    @Override
    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
        this.myProcess.itemSelected(lookupItem, completionChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToLimit(ProcessingContext context2) {
        List<LookupElement> removed;
        BaseCompletionLookupArranger baseCompletionLookupArranger = this;
        synchronized (baseCompletionLookupArranger) {
            if (this.myItems.size() < this.myLimit) {
                return;
            }
            List<LookupElement> items2 = this.getMatchingItems();
            Iterator<LookupElement> iterator2 = this.sortByRelevance(this.groupItemsBySorter(items2)).iterator();
            ReferenceOpenHashSet<LookupElement> retainedSet = new ReferenceOpenHashSet<LookupElement>();
            retainedSet.addAll(this.getPrefixItems(true));
            retainedSet.addAll(this.getPrefixItems(false));
            retainedSet.addAll(this.myFrozenItems);
            while (retainedSet.size() < this.myLimit / 2 && iterator2.hasNext()) {
                retainedSet.add(iterator2.next());
            }
            if (!iterator2.hasNext()) {
                return;
            }
            removed = this.retainItems(retainedSet);
            if (!this.myOverflow) {
                this.myOverflow = true;
                this.myProcess.addAdvertisement(AnalysisBundle.message("completion.not.all.variants.are.shown", new Object[0]), null);
                this.myProcess.addWatchedPrefix(0, StandardPatterns.string());
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this.printTestWarning();
                }
            }
        }
        for (LookupElement element : removed) {
            this.removeItem(element, context2);
        }
    }

    private void printTestWarning() {
        System.err.println("Your test might miss some lookup items, because only " + this.myLimit / 2 + " most relevant items are guaranteed to be shown in the lookup. You can:");
        System.err.println("1. Make the prefix used for completion longer, so that there are less suggestions.");
        System.err.println("2. Increase 'ide.completion.variant.limit' (using RegistryValue#setValue with a test root disposable).");
        System.err.println("3. Ignore this warning.");
    }

    protected void removeItem(LookupElement element, ProcessingContext context2) {
        CompletionSorterImpl sorter = this.obtainSorter(element);
        Classifier<LookupElement> classifier = this.myClassifiers.get(sorter);
        if (classifier != null) {
            classifier.removeElement(element, context2);
        }
    }

    private List<LookupElement> sortByPresentation(Iterable<? extends LookupElement> source) {
        ArrayList<LookupElement> startMatches = new ArrayList<LookupElement>();
        ArrayList middleMatches = new ArrayList();
        for (LookupElement lookupElement : source) {
            (this.itemMatcher(lookupElement).isStartMatch(lookupElement) ? startMatches : middleMatches).add(lookupElement);
        }
        ContainerUtil.sort(startMatches, BY_PRESENTATION_COMPARATOR);
        ContainerUtil.sort(middleMatches, BY_PRESENTATION_COMPARATOR);
        startMatches.addAll(middleMatches);
        return startMatches;
    }

    protected boolean isAlphaSorted() {
        return false;
    }

    @Override
    public Pair<List<LookupElement>, Integer> arrangeItems() {
        LookupElementListPresenter dummyListPresenter = new LookupElementListPresenter(){

            @Override
            @NotNull
            public String getAdditionalPrefix() {
                return "";
            }

            @Override
            public LookupElement getCurrentItem() {
                return null;
            }

            @Override
            public LookupElement getCurrentItemOrEmpty() {
                return null;
            }

            @Override
            public boolean isSelectionTouched() {
                return false;
            }

            @Override
            public int getSelectedIndex() {
                return 0;
            }

            @Override
            public int getLastVisibleIndex() {
                return 0;
            }

            @Override
            @NotNull
            public LookupFocusDegree getLookupFocusDegree() {
                LookupFocusDegree lookupFocusDegree = LookupFocusDegree.FOCUSED;
                if (lookupFocusDegree == null) {
                    1.$$$reportNull$$$0(0);
                }
                return lookupFocusDegree;
            }

            @Override
            public boolean isShown() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/BaseCompletionLookupArranger$1", "getLookupFocusDegree"));
            }
        };
        return this.doArrangeItems(dummyListPresenter, false);
    }

    @Override
    public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup2, boolean onExplicitAction) {
        if (lookup2 == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(10);
        }
        return this.doArrangeItems((LookupElementListPresenter)((Object)lookup2), onExplicitAction);
    }

    @NotNull
    private synchronized Pair<List<LookupElement>, Integer> doArrangeItems(@NotNull LookupElementListPresenter lookup2, boolean onExplicitAction) {
        if (lookup2 == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(11);
        }
        Pair pair = (Pair)TraceKt.computeWithSpan((Tracer)TraceManager.INSTANCE.getTracer("codeCompletion"), (String)"arrangeItems", span -> {
            List<LookupElement> items2 = this.getMatchingItems();
            Iterable<LookupElement> sortedByRelevance = this.sortByRelevance(this.groupItemsBySorter(items2));
            sortedByRelevance = this.applyFinalSorter(sortedByRelevance);
            LookupElement relevantSelection = this.findMostRelevantItem(sortedByRelevance);
            List<LookupElement> listModel = this.isAlphaSorted() ? this.sortByPresentation(items2) : this.fillModelByRelevance(lookup2, new ReferenceOpenHashSet<LookupElement>(items2), sortedByRelevance, relevantSelection);
            int toSelect2 = this.getItemToSelect(lookup2, listModel, onExplicitAction, relevantSelection);
            LOG.assertTrue(toSelect2 >= 0);
            return new Pair<List<LookupElement>, Integer>(listModel, toSelect2);
        });
        if (pair == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @NotNull
    protected Iterable<? extends LookupElement> applyFinalSorter(Iterable<? extends LookupElement> sortedByRelevance) {
        if (sortedByRelevance.iterator().hasNext()) {
            Iterable<? extends LookupElement> iterable = this.myFinalSorter.sort(sortedByRelevance, Objects.requireNonNull(this.myProcess.getParameters()));
            if (iterable == null) {
                BaseCompletionLookupArranger.$$$reportNull$$$0(13);
            }
            return iterable;
        }
        Iterable<? extends LookupElement> iterable = sortedByRelevance;
        if (iterable == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(14);
        }
        return iterable;
    }

    private List<LookupElement> fillModelByRelevance(LookupElementListPresenter lookup2, Set<? extends LookupElement> items2, Iterable<? extends LookupElement> sortedElements, @Nullable LookupElement relevantSelection) {
        Iterator<? extends LookupElement> byRelevance = sortedElements.iterator();
        LinkedHashSet model2 = new LinkedHashSet();
        this.addPrefixItems(model2);
        this.addFrozenItems(items2, model2);
        if (model2.size() < 5) {
            BaseCompletionLookupArranger.addSomeItems(model2, byRelevance, lastAdded -> model2.size() >= 5);
        }
        BaseCompletionLookupArranger.addCurrentlySelectedItemToTop(lookup2, items2, model2);
        this.freezeTopItems(lookup2, model2);
        BaseCompletionLookupArranger.ensureItemAdded(items2, model2, byRelevance, lookup2.getCurrentItem());
        BaseCompletionLookupArranger.ensureItemAdded(items2, model2, byRelevance, relevantSelection);
        ContainerUtil.addAll(model2, byRelevance);
        return new ArrayList<LookupElement>(model2);
    }

    private static void ensureItemAdded(Set<? extends LookupElement> items2, LinkedHashSet<? super LookupElement> model2, Iterator<? extends LookupElement> byRelevance, @Nullable LookupElement item) {
        if (item != null && items2.contains(item) && !model2.contains(item)) {
            BaseCompletionLookupArranger.addSomeItems(model2, byRelevance, lastAdded -> lastAdded == item);
        }
    }

    private void freezeTopItems(LookupElementListPresenter lookup2, LinkedHashSet<? extends LookupElement> model2) {
        this.myFrozenItems.clear();
        if (lookup2.isShown()) {
            this.myFrozenItems.addAll(model2);
        }
    }

    private void addFrozenItems(Set<? extends LookupElement> items2, LinkedHashSet<? super LookupElement> model2) {
        this.myFrozenItems.removeIf(element -> !element.isValid() || !items2.contains(element));
        model2.addAll(this.myFrozenItems);
    }

    private void addPrefixItems(LinkedHashSet<? super LookupElement> model2) {
        ContainerUtil.addAll(model2, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(true))));
        ContainerUtil.addAll(model2, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(false))));
    }

    private static void addCurrentlySelectedItemToTop(LookupElementListPresenter lookup2, Set<? extends LookupElement> items2, LinkedHashSet<? super LookupElement> model2) {
        LookupElement lastSelection;
        if (!lookup2.isSelectionTouched() && items2.contains(lastSelection = lookup2.getCurrentItem())) {
            model2.add(lastSelection);
        }
    }

    private static void addSomeItems(Set<? super LookupElement> model2, Iterator<? extends LookupElement> iterator2, Predicate<? super LookupElement> stopWhen) {
        while (iterator2.hasNext()) {
            LookupElement item = iterator2.next();
            model2.add(item);
            if (!stopWhen.test(item)) continue;
            break;
        }
    }

    private Iterable<LookupElement> sortByRelevance(MultiMap<CompletionSorterImpl, LookupElement> inputBySorter) {
        if (inputBySorter.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<CompletionSorterImpl, Classifier<LookupElement>>> entries2 = new ArrayList<Map.Entry<CompletionSorterImpl, Classifier<LookupElement>>>(this.myClassifiers.entrySet());
        return EntryStream.of(entries2.iterator()).mapKeyValue((sorter, classifier) -> classifier.classify(inputBySorter.get((CompletionSorterImpl)sorter), this.createContext())).flatMap(iterable -> StreamEx.of(iterable.iterator())).toList();
    }

    private ProcessingContext createContext() {
        ProcessingContext context2 = new ProcessingContext();
        context2.put(PREFIX_CHANGES, this.myPrefixChanges);
        context2.put(WEIGHING_CONTEXT, this);
        return context2;
    }

    void setLastLookupPrefix(String lookupPrefix) {
        this.myLastLookupPrefix = lookupPrefix;
    }

    public String getLastLookupPrefix() {
        return this.myLastLookupPrefix;
    }

    @Override
    public LookupArranger createEmptyCopy() {
        return new BaseCompletionLookupArranger(this.myProcess);
    }

    private int getItemToSelect(LookupElementListPresenter lookup2, List<? extends LookupElement> items2, boolean onExplicitAction, @Nullable LookupElement mostRelevant) {
        LookupElement exactMatch;
        if (items2.isEmpty() || lookup2.getLookupFocusDegree() == LookupFocusDegree.UNFOCUSED) {
            return 0;
        }
        if (lookup2.isSelectionTouched() || !onExplicitAction) {
            int index2;
            LookupElement lastSelection = lookup2.getCurrentItem();
            int old = ContainerUtil.indexOfIdentity(items2, lastSelection);
            if (old >= 0) {
                return old;
            }
            LookupElement selectedValue = lookup2.getCurrentItemOrEmpty();
            if (selectedValue instanceof EmptyLookupItem && ((EmptyLookupItem)selectedValue).isLoading() && (index2 = lookup2.getSelectedIndex()) >= 0 && index2 < items2.size()) {
                return index2;
            }
            for (int i2 = 0; i2 < items2.size(); ++i2) {
                LookupElementPresentation p2;
                LookupElementPresentation p1 = BaseCompletionLookupArranger.getDefaultPresentation(items2.get(i2));
                LookupElementPresentation lookupElementPresentation = p2 = lastSelection == null ? null : BaseCompletionLookupArranger.getDefaultPresentation(lastSelection);
                if (p1 == null || p2 == null || PRESENTATION_COMPARATOR.compare(p1, p2) != 0) continue;
                return i2;
            }
        }
        return Math.max(0, ContainerUtil.indexOfIdentity(items2, (exactMatch = this.getBestExactMatch(items2)) != null ? exactMatch : mostRelevant));
    }

    @ApiStatus.Internal
    public static LookupElementPresentation getDefaultPresentation(@NotNull LookupElement item) {
        if (item == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(15);
        }
        return item.getUserData(DEFAULT_PRESENTATION);
    }

    protected List<LookupElement> getExactMatches(List<? extends LookupElement> items2) {
        Editor editor2 = this.myProcess.getParameters().getEditor();
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        String selectedText = editor2.getSelectionModel().getSelectedText();
        SmartList<LookupElement> exactMatches = new SmartList<LookupElement>();
        for (LookupElement lookupElement : items2) {
            if (!this.isPrefixItem(lookupElement, true) && !lookupElement.getLookupString().equals(selectedText)) continue;
            exactMatches.add(lookupElement);
        }
        return exactMatches;
    }

    @Nullable
    private LookupElement getBestExactMatch(List<? extends LookupElement> items2) {
        List<LookupElement> exactMatches = this.getExactMatches(items2);
        if (exactMatches.isEmpty()) {
            return null;
        }
        if (exactMatches.size() == 1) {
            return exactMatches.get(0);
        }
        return this.sortByRelevance(this.groupItemsBySorter(exactMatches)).iterator().next();
    }

    @Nullable
    private LookupElement findMostRelevantItem(Iterable<? extends LookupElement> sorted) {
        for (LookupElement lookupElement : sorted) {
            if (this.mySkippedItems.contains(lookupElement)) continue;
            return lookupElement;
        }
        return null;
    }

    private boolean shouldSkip(LookupElement element) {
        CompletionLocation location2 = this.getLocation();
        for (CompletionPreselectSkipper skipper : this.mySkippers) {
            if (!skipper.skipElement(element, location2)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped element " + element + " by " + skipper);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompletionLocation getLocation() {
        if (this.myLocation == null) {
            BaseCompletionLookupArranger baseCompletionLookupArranger = this;
            synchronized (baseCompletionLookupArranger) {
                if (this.myLocation == null) {
                    this.myLocation = new CompletionLocation(Objects.requireNonNull(this.myProcess.getParameters()));
                }
            }
        }
        CompletionLocation completionLocation = this.myLocation;
        if (completionLocation == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(16);
        }
        return completionLocation;
    }

    @Override
    public synchronized void prefixChanged(Lookup lookup2) {
        ++this.myPrefixChanges;
        this.myFrozenItems.clear();
        super.prefixChanged(lookup2);
    }

    @Override
    public void prefixTruncated(@NotNull LookupEx lookup2, int hideOffset) {
        if (lookup2 == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(17);
        }
        if (hideOffset < lookup2.getEditor().getCaretModel().getOffset()) {
            this.myProcess.scheduleRestart();
            return;
        }
        this.myProcess.prefixUpdated();
        lookup2.hideLookup(false);
    }

    @Override
    public boolean isCompletion() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 15, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/BaseCompletionLookupArranger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPrefix";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainSorter";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/BaseCompletionLookupArranger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevanceObjects";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doArrangeItems";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "applyFinalSorter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRelevanceObjects";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prefixReplaced";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "arrangeItems";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doArrangeItems";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPresentation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prefixTruncated";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 15, 17 -> new IllegalArgumentException(string2);
        };
    }

    private static final class EmptyClassifier
    extends Classifier<LookupElement> {
        private EmptyClassifier() {
            super(null, "empty");
        }

        @Override
        @NotNull
        public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items2, @NotNull ProcessingContext context2) {
            if (items2 == null) {
                EmptyClassifier.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                EmptyClassifier.$$$reportNull$$$0(1);
            }
            List<Pair<LookupElement, Object>> list2 = Collections.emptyList();
            if (list2 == null) {
                EmptyClassifier.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context2) {
            if (source == null) {
                EmptyClassifier.$$$reportNull$$$0(3);
            }
            if (context2 == null) {
                EmptyClassifier.$$$reportNull$$$0(4);
            }
            Iterable<LookupElement> iterable = source;
            if (iterable == null) {
                EmptyClassifier.$$$reportNull$$$0(5);
            }
            return iterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/BaseCompletionLookupArranger$EmptyClassifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/BaseCompletionLookupArranger$EmptyClassifier";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortingWeights";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortingWeights";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "classify";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 5 -> new IllegalStateException(string2);
            };
        }
    }
}

