/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.StringComboboxEditor;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public class ComboEditorCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final Key<Boolean> CONTINUE_RUN_COMPLETION = Key.create("CONTINUE_RUN_COMPLETION");
    private static final Key<LookupElementProvider> LOOKUP_ELEMENT_PROVIDER_KEY = Key.create("LOOKUP_ELEMENT_PROVIDER_KEY");

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        JComboBox comboBox;
        if (parameters2 == null) {
            ComboEditorCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ComboEditorCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters2.getInvocationCount() == 0) {
            return;
        }
        PsiFile file2 = parameters2.getOriginalFile();
        Document document = PsiDocumentManager.getInstance(file2.getProject()).getDocument(file2);
        if (document != null && (comboBox = document.getUserData(StringComboboxEditor.COMBO_BOX_KEY)) != null) {
            String substring = document.getText().substring(0, parameters2.getOffset());
            boolean plainPrefixMatcher = Boolean.TRUE.equals(document.getUserData(StringComboboxEditor.USE_PLAIN_PREFIX_MATCHER));
            CompletionResultSet resultSet = plainPrefixMatcher ? result2.withPrefixMatcher(new PlainPrefixMatcher(substring)) : result2.withPrefixMatcher(substring);
            LookupElementProvider lookupElementProvider = LOOKUP_ELEMENT_PROVIDER_KEY.get(document, LookupElementProvider.DEFAULT);
            int count2 = comboBox.getItemCount();
            for (int i2 = 0; i2 < count2; ++i2) {
                Object o = comboBox.getItemAt(i2);
                if (!(o instanceof String)) continue;
                resultSet.addElement(PrioritizedLookupElement.withPriority(lookupElementProvider.createLookupElement((String)o), count2 - i2));
            }
            if (!Boolean.TRUE.equals(document.getUserData(CONTINUE_RUN_COMPLETION))) {
                result2.stopHere();
            }
        }
    }

    public static void installLookupElementProvider(@NotNull Document document, @NotNull LookupElementProvider provider2) {
        if (document == null) {
            ComboEditorCompletionContributor.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            ComboEditorCompletionContributor.$$$reportNull$$$0(3);
        }
        LOOKUP_ELEMENT_PROVIDER_KEY.set(document, provider2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/ComboEditorCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installLookupElementProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface LookupElementProvider {
        public static final DefaultLookupElementProvider DEFAULT = new DefaultLookupElementProvider();

        @NotNull
        public LookupElement createLookupElement(@NotNull String var1);
    }

    public static class DefaultLookupElementProvider
    implements LookupElementProvider {
        @Override
        @NotNull
        public LookupElementBuilder createLookupElement(@NotNull String lookupString) {
            if (lookupString == null) {
                DefaultLookupElementProvider.$$$reportNull$$$0(0);
            }
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create(lookupString).withInsertHandler((context2, item) -> {
                Document document = context2.getEditor().getDocument();
                document.deleteString(context2.getEditor().getCaretModel().getOffset(), document.getTextLength());
            });
            if (lookupElementBuilder == null) {
                DefaultLookupElementProvider.$$$reportNull$$$0(1);
            }
            return lookupElementBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookupString";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/ComboEditorCompletionContributor$DefaultLookupElementProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/ComboEditorCompletionContributor$DefaultLookupElementProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupElement";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

