/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributorEP;
import com.intellij.codeInsight.completion.CompletionExtension;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionContributor {
    public static final ExtensionPointName<CompletionContributorEP> EP = new ExtensionPointName("com.intellij.completion.contributor");
    private final MultiMap<CompletionType, Pair<ElementPattern<? extends PsiElement>, CompletionProvider<CompletionParameters>>> myMap = new MultiMap();
    private static final LanguageExtension<CompletionContributor> INSTANCE = new CompletionExtension<CompletionContributor>(EP.getName());

    public final void extend(@Nullable CompletionType type, @NotNull ElementPattern<? extends PsiElement> place, CompletionProvider<CompletionParameters> provider2) {
        if (place == null) {
            CompletionContributor.$$$reportNull$$$0(0);
        }
        this.myMap.putValue(type, new Pair<ElementPattern<? extends PsiElement>, CompletionProvider<CompletionParameters>>(place, provider2));
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        ProcessingContext context2;
        if (parameters2 == null) {
            CompletionContributor.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            CompletionContributor.$$$reportNull$$$0(2);
        }
        for (Pair<ElementPattern<? extends PsiElement>, CompletionProvider<CompletionParameters>> pair : this.myMap.get(parameters2.getCompletionType())) {
            ProgressManager.checkCanceled();
            context2 = new ProcessingContext();
            if (!((ElementPattern)pair.first).accepts(parameters2.getPosition(), context2)) continue;
            ((CompletionProvider)pair.second).addCompletionVariants(parameters2, context2, result2);
            if (!result2.isStopped()) continue;
            return;
        }
        for (Pair<ElementPattern<? extends PsiElement>, CompletionProvider<CompletionParameters>> pair : this.myMap.get(null)) {
            context2 = new ProcessingContext();
            if (!((ElementPattern)pair.first).accepts(parameters2.getPosition(), context2)) continue;
            ((CompletionProvider)pair.second).addCompletionVariants(parameters2, context2, result2);
            if (!result2.isStopped()) continue;
            return;
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context2) {
        if (context2 == null) {
            CompletionContributor.$$$reportNull$$$0(3);
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String advertise(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            CompletionContributor.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Nullable
    @NlsContexts.HintText
    public String handleEmptyLookup(@NotNull CompletionParameters parameters2, Editor editor2) {
        if (parameters2 == null) {
            CompletionContributor.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context2) {
        if (context2 == null) {
            CompletionContributor.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Deprecated
    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            CompletionContributor.$$$reportNull$$$0(7);
        }
        return false;
    }

    public void duringCompletion(@NotNull CompletionInitializationContext context2) {
        if (context2 == null) {
            CompletionContributor.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    public static List<CompletionContributor> forParameters(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            CompletionContributor.$$$reportNull$$$0(9);
        }
        List list2 = ReadAction.compute(() -> {
            PsiElement position = parameters2.getPosition();
            return CompletionContributor.forLanguageHonorDumbness(PsiUtilCore.getLanguageAtOffset(position.getContainingFile(), parameters2.getOffset()), position.getProject());
        });
        if (list2 == null) {
            CompletionContributor.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public static List<CompletionContributor> forLanguage(@NotNull Language language) {
        if (language == null) {
            CompletionContributor.$$$reportNull$$$0(11);
        }
        List<CompletionContributor> list2 = INSTANCE.forKey(language);
        if (list2 == null) {
            CompletionContributor.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @NotNull
    public static List<CompletionContributor> forLanguageHonorDumbness(@NotNull Language language, @NotNull Project project2) {
        if (language == null) {
            CompletionContributor.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            CompletionContributor.$$$reportNull$$$0(14);
        }
        List<CompletionContributor> list2 = DumbService.getInstance(project2).filterByDumbAwareness(CompletionContributor.forLanguage(language));
        if (list2 == null) {
            CompletionContributor.$$$reportNull$$$0(15);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionContributor";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionContributor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "forParameters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguageHonorDumbness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extend";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "advertise";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleEmptyLookup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleAutoCompletionPossibility";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invokeAutoPopup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "duringCompletion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forParameters";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "forLanguageHonorDumbness";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 10, 12, 15 -> new IllegalStateException(string2);
        };
    }
}

