/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BatchConsumer;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionService {
    public static final Key<CompletionStatistician> STATISTICS_KEY = Key.create("completion");
    public static final Key<CompletionWeigher> RELEVANCE_KEY = Key.create("completion");

    public static CompletionService getCompletionService() {
        return ApplicationManager.getApplication().getService(CompletionService.class);
    }

    @Deprecated(forRemoval=true)
    public abstract void setAdvertisementText(@Nullable @NlsContexts.PopupAdvertisement String var1);

    public void getVariantsFromContributors(CompletionParameters parameters2, @Nullable CompletionContributor from, Consumer<? super CompletionResult> consumer2) {
        this.getVariantsFromContributors(parameters2, from, this.createMatcher(this.suggestPrefix(parameters2), false), consumer2);
    }

    protected void getVariantsFromContributors(CompletionParameters parameters2, @Nullable CompletionContributor from, PrefixMatcher matcher, Consumer<? super CompletionResult> consumer2) {
        this.getVariantsFromContributors(parameters2, from, matcher, consumer2, null);
    }

    protected void getVariantsFromContributors(CompletionParameters parameters2, @Nullable CompletionContributor from, PrefixMatcher matcher, Consumer<? super CompletionResult> consumer2, CompletionSorter customSorter) {
        List<CompletionContributor> contributors = CompletionContributor.forParameters(parameters2);
        for (int i2 = contributors.indexOf(from) + 1; i2 < contributors.size(); ++i2) {
            ProgressManager.checkCanceled();
            CompletionContributor contributor = contributors.get(i2);
            CompletionResultSet result2 = this.createResultSet(parameters2, consumer2, contributor, matcher);
            if (customSorter != null) {
                result2 = result2.withRelevanceSorter(customSorter);
            }
            this.getVariantsFromContributor(parameters2, contributor, result2);
            if (!result2.isStopped()) continue;
            return;
        }
    }

    protected void getVariantsFromContributor(CompletionParameters params, CompletionContributor contributor, CompletionResultSet result2) {
        contributor.fillCompletionVariants(params, result2);
    }

    protected abstract CompletionResultSet createResultSet(CompletionParameters var1, Consumer<? super CompletionResult> var2, @NotNull CompletionContributor var3, PrefixMatcher var4);

    protected abstract String suggestPrefix(CompletionParameters var1);

    @NotNull
    protected abstract PrefixMatcher createMatcher(String var1, boolean var2);

    @Nullable
    public abstract CompletionProcess getCurrentCompletion();

    public void performCompletion(CompletionParameters parameters2, final Consumer<? super CompletionResult> consumer2) {
        final Set lookupSet = ContainerUtil.newConcurrentSet();
        final AtomicBoolean typoTolerant = new AtomicBoolean();
        BatchConsumer<CompletionResult> batchConsumer = new BatchConsumer<CompletionResult>(){

            @Override
            public void startBatch() {
                if (consumer2 instanceof BatchConsumer) {
                    ((BatchConsumer)consumer2).startBatch();
                }
            }

            @Override
            public void endBatch() {
                if (consumer2 instanceof BatchConsumer) {
                    ((BatchConsumer)consumer2).endBatch();
                }
            }

            @Override
            public void consume(CompletionResult result2) {
                if (typoTolerant.get() && result2.getLookupElement().getAutoCompletionPolicy() != AutoCompletionPolicy.NEVER_AUTOCOMPLETE) {
                    result2 = result2.withLookupElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(result2.getLookupElement()));
                }
                if (lookupSet.add(result2.getLookupElement())) {
                    consumer2.consume(result2);
                }
            }
        };
        String prefix = this.suggestPrefix(parameters2);
        this.getVariantsFromContributors(parameters2, null, this.createMatcher(prefix, false), (Consumer<? super CompletionResult>)batchConsumer);
        if (lookupSet.isEmpty() && prefix.length() > 2) {
            typoTolerant.set(true);
            this.getVariantsFromContributors(parameters2, null, this.createMatcher(prefix, true), (Consumer<? super CompletionResult>)batchConsumer);
        }
    }

    public abstract CompletionSorter defaultSorter(CompletionParameters var1, PrefixMatcher var2);

    public abstract CompletionSorter emptySorter();

    @ApiStatus.Internal
    public static boolean isStartMatch(LookupElement element, WeighingContext context2) {
        return CompletionService.getItemMatcher(element, context2).isStartMatch(element);
    }

    @ApiStatus.Internal
    public static PrefixMatcher getItemMatcher(LookupElement element, WeighingContext context2) {
        PrefixMatcher itemMatcher = context2.itemMatcher(element);
        String pattern = context2.itemPattern(element);
        if (!pattern.equals(itemMatcher.getPrefix())) {
            return itemMatcher.cloneWithPrefix(pattern);
        }
        return itemMatcher;
    }
}

