/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.util.containers.ContainerUtil;

public class DefaultCharFilter
extends CharFilter {
    public CharFilter.Result acceptChar(char c2, int prefixLength, Lookup lookup2) {
        if (Character.isJavaIdentifierPart(c2)) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        return switch (c2) {
            case ' ', '(', ',', '.', ':', ';', '=' -> CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            case '-' -> {
                if (ContainerUtil.exists(lookup2.getItems(), item -> DefaultCharFilter.matchesAfterAppendingChar(lookup2, item, c2))) {
                    yield CharFilter.Result.ADD_TO_PREFIX;
                }
                yield CharFilter.Result.HIDE_LOOKUP;
            }
            default -> CharFilter.Result.HIDE_LOOKUP;
        };
    }

    private static boolean matchesAfterAppendingChar(Lookup lookup2, LookupElement item, char c2) {
        PrefixMatcher matcher = lookup2.itemMatcher(item);
        return matcher.cloneWithPrefix(matcher.getPrefix() + ((LookupImpl)lookup2).getAdditionalPrefix() + c2).prefixMatches(item);
    }
}

