/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.FileReferenceWithExtendedCompletion;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance(FilePathCompletionContributor.class);

    public FilePathCompletionContributor() {
        this.extend(CompletionType.BASIC, PlatformPatterns.psiElement(), new CompletionProvider<CompletionParameters>(){

            @Override
            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
                PsiReference psiReference;
                if (parameters2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (FilePathCompletionContributor.getReference(psiReference = parameters2.getPosition().getContainingFile().findReferenceAt(parameters2.getOffset())) != null && parameters2.getInvocationCount() == 1) {
                    String shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion");
                    result2.addLookupAdvertisement(CodeInsightBundle.message("class.completion.file.path", shortcut));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/FilePathCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        CompletionProvider<CompletionParameters> provider2 = new CompletionProvider<CompletionParameters>(){

            @Override
            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet _result) {
                if (parameters2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (_result == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (!parameters2.isExtendedCompletion()) {
                    return;
                }
                @NotNull CompletionResultSet result2 = _result.caseInsensitive();
                PsiElement e = parameters2.getPosition();
                Project project2 = e.getProject();
                PsiReference psiReference = parameters2.getPosition().getContainingFile().findReferenceAt(parameters2.getOffset());
                Pair<FileReference, Boolean> fileReferencePair = FilePathCompletionContributor.getReference(psiReference);
                if (fileReferencePair != null) {
                    FileReference first2 = fileReferencePair.getFirst();
                    if (first2 == null) {
                        return;
                    }
                    Boolean stopHere = fileReferencePair.getSecond();
                    Set variants = stopHere != false ? Collections.emptySet() : Arrays.stream(first2.getVariants()).map(v -> v instanceof LookupElement ? ((LookupElement)v).getObject() : null).filter(o -> o instanceof PsiFile).map(o -> (PsiFile)o).collect(Collectors.toSet());
                    FileReferenceSet set2 = first2.getFileReferenceSet();
                    int end = parameters2.getOffset() - set2.getElement().getTextRange().getStartOffset() - set2.getStartInElement();
                    String pathString = set2.getPathString();
                    if (pathString.length() < end) {
                        return;
                    }
                    PsiFile originalFile = parameters2.getOriginalFile();
                    VirtualFile contextFile = originalFile.getVirtualFile();
                    String relativePrefix = FilePathCompletionContributor.getRelativePathPrefix(pathString);
                    VirtualFile parent2 = null;
                    if (relativePrefix != null && relativePrefix.length() <= end && (parent2 = VfsUtilCore.findRelativeFile(relativePrefix, contextFile.getParent())) != null) {
                        pathString = pathString.substring(relativePrefix.length());
                        end -= relativePrefix.length();
                    }
                    String prefix = pathString.substring(0, end);
                    List<String> pathPrefixParts = null;
                    int lastSlashIndex = prefix.lastIndexOf(47);
                    if (lastSlashIndex != -1) {
                        pathPrefixParts = StringUtil.split(prefix.substring(0, lastSlashIndex), "/");
                        prefix = prefix.substring(lastSlashIndex + 1);
                    }
                    CompletionResultSet __result = result2.withPrefixMatcher(prefix).caseInsensitive();
                    if (contextFile != null) {
                        TreeSet resultNames = new TreeSet();
                        String finalPrefix = prefix;
                        FilePathCompletionContributor.processAllNames(project2, fileName -> {
                            if (FilePathCompletionContributor.filenameMatchesPrefixOrType(fileName, finalPrefix, set2.getSuitableFileTypes(), parameters2.getInvocationCount())) {
                                resultNames.add(fileName);
                            }
                            return true;
                        });
                        ProjectFileIndex index2 = ProjectRootManager.getInstance(project2).getFileIndex();
                        Module contextModule = index2.getModuleForFile(contextFile);
                        if (contextModule != null) {
                            List<FileReferenceHelper> helpers = FileReferenceHelperRegistrar.getHelpers(originalFile);
                            GlobalSearchScope scope = ProjectScope.getProjectScope(project2);
                            for (String name : resultNames) {
                                PsiFile[] files2;
                                ProgressManager.checkCanceled();
                                for (PsiFile file2 : files2 = FilenameIndex.getFilesByName((Project)project2, (String)name, (GlobalSearchScope)scope)) {
                                    VirtualFile virtualFile2;
                                    ProgressManager.checkCanceled();
                                    if (variants.contains(file2) && file2.getName().startsWith(finalPrefix) || (virtualFile2 = file2.getVirtualFile()) == null || !virtualFile2.isValid() || Comparing.equal(virtualFile2, contextFile) || parent2 != null && !VfsUtilCore.isAncestor(parent2, virtualFile2, true)) continue;
                                    ArrayList<FileReferenceHelper> helperList = new ArrayList<FileReferenceHelper>();
                                    for (FileReferenceHelper contextHelper : helpers) {
                                        ProgressManager.checkCanceled();
                                        if (!contextHelper.isMine(project2, virtualFile2) || pathPrefixParts != null && !FilePathCompletionContributor.fileMatchesPathPrefix(contextHelper.getPsiFileSystemItem(project2, virtualFile2), parent2, pathPrefixParts)) continue;
                                        helperList.add(contextHelper);
                                    }
                                    if (helperList.isEmpty()) continue;
                                    __result.addElement(new FilePathLookupItem(file2, helperList));
                                }
                            }
                        }
                    }
                    if (set2.getSuitableFileTypes().length > 0 && parameters2.getInvocationCount() == 1) {
                        String shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion");
                        result2.addLookupAdvertisement(CodeInsightBundle.message("class.completion.file.path.all.variants", shortcut));
                    }
                    if (stopHere.booleanValue()) {
                        result2.stopHere();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "_result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/FilePathCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.extend(CompletionType.BASIC, PlatformPatterns.psiElement(), provider2);
    }

    private static boolean filenameMatchesPrefixOrType(String fileName, String prefix, FileType[] suitableFileTypes, int invocationCount) {
        boolean prefixMatched;
        boolean bl = prefixMatched = prefix.length() == 0 || StringUtil.startsWithIgnoreCase(fileName, prefix);
        if (prefixMatched && (suitableFileTypes.length == 0 || invocationCount > 2)) {
            return true;
        }
        if (prefixMatched) {
            String extension2 = FileUtilRt.getExtension(fileName);
            if (extension2.length() == 0) {
                return false;
            }
            for (FileType fileType : suitableFileTypes) {
                for (FileNameMatcher matcher : FileTypeManager.getInstance().getAssociations(fileType)) {
                    if (!matcher.acceptsCharSequence((CharSequence)fileName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String getRelativePathPrefix(@NotNull String path2) {
        if (path2 == null) {
            FilePathCompletionContributor.$$$reportNull$$$0(0);
        }
        if (!path2.startsWith("./") && !path2.startsWith("../")) {
            return null;
        }
        int index2 = 0;
        char currentChar = path2.charAt(index2);
        while ((currentChar == '.' || currentChar == '/') && ++index2 < path2.length()) {
            currentChar = path2.charAt(index2);
        }
        return path2.substring(0, index2);
    }

    private static boolean fileMatchesPathPrefix(@Nullable PsiFileSystemItem file2, @Nullable VirtualFile stopParent, @NotNull List<String> pathPrefix) {
        PsiFileSystemItem parent2;
        if (pathPrefix == null) {
            FilePathCompletionContributor.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            return false;
        }
        ArrayList<String> contextParts = new ArrayList<String>();
        PsiFileSystemItem parentFile = file2;
        while (!((parent2 = parentFile.getParent()) == null || stopParent != null && Objects.equals(parent2.getVirtualFile(), stopParent))) {
            if (parent2.getName().length() > 0) {
                contextParts.add(0, StringUtil.toLowerCase(parent2.getName()));
            }
            parentFile = parent2;
        }
        String path2 = StringUtil.join(contextParts, "/");
        int nextIndex = 0;
        for (String s : pathPrefix) {
            nextIndex = path2.indexOf(StringUtil.toLowerCase(s), nextIndex);
            if (nextIndex != -1) continue;
            return false;
        }
        return true;
    }

    private static void processAllNames(@NotNull Project project2, @NotNull Processor<? super String> processor) {
        if (project2 == null) {
            FilePathCompletionContributor.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            FilePathCompletionContributor.$$$reportNull$$$0(3);
        }
        for (ChooseByNameContributor contributor : ChooseByNameContributor.FILE_EP_NAME.getExtensionList()) {
            try {
                if (contributor instanceof ChooseByNameContributorEx) {
                    ((ChooseByNameContributorEx)contributor).processNames(processor, FindSymbolParameters.searchScopeFor(project2, false), null);
                    continue;
                }
                ContainerUtil.process(contributor.getNames(project2, false), processor);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Exception ex) {
                LOG.error(ex);
            }
        }
    }

    @Nullable
    private static Pair<FileReference, Boolean> getReference(PsiReference original) {
        PsiFileReference fileReference;
        if (original == null) {
            return null;
        }
        if (original instanceof PsiMultiReference) {
            PsiMultiReference multiReference = (PsiMultiReference)original;
            for (PsiReference reference2 : multiReference.getReferences()) {
                if (!(reference2 instanceof FileReference) || !((FileReference)reference2).getFileReferenceSet().supportsExtendedCompletion()) continue;
                return Pair.create((FileReference)reference2, false);
            }
        } else if (original instanceof FileReferenceOwner && (fileReference = ((FileReferenceOwner)((Object)original)).getLastFileReference()) instanceof FileReference && ((FileReference)fileReference).getFileReferenceSet().supportsExtendedCompletion()) {
            return Pair.create((FileReference)fileReference, true);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPrefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/FilePathCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativePathPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMatchesPathPrefix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FilePathLookupItem
    extends LookupElement {
        private final String myName;
        private final String myPath;
        private final String myInfo;
        private final Icon myIcon;
        private final PsiFile myFile;
        private final List<? extends FileReferenceHelper> myHelpers;

        public FilePathLookupItem(@NotNull PsiFile file2, @NotNull List<? extends FileReferenceHelper> helpers) {
            if (file2 == null) {
                FilePathLookupItem.$$$reportNull$$$0(0);
            }
            if (helpers == null) {
                FilePathLookupItem.$$$reportNull$$$0(1);
            }
            this.myName = file2.getName();
            this.myPath = file2.getVirtualFile().getPath();
            this.myHelpers = helpers;
            this.myInfo = FileInfoManager.getFileAdditionalInfo(file2);
            this.myIcon = file2.getIcon(0);
            this.myFile = file2;
        }

        @Override
        public String toString() {
            return String.format("%s%s", this.myName, this.myInfo == null ? "" : " (" + this.myInfo + ")");
        }

        @Override
        @NotNull
        public Object getObject() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                FilePathLookupItem.$$$reportNull$$$0(2);
            }
            return psiFile;
        }

        @Override
        @NotNull
        public String getLookupString() {
            String string2 = this.myName;
            if (string2 == null) {
                FilePathLookupItem.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Override
        public void handleInsert(@NotNull InsertionContext context2) {
            PsiReference psiReference;
            Pair<FileReference, Boolean> fileReferencePair;
            if (context2 == null) {
                FilePathLookupItem.$$$reportNull$$$0(4);
            }
            context2.commitDocument();
            if (this.myFile.isValid() && (fileReferencePair = FilePathCompletionContributor.getReference(psiReference = context2.getFile().findReferenceAt(context2.getStartOffset()))) != null) {
                FileReference ref = fileReferencePair.getFirst();
                context2.setTailOffset(ref.getRangeInElement().getEndOffset() + ref.getElement().getTextRange().getStartOffset());
                if (ref instanceof FileReferenceWithExtendedCompletion) {
                    ((FileReferenceWithExtendedCompletion)((Object)ref)).bindToExtendedElement(this.myFile);
                } else {
                    ref.bindToElement(this.myFile);
                }
            }
        }

        @Override
        public void renderElement(@NotNull LookupElementPresentation presentation2) {
            if (presentation2 == null) {
                FilePathLookupItem.$$$reportNull$$$0(5);
            }
            String relativePath = this.getRelativePath();
            StringBuilder sb = new StringBuilder();
            if (this.myInfo != null) {
                sb.append(" (").append(this.myInfo);
            }
            if (relativePath != null && !relativePath.equals(this.myName)) {
                if (this.myInfo != null) {
                    sb.append(", ");
                } else {
                    sb.append(" (");
                }
                sb.append(relativePath);
            }
            if (sb.length() > 0) {
                sb.append(')');
            }
            presentation2.setItemText(this.myName);
            if (sb.length() > 0) {
                presentation2.setTailText(sb.toString(), true);
            }
            presentation2.setIcon(this.myIcon);
        }

        @Nullable
        private String getRelativePath() {
            VirtualFile virtualFile2 = this.myFile.getVirtualFile();
            LOG.assertTrue(virtualFile2 != null);
            for (FileReferenceHelper fileReferenceHelper : this.myHelpers) {
                PsiFileSystemItem root = fileReferenceHelper.findRoot(this.myFile.getProject(), virtualFile2);
                String path2 = PsiFileSystemItemUtil.findRelativePath(root, fileReferenceHelper.getPsiFileSystemItem(this.myFile.getProject(), virtualFile2));
                if (path2 == null) continue;
                return path2;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilePathLookupItem that = (FilePathLookupItem)o;
            if (!this.myName.equals(that.myName)) {
                return false;
            }
            return this.myPath.equals(that.myPath);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + this.myPath.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helpers";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "renderElement";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

