/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.FileElement;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/completion/OffsetsInFile;", "", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "offsets", "Lcom/intellij/codeInsight/completion/OffsetMap;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInsight/completion/OffsetMap;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffsets", "()Lcom/intellij/codeInsight/completion/OffsetMap;", "copyWithReplacement", "startOffset", "", "endOffset", "replacement", "", "replaceInCopy", "Ljava/util/function/Supplier;", "fileCopy", "toInjectedIfAny", "offset", "toTopLevelFile", "intellij.platform.analysis.impl"})
public final class OffsetsInFile {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final OffsetMap offsets;

    public OffsetsInFile(@NotNull PsiFile file2, @NotNull OffsetMap offsets2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)offsets2, (String)"offsets");
        this.file = file2;
        this.offsets = offsets2;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final OffsetMap getOffsets() {
        return this.offsets;
    }

    public OffsetsInFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Document document = file2.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        this(file2, new OffsetMap(document));
    }

    @NotNull
    public final OffsetsInFile toTopLevelFile() {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance(this.file.getProject());
        PsiFile hostFile = manager.getTopLevelFile(this.file);
        if (Intrinsics.areEqual((Object)hostFile, (Object)this.file)) {
            return this;
        }
        Intrinsics.checkNotNullExpressionValue((Object)hostFile, (String)"hostFile");
        Document document = hostFile.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        OffsetMap offsetMap = this.offsets.mapOffsets(document, arg_0 -> OffsetsInFile.toTopLevelFile$lambda$0((Function1)new Function1<Integer, Integer>(manager, this){
            final /* synthetic */ InjectedLanguageManager $manager;
            final /* synthetic */ OffsetsInFile this$0;
            {
                this.$manager = $manager;
                this.this$0 = $receiver;
                super(1);
            }

            public final Integer invoke(Integer it) {
                PsiElement psiElement = this.this$0.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return this.$manager.injectedToHost(psiElement, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"fun toTopLevelFile(): Of\u2026edToHost(file, it) })\n  }");
        return new OffsetsInFile(hostFile, offsetMap);
    }

    @NotNull
    public final OffsetsInFile toInjectedIfAny(int offset2) {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance(this.file.getProject());
        PsiElement psiElement = manager.findInjectedElementAt(this.file, offset2);
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        if (psiFile == null) {
            return this;
        }
        PsiFile injected = psiFile;
        VirtualFile virtualFile2 = injected.getVirtualFile();
        if (virtualFile2 instanceof VirtualFileWindow) {
            DocumentWindow documentWindow = ((VirtualFileWindow)((Object)virtualFile2)).getDocumentWindow();
            Intrinsics.checkNotNullExpressionValue((Object)documentWindow, (String)"virtualFile.documentWindow");
            DocumentWindow documentWindow2 = documentWindow;
            OffsetMap offsetMap = this.offsets.mapOffsets(documentWindow2, arg_0 -> OffsetsInFile.toInjectedIfAny$lambda$1((Function1)new Function1<Integer, Integer>(documentWindow2){
                final /* synthetic */ DocumentWindow $documentWindow;
                {
                    this.$documentWindow = $documentWindow;
                    super(1);
                }

                public final Integer invoke(Integer it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return this.$documentWindow.hostToInjected(it);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"documentWindow = virtual\u2026ndow.hostToInjected(it) }");
            return new OffsetsInFile(injected, offsetMap);
        }
        return this;
    }

    @NotNull
    public final OffsetsInFile copyWithReplacement(int startOffset, int endOffset, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        PsiElement psiElement = this.file.copy();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
        OffsetsInFile offsetsInFile = this.replaceInCopy((PsiFile)psiElement, startOffset, endOffset, replacement).get();
        Intrinsics.checkNotNullExpressionValue((Object)offsetsInFile, (String)"replaceInCopy(file.copy(\u2026ffset, replacement).get()");
        return offsetsInFile;
    }

    @NotNull
    public final Supplier<OffsetsInFile> replaceInCopy(@NotNull PsiFile fileCopy, int startOffset, int endOffset, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        CharSequence charSequence = this.offsets.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"offsets.document.immutableCharSequence");
        CharSequence originalText = charSequence;
        DocumentImpl tempDocument = new DocumentImpl(originalText, StringsKt.contains$default((CharSequence)originalText, (char)'\r', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)replacement, (char)'\r', (boolean)false, (int)2, null), true);
        OffsetMap offsetMap = this.offsets.copyOffsets(tempDocument);
        Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"offsets.copyOffsets(tempDocument)");
        OffsetMap tempMap = offsetMap;
        tempDocument.replaceString(startOffset, endOffset, replacement);
        Document document = fileCopy.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        Document copyDocument = document;
        FileASTNode fileASTNode = fileCopy.getNode();
        FileElement fileElement = fileASTNode instanceof FileElement ? (FileElement)fileASTNode : null;
        if (fileElement == null) {
            throw new IllegalStateException("Node is not a FileElement " + fileCopy.getClass().getName() + " / " + fileCopy.getFileType() + " / " + fileCopy.getNode());
        }
        FileElement node2 = fileElement;
        PomModel pomModel = PomManager.getModel(this.file.getProject());
        Intrinsics.checkNotNull((Object)pomModel, (String)"null cannot be cast to non-null type com.intellij.pom.core.impl.PomModelImpl");
        Runnable applyPsiChange = ((PomModelImpl)pomModel).reparseFile(fileCopy, node2, tempDocument.getImmutableCharSequence());
        return () -> OffsetsInFile.replaceInCopy$lambda$2(applyPsiChange, fileCopy, tempMap, copyDocument);
    }

    private static final Integer toTopLevelFile$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer toInjectedIfAny$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final OffsetsInFile replaceInCopy$lambda$2(Runnable $applyPsiChange, PsiFile $fileCopy, OffsetMap $tempMap, Document $copyDocument) {
        Intrinsics.checkNotNullParameter((Object)$fileCopy, (String)"$fileCopy");
        Intrinsics.checkNotNullParameter((Object)$tempMap, (String)"$tempMap");
        Intrinsics.checkNotNullParameter((Object)$copyDocument, (String)"$copyDocument");
        Runnable runnable = $applyPsiChange;
        if (runnable != null) {
            runnable.run();
        }
        OffsetMap offsetMap = $tempMap.copyOffsets($copyDocument);
        Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"tempMap.copyOffsets(copyDocument)");
        return new OffsetsInFile($fileCopy, offsetMap);
    }
}

