/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.WeakReferenceDisposableWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.Alarm;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\bH\u0016J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/completion/StatisticsUpdate;", "Lcom/intellij/openapi/Disposable;", "myInfo", "Lcom/intellij/psi/statistics/StatisticsInfo;", "(Lcom/intellij/psi/statistics/StatisticsInfo;)V", "mySpared", "", "addSparedChars", "", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "dispose", "trackStatistics", "Companion", "DocumentChangeListener", "intellij.platform.lang.impl"})
public final class StatisticsUpdate
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StatisticsInfo myInfo;
    private int mySpared;
    @NotNull
    private static final Alarm ourStatsAlarm = new Alarm((Disposable)ApplicationManager.getApplication());
    @Nullable
    private static StatisticsUpdate ourPendingUpdate;

    private StatisticsUpdate(StatisticsInfo myInfo) {
        this.myInfo = myInfo;
    }

    @Override
    public void dispose() {
    }

    public final void addSparedChars(@NotNull Lookup lookup2, @NotNull LookupElement item, @NotNull InsertionContext context2) {
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String textInserted = null;
        if (context2.getOffsetMap().containsOffset(CompletionInitializationContext.START_OFFSET) && context2.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET) && context2.getTailOffset() >= context2.getStartOffset()) {
            textInserted = ((Object)context2.getDocument().getImmutableCharSequence().subSequence(context2.getStartOffset(), context2.getTailOffset())).toString();
        } else {
            String string2 = item.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"item.lookupString");
            textInserted = string2;
        }
        Object[] objectArray = new String[]{" ", "\t", "\n"};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"", "", ""};
        String string3 = StringUtil.replace(textInserted, list2, CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"replace(textInserted, li\u2026\\n\"), listOf(\"\", \"\", \"\"))");
        String withoutSpaces = string3;
        int spared = withoutSpaces.length() - lookup2.itemPattern(item).length();
        char completionChar = context2.getCompletionChar();
        if (!LookupEvent.isSpecialCompletionChar(completionChar) && StringsKt.contains$default((CharSequence)withoutSpaces, (CharSequence)String.valueOf(completionChar), (boolean)false, (int)2, null)) {
            --spared;
        }
        if (spared > 0) {
            this.mySpared += spared;
        }
    }

    public final void trackStatistics(@NotNull InsertionContext context2) {
        int tailOffset;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (ourPendingUpdate != this) {
            return;
        }
        if (!context2.getOffsetMap().containsOffset(CompletionInitializationContext.START_OFFSET)) {
            return;
        }
        Document document = context2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"context.document");
        Document document2 = document;
        int startOffset = context2.getStartOffset();
        int n = tailOffset = context2.getEditor().getSelectionModel().hasSelection() ? context2.getEditor().getSelectionModel().getSelectionStart() : context2.getEditor().getCaretModel().getOffset();
        if (startOffset < 0 || tailOffset <= startOffset) {
            return;
        }
        RangeMarker rangeMarker = document2.createRangeMarker(startOffset, tailOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"document.createRangeMark\u2026(startOffset, tailOffset)");
        RangeMarker marker = rangeMarker;
        DocumentChangeListener listener2 = new DocumentChangeListener(document2, marker);
        document2.addDocumentListener(listener2);
        Disposer.register(this, new WeakReferenceDisposableWrapper(listener2));
        ourStatsAlarm.addRequest(() -> StatisticsUpdate.trackStatistics$lambda$0(this), 20000);
        Disposer.register(this, StatisticsUpdate::trackStatistics$lambda$1);
    }

    private static final void trackStatistics$lambda$0(StatisticsUpdate this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (ourPendingUpdate == this$0) {
            Companion.applyLastCompletionStatisticsUpdate();
        }
    }

    private static final void trackStatistics$lambda$1() {
        ourStatsAlarm.cancelAllRequests();
    }

    private static final void _init_$lambda$2() {
        Companion.cancelLastCompletionStatisticsUpdate();
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final StatisticsUpdate collectStatisticChanges(@NotNull LookupElement item) {
        return Companion.collectStatisticChanges(item);
    }

    @JvmStatic
    public static final void cancelLastCompletionStatisticsUpdate() {
        Companion.cancelLastCompletionStatisticsUpdate();
    }

    @JvmStatic
    public static final void applyLastCompletionStatisticsUpdate() {
        Companion.applyLastCompletionStatisticsUpdate();
    }

    public /* synthetic */ StatisticsUpdate(StatisticsInfo myInfo, DefaultConstructorMarker $constructor_marker) {
        this(myInfo);
    }

    static {
        Disposer.register(ApplicationManager.getApplication(), StatisticsUpdate::_init_$lambda$2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/completion/StatisticsUpdate$DocumentChangeListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/Disposable;", "document", "Lcom/intellij/openapi/editor/Document;", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/RangeMarker;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "beforeDocumentChange", "", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "dispose", "intellij.platform.lang.impl"})
    private static final class DocumentChangeListener
    implements DocumentListener,
    Disposable {
        @NotNull
        private final Document document;
        @NotNull
        private final RangeMarker marker;

        public DocumentChangeListener(@NotNull Document document, @NotNull RangeMarker marker) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            this.document = document;
            this.marker = marker;
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @NotNull
        public final RangeMarker getMarker() {
            return this.marker;
        }

        @Override
        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.marker.isValid() || e.getOffset() > this.marker.getStartOffset() && e.getOffset() < this.marker.getEndOffset()) {
                Companion.cancelLastCompletionStatisticsUpdate();
            }
        }

        @Override
        public void dispose() {
            this.document.removeDocumentListener(this);
            this.marker.dispose();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/completion/StatisticsUpdate$Companion;", "", "()V", "ourPendingUpdate", "Lcom/intellij/codeInsight/completion/StatisticsUpdate;", "ourStatsAlarm", "Lcom/intellij/util/Alarm;", "applyLastCompletionStatisticsUpdate", "", "cancelLastCompletionStatisticsUpdate", "collectStatisticChanges", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nStatisticsUpdate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsUpdate.kt\ncom/intellij/codeInsight/completion/StatisticsUpdate$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final StatisticsUpdate collectStatisticChanges(@NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.applyLastCompletionStatisticsUpdate();
            StatisticsInfo statisticsInfo = StatisticsWeigher.getBaseStatisticsInfo(item, null);
            Intrinsics.checkNotNullExpressionValue((Object)statisticsInfo, (String)"getBaseStatisticsInfo(item, null)");
            StatisticsInfo base = statisticsInfo;
            if (base == StatisticsInfo.EMPTY) {
                StatisticsInfo statisticsInfo2 = StatisticsInfo.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)statisticsInfo2, (String)"EMPTY");
                return new StatisticsUpdate(statisticsInfo2, null);
            }
            StatisticsUpdate update2 = new StatisticsUpdate(base, null);
            ourPendingUpdate = update2;
            Disposer.register(update2, Companion::collectStatisticChanges$lambda$0);
            return update2;
        }

        @JvmStatic
        public final void cancelLastCompletionStatisticsUpdate() {
            boolean bl;
            StatisticsUpdate statisticsUpdate = ourPendingUpdate;
            if (statisticsUpdate != null) {
                StatisticsUpdate it = statisticsUpdate;
                boolean bl2 = false;
                Disposer.dispose(it);
            }
            boolean bl3 = bl = ourPendingUpdate == null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }

        @JvmStatic
        public final void applyLastCompletionStatisticsUpdate() {
            StatisticsUpdate statisticsUpdate = ourPendingUpdate;
            if (statisticsUpdate != null) {
                StatisticsUpdate it = statisticsUpdate;
                boolean bl = false;
                StatisticsManager.getInstance().incUseCount(it.myInfo);
                FeatureUsageTracker featureUsageTracker = FeatureUsageTracker.getInstance();
                Intrinsics.checkNotNull((Object)featureUsageTracker, (String)"null cannot be cast to non-null type com.intellij.featureStatistics.FeatureUsageTrackerImpl");
                ((FeatureUsageTrackerImpl)featureUsageTracker).getCompletionStatistics().registerInvocation(it.mySpared);
            }
            this.cancelLastCompletionStatisticsUpdate();
        }

        private static final void collectStatisticChanges$lambda$0() {
            ourPendingUpdate = null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

