/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.StatisticsComparable;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatisticsWeigher
extends CompletionWeigher {
    private static final Logger LOG = Logger.getInstance(StatisticsWeigher.class);
    private static final Key<StatisticsInfo> BASE_STATISTICS_INFO = Key.create("Base statistics info");

    @Override
    public Comparable weigh(@NotNull LookupElement item, @NotNull CompletionLocation location2) {
        if (item == null) {
            StatisticsWeigher.$$$reportNull$$$0(0);
        }
        if (location2 == null) {
            StatisticsWeigher.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    public static void clearBaseStatisticsInfo(LookupElement item) {
        item.putUserData(BASE_STATISTICS_INFO, null);
    }

    @NotNull
    public static StatisticsInfo getBaseStatisticsInfo(LookupElement item, @Nullable CompletionLocation location2) {
        StatisticsInfo info2 = BASE_STATISTICS_INFO.get(item);
        if (info2 == null) {
            if (location2 == null) {
                StatisticsInfo statisticsInfo = StatisticsInfo.EMPTY;
                if (statisticsInfo == null) {
                    StatisticsWeigher.$$$reportNull$$$0(2);
                }
                return statisticsInfo;
            }
            info2 = StatisticsWeigher.calcBaseInfo(item, location2);
            BASE_STATISTICS_INFO.set(item, info2);
        }
        StatisticsInfo statisticsInfo = info2;
        if (statisticsInfo == null) {
            StatisticsWeigher.$$$reportNull$$$0(3);
        }
        return statisticsInfo;
    }

    @NotNull
    private static StatisticsInfo calcBaseInfo(LookupElement item, @NotNull CompletionLocation location2) {
        StatisticsInfo info2;
        if (location2 == null) {
            StatisticsWeigher.$$$reportNull$$$0(4);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !location2.getCompletionParameters().isTestingMode()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        StatisticsInfo statisticsInfo = (info2 = StatisticsManager.serialize(CompletionService.STATISTICS_KEY, item, location2)) == null ? StatisticsInfo.EMPTY : info2;
        if (statisticsInfo == null) {
            StatisticsWeigher.$$$reportNull$$$0(5);
        }
        return statisticsInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/StatisticsWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/StatisticsWeigher";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseStatisticsInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBaseInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "weigh";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcBaseInfo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 5 -> new IllegalStateException(string2);
        };
    }

    public static class LookupStatisticsWeigher
    extends Classifier<LookupElement> {
        private final CompletionLocation myLocation;
        private final Map<LookupElement, StatisticsComparable> myWeights = new IdentityHashMap<LookupElement, StatisticsComparable>();
        private final Set<String> myStringsWithWeights = CollectionFactory.createSmallMemoryFootprintSet();
        private final Set<LookupElement> myNoStats = new ReferenceOpenHashSet<LookupElement>();
        private final List<Function<@NotNull LookupElement, @Nullable StatisticsInfo>> mySerializers;

        public LookupStatisticsWeigher(CompletionLocation location2, Classifier<LookupElement> next2) {
            super(next2, "stats");
            this.myLocation = location2;
            this.mySerializers = this.myLocation == null ? List.of() : ContainerUtil.map(StatisticsManager.COLLECTOR.forKey(CompletionService.STATISTICS_KEY), stat -> ((CompletionStatistician)stat).forLocation(this.myLocation));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElement(@NotNull LookupElement element, @NotNull ProcessingContext context2) {
            if (element == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(1);
            }
            StatisticsInfo baseInfo = this.getBaseStatisticsInfo(element);
            int weight = LookupStatisticsWeigher.weigh(baseInfo);
            LookupStatisticsWeigher lookupStatisticsWeigher = this;
            synchronized (lookupStatisticsWeigher) {
                if (weight != 0) {
                    this.myWeights.put(element, new StatisticsComparable(weight, baseInfo));
                    this.myStringsWithWeights.add(element.getLookupString());
                }
                if (baseInfo == StatisticsInfo.EMPTY) {
                    this.myNoStats.add(element);
                }
            }
            super.addElement(element, context2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context2) {
            Collection byWeight;
            List<LookupElement> initialList;
            if (source == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(3);
            }
            LookupStatisticsWeigher lookupStatisticsWeigher = this;
            synchronized (lookupStatisticsWeigher) {
                initialList = this.getInitialNoStatElements(source, context2);
                Iterable<LookupElement> rest = LookupStatisticsWeigher.withoutInitial(source, initialList);
                byWeight = this.buildMapByWeight(rest).descendingMap().values();
            }
            JBIterable jBIterable = JBIterable.from(initialList).append((LookupElement)((Object)JBIterable.from(byWeight).flatten(group2 -> this.myNext.classify(group2, context2))));
            if (jBIterable == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        private static Iterable<LookupElement> withoutInitial(Iterable<? extends LookupElement> allItems, List<? extends LookupElement> initial) {
            ReferenceOpenHashSet<? extends LookupElement> initialSet = new ReferenceOpenHashSet<LookupElement>(initial);
            return JBIterable.from(allItems).filter(element -> !initialSet.contains(element));
        }

        private List<LookupElement> getInitialNoStatElements(Iterable<? extends LookupElement> source, ProcessingContext context2) {
            ArrayList<LookupElement> initialList = new ArrayList<LookupElement>();
            for (LookupElement lookupElement : this.myNext.classify(source, context2)) {
                if (!this.myNoStats.contains(lookupElement)) break;
                initialList.add(lookupElement);
            }
            return initialList;
        }

        private TreeMap<Integer, List<LookupElement>> buildMapByWeight(Iterable<? extends LookupElement> source) {
            MultiMap<String, LookupElement> byName = MultiMap.create();
            ArrayList<LookupElement> noStats = new ArrayList<LookupElement>();
            for (LookupElement lookupElement : source) {
                String string2 = lookupElement.getLookupString();
                if (this.myStringsWithWeights.contains(string2)) {
                    byName.putValue(string2, lookupElement);
                    continue;
                }
                noStats.add(lookupElement);
            }
            TreeMap<Integer, List<LookupElement>> map2 = new TreeMap<Integer, List<LookupElement>>();
            map2.put(0, noStats);
            for (String s : byName.keySet()) {
                List group2 = (List)byName.get(s);
                group2.sort(Comparator.comparing(this::getScalarWeight).reversed());
                map2.computeIfAbsent(this.getMaxWeight(group2), __ -> new ArrayList()).addAll(group2);
            }
            return map2;
        }

        private int getMaxWeight(List<? extends LookupElement> group2) {
            int max = 0;
            for (int i2 = 0; i2 < group2.size(); ++i2) {
                max = Math.max(max, this.getScalarWeight(group2.get(i2)));
            }
            return max;
        }

        private int getScalarWeight(LookupElement e) {
            StatisticsComparable comparable = this.myWeights.get(e);
            return comparable == null ? 0 : comparable.getScalar();
        }

        private StatisticsComparable getWeight(LookupElement t) {
            StatisticsComparable w = this.myWeights.get(t);
            if (w == null) {
                StatisticsInfo info2 = this.getBaseStatisticsInfo(t);
                w = new StatisticsComparable(LookupStatisticsWeigher.weigh(info2), info2);
                this.myWeights.put(t, w);
            }
            return w;
        }

        private static int weigh(StatisticsInfo baseInfo) {
            if (baseInfo == StatisticsInfo.EMPTY) {
                return 0;
            }
            int minRecency = StatisticsManager.getInstance().getLastUseRecency(baseInfo);
            return minRecency == Integer.MAX_VALUE ? 0 : 10000 - minRecency;
        }

        @Override
        @NotNull
        public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items2, @NotNull ProcessingContext context2) {
            if (items2 == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(5);
            }
            if (context2 == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(6);
            }
            List<Pair<LookupElement, Object>> list2 = ContainerUtil.map(items2, lookupElement -> new Pair<LookupElement, StatisticsComparable>((LookupElement)lookupElement, this.getWeight((LookupElement)lookupElement)));
            if (list2 == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(7);
            }
            return list2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElement(@NotNull LookupElement element, @NotNull ProcessingContext context2) {
            if (element == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(8);
            }
            if (context2 == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(9);
            }
            LookupStatisticsWeigher lookupStatisticsWeigher = this;
            synchronized (lookupStatisticsWeigher) {
                this.myWeights.remove(element);
                this.myNoStats.remove(element);
            }
            super.removeElement(element, context2);
        }

        @NotNull
        private StatisticsInfo getBaseStatisticsInfo(LookupElement item) {
            StatisticsInfo info2 = BASE_STATISTICS_INFO.get(item);
            if (info2 == null) {
                if (this.myLocation == null) {
                    StatisticsInfo statisticsInfo = StatisticsInfo.EMPTY;
                    if (statisticsInfo == null) {
                        LookupStatisticsWeigher.$$$reportNull$$$0(10);
                    }
                    return statisticsInfo;
                }
                info2 = this.calcBaseInfo(item);
                BASE_STATISTICS_INFO.set(item, info2);
            }
            StatisticsInfo statisticsInfo = info2;
            if (statisticsInfo == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(11);
            }
            return statisticsInfo;
        }

        @NotNull
        private StatisticsInfo calcBaseInfo(LookupElement item) {
            if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myLocation.getCompletionParameters().isTestingMode()) {
                ApplicationManager.getApplication().assertIsNonDispatchThread();
            }
            for (Function<LookupElement, StatisticsInfo> serializer : this.mySerializers) {
                StatisticsInfo info2 = serializer.apply(item);
                if (info2 == null) continue;
                StatisticsInfo statisticsInfo = info2;
                if (statisticsInfo == null) {
                    LookupStatisticsWeigher.$$$reportNull$$$0(12);
                }
                return statisticsInfo;
            }
            StatisticsInfo statisticsInfo = StatisticsInfo.EMPTY;
            if (statisticsInfo == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(13);
            }
            return statisticsInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 7, 10, 11, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/StatisticsWeigher$LookupStatisticsWeigher";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/StatisticsWeigher$LookupStatisticsWeigher";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classify";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortingWeights";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseStatisticsInfo";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcBaseInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "classify";
                    break;
                }
                case 4: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortingWeights";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElement";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4, 7, 10, 11, 12, 13 -> new IllegalStateException(string2);
            };
        }
    }
}

