/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HippieWordCompletionHandler
implements CodeInsightActionHandler {
    private static final Key<CompletionState> KEY_STATE = new Key("HIPPIE_COMPLETION_STATE");
    private final boolean myForward;

    public HippieWordCompletionHandler(boolean forward) {
        this.myForward = forward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            HippieWordCompletionHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            HippieWordCompletionHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            HippieWordCompletionHandler.$$$reportNull$$$0(2);
        }
        if (!EditorModificationUtil.requestWriting((Editor)editor2)) {
            return;
        }
        int caretOffset = editor2.getCaretModel().getOffset();
        if (editor2.isViewer() || editor2.getDocument().getRangeGuard(caretOffset, caretOffset) != null) {
            editor2.getDocument().fireReadOnlyModificationAttempt();
            EditorModificationUtil.checkModificationAllowed((Editor)editor2);
            return;
        }
        LookupManager.getInstance(project2).hideActiveLookup();
        CharSequence charsSequence = editor2.getDocument().getCharsSequence();
        CompletionData data2 = HippieWordCompletionHandler.computeData(editor2, charsSequence);
        CompletionState completionState = HippieWordCompletionHandler.getCompletionState(editor2);
        String oldPrefix = completionState.oldPrefix;
        CompletionVariant lastProposedVariant = completionState.lastProposedVariant;
        boolean fromOtherFiles = completionState.fromOtherFiles;
        if (lastProposedVariant == null || oldPrefix == null || !completionState.caretOffsets.equals(HippieWordCompletionHandler.getCaretOffsets(editor2)) || completionState.lastModCount != editor2.getDocument().getModificationStamp()) {
            completionState.oldPrefix = oldPrefix = data2.myPrefix;
            lastProposedVariant = null;
            fromOtherFiles = false;
        } else {
            data2.startOffset = completionState.lastStartOffset;
        }
        CompletionVariant nextVariant = this.computeNextVariant(editor2, oldPrefix, lastProposedVariant, data2, file2, fromOtherFiles, false);
        if (nextVariant == null) {
            HippieWordCompletionHandler.insertStringForEachCaret(editor2, oldPrefix, caretOffset - data2.startOffset);
            editor2.putUserData(KEY_STATE, null);
            return;
        }
        RangeMarker start = editor2.getDocument().createRangeMarker(data2.startOffset, data2.startOffset);
        nextVariant.fastenBelts();
        try {
            HippieWordCompletionHandler.insertStringForEachCaret(editor2, nextVariant.variant, caretOffset - data2.startOffset);
        }
        finally {
            nextVariant.unfastenBelts();
        }
        if (!start.isValid()) {
            editor2.putUserData(KEY_STATE, null);
            return;
        }
        completionState.lastProposedVariant = nextVariant;
        completionState.lastStartOffset = start.getStartOffset();
        completionState.lastModCount = editor2.getDocument().getModificationStamp();
        completionState.caretOffsets = HippieWordCompletionHandler.getCaretOffsets(editor2);
        boolean bl = completionState.fromOtherFiles = nextVariant.editor != editor2;
        if (nextVariant.editor == editor2) {
            HippieWordCompletionHandler.highlightWord(nextVariant, project2);
        }
        start.dispose();
    }

    private static void insertStringForEachCaret(Editor editor2, String text2, int relativeOffset) {
        editor2.getCaretModel().runForEachCaret(caret -> {
            int caretOffset = caret.getOffset();
            int startOffset = Math.max(0, caretOffset - relativeOffset);
            editor2.getDocument().replaceString(startOffset, caretOffset, text2);
            caret.moveToOffset(startOffset + text2.length());
        });
    }

    private static void highlightWord(CompletionVariant variant, Project project2) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        EditorColorsManager colorManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlight(variant.editor, variant.offset, variant.offset + variant.variant.length(), attributes, 2, null, null);
    }

    @Nullable
    private CompletionVariant computeNextVariant(Editor editor2, @Nullable String prefix, @Nullable CompletionVariant lastProposedVariant, CompletionData data2, PsiFile file2, boolean includeWordsFromOtherFiles, boolean weAlreadyDoBestAttempt) {
        List<CompletionVariant> variants = HippieWordCompletionHandler.computeVariants(editor2, new CamelHumpMatcher(StringUtil.notNullize(prefix)), file2, includeWordsFromOtherFiles);
        if (variants.isEmpty()) {
            return weAlreadyDoBestAttempt ? null : this.computeNextVariant(editor2, prefix, null, data2, file2, !includeWordsFromOtherFiles, true);
        }
        if (lastProposedVariant != null) {
            for (CompletionVariant completionVariant : variants) {
                if (!completionVariant.variant.equals(((CompletionVariant)lastProposedVariant).variant)) continue;
                if (((CompletionVariant)lastProposedVariant).offset > data2.startOffset && completionVariant.offset > data2.startOffset) {
                    lastProposedVariant = completionVariant;
                }
                if (((CompletionVariant)lastProposedVariant).offset < data2.startOffset && completionVariant.offset < data2.startOffset) {
                    lastProposedVariant = completionVariant;
                }
                if (!includeWordsFromOtherFiles || ((CompletionVariant)lastProposedVariant).editor != completionVariant.editor) continue;
                lastProposedVariant = completionVariant;
            }
        }
        if (lastProposedVariant == null) {
            CompletionVariant result2 = null;
            if (this.myForward) {
                if (includeWordsFromOtherFiles) {
                    return variants.get(variants.size() - 1);
                }
                for (CompletionVariant variant : variants) {
                    if (variant.offset < data2.startOffset) {
                        result2 = variant;
                        continue;
                    }
                    if (result2 != null) continue;
                    result2 = variant;
                    break;
                }
            } else {
                if (includeWordsFromOtherFiles) {
                    return variants.get(0);
                }
                for (CompletionVariant variant : variants) {
                    if (variant.offset <= data2.startOffset) continue;
                    return variant;
                }
                return variants.iterator().next();
            }
            return result2;
        }
        if (this.myForward) {
            CompletionVariant result2 = null;
            for (CompletionVariant variant : variants) {
                if (variant == lastProposedVariant) {
                    if (result2 == null) {
                        return this.computeNextVariant(editor2, prefix, null, data2, file2, !includeWordsFromOtherFiles, true);
                    }
                    return result2;
                }
                result2 = variant;
            }
            return variants.get(variants.size() - 1);
        }
        Iterator<CompletionVariant> i2 = variants.iterator();
        while (i2.hasNext()) {
            CompletionVariant completionVariant = i2.next();
            if (completionVariant != lastProposedVariant) continue;
            if (i2.hasNext()) {
                return i2.next();
            }
            return this.computeNextVariant(editor2, prefix, null, data2, file2, !includeWordsFromOtherFiles, true);
        }
        return null;
    }

    private static boolean containsLettersOrDigits(CharSequence seq, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            if (!Character.isLetterOrDigit(seq.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    private static List<CompletionVariant> computeVariants(@NotNull Editor editor2, CamelHumpMatcher matcher, PsiFile file2, boolean includeWordsFromOtherFiles) {
        if (editor2 == null) {
            HippieWordCompletionHandler.$$$reportNull$$$0(3);
        }
        ArrayList words = new ArrayList();
        ArrayList afterWords = new ArrayList();
        if (includeWordsFromOtherFiles) {
            for (FileEditor fileEditor : FileEditorManager.getInstance(file2.getProject()).getAllEditors()) {
                TextEditor textEditor;
                Editor anotherEditor;
                if (!(fileEditor instanceof TextEditor) || (anotherEditor = (textEditor = (TextEditor)fileEditor).getEditor()) == editor2) continue;
                HippieWordCompletionHandler.addWordsForEditor(anotherEditor, matcher, words, afterWords, false);
            }
        } else {
            HippieWordCompletionHandler.addWordsForEditor(editor2, matcher, words, afterWords, true);
        }
        HashSet<String> allWords = new HashSet<String>();
        ArrayList<CompletionVariant> result2 = new ArrayList<CompletionVariant>();
        Collections.reverse(words);
        for (CompletionVariant variant : words) {
            if (allWords.contains(variant.variant)) continue;
            result2.add(variant);
            allWords.add(variant.variant);
        }
        Collections.reverse(result2);
        allWords.clear();
        for (CompletionVariant variant : afterWords) {
            if (allWords.contains(variant.variant)) continue;
            result2.add(variant);
            allWords.add(variant.variant);
        }
        return result2;
    }

    private static void addWordsForEditor(final Editor editor2, final CamelHumpMatcher matcher, final List<? super CompletionVariant> words, final List<? super CompletionVariant> afterWords, boolean takeCaretsIntoAccount) {
        int[] caretOffsets;
        int primaryCaretOffset;
        final CharSequence chars = editor2.getDocument().getImmutableCharSequence();
        if (takeCaretsIntoAccount) {
            CaretModel caretModel = editor2.getCaretModel();
            primaryCaretOffset = caretModel.getOffset();
            caretOffsets = HippieWordCompletionHandler.getCaretOffsets(caretModel);
        } else {
            primaryCaretOffset = 0;
            caretOffsets = new int[]{};
        }
        TokenProcessor processor = new TokenProcessor(){

            @Override
            public boolean processToken(int start, int end) {
                String word2;
                for (int caretOffset : caretOffsets) {
                    if (start > caretOffset || end < caretOffset) continue;
                    return true;
                }
                if (end - start > matcher.getPrefix().length() && matcher.isStartMatch(word2 = chars.subSequence(start, end).toString())) {
                    CompletionVariant v = new CompletionVariant(editor2, word2, start);
                    if (end > primaryCaretOffset) {
                        afterWords.add(v);
                    } else {
                        words.add(v);
                    }
                }
                return true;
            }
        };
        HippieWordCompletionHandler.processWords(editor2, 0, processor);
    }

    private static int[] getCaretOffsets(CaretModel caretModel) {
        int[] caretOffsets = new int[caretModel.getCaretCount()];
        int i2 = 0;
        for (Caret caret : caretModel.getAllCarets()) {
            caretOffsets[i2++] = caret.getOffset();
        }
        return caretOffsets;
    }

    private static void processWords(Editor editor2, int startOffset, TokenProcessor processor) {
        CharSequence chars = editor2.getDocument().getCharsSequence();
        HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(startOffset);
        while (!iterator2.atEnd()) {
            int start = iterator2.getStart();
            int end = iterator2.getEnd();
            while (start < end) {
                int wordEnd;
                int wordStart;
                for (wordStart = start; wordStart < end && !HippieWordCompletionHandler.isWordPart(chars.charAt(wordStart)); ++wordStart) {
                }
                for (wordEnd = wordStart; wordEnd < end && HippieWordCompletionHandler.isWordPart(chars.charAt(wordEnd)); ++wordEnd) {
                }
                if (wordEnd > wordStart && HippieWordCompletionHandler.containsLettersOrDigits(chars, wordStart, wordEnd) && !processor.processToken(wordStart, wordEnd)) {
                    return;
                }
                start = wordEnd + 1;
            }
            iterator2.advance();
        }
    }

    private static boolean isWordPart(char c2) {
        return Character.isJavaIdentifierPart(c2) || c2 == '-' || c2 == '*';
    }

    private static CompletionData computeData(Editor editor2, final CharSequence charsSequence) {
        final int offset2 = editor2.getCaretModel().getOffset();
        final CompletionData data2 = new CompletionData();
        HippieWordCompletionHandler.processWords(editor2, Math.max(offset2 - 1, 0), new TokenProcessor(){

            @Override
            public boolean processToken(int start, int end) {
                if (start > offset2) {
                    return false;
                }
                if (end >= offset2) {
                    data2.myPrefix = charsSequence.subSequence(start, offset2).toString();
                    data2.startOffset = start;
                    return false;
                }
                return true;
            }
        });
        if (data2.myPrefix == null) {
            data2.myPrefix = "";
            data2.startOffset = offset2;
        }
        return data2;
    }

    private static CompletionState getCompletionState(Editor editor2) {
        CompletionState state = (CompletionState)editor2.getUserData(KEY_STATE);
        if (state == null) {
            state = new CompletionState();
            editor2.putUserData(KEY_STATE, (Object)state);
        }
        return state;
    }

    @NotNull
    private static List<Integer> getCaretOffsets(Editor editor2) {
        List<Integer> list2 = ContainerUtil.map(editor2.getCaretModel().getAllCarets(), caret -> caret.getOffset());
        if (list2 == null) {
            HippieWordCompletionHandler.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }

    private static class CompletionData {
        public String myPrefix;
        public int startOffset;

        private CompletionData() {
        }
    }

    private static class CompletionState {
        public String oldPrefix;
        public CompletionVariant lastProposedVariant;
        public boolean fromOtherFiles;
        int lastStartOffset;
        long lastModCount;
        List<Integer> caretOffsets = Collections.emptyList();

        private CompletionState() {
        }
    }

    public static class CompletionVariant {
        public final Editor editor;
        public final String variant;
        public int offset;
        private RangeMarker marker;

        public CompletionVariant(Editor editor2, String variant, int offset2) {
            this.editor = editor2;
            this.variant = variant;
            this.offset = offset2;
        }

        public void fastenBelts() {
            this.marker = this.editor.getDocument().createRangeMarker(this.offset, this.offset);
        }

        public void unfastenBelts() {
            if (this.marker.isValid()) {
                this.offset = this.marker.getStartOffset();
                this.marker.dispose();
            }
            this.marker = null;
        }
    }

    private static interface TokenProcessor {
        public boolean processToken(int var1, int var2);
    }
}

