/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.containers.FList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BetterPrefixMatcher
extends PrefixMatcher {
    private final PrefixMatcher myOriginal;
    @Nullable
    private final CamelHumpMatcher myHumpMatcher;
    private final int myMinMatchingDegree;

    public BetterPrefixMatcher(PrefixMatcher original, int minMatchingDegree) {
        super(original.getPrefix());
        this.myOriginal = original;
        this.myHumpMatcher = original instanceof CamelHumpMatcher ? (CamelHumpMatcher)original : null;
        this.myMinMatchingDegree = minMatchingDegree;
    }

    @NotNull
    public BetterPrefixMatcher improve(CompletionResult result2) {
        int degree = RealPrefixMatchingWeigher.getBestMatchingDegree(result2.getLookupElement(), result2.getPrefixMatcher());
        if (degree <= this.myMinMatchingDegree) {
            BetterPrefixMatcher betterPrefixMatcher = this;
            if (betterPrefixMatcher == null) {
                BetterPrefixMatcher.$$$reportNull$$$0(0);
            }
            return betterPrefixMatcher;
        }
        BetterPrefixMatcher betterPrefixMatcher = this.createCopy(this.myOriginal, degree);
        if (betterPrefixMatcher == null) {
            BetterPrefixMatcher.$$$reportNull$$$0(1);
        }
        return betterPrefixMatcher;
    }

    @NotNull
    protected BetterPrefixMatcher createCopy(PrefixMatcher original, int degree) {
        return new BetterPrefixMatcher(original, degree);
    }

    @Override
    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            BetterPrefixMatcher.$$$reportNull$$$0(2);
        }
        return this.prefixMatchesEx(name) == MatchingOutcome.BETTER_MATCH;
    }

    protected MatchingOutcome prefixMatchesEx(String name) {
        return this.myHumpMatcher != null ? this.matchOptimized(name, this.myHumpMatcher) : this.matchGeneric(name);
    }

    private MatchingOutcome matchGeneric(String name) {
        if (!this.myOriginal.prefixMatches(name)) {
            return MatchingOutcome.NON_MATCH;
        }
        if (!this.myOriginal.isStartMatch(name)) {
            return MatchingOutcome.WORSE_MATCH;
        }
        return this.myOriginal.matchingDegree(name) >= this.myMinMatchingDegree ? MatchingOutcome.BETTER_MATCH : MatchingOutcome.WORSE_MATCH;
    }

    private MatchingOutcome matchOptimized(String name, CamelHumpMatcher matcher) {
        FList<TextRange> fragments = matcher.matchingFragments(name);
        if (fragments == null) {
            return MatchingOutcome.NON_MATCH;
        }
        if (!MinusculeMatcher.isStartMatch(fragments)) {
            return MatchingOutcome.WORSE_MATCH;
        }
        return matcher.matchingDegree(name, fragments) >= this.myMinMatchingDegree ? MatchingOutcome.BETTER_MATCH : MatchingOutcome.WORSE_MATCH;
    }

    @Override
    public boolean isStartMatch(String name) {
        return this.myOriginal.isStartMatch(name);
    }

    @Override
    public int matchingDegree(String string2) {
        return this.myOriginal.matchingDegree(string2);
    }

    @Override
    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            BetterPrefixMatcher.$$$reportNull$$$0(3);
        }
        BetterPrefixMatcher betterPrefixMatcher = this.createCopy(this.myOriginal.cloneWithPrefix(prefix), this.myMinMatchingDegree);
        if (betterPrefixMatcher == null) {
            BetterPrefixMatcher.$$$reportNull$$$0(4);
        }
        return betterPrefixMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "improve";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithPrefix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3 -> new IllegalArgumentException(string2);
        };
    }

    protected static enum MatchingOutcome {
        NON_MATCH,
        WORSE_MATCH,
        BETTER_MATCH;

    }

    public static class AutoRestarting
    extends BetterPrefixMatcher {
        private final CompletionResultSet myResult;

        public AutoRestarting(@NotNull CompletionResultSet result2) {
            if (result2 == null) {
                AutoRestarting.$$$reportNull$$$0(0);
            }
            this(result2, result2.getPrefixMatcher(), Integer.MIN_VALUE);
        }

        private AutoRestarting(CompletionResultSet result2, PrefixMatcher original, int minMatchingDegree) {
            super(original, minMatchingDegree);
            this.myResult = result2;
        }

        @Override
        @NotNull
        protected BetterPrefixMatcher createCopy(PrefixMatcher original, int degree) {
            return new AutoRestarting(this.myResult, original, degree);
        }

        @Override
        protected MatchingOutcome prefixMatchesEx(String name) {
            MatchingOutcome outcome = super.prefixMatchesEx(name);
            if (outcome == MatchingOutcome.WORSE_MATCH) {
                this.myResult.restartCompletionOnAnyPrefixChange();
            }
            return outcome;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher$AutoRestarting", "<init>"));
        }
    }
}

