/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CamelHumpMatcher
extends PrefixMatcher {
    private final MinusculeMatcher myMatcher;
    private final MinusculeMatcher myCaseInsensitiveMatcher;
    private final boolean myCaseSensitive;
    private static boolean ourForceStartMatching;
    private final boolean myTypoTolerant;

    public CamelHumpMatcher(@NotNull String prefix) {
        if (prefix == null) {
            CamelHumpMatcher.$$$reportNull$$$0(0);
        }
        this(prefix, true);
    }

    public CamelHumpMatcher(String prefix, boolean caseSensitive) {
        this(prefix, caseSensitive, false);
    }

    @ApiStatus.Internal
    public CamelHumpMatcher(String prefix, boolean caseSensitive, boolean typoTolerant) {
        super(prefix);
        this.myCaseSensitive = caseSensitive;
        this.myTypoTolerant = typoTolerant;
        this.myMatcher = this.createMatcher(this.myCaseSensitive);
        this.myCaseInsensitiveMatcher = this.createMatcher(false);
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    @Override
    public boolean isStartMatch(String name) {
        return this.myMatcher.isStartMatch(name);
    }

    @Override
    public boolean isStartMatch(LookupElement element) {
        for (String s : CompletionUtil.iterateLookupStrings(element)) {
            FList ranges2 = this.myCaseInsensitiveMatcher.matchingFragments(s);
            if (ranges2 == null || !ranges2.isEmpty() && CamelHumpMatcher.skipUnderscores(s) < ((TextRange)ranges2.get(0)).getStartOffset()) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean isTypoTolerant() {
        return this.myTypoTolerant;
    }

    private static int skipUnderscores(@NotNull String name) {
        if (name == null) {
            CamelHumpMatcher.$$$reportNull$$$0(1);
        }
        return CharArrayUtil.shiftForward(name, 0, "_");
    }

    @Override
    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            CamelHumpMatcher.$$$reportNull$$$0(2);
        }
        if (name.startsWith("_") && CodeInsightSettings.getInstance().getCompletionCaseSensitive() == 3 && this.firstLetterCaseDiffers(name)) {
            return false;
        }
        return this.myMatcher.matches(name);
    }

    private boolean firstLetterCaseDiffers(String name) {
        int nameFirst = CamelHumpMatcher.skipUnderscores(name);
        int prefixFirst = CamelHumpMatcher.skipUnderscores(this.myPrefix);
        return nameFirst < name.length() && prefixFirst < this.myPrefix.length() && CamelHumpMatcher.caseDiffers(name.charAt(nameFirst), this.myPrefix.charAt(prefixFirst));
    }

    private static boolean caseDiffers(char c1, char c2) {
        return Character.isLowerCase(c1) != Character.isLowerCase(c2) || Character.isUpperCase(c1) != Character.isUpperCase(c2);
    }

    @Override
    public boolean prefixMatches(@NotNull LookupElement element) {
        if (element == null) {
            CamelHumpMatcher.$$$reportNull$$$0(3);
        }
        return this.prefixMatchersInternal(element, !element.isCaseSensitive());
    }

    private boolean prefixMatchersInternal(LookupElement element, boolean itemCaseInsensitive) {
        for (String name : element.getAllLookupStrings()) {
            if (itemCaseInsensitive && StringUtil.startsWithIgnoreCase(name, this.myPrefix) || this.prefixMatches(name)) {
                return true;
            }
            if (!itemCaseInsensitive || 1 == CodeInsightSettings.getInstance().getCompletionCaseSensitive() || !this.myCaseInsensitiveMatcher.matches(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            CamelHumpMatcher.$$$reportNull$$$0(4);
        }
        if (prefix.equals(this.myPrefix)) {
            CamelHumpMatcher camelHumpMatcher = this;
            if (camelHumpMatcher == null) {
                CamelHumpMatcher.$$$reportNull$$$0(5);
            }
            return camelHumpMatcher;
        }
        return new CamelHumpMatcher(prefix, this.myCaseSensitive, this.myTypoTolerant);
    }

    private MinusculeMatcher createMatcher(boolean caseSensitive) {
        String prefix = CamelHumpMatcher.applyMiddleMatching(this.myPrefix);
        NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)prefix);
        if (caseSensitive) {
            int setting = CodeInsightSettings.getInstance().getCompletionCaseSensitive();
            if (setting == 3) {
                builder2 = builder2.withCaseSensitivity(NameUtil.MatchingCaseSensitivity.FIRST_LETTER);
            } else if (setting == 1) {
                builder2 = builder2.withCaseSensitivity(NameUtil.MatchingCaseSensitivity.ALL);
            }
        }
        if (this.myTypoTolerant) {
            builder2 = builder2.typoTolerant();
        }
        return builder2.build();
    }

    public static String applyMiddleMatching(String prefix) {
        if (Registry.is("ide.completion.middle.matching") && !prefix.isEmpty() && !ourForceStartMatching) {
            return "*" + StringUtil.replace(prefix, ".", ". ").trim();
        }
        return prefix;
    }

    public String toString() {
        return this.myPrefix;
    }

    @Deprecated
    @TestOnly
    public static void forceStartMatching(Disposable parent2) {
        ourForceStartMatching = true;
        Disposer.register(parent2, new Disposable(){

            @Override
            public void dispose() {
                ourForceStartMatching = false;
            }
        });
    }

    @Override
    public int matchingDegree(String string2) {
        return this.matchingDegree(string2, this.matchingFragments(string2));
    }

    @Nullable
    public FList<TextRange> matchingFragments(String string2) {
        return this.myMatcher.matchingFragments(string2);
    }

    public int matchingDegree(String string2, @Nullable FList<? extends TextRange> fragments) {
        int matchStart;
        FList ciRanges;
        int underscoreEnd = CamelHumpMatcher.skipUnderscores(string2);
        if (underscoreEnd > 0 && (ciRanges = this.myCaseInsensitiveMatcher.matchingFragments(string2)) != null && !ciRanges.isEmpty() && (matchStart = ((TextRange)ciRanges.get(0)).getStartOffset()) > 0 && matchStart <= underscoreEnd) {
            return this.myCaseInsensitiveMatcher.matchingDegree(string2.substring(matchStart), true) - 1;
        }
        return this.myMatcher.matchingDegree(string2, true, fragments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/CamelHumpMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/CamelHumpMatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipUnderscores";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithPrefix";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5 -> new IllegalStateException(string2);
        };
    }
}

