/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionPhaseListener;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionThreadingBase;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.telemetry.IJTracer;
import com.intellij.diagnostic.telemetry.TraceKt;
import com.intellij.diagnostic.telemetry.TraceManager;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.Weigher;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import io.opentelemetry.api.trace.Tracer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionServiceImpl
extends BaseCompletionService {
    private static final Logger LOG = Logger.getInstance(CompletionServiceImpl.class);
    private static final CompletionPhaseHolder DEFAULT_PHASE_HOLDER = new CompletionPhaseHolder(CompletionPhase.NoCompletion, null);
    private final IJTracer myCompletionTracer = TraceManager.INSTANCE.getTracer("codeCompletion");

    public CompletionServiceImpl() {
        SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
        connection.subscribe(ProjectCloseListener.TOPIC, new ProjectCloseListener(){

            @Override
            public void projectClosing(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                List sessions = ClientSessionsManager.getAppSessions((ClientKind)ClientKind.ALL);
                for (ClientAppSession session : sessions) {
                    ClientCompletionService clientCompletionService = ClientCompletionService.tryGetInstance(session);
                    if (clientCompletionService == null) continue;
                    CompletionProgressIndicator indicator = clientCompletionService.getCurrentCompletionProgressIndicator();
                    if (indicator != null && indicator.getProject() == project2) {
                        indicator.closeAndFinish(true);
                        clientCompletionService.setCompletionPhase(CompletionPhase.NoCompletion);
                        continue;
                    }
                    if (indicator != null) continue;
                    clientCompletionService.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$1", "projectClosing"));
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                List sessions = ClientSessionsManager.getAppSessions((ClientKind)ClientKind.ALL);
                for (ClientAppSession session : sessions) {
                    ClientCompletionService clientCompletionService = ClientCompletionService.tryGetInstance(session);
                    if (clientCompletionService == null) continue;
                    clientCompletionService.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$2", "beforePluginUnload"));
            }
        });
    }

    public static CompletionServiceImpl getCompletionService() {
        return (CompletionServiceImpl)CompletionService.getCompletionService();
    }

    @Override
    public void setAdvertisementText(@NlsContexts.PopupAdvertisement @Nullable String text2) {
        if (text2 == null) {
            return;
        }
        CompletionProgressIndicator completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (completion != null) {
            completion.addAdvertisement(text2, null);
        }
    }

    @Override
    protected CompletionResultSet createResultSet(@NotNull CompletionParameters parameters2, @NotNull Consumer<? super CompletionResult> consumer2, @NotNull CompletionContributor contributor, @NotNull PrefixMatcher matcher) {
        if (parameters2 == null) {
            CompletionServiceImpl.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            CompletionServiceImpl.$$$reportNull$$$0(1);
        }
        if (contributor == null) {
            CompletionServiceImpl.$$$reportNull$$$0(2);
        }
        if (matcher == null) {
            CompletionServiceImpl.$$$reportNull$$$0(3);
        }
        return new CompletionResultSetImpl(consumer2, matcher, contributor, parameters2, null, null);
    }

    @Override
    public CompletionProcess getCurrentCompletion() {
        CompletionProgressIndicator indicator = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (indicator != null) {
            return indicator;
        }
        return ClientId.isCurrentlyUnderLocalId() ? this.myApiCompletionProcess : null;
    }

    @Nullable
    public static CompletionProgressIndicator getCurrentCompletionProgressIndicator() {
        ClientCompletionService clientCompletionService = ClientCompletionService.tryGetInstance(ClientSessionsManager.getAppSession());
        if (clientCompletionService == null) {
            return null;
        }
        return clientCompletionService.getCurrentCompletionProgressIndicator();
    }

    @SafeVarargs
    public static void assertPhase(Class<? extends CompletionPhase> ... possibilities) {
        ClientCompletionService clientCompletionService;
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(4);
        }
        CompletionPhaseHolder holder = (clientCompletionService = ClientCompletionService.tryGetInstance(ClientSessionsManager.getAppSession())) != null ? clientCompletionService.getCompletionPhaseHolder() : DEFAULT_PHASE_HOLDER;
        CompletionServiceImpl.assertPhase(holder, possibilities);
    }

    @SafeVarargs
    private static void assertPhase(@NotNull CompletionPhaseHolder phaseHolder, Class<? extends CompletionPhase> ... possibilities) {
        if (phaseHolder == null) {
            CompletionServiceImpl.$$$reportNull$$$0(5);
        }
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(6);
        }
        if (!CompletionServiceImpl.isPhase(phaseHolder.phase(), possibilities)) {
            CompletionServiceImpl.reportPhase(phaseHolder);
        }
    }

    private static void reportPhase(@NotNull CompletionPhaseHolder phaseHolder) {
        Throwable phaseTrace;
        if (phaseHolder == null) {
            CompletionServiceImpl.$$$reportNull$$$0(7);
        }
        String traceText = (phaseTrace = phaseHolder.phaseTrace()) != null ? "; set at " + ExceptionUtil.getThrowableText(phaseTrace) : "";
        LOG.error(phaseHolder.phase() + "; " + ClientId.getCurrent() + traceText);
    }

    @SafeVarargs
    public static boolean isPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(8);
        }
        return CompletionServiceImpl.isPhase(CompletionServiceImpl.getCompletionPhase(), possibilities);
    }

    @SafeVarargs
    private static boolean isPhase(@NotNull CompletionPhase phase, Class<? extends CompletionPhase> ... possibilities) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(9);
        }
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(10);
        }
        for (Class<? extends CompletionPhase> possibility : possibilities) {
            if (!possibility.isInstance(phase)) continue;
            return true;
        }
        return false;
    }

    public static void setCompletionPhase(@NotNull CompletionPhase phase) {
        ClientCompletionService clientCompletionService;
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(11);
        }
        if ((clientCompletionService = ClientCompletionService.tryGetInstance(ClientSessionsManager.getAppSession())) == null) {
            return;
        }
        clientCompletionService.setCompletionPhase(phase);
    }

    private static boolean isRunningPhase(@NotNull CompletionPhase phase) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(12);
        }
        return phase != CompletionPhase.NoCompletion && !(phase instanceof CompletionPhase.ZombiePhase) && !(phase instanceof CompletionPhase.ItemsCalculated);
    }

    @NotNull
    public static CompletionPhase getCompletionPhase() {
        ClientCompletionService clientCompletionService = ClientCompletionService.tryGetInstance(ClientSessionsManager.getAppSession());
        if (clientCompletionService == null) {
            CompletionPhase completionPhase = CompletionServiceImpl.DEFAULT_PHASE_HOLDER.phase;
            if (completionPhase == null) {
                CompletionServiceImpl.$$$reportNull$$$0(13);
            }
            return completionPhase;
        }
        CompletionPhase completionPhase = clientCompletionService.getCompletionPhase();
        if (completionPhase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(14);
        }
        return completionPhase;
    }

    @Override
    @NotNull
    protected CompletionSorterImpl addWeighersBefore(@NotNull CompletionSorterImpl sorter) {
        if (sorter == null) {
            CompletionServiceImpl.$$$reportNull$$$0(15);
        }
        CompletionSorterImpl processed2 = super.addWeighersBefore(sorter);
        CompletionSorterImpl completionSorterImpl = processed2.withClassifier(CompletionSorterImpl.weighingFactory(new LiveTemplateWeigher()));
        if (completionSorterImpl == null) {
            CompletionServiceImpl.$$$reportNull$$$0(16);
        }
        return completionSorterImpl;
    }

    @Override
    @NotNull
    protected CompletionSorterImpl processStatsWeigher(@NotNull CompletionSorterImpl sorter, @NotNull Weigher weigher, final @NotNull CompletionLocation location2) {
        if (sorter == null) {
            CompletionServiceImpl.$$$reportNull$$$0(17);
        }
        if (weigher == null) {
            CompletionServiceImpl.$$$reportNull$$$0(18);
        }
        if (location2 == null) {
            CompletionServiceImpl.$$$reportNull$$$0(19);
        }
        CompletionSorterImpl processedSorter = super.processStatsWeigher(sorter, weigher, location2);
        CompletionSorterImpl completionSorterImpl = processedSorter.withClassifier(new ClassifierFactory<LookupElement>("stats"){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next2) {
                return new StatisticsWeigher.LookupStatisticsWeigher(location2, next2);
            }
        });
        if (completionSorterImpl == null) {
            CompletionServiceImpl.$$$reportNull$$$0(20);
        }
        return completionSorterImpl;
    }

    @Override
    protected void getVariantsFromContributor(CompletionParameters params, CompletionContributor contributor, CompletionResultSet result2) {
        TraceKt.runWithSpan((Tracer)this.myCompletionTracer, (String)contributor.getClass().getSimpleName(), span -> {
            super.getVariantsFromContributor(params, contributor, result2);
            span.setAttribute("avoid_null_value", true);
        });
    }

    @Override
    public void performCompletion(CompletionParameters parameters2, final Consumer<? super CompletionResult> consumer2) {
        TraceKt.runWithSpan((Tracer)this.myCompletionTracer, (String)"performCompletion", span -> {
            var countingConsumer = new Consumer<CompletionResult>(){
                int count = 0;

                @Override
                public void consume(CompletionResult result2) {
                    ++this.count;
                    consumer2.consume(result2);
                }
            };
            super.performCompletion(parameters2, countingConsumer);
            span.setAttribute("lookupsFound", (long)countingConsumer.count);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 16, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibilities";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phaseHolder";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weigher";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionPhase";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addWeighersBefore";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "processStatsWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createResultSet";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertPhase";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reportPhase";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPhase";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionPhase";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isRunningPhase";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 20: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addWeighersBefore";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processStatsWeigher";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 13, 14, 16, 20 -> new IllegalStateException(string2);
        };
    }

    private static class CompletionResultSetImpl
    extends BaseCompletionService.BaseCompletionResultSet {
        CompletionResultSetImpl(Consumer<? super CompletionResult> consumer2, PrefixMatcher prefixMatcher, CompletionContributor contributor, CompletionParameters parameters2, @Nullable CompletionSorter sorter, @Nullable CompletionResultSetImpl original) {
            super(consumer2, prefixMatcher, contributor, parameters2, sorter, original);
        }

        @Override
        public void addAllElements(@NotNull Iterable<? extends LookupElement> elements) {
            if (elements == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(0);
            }
            CompletionThreadingBase.withBatchUpdate(() -> super.addAllElements(elements), this.myParameters.getProcess());
        }

        @Override
        public void passResult(@NotNull CompletionResult result2) {
            LookupElement element;
            if (result2 == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(1);
            }
            if ((element = result2.getLookupElement()) != null && element.getUserData(BaseCompletionService.LOOKUP_ELEMENT_CONTRIBUTOR) == null) {
                element.putUserData(BaseCompletionService.LOOKUP_ELEMENT_CONTRIBUTOR, this.myContributor);
            }
            super.passResult(result2);
        }

        @Override
        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(2);
            }
            if (matcher.equals(this.getPrefixMatcher())) {
                CompletionResultSetImpl completionResultSetImpl = this;
                if (completionResultSetImpl == null) {
                    CompletionResultSetImpl.$$$reportNull$$$0(3);
                }
                return completionResultSetImpl;
            }
            return new CompletionResultSetImpl(this.getConsumer(), matcher, this.myContributor, this.myParameters, this.mySorter, this);
        }

        @Override
        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            if (sorter == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(4);
            }
            return new CompletionResultSetImpl(this.getConsumer(), this.getPrefixMatcher(), this.myContributor, this.myParameters, sorter, this);
        }

        @Override
        public void addLookupAdvertisement(@NotNull String text2) {
            if (text2 == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(5);
            }
            CompletionServiceImpl.getCompletionService().setAdvertisementText(text2);
        }

        @Override
        public void restartCompletionOnPrefixChange(ElementPattern<String> prefixCondition) {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProcessBase) {
                ((CompletionProcessBase)process2).addWatchedPrefix(this.myParameters.getOffset() - this.getPrefixMatcher().getPrefix().length(), prefixCondition);
            }
        }

        @Override
        public void restartCompletionWhenNothingMatches() {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProgressIndicator) {
                ((CompletionProgressIndicator)process2).getLookup().setStartCompletionWhenNothingMatches(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sorter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addAllElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "passResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixMatcher";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelevanceSorter";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addLookupAdvertisement";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    private static class ClientCompletionService
    implements Disposable {
        @NotNull
        private final ClientAppSession myAppSession;
        @NotNull
        private volatile CompletionPhaseHolder myPhaseHolder;

        @Nullable
        public static ClientCompletionService tryGetInstance(@Nullable ClientAppSession session) {
            if (session == null) {
                return null;
            }
            return (ClientCompletionService)session.getService(ClientCompletionService.class);
        }

        ClientCompletionService(@NotNull ClientAppSession appSession) {
            if (appSession == null) {
                ClientCompletionService.$$$reportNull$$$0(0);
            }
            this.myPhaseHolder = DEFAULT_PHASE_HOLDER;
            this.myAppSession = appSession;
        }

        @Override
        public void dispose() {
            Disposer.dispose(this.myPhaseHolder.phase);
        }

        public void setCompletionPhase(@NotNull CompletionPhase phase) {
            if (phase == null) {
                ClientCompletionService.$$$reportNull$$$0(1);
            }
            try (AccessToken ignored = ClientId.withClientId(this.myAppSession.getClientId());){
                ApplicationManager.getApplication().assertIsDispatchThread();
                CompletionPhase oldPhase = this.getCompletionPhase();
                CompletionProgressIndicator oldIndicator = oldPhase.indicator;
                if (oldIndicator != null && !(phase instanceof CompletionPhase.BgCalculation) && oldIndicator.isRunning() && !oldIndicator.isCanceled()) {
                    LOG.error("don't change phase during running completion: oldPhase=" + oldPhase);
                }
                boolean wasCompletionRunning = CompletionServiceImpl.isRunningPhase(oldPhase);
                boolean isCompletionRunning = CompletionServiceImpl.isRunningPhase(phase);
                if (isCompletionRunning != wasCompletionRunning) {
                    ApplicationManager.getApplication().getMessageBus().syncPublisher(CompletionPhaseListener.TOPIC).completionPhaseChanged(isCompletionRunning);
                }
                Disposer.dispose(oldPhase);
                Throwable phaseTrace = new Throwable();
                this.myPhaseHolder = new CompletionPhaseHolder(phase, phaseTrace);
            }
        }

        @NotNull
        public CompletionPhase getCompletionPhase() {
            CompletionPhase completionPhase = this.getCompletionPhaseHolder().phase;
            if (completionPhase == null) {
                ClientCompletionService.$$$reportNull$$$0(2);
            }
            return completionPhase;
        }

        @NotNull
        public CompletionPhaseHolder getCompletionPhaseHolder() {
            CompletionPhaseHolder completionPhaseHolder = this.myPhaseHolder;
            if (completionPhaseHolder == null) {
                ClientCompletionService.$$$reportNull$$$0(3);
            }
            return completionPhaseHolder;
        }

        public CompletionProgressIndicator getCurrentCompletionProgressIndicator() {
            return this.getCurrentCompletionProgressIndicator(this.getCompletionPhase());
        }

        public CompletionProgressIndicator getCurrentCompletionProgressIndicator(@NotNull CompletionPhase phase) {
            if (phase == null) {
                ClientCompletionService.$$$reportNull$$$0(4);
            }
            if (CompletionServiceImpl.isPhase(phase, CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.CommittingDocuments.class, CompletionPhase.Synchronous.class)) {
                return phase.indicator;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "appSession";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phase";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$ClientCompletionService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$ClientCompletionService";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletionPhase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletionPhaseHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setCompletionPhase";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCurrentCompletionProgressIndicator";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    private record CompletionPhaseHolder(@NotNull CompletionPhase phase, @Nullable Throwable phaseTrace) {
        @NotNull
        private final CompletionPhase phase;

        private CompletionPhaseHolder(@NotNull CompletionPhase phase, @Nullable Throwable phaseTrace) {
            if (phase == null) {
                CompletionPhaseHolder.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public CompletionPhase phase() {
            CompletionPhase completionPhase = this.phase;
            if (completionPhase == null) {
                CompletionPhaseHolder.$$$reportNull$$$0(1);
            }
            return completionPhase;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phase";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionPhaseHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionPhaseHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "phase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

