/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.FlatteningIterator;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LiftShorterItemsClassifier
extends Classifier<LookupElement> {
    private final TreeSet<String> mySortedStrings = new TreeSet();
    private final MultiMap<String, LookupElement> myElements = LiftShorterItemsClassifier.createMultiMap(false);
    private final MultiMap<LookupElement, LookupElement> myToLift = LiftShorterItemsClassifier.createMultiMap(true);
    private final MultiMap<LookupElement, LookupElement> myReversedToLift = LiftShorterItemsClassifier.createMultiMap(true);
    private final LiftingCondition myCondition;
    private final boolean myLiftBefore;
    private volatile int myCount = 0;

    public LiftShorterItemsClassifier(@NonNls String name, Classifier<LookupElement> next2, LiftingCondition condition, boolean liftBefore) {
        super(next2, name);
        this.myCondition = condition;
        this.myLiftBefore = liftBefore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addElement(@NotNull LookupElement added, @NotNull ProcessingContext context2) {
        if (added == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(1);
        }
        LiftShorterItemsClassifier liftShorterItemsClassifier = this;
        synchronized (liftShorterItemsClassifier) {
            ++this.myCount;
            for (String string2 : CompletionUtil.iterateLookupStrings(added)) {
                if (string2.length() == 0) continue;
                this.myElements.putValue(string2, added);
                this.mySortedStrings.add(string2);
                NavigableSet<String> after2 = this.mySortedStrings.tailSet(string2, false);
                for (String s : after2) {
                    if (!s.startsWith(string2)) break;
                    for (LookupElement longer : this.myElements.get(s)) {
                        this.updateLongerItem(added, longer);
                    }
                }
            }
        }
        super.addElement(added, context2);
        this.calculateToLift(added);
    }

    private void updateLongerItem(LookupElement shorter, LookupElement longer) {
        if (this.myCondition.shouldLift(shorter, longer)) {
            this.myToLift.putValue(longer, shorter);
            this.myReversedToLift.putValue(shorter, longer);
        }
    }

    private synchronized void calculateToLift(@NotNull LookupElement element) {
        if (element == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(2);
        }
        for (String string2 : CompletionUtil.iterateLookupStrings(element)) {
            for (int len = 1; len < string2.length(); ++len) {
                String prefix = string2.substring(0, len);
                for (LookupElement shorterElement : this.myElements.get(prefix)) {
                    if (!this.myCondition.shouldLift(shorterElement, element)) continue;
                    this.myToLift.putValue(element, shorterElement);
                    this.myReversedToLift.putValue(shorterElement, element);
                }
            }
        }
    }

    @Override
    @NotNull
    public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context2) {
        if (source == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(4);
        }
        return this.liftShorterElements(source, null, context2);
    }

    @NotNull
    private Iterable<LookupElement> liftShorterElements(@NotNull Iterable<? extends LookupElement> source, @Nullable Set<? super LookupElement> lifted, @NotNull ProcessingContext context2) {
        if (source == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(6);
        }
        ReferenceOpenHashSet<LookupElement> srcSet = new ReferenceOpenHashSet<LookupElement>(source instanceof Collection ? ((Collection)source).size() : this.myCount);
        ContainerUtil.addAll(srcSet, source);
        if (srcSet.size() < 2) {
            Iterable<LookupElement> iterable = this.myNext.classify(source, context2);
            if (iterable == null) {
                LiftShorterItemsClassifier.$$$reportNull$$$0(7);
            }
            return iterable;
        }
        return new LiftingIterable(srcSet, context2, source, lifted);
    }

    @Override
    @NotNull
    public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items2, @NotNull ProcessingContext context2) {
        if (items2 == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(9);
        }
        ReferenceOpenHashSet lifted = new ReferenceOpenHashSet();
        Iterable<LookupElement> iterable = this.liftShorterElements(ContainerUtil.newArrayList(items2), lifted, context2);
        List<Pair<LookupElement, Object>> list2 = ContainerUtil.map(iterable, element -> new Pair<LookupElement, Boolean>((LookupElement)element, lifted.contains(element)));
        if (list2 == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(10);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElement(@NotNull LookupElement element, @NotNull ProcessingContext context2) {
        if (element == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(12);
        }
        LiftShorterItemsClassifier liftShorterItemsClassifier = this;
        synchronized (liftShorterItemsClassifier) {
            for (String s : CompletionUtil.iterateLookupStrings(element)) {
                this.myElements.remove(s, element);
                if (!this.myElements.get(s).isEmpty()) continue;
                this.mySortedStrings.remove(s);
            }
            LiftShorterItemsClassifier.removeFromMap(element, this.myToLift, this.myReversedToLift);
            LiftShorterItemsClassifier.removeFromMap(element, this.myReversedToLift, this.myToLift);
        }
        super.removeElement(element, context2);
    }

    private static void removeFromMap(LookupElement key, @NotNull MultiMap<LookupElement, LookupElement> mainMap, @NotNull MultiMap<LookupElement, LookupElement> inverseMap) {
        Collection<LookupElement> removed;
        if (mainMap == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(13);
        }
        if (inverseMap == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(14);
        }
        if ((removed = mainMap.remove(key)) == null) {
            return;
        }
        for (LookupElement reference2 : new ArrayList<LookupElement>(removed)) {
            inverseMap.remove(reference2, key);
        }
    }

    @NotNull
    private static <K, V> MultiMap<K, V> createMultiMap(boolean identityKeys) {
        return new MultiMap<K, V>((Map)(identityKeys ? new Reference2ObjectOpenHashMap() : CollectionFactory.createSmallMemoryFootprintMap())){

            @Override
            public boolean remove(K key, V value) {
                List elements = (List)this.get(key);
                int i2 = ContainerUtil.indexOfIdentity(elements, value);
                if (i2 >= 0) {
                    elements.remove(i2);
                    if (elements.isEmpty()) {
                        this.remove(key);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/LiftShorterItemsClassifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainMap";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inverseMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/LiftShorterItemsClassifier";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "liftShorterElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingWeights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateToLift";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "liftShorterElements";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSortingWeights";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeFromMap";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 10 -> new IllegalStateException(string2);
        };
    }

    public static class LiftingCondition {
        public boolean shouldLift(LookupElement shorterElement, LookupElement longerElement) {
            return true;
        }
    }

    private class LiftingIterable
    implements Iterable<LookupElement> {
        @NotNull
        private final Set<LookupElement> mySrcSet;
        @NotNull
        private final ProcessingContext myContext;
        @NotNull
        private final Iterable<? extends LookupElement> mySource;
        @Nullable
        private final Set<? super LookupElement> myLifted;

        LiftingIterable(@NotNull Set<LookupElement> srcSet, @NotNull ProcessingContext context2, @Nullable Iterable<? extends LookupElement> source, Set<? super LookupElement> lifted) {
            if (srcSet == null) {
                LiftingIterable.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                LiftingIterable.$$$reportNull$$$0(1);
            }
            if (source == null) {
                LiftingIterable.$$$reportNull$$$0(2);
            }
            this.mySrcSet = srcSet;
            this.myContext = context2;
            this.mySource = source;
            this.myLifted = lifted;
        }

        @Override
        @NotNull
        public Iterator<LookupElement> iterator() {
            final ReferenceOpenHashSet processed2 = new ReferenceOpenHashSet(this.mySrcSet.size());
            final ReferenceOpenHashSet arraysProcessed = new ReferenceOpenHashSet();
            Iterable<? extends LookupElement> next2 = LiftShorterItemsClassifier.this.myNext == null ? this.mySource : LiftShorterItemsClassifier.this.myNext.classify(this.mySource, this.myContext);
            Iterator<LookupElement> base = FilteringIterator.create(next2.iterator(), processed2::add);
            return new FlatteningIterator<LookupElement, LookupElement>(base){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @NotNull
                protected Iterator<LookupElement> createValueIterator(LookupElement element) {
                    ArrayList<LookupElement> toLift;
                    LiftShorterItemsClassifier liftShorterItemsClassifier = LiftShorterItemsClassifier.this;
                    synchronized (liftShorterItemsClassifier) {
                        toLift = new ArrayList<LookupElement>(LiftShorterItemsClassifier.this.myToLift.get(element));
                    }
                    List<LookupElement> shorter = this.addShorterElements(toLift);
                    List<LookupElement> singleton = Collections.singletonList(element);
                    if (shorter != null) {
                        if (LiftingIterable.this.myLifted != null) {
                            LiftingIterable.this.myLifted.addAll(shorter);
                        }
                        List<LookupElement> lifted = LiftShorterItemsClassifier.this.myNext == null ? shorter : LiftShorterItemsClassifier.this.myNext.classify(shorter, LiftingIterable.this.myContext);
                        Iterator<LookupElement> iterator2 = (LiftShorterItemsClassifier.this.myLiftBefore ? ContainerUtil.concat(lifted, singleton) : ContainerUtil.concat(singleton, lifted)).iterator();
                        if (iterator2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return iterator2;
                    }
                    Iterator<LookupElement> iterator3 = singleton.iterator();
                    if (iterator3 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return iterator3;
                }

                @Nullable
                private List<LookupElement> addShorterElements(@Nullable Collection<LookupElement> from) {
                    ArrayList<LookupElement> toLift = null;
                    if (from == null) {
                        return null;
                    }
                    if (arraysProcessed.add(from)) {
                        for (LookupElement shorterElement : from) {
                            if (!LiftingIterable.this.mySrcSet.contains(shorterElement) || !processed2.add(shorterElement)) continue;
                            if (toLift == null) {
                                toLift = new ArrayList<LookupElement>();
                            }
                            toLift.add(shorterElement);
                        }
                    }
                    return toLift;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/LiftShorterItemsClassifier$LiftingIterable$1", "createValueIterator"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "srcSet";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/impl/LiftShorterItemsClassifier$LiftingIterable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

