/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiFile;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface ReferenceImporter {
    public static final ExtensionPointName<ReferenceImporter> EP_NAME = ExtensionPointName.create("com.intellij.referenceImporter");

    default public boolean autoImportReferenceAtCursor(@NotNull Editor editor2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            ReferenceImporter.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ReferenceImporter.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Future<BooleanSupplier> future = ApplicationManager.getApplication().executeOnPooledThread(() -> ReadAction.compute(() -> {
            if (editor2.isDisposed() || file2.getProject().isDisposed()) {
                return null;
            }
            int offset2 = editor2.getCaretModel().getOffset();
            return this.computeAutoImportAtOffset(editor2, file2, offset2, true);
        }));
        try {
            BooleanSupplier fix2 = future.get();
            if (fix2 != null) {
                return fix2.getAsBoolean();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    @ApiStatus.Experimental
    default public BooleanSupplier computeAutoImportAtOffset(@NotNull Editor editor2, @NotNull PsiFile file2, int offset2, boolean allowCaretNearReference) {
        if (editor2 == null) {
            ReferenceImporter.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ReferenceImporter.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return null;
    }

    default public boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile file2) {
        if (file2 == null) {
            ReferenceImporter.$$$reportNull$$$0(4);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/ReferenceImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "autoImportReferenceAtCursor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAutoImportAtOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAddUnambiguousImportsOnTheFlyEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

