/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.ConfigureInspectionsAction;
import com.intellij.codeInsight.daemon.impl.LevelAction;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"getConfigureHighlightingLevelPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nConfigureHighlightingLevel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureHighlightingLevel.kt\ncom/intellij/codeInsight/daemon/impl/ConfigureHighlightingLevelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1045#2:105\n1855#2,2:106\n*S KotlinDebug\n*F\n+ 1 ConfigureHighlightingLevel.kt\ncom/intellij/codeInsight/daemon/impl/ConfigureHighlightingLevelKt\n*L\n37#1:105\n37#1:106,2\n*E\n"})
public final class ConfigureHighlightingLevelKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final JBPopup getConfigureHighlightingLevelPopup(@NotNull DataContext context2) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiFile psiFile = (PsiFile)context2.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        PsiFile psi = psiFile;
        if (!psi.isValid() || psi.getProject().isDisposed()) {
            return null;
        }
        FileViewProvider fileViewProvider = psi.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"psi.viewProvider");
        FileViewProvider provider2 = fileViewProvider;
        Set<Language> set2 = provider2.getLanguages();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"provider.languages");
        Set<Language> languages = set2;
        if (languages.isEmpty()) {
            return null;
        }
        VirtualFile virtualFile2 = psi.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(psi.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(psi.project)");
        ProjectFileIndex index2 = projectFileIndex;
        boolean isAllInspectionsEnabled = index2.isInContent(file2) || !index2.isInLibrary(file2);
        DefaultActionGroup group2 = new DefaultActionGroup();
        Iterable $this$sortedBy$iv = languages;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Language it = (Language)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getDisplayName());
                it = (Language)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Language it = (Language)element$iv;
            boolean bl = false;
            if (((Collection)languages).size() > 1) {
                group2.add((AnAction)Separator.create((String)it.getDisplayName()));
            }
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            group2.add((AnAction)new LevelAction(InspectionsLevel.NONE, provider2, it));
            group2.add((AnAction)new LevelAction(InspectionsLevel.SYNTAX, provider2, it));
            if (!isAllInspectionsEnabled) continue;
            if (ApplicationManager.getApplication().isInternal()) {
                group2.add((AnAction)new LevelAction(InspectionsLevel.ESSENTIAL, provider2, it));
            }
            group2.add((AnAction)new LevelAction(InspectionsLevel.ALL, provider2, it));
        }
        group2.add((AnAction)Separator.create());
        group2.add((AnAction)new ConfigureInspectionsAction());
        Object[] objectArray = new Object[]{psi.getVirtualFile().getPresentableName()};
        String string2 = DaemonBundle.message("popup.title.configure.highlighting.level", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"popup.title.con\u2026tualFile.presentableName)");
        String title = string2;
        return (JBPopup)JBPopupFactory.getInstance().createActionGroupPopup(title, (ActionGroup)group2, context2, true, null, 100);
    }
}

