/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettingsImpl;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.IntentionsUIImpl;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.PassExecutorService;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.StatusBarUpdater;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.impl.FileLevelIntentionComponent;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixUpdater;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.notebook.editor.BackedVirtualFileProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.ClientFileEditorManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.EDT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="DaemonCodeAnalyzer", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class DaemonCodeAnalyzerImpl
extends DaemonCodeAnalyzerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(DaemonCodeAnalyzerImpl.class);
    private static final Key<List<HighlightInfo>> FILE_LEVEL_HIGHLIGHTS = Key.create("FILE_LEVEL_HIGHLIGHTS");
    @NotNull
    private static final Key<Boolean> COMPLETE_ESSENTIAL_HIGHLIGHTING_KEY = Key.create("COMPLETE_ESSENTIAL_HIGHLIGHTING");
    private final Project myProject;
    private final DaemonCodeAnalyzerSettings mySettings;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    private FileEditorManager myFileEditorManager;
    private final Map<FileEditor, DaemonProgressIndicator> myUpdateProgress;
    private final UpdateRunnable myUpdateRunnable;
    @NotNull
    private volatile Future<?> myUpdateRunnableFuture;
    private boolean myUpdateByTimerEnabled;
    private final Collection<VirtualFile> myDisabledHintsFiles;
    private final Collection<VirtualFile> myDisabledHighlightingFiles;
    private final FileStatusMap myFileStatusMap;
    private DaemonCodeAnalyzerSettings myLastSettings;
    private volatile boolean myDisposed;
    @NonNls
    private static final String DISABLE_HINTS_TAG = "disable_hints";
    @NonNls
    private static final String FILE_TAG = "file";
    @NonNls
    private static final String URL_ATT = "url";
    private final PassExecutorService myPassExecutorService;
    private long myScheduledUpdateTimestamp;
    private volatile boolean completeEssentialHighlightingRequested;
    private final AtomicInteger daemonCancelEventCount;
    private final DaemonCodeAnalyzer.DaemonListener myDaemonListenerPublisher;
    private static final int ANY_GROUP = -409423948;
    private volatile boolean mustWaitForSmartMode;
    private final AtomicInteger myDisableCount;

    public DaemonCodeAnalyzerImpl(@NotNull Project project2) {
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(0);
        }
        this.myUpdateProgress = new ConcurrentHashMap<FileEditor, DaemonProgressIndicator>();
        this.myUpdateRunnableFuture = CompletableFuture.completedFuture(null);
        this.myUpdateByTimerEnabled = true;
        this.myDisabledHintsFiles = new HashSet<VirtualFile>();
        this.myDisabledHighlightingFiles = new HashSet<VirtualFile>();
        this.daemonCancelEventCount = new AtomicInteger();
        this.mustWaitForSmartMode = true;
        this.myDisableCount = new AtomicInteger();
        DependencyValidationManager.getInstance(project2);
        this.myProject = project2;
        this.mySettings = DaemonCodeAnalyzerSettings.getInstance();
        this.myPsiDocumentManager = PsiDocumentManager.getInstance(project2);
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)this.mySettings).clone();
        this.myFileStatusMap = new FileStatusMap(project2);
        this.myPassExecutorService = new PassExecutorService(project2);
        Disposer.register(this, this.myPassExecutorService);
        Disposer.register(this, this.myFileStatusMap);
        DaemonProgressIndicator.setDebug(LOG.isDebugEnabled());
        Disposer.register(this, new StatusBarUpdater(project2));
        this.myDisposed = false;
        this.myFileStatusMap.markAllFilesDirty("DaemonCodeAnalyzer init");
        this.myUpdateRunnable = new UpdateRunnable(project2);
        Disposer.register(this, () -> {
            assert (!this.myDisposed) : "Double dispose";
            this.myUpdateRunnable.clearFieldsOnDispose();
            this.stopProcess(false, "Dispose " + project2);
            this.myDisposed = true;
            this.myLastSettings = null;
        });
        this.myDaemonListenerPublisher = (DaemonCodeAnalyzer.DaemonListener)project2.getMessageBus().syncPublisher(DAEMON_EVENT_TOPIC);
    }

    private FileEditorManager getFileEditorManager() {
        FileEditorManager result2 = this.myFileEditorManager;
        if (result2 == null) {
            this.myFileEditorManager = result2 = FileEditorManager.getInstance(this.myProject);
        }
        return result2;
    }

    @Override
    public synchronized void dispose() {
        this.clearReferences();
    }

    private synchronized void clearReferences() {
        this.myUpdateProgress.values().forEach(ProgressIndicator::cancel);
        this.myUpdateProgress.clear();
        this.myUpdateRunnableFuture.cancel(true);
    }

    synchronized void clearProgressIndicator() {
        this.myUpdateProgress.values().forEach(HighlightingSessionImpl::clearProgressIndicator);
    }

    @TestOnly
    @NotNull
    public static List<HighlightInfo> getHighlights(@NotNull Document document, @Nullable HighlightSeverity minSeverity, @NotNull Project project2) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(2);
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerImpl.processHighlights(document, project2, minSeverity, 0, document.getTextLength(), Processors.cancelableCollectProcessor(infos));
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @TestOnly
    @NotNull
    public List<HighlightInfo> getFileLevelHighlights(@NotNull Project project2, @NotNull PsiFile file2) {
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(5);
        }
        this.assertMyFile(file2.getProject(), file2);
        this.assertMyFile(project2, file2);
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        List<HighlightInfo> list2 = Arrays.stream(this.getFileEditorManager().getAllEditors(vFile)).map(fileEditor -> (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        if (list2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private void assertMyFile(@NotNull Project project2, @NotNull PsiFile file2) {
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(8);
        }
        if (project2 != this.myProject) {
            throw new IllegalStateException("my project is " + this.myProject + " but I was called with " + project2);
        }
        if (file2.getProject() != this.myProject) {
            throw new IllegalStateException("my project is " + this.myProject + " but I was called with file " + file2 + " from " + file2.getProject());
        }
    }

    @Override
    public void cleanFileLevelHighlights(int group2, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(9);
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        VirtualFile vFile = BackedVirtualFile.getOriginFileIfBacked(psiFile.getViewProvider().getVirtualFile());
        for (FileEditor fileEditor : this.getFileEditorManager().getAllEditors(vFile)) {
            this.cleanFileLevelHighlights(fileEditor, group2);
        }
    }

    void cleanAllFileLevelHighlights() {
        for (FileEditor fileEditor : this.getFileEditorManager().getAllEditors()) {
            this.cleanFileLevelHighlights(fileEditor, -409423948);
        }
    }

    private void cleanFileLevelHighlights(@NotNull FileEditor fileEditor, int group2) {
        List infos;
        if (fileEditor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(10);
        }
        if ((infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS)) == null || infos.isEmpty()) {
            return;
        }
        ArrayList<HighlightInfo> infosToRemove = new ArrayList<HighlightInfo>(infos.size());
        for (HighlightInfo info2 : infos) {
            if (info2.getGroup() != group2 && group2 != -409423948) continue;
            JComponent component2 = info2.getFileLevelComponent(fileEditor);
            if (component2 != null) {
                this.getFileEditorManager().removeTopComponent(fileEditor, component2);
                info2.removeFileLeverComponent(fileEditor);
            }
            infosToRemove.add(info2);
        }
        infos.removeAll(infosToRemove);
    }

    @Override
    public void addFileLevelHighlight(int group2, @NotNull HighlightInfo info2, @NotNull PsiFile psiFile) {
        if (info2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(11);
        }
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(12);
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        VirtualFile vFile = BackedVirtualFile.getOriginFileIfBacked(psiFile.getViewProvider().getVirtualFile());
        FileEditorManager fileEditorManager = this.getFileEditorManager();
        for (FileEditor fileEditor : fileEditorManager.getAllEditors(vFile)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            ArrayList actionRanges = new ArrayList();
            info2.findRegisteredQuickFix((descriptor2, range) -> {
                actionRanges.add(Pair.create(descriptor2, range));
                return null;
            });
            FileLevelIntentionComponent component2 = new FileLevelIntentionComponent(info2.getDescription(), info2.getSeverity(), info2.getGutterIconRenderer(), actionRanges, psiFile, ((TextEditor)fileEditor).getEditor(), info2.getToolTip());
            fileEditorManager.addTopComponent(fileEditor, (JComponent)((Object)component2));
            ArrayList<HighlightInfo> fileLevelInfos = (ArrayList<HighlightInfo>)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (fileLevelInfos == null) {
                fileLevelInfos = new ArrayList<HighlightInfo>();
                fileEditor.putUserData(FILE_LEVEL_HIGHLIGHTS, fileLevelInfos);
            }
            info2.addFileLeverComponent(fileEditor, (JComponent)((Object)component2));
            info2.setGroup(group2);
            fileLevelInfos.add(info2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<HighlightInfo> runMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull ProgressIndicator progress) {
        ArrayList<HighlightInfo> result2;
        block11: {
            if (psiFile == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(13);
            }
            if (document == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(14);
            }
            if (progress == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(15);
            }
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                throw new IllegalStateException("Must run highlighting outside read action, external annotators do not support checkCanceled");
            }
            this.assertMyFile(psiFile.getProject(), psiFile);
            GlobalInspectionContextBase.assertUnderDaemonProgress();
            this.myFileStatusMap.markAllFilesDirty("prepare to run main passes");
            this.stopProcess(false, "disable background daemon");
            this.myPassExecutorService.cancelAll(true);
            try {
                result2 = new ArrayList<HighlightInfo>();
                VirtualFile virtualFile2 = psiFile.getVirtualFile();
                if (virtualFile2 == null || virtualFile2.getFileType().isBinary()) break block11;
                List passes = DumbService.getInstance(this.myProject).runReadActionInSmartMode(() -> {
                    List<TextEditorHighlightingPass> mainPasses = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject).instantiateMainPasses(psiFile, document, HighlightInfoProcessor.getEmpty());
                    mainPasses.sort((o1, o2) -> {
                        if (o1 instanceof GeneralHighlightingPass) {
                            return -1;
                        }
                        if (o2 instanceof GeneralHighlightingPass) {
                            return 1;
                        }
                        return 0;
                    });
                    try {
                        for (TextEditorHighlightingPass pass2 : mainPasses) {
                            pass2.doCollectInformation(progress);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        LOG.debug("Canceled: " + progress);
                        throw e;
                    }
                    return mainPasses;
                });
                try {
                    for (TextEditorHighlightingPass pass2 : passes) {
                        result2.addAll(pass2.getInfos());
                    }
                }
                catch (ProcessCanceledException e) {
                    LOG.debug("Canceled: " + progress);
                    throw e;
                }
            }
            finally {
                this.stopProcess(true, "re-enable background daemon after main passes run");
            }
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @TestOnly
    public void mustWaitForSmartMode(boolean mustWait, @NotNull Disposable parent2) {
        if (parent2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(17);
        }
        boolean old = this.mustWaitForSmartMode;
        this.mustWaitForSmartMode = mustWait;
        Disposer.register(parent2, () -> {
            this.mustWaitForSmartMode = old;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void runPasses(@NotNull PsiFile file2, @NotNull Document document, @NotNull TextEditor textEditor, int @NotNull [] passesToIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) throws ProcessCanceledException {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(18);
        }
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(19);
        }
        if (textEditor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(20);
        }
        if (passesToIgnore == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!this.myDisposed);
        this.assertMyFile(file2.getProject(), file2);
        assert (textEditor.getEditor().getDocument() == document) : "Expected document " + document + " but one of the passed TextEditors points to a different document: " + textEditor.getEditor().getDocument();
        Document associatedDocument = PsiDocumentManager.getInstance(this.myProject).getDocument(file2);
        assert (associatedDocument == document) : "Expected document " + document + " but the passed PsiFile points to a different document: " + associatedDocument;
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not start highlighting from within write action, or deadlock is imminent");
        }
        DaemonProgressIndicator.setDebug(!ApplicationManagerEx.isInStressTest());
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        do {
            EDT.dispatchAllInvocationEvents();
        } while (RefreshQueueImpl.isRefreshInProgress() || DaemonCodeAnalyzerImpl.heavyProcessIsRunning());
        long dStart = System.currentTimeMillis();
        while (this.mustWaitForSmartMode && DumbService.getInstance(this.myProject).isDumb()) {
            if (System.currentTimeMillis() > dStart + 100000L) {
                throw new IllegalStateException("Timeout waiting for smart mode. If you absolutely want to be dumb, please use DaemonCodeAnalyzerImpl.mustWaitForSmartMode(false).");
            }
            EDT.dispatchAllInvocationEvents();
        }
        ((GistManagerImpl)GistManager.getInstance()).clearQueueInTests();
        EDT.dispatchAllInvocationEvents();
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        this.myUpdateRunnableFuture.cancel(false);
        this.myPassExecutorService.cancelAll(false);
        FileStatusMap fileStatusMap = this.getFileStatusMap();
        boolean old = fileStatusMap.allowDirt(canChangeDocument);
        for (int ignoreId : passesToIgnore) {
            fileStatusMap.markFileUpToDate(document, ignoreId);
        }
        try {
            this.doRunPasses(textEditor, passesToIgnore, canChangeDocument, callbackWhileWaiting);
        }
        finally {
            DaemonProgressIndicator.setDebug(false);
            fileStatusMap.allowDirt(old);
        }
    }

    @TestOnly
    private void doRunPasses(@NotNull TextEditor textEditor, int @NotNull [] passesToIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) {
        if (textEditor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(22);
        }
        if (passesToIgnore == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(23);
        }
        ((CoreProgressManager)ProgressManager.getInstance()).suppressAllDeprioritizationsDuringLongTestsExecutionIn(() -> {
            VirtualFile virtualFile2 = textEditor.getFile();
            PsiFile psiFile = PsiManagerEx.getInstanceEx(this.myProject).findFile(virtualFile2);
            psiFile = psiFile instanceof PsiCompiledFile ? ((PsiCompiledFile)psiFile).getDecompiledPsiFile() : psiFile;
            LOG.assertTrue(psiFile != null, "PsiFile not found for " + virtualFile2);
            HighlightingSession session = this.queuePassesCreation((FileEditor)textEditor, virtualFile2, psiFile, passesToIgnore);
            if (session == null) {
                LOG.error("Can't create session for " + textEditor + " (" + textEditor.getClass() + "), fileEditor.getBackgroundHighlighter()=" + textEditor.getBackgroundHighlighter() + "; virtualFile=" + virtualFile2 + "; psiFile=" + psiFile);
                throw new ProcessCanceledException();
            }
            ProgressIndicator progress = session.getProgressIndicator();
            progress.checkCanceled();
            try {
                long start = System.currentTimeMillis();
                this.waitInOtherThread(600000, canChangeDocument, () -> {
                    progress.checkCanceled();
                    if (callbackWhileWaiting != null) {
                        callbackWhileWaiting.run();
                    }
                    EDT.dispatchAllInvocationEvents();
                    Throwable savedException = PassExecutorService.getSavedException((DaemonProgressIndicator)progress);
                    if (savedException != null) {
                        throw savedException;
                    }
                    return progress.isRunning();
                });
                if (progress.isRunning() && !progress.isCanceled()) {
                    throw new RuntimeException("Highlighting still running after " + (System.currentTimeMillis() - start) / 1000L + " seconds. Still submitted passes: " + this.myPassExecutorService.getAllSubmittedPasses() + " ForkJoinPool.commonPool(): " + ForkJoinPool.commonPool() + "\n, ForkJoinPool.commonPool() active thread count: " + ForkJoinPool.commonPool().getActiveThreadCount() + ", ForkJoinPool.commonPool() has queued submissions: " + ForkJoinPool.commonPool().hasQueuedSubmissions() + "\n" + ThreadDumper.dumpThreadsToString());
                }
                ((HighlightingSessionImpl)session).waitForHighlightInfosApplied();
                EDT.dispatchAllInvocationEvents();
                EDT.dispatchAllInvocationEvents();
                assert (progress.isCanceled());
            }
            catch (Throwable e) {
                Throwable unwrapped = ExceptionUtilRt.unwrapException(e, ExecutionException.class);
                if (progress.isCanceled() && progress.isRunning()) {
                    unwrapped.addSuppressed(new RuntimeException("Daemon progress was canceled unexpectedly: " + progress));
                }
                ExceptionUtil.rethrow(unwrapped);
            }
            finally {
                progress.cancel();
                this.waitForTermination();
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    private void waitInOtherThread(int millis, boolean canChangeDocument, @NotNull ThrowableComputable<Boolean, Throwable> runWhile) throws Throwable {
        if (runWhile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposable disposable = Disposer.newDisposable();
        final AtomicBoolean assertOnModification = new AtomicBoolean();
        this.myProject.getMessageBus().connect(disposable).subscribe(PsiModificationTracker.TOPIC, () -> {
            if (assertOnModification.get()) {
                throw new IllegalStateException("You must not perform PSI modifications from inside highlighting");
            }
        });
        if (!canChangeDocument) {
            this.myProject.getMessageBus().connect(disposable).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, new DaemonCodeAnalyzer.DaemonListener(){

                @Override
                public void daemonCancelEventOccurred(@NotNull String reason) {
                    if (reason == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (assertOnModification.get()) {
                        throw new IllegalStateException("You must not cancel daemon inside highlighting test: " + reason);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$1", "daemonCancelEventOccurred"));
                }
            });
        }
        long deadline = System.currentTimeMillis() + (long)millis;
        try {
            Future<Boolean> future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    return this.myPassExecutorService.waitFor(millis);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
            do {
                assertOnModification.set(true);
                try {
                    future.get(50L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                }
                finally {
                    assertOnModification.set(false);
                }
            } while (runWhile.compute().booleanValue() && System.currentTimeMillis() < deadline);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            Disposer.dispose(disposable);
        }
    }

    @TestOnly
    public void prepareForTest() {
        this.setUpdateByTimerEnabled(false);
        this.waitForTermination();
        this.clearReferences();
    }

    @TestOnly
    public void cleanupAfterTest() {
        if (this.myProject.isOpen()) {
            this.prepareForTest();
        }
    }

    @TestOnly
    public void waitForTermination() {
        this.myPassExecutorService.cancelAll(true);
    }

    @Override
    public void settingsChanged() {
        if (this.mySettings.isCodeHighlightingChanged(this.myLastSettings)) {
            this.restart();
        }
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)this.mySettings).clone();
    }

    @Override
    public synchronized void setUpdateByTimerEnabled(boolean value) {
        this.myUpdateByTimerEnabled = value;
        this.stopProcess(value, "Update by timer change");
    }

    @Override
    public void disableUpdateByTimer(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(25);
        }
        this.setUpdateByTimerEnabled(false);
        this.myDisableCount.incrementAndGet();
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.register(parentDisposable, () -> {
            if (this.myDisableCount.decrementAndGet() == 0) {
                this.setUpdateByTimerEnabled(true);
            }
        });
    }

    synchronized boolean isUpdateByTimerEnabled() {
        return this.myUpdateByTimerEnabled;
    }

    @Override
    public void setImportHintsEnabled(@NotNull PsiFile file2, boolean value) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(26);
        }
        this.assertMyFile(file2.getProject(), file2);
        VirtualFile vFile = file2.getVirtualFile();
        if (value) {
            this.myDisabledHintsFiles.remove(vFile);
            this.stopProcess(true, "Import hints change");
        } else {
            this.myDisabledHintsFiles.add(vFile);
            HintManager.getInstance().hideAllHints();
        }
    }

    @Override
    public void resetImportHintsEnabledForProject() {
        this.myDisabledHintsFiles.clear();
    }

    @Override
    public void setHighlightingEnabled(@NotNull PsiFile psiFile, boolean value) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(27);
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(psiFile);
        if (value) {
            this.myDisabledHighlightingFiles.remove(virtualFile2);
        } else {
            this.myDisabledHighlightingFiles.add(virtualFile2);
        }
    }

    @Override
    public boolean isHighlightingAvailable(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(28);
        }
        if (!psiFile.isPhysical()) {
            return false;
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        if (this.myDisabledHighlightingFiles.contains(PsiUtilCore.getVirtualFile(psiFile))) {
            return false;
        }
        if (psiFile instanceof PsiCompiledElement) {
            return false;
        }
        FileType fileType = psiFile.getFileType();
        return !fileType.isBinary();
    }

    @Override
    public boolean isImportHintsEnabled(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(29);
        }
        return this.isAutohintsAvailable(psiFile) && !this.myDisabledHintsFiles.contains(psiFile.getVirtualFile());
    }

    @Override
    public boolean isAutohintsAvailable(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(30);
        }
        return this.isHighlightingAvailable(psiFile) && !(psiFile instanceof PsiCompiledElement);
    }

    @Override
    public void restart() {
        this.stopProcessAndRestartAllFiles("Global restart");
    }

    void stopProcessAndRestartAllFiles(@NotNull String reason) {
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(31);
        }
        this.myFileStatusMap.markAllFilesDirty(reason);
        this.stopProcess(true, reason);
    }

    @Override
    public void restart(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(32);
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        Document document = psiFile.getViewProvider().getDocument();
        if (document == null) {
            return;
        }
        String reason = "Psi file restart: " + psiFile.getName();
        this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, document.getTextLength()), psiFile.getTextLength(), reason);
        this.stopProcess(true, reason);
    }

    @NotNull
    public List<ProgressableTextEditorHighlightingPass> getPassesToShowProgressFor(@NotNull Document document) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(33);
        }
        List<HighlightingPass> allPasses = this.myPassExecutorService.getAllSubmittedPasses();
        List<ProgressableTextEditorHighlightingPass> list2 = allPasses.stream().map(p -> p instanceof ProgressableTextEditorHighlightingPass ? (ProgressableTextEditorHighlightingPass)p : null).filter(p -> p != null && p.getDocument() == document).sorted(Comparator.comparingInt(p -> p.getId())).collect(Collectors.toList());
        if (list2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(34);
        }
        return list2;
    }

    boolean isAllAnalysisFinished(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(35);
        }
        if (this.myDisposed) {
            return false;
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        Document document = psiFile.getViewProvider().getDocument();
        return document != null && document.getModificationStamp() == psiFile.getViewProvider().getModificationStamp() && this.myFileStatusMap.allDirtyScopesAreNull(document);
    }

    @Override
    public boolean isErrorAnalyzingFinished(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(36);
        }
        if (this.myDisposed) {
            return false;
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        Document document = psiFile.getViewProvider().getDocument();
        return document != null && document.getModificationStamp() == psiFile.getViewProvider().getModificationStamp() && this.myFileStatusMap.getFileDirtyScope(document, psiFile, 4) == null;
    }

    @Override
    @NotNull
    public FileStatusMap getFileStatusMap() {
        FileStatusMap fileStatusMap = this.myFileStatusMap;
        if (fileStatusMap == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(37);
        }
        return fileStatusMap;
    }

    public synchronized boolean isRunning() {
        for (DaemonProgressIndicator indicator : this.myUpdateProgress.values()) {
            if (indicator.isCanceled()) continue;
            return true;
        }
        return false;
    }

    @TestOnly
    public boolean isRunningOrPending() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.isRunning() || !this.myUpdateRunnableFuture.isDone() || GeneralHighlightingPass.isRestartPending();
    }

    synchronized void stopProcess(boolean toRestartAlarm, @NotNull @NonNls String reason) {
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(38);
        }
        this.cancelAllUpdateProgresses(toRestartAlarm, reason);
        boolean restart = toRestartAlarm && !this.myDisposed;
        long autoReparseDelayNanos = TimeUnit.MILLISECONDS.toNanos(this.mySettings.getAutoReparseDelay());
        if (restart) {
            this.myScheduledUpdateTimestamp = System.nanoTime() + autoReparseDelayNanos;
        }
        boolean isDone = this.myUpdateRunnableFuture.isDone();
        if (restart && isDone) {
            this.scheduleUpdateRunnable(autoReparseDelayNanos);
        }
    }

    private synchronized void scheduleUpdateRunnable(long delayNanos) {
        Future<?> oldFuture = this.myUpdateRunnableFuture;
        if (oldFuture.isDone()) {
            ConcurrencyUtil.manifestExceptionsIn(oldFuture);
        }
        this.myUpdateRunnableFuture = EdtExecutorService.getScheduledExecutorInstance().schedule(this.myUpdateRunnable, delayNanos, TimeUnit.NANOSECONDS);
    }

    synchronized void cancelAllUpdateProgresses(boolean toRestartAlarm, @NotNull @NonNls String reason) {
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(39);
        }
        if (this.myDisposed || this.myProject.isDisposed() || this.myProject.getMessageBus().isDisposed()) {
            return;
        }
        boolean canceled = false;
        for (DaemonProgressIndicator updateProgress : this.myUpdateProgress.values()) {
            if (updateProgress.isCanceled()) continue;
            PassExecutorService.log(updateProgress, null, "Cancel", reason, toRestartAlarm);
            updateProgress.cancel();
            this.myPassExecutorService.cancelAll(false);
            canceled = true;
        }
        if (canceled) {
            ApplicationManager.getApplication().invokeLater(() -> this.myDaemonListenerPublisher.daemonCancelEventOccurred(reason), __ -> this.myDisposed || this.myProject.isDisposed() || this.myProject.getMessageBus().isDisposed());
        }
        this.daemonCancelEventCount.incrementAndGet();
    }

    static boolean processHighlightsNearOffset(@NotNull Document document, @NotNull Project project2, @NotNull HighlightSeverity minSeverity, int offset2, boolean includeFixRange, @NotNull Processor<? super HighlightInfo> processor) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(40);
        }
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(41);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(43);
        }
        return DaemonCodeAnalyzerImpl.processHighlights(document, project2, null, 0, document.getTextLength(), (? super HighlightInfo info2) -> {
            if (!info2.containsOffset(offset2, includeFixRange)) {
                return true;
            }
            int compare = info2.getSeverity().compareTo(minSeverity);
            return compare < 0 || processor.process((HighlightInfo)info2);
        });
    }

    @Nullable
    public HighlightInfo findHighlightByOffset(@NotNull Document document, int offset2, boolean includeFixRange) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(44);
        }
        return this.findHighlightByOffset(document, offset2, includeFixRange, HighlightSeverity.INFORMATION);
    }

    @Nullable
    HighlightInfo findHighlightByOffset(@NotNull Document document, int offset2, boolean includeFixRange, @NotNull HighlightSeverity minSeverity) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(45);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(46);
        }
        return this.findHighlightsByOffset(document, offset2, includeFixRange, true, minSeverity);
    }

    @Nullable
    public HighlightInfo findHighlightsByOffset(@NotNull Document document, int offset2, boolean includeFixRange, boolean highestPriorityOnly, @NotNull HighlightSeverity minSeverity) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(47);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(48);
        }
        HighlightByOffsetProcessor processor = new HighlightByOffsetProcessor(highestPriorityOnly);
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(document, this.myProject, minSeverity, offset2, includeFixRange, processor);
        return processor.getResult();
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static void waitForUnresolvedReferencesQuickFixesUnderCaret(@NotNull PsiFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(49);
        }
        if (editor2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(50);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessNotAllowed();
        ArrayList relevantInfos = new ArrayList();
        Project project2 = file2.getProject();
        ReadAction.run(() -> {
            PsiUtilBase.assertEditorAndProjectConsistent(project2, editor2);
            CaretModel caretModel = editor2.getCaretModel();
            int offset2 = caretModel.getOffset();
            Document document = editor2.getDocument();
            int logicalLine = caretModel.getLogicalPosition().line;
            DaemonCodeAnalyzerImpl.processHighlights(document, project2, null, 0, document.getTextLength(), (? super HighlightInfo info2) -> {
                boolean atTheSameLine;
                if (info2.containsOffset(offset2, true) && info2.isUnresolvedReference()) {
                    relevantInfos.add(info2);
                    return true;
                }
                boolean bl = atTheSameLine = editor2.offsetToLogicalPosition((int)info2.getActualStartOffset()).line <= logicalLine && logicalLine <= editor2.offsetToLogicalPosition((int)info2.getActualEndOffset()).line;
                if (atTheSameLine && info2.isUnresolvedReference()) {
                    relevantInfos.add(info2);
                }
                return true;
            });
        });
        UnresolvedReferenceQuickFixUpdater.getInstance(project2).waitQuickFixesSynchronously(file2, editor2, relevantInfos);
    }

    @NotNull
    public static List<LineMarkerInfo<?>> getLineMarkers(@NotNull Document document, @NotNull Project project2) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(51);
        }
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(52);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList result2 = new ArrayList();
        LineMarkersUtil.processLineMarkers(project2, document, new TextRange(0, document.getTextLength()), -1, new CommonProcessors.CollectProcessor(result2));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    @Nullable
    IntentionHintComponent getLastIntentionHint() {
        return ((IntentionsUIImpl)IntentionsUI.getInstance(this.myProject)).getLastIntentionHint();
    }

    @Override
    public boolean hasVisibleLightBulbOrPopup() {
        IntentionHintComponent hint = this.getLastIntentionHint();
        return hint != null && hint.hasVisibleLightBulbOrPopup();
    }

    @Override
    @NotNull
    public Element getState() {
        Element state = new Element("state");
        if (this.myDisabledHintsFiles.isEmpty()) {
            Element element = state;
            if (element == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(54);
            }
            return element;
        }
        ArrayList<String> array = new ArrayList<String>(this.myDisabledHintsFiles.size());
        for (VirtualFile file2 : this.myDisabledHintsFiles) {
            if (!file2.isValid()) continue;
            array.add(file2.getUrl());
        }
        if (!array.isEmpty()) {
            Collections.sort(array);
            Element disableHintsElement = new Element(DISABLE_HINTS_TAG);
            state.addContent(disableHintsElement);
            for (String url : array) {
                disableHintsElement.addContent(new Element(FILE_TAG).setAttribute(URL_ATT, url));
            }
        }
        Element element = state;
        if (element == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(55);
        }
        return element;
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(56);
        }
        this.myDisabledHintsFiles.clear();
        Element element = state.getChild(DISABLE_HINTS_TAG);
        if (element != null) {
            for (Element e : element.getChildren(FILE_TAG)) {
                VirtualFile file2;
                String url = e.getAttributeValue(URL_ATT);
                if (url == null || (file2 = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
                this.myDisabledHintsFiles.add(file2);
            }
        }
    }

    private HighlightingSession queuePassesCreation(@NotNull FileEditor fileEditor, @NotNull VirtualFile virtualFile2, @NotNull PsiFile psiFile, int @NotNull [] passesToIgnore) {
        HighlightingSessionImpl session;
        Document document;
        Editor editor2;
        BackgroundEditorHighlighter highlighter;
        if (fileEditor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(57);
        }
        if (virtualFile2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(58);
        }
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(59);
        }
        if (passesToIgnore == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(60);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int modificationCountBefore = this.daemonCancelEventCount.get();
        try (AccessToken ignored = ClientId.withClientId(ClientFileEditorManager.getClientId((FileEditor)fileEditor));){
            highlighter = fileEditor.getBackgroundHighlighter();
        }
        if (highlighter == null) {
            return null;
        }
        DaemonProgressIndicator progress = this.createUpdateProgress(fileEditor);
        Editor editor3 = editor2 = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        if (editor2 != null && editor2.getDocument().isInBulkUpdate()) {
            this.stopProcess(false, editor2.getDocument() + " is in bulk state");
            throw new ProcessCanceledException();
        }
        Document document2 = document = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor().getDocument() : FileDocumentManager.getInstance().getCachedDocument(virtualFile2);
        if (document == null) {
            return null;
        }
        EditorColorsScheme scheme = editor2 == null ? null : editor2.getColorsScheme();
        try (AccessToken ignored = ClientId.withClientId(ClientFileEditorManager.getClientId((FileEditor)fileEditor));){
            session = HighlightingSessionImpl.createHighlightingSession(psiFile, editor2, scheme, progress);
        }
        JobLauncher.getInstance().submitToJobThread(() -> this.submitInBackground(fileEditor, document, virtualFile2, psiFile, highlighter, passesToIgnore, modificationCountBefore, progress, session), task2 -> ApplicationManager.getApplication().invokeLater(() -> ConcurrencyUtil.manifestExceptionsIn(task2)));
        return session;
    }

    private static PsiFile findFileToHighlight(@NotNull Project project2, @Nullable VirtualFile virtualFile2) {
        if (project2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(61);
        }
        PsiFile psiFile = virtualFile2 == null || !virtualFile2.isValid() ? null : PsiManagerEx.getInstanceEx(project2).getFileManager().getCachedPsiFile(virtualFile2);
        psiFile = psiFile instanceof PsiCompiledFile ? ((PsiCompiledFile)psiFile).getDecompiledPsiFile() : psiFile;
        return psiFile;
    }

    private void submitInBackground(@NotNull FileEditor fileEditor, @NotNull Document document, @NotNull VirtualFile virtualFile2, @NotNull PsiFile psiFile, @NotNull BackgroundEditorHighlighter backgroundEditorHighlighter, int @NotNull [] passesToIgnore, int modificationCountBefore, @NotNull DaemonProgressIndicator progress, @NotNull HighlightingSessionImpl session) {
        if (fileEditor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(62);
        }
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(63);
        }
        if (virtualFile2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(64);
        }
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(65);
        }
        if (backgroundEditorHighlighter == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(66);
        }
        if (progress == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(67);
        }
        if (session == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(68);
        }
        if (passesToIgnore == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(69);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (this.myProject.isDisposed()) {
            this.stopProcess(false, "project disposed");
            return;
        }
        if (progress.isCanceled()) {
            this.stopProcess(true, "canceled in queuePassesCreation: " + progress.getCancellationTrace());
            return;
        }
        if (this.myPsiDocumentManager.hasEventSystemEnabledUncommittedDocuments()) {
            this.stopProcess(true, "more documents to commit: " + ReadAction.compute(() -> Arrays.toString(this.myPsiDocumentManager.getUncommittedDocuments())));
            return;
        }
        try {
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                boolean hasPasses;
                boolean heavyProcessIsRunning = DaemonCodeAnalyzerImpl.heavyProcessIsRunning();
                HighlightingPass[] passes = ReadAction.compute(() -> {
                    if (this.myProject.isDisposed() || !fileEditor.isValid() || !psiFile.isValid()) {
                        return HighlightingPass.EMPTY_ARRAY;
                    }
                    if (this.daemonCancelEventCount.get() != modificationCountBefore) {
                        throw new ProcessCanceledException();
                    }
                    session.additionalSetupFromBackground(psiFile);
                    try (AccessToken ignored = ClientId.withClientId(ClientFileEditorManager.getClientId((FileEditor)fileEditor));){
                        HighlightingPass[] r;
                        HighlightingPass[] highlightingPassArray = r = backgroundEditorHighlighter instanceof TextEditorBackgroundHighlighter ? ((TextEditorBackgroundHighlighter)backgroundEditorHighlighter).getPasses(passesToIgnore).toArray(HighlightingPass.EMPTY_ARRAY) : backgroundEditorHighlighter.createPassesForEditor();
                        if (heavyProcessIsRunning) {
                            r = ContainerUtil.findAllAsArray(r, DumbService::isDumbAware);
                        }
                        HighlightingPass[] highlightingPassArray2 = r;
                        return highlightingPassArray2;
                    }
                });
                boolean bl = hasPasses = passes.length != 0;
                if (!hasPasses) {
                    return;
                }
                TextEditorHighlightingPassRegistrar textEditorHighlightingPassRegistrar = TextEditorHighlightingPassRegistrar.getInstance(this.myProject);
                synchronized (textEditorHighlightingPassRegistrar) {
                    this.myPassExecutorService.submitPasses(document, virtualFile2, psiFile, fileEditor, passes, progress);
                }
            }, progress);
        }
        catch (ProcessCanceledException e) {
            this.stopProcess(true, "PCE in queuePassesCreation");
        }
        catch (Throwable e) {
            PassExecutorService.saveException(e, progress);
            throw e;
        }
    }

    private static boolean heavyProcessIsRunning() {
        if (DumbServiceImpl.ALWAYS_SMART) {
            return false;
        }
        return HeavyProcessLatch.INSTANCE.isRunningAnythingBut(HeavyProcessLatch.Type.Syncing);
    }

    @NotNull
    private synchronized DaemonProgressIndicator createUpdateProgress(@NotNull FileEditor fileEditor) {
        DaemonProgressIndicator old;
        if (fileEditor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(70);
        }
        if ((old = this.myUpdateProgress.get(fileEditor)) != null && !old.isCanceled()) {
            old.cancel();
        }
        this.myUpdateProgress.entrySet().removeIf(entry -> !((FileEditor)entry.getKey()).isValid());
        MyDaemonProgressIndicator progress = new MyDaemonProgressIndicator(this.myProject, fileEditor);
        progress.setModalityProgress(null);
        progress.start();
        this.myDaemonListenerPublisher.daemonStarting(List.of(fileEditor));
        if (this.isRestartToCompleteEssentialHighlightingRequested()) {
            progress.putUserData(COMPLETE_ESSENTIAL_HIGHLIGHTING_KEY, true);
        }
        this.myUpdateProgress.put(fileEditor, progress);
        MyDaemonProgressIndicator myDaemonProgressIndicator = progress;
        if (myDaemonProgressIndicator == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(71);
        }
        return myDaemonProgressIndicator;
    }

    @Override
    public void autoImportReferenceAtCursor(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        ReferenceImporter importer;
        if (editor2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(72);
        }
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(73);
        }
        this.assertMyFile(psiFile.getProject(), psiFile);
        Iterator<ReferenceImporter> iterator2 = ReferenceImporter.EP_NAME.getExtensionList().iterator();
        while (!(!iterator2.hasNext() || (importer = iterator2.next()).isAddUnambiguousImportsOnTheFlyEnabled(psiFile) && importer.autoImportReferenceAtCursor(editor2, psiFile))) {
        }
    }

    @TestOnly
    @NotNull
    synchronized Map<FileEditor, DaemonProgressIndicator> getUpdateProgress() {
        Map<FileEditor, DaemonProgressIndicator> map2 = this.myUpdateProgress;
        if (map2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(74);
        }
        return map2;
    }

    @NotNull
    private Collection<FileEditor> getSelectedEditors() {
        Collection<Object> activeTextEditors;
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        List<? extends Editor> editors2 = EditorTracker.getInstance(this.myProject).getActiveEditors();
        if (editors2.isEmpty()) {
            activeTextEditors = Collections.emptyList();
        } else {
            TextEditorProvider textEditorProvider = TextEditorProvider.getInstance();
            activeTextEditors = new HashSet(editors2.size());
            for (Editor editor2 : editors2) {
                if (editor2.isDisposed()) continue;
                TextEditor textEditor = textEditorProvider.getTextEditor(editor2);
                activeTextEditors.add(textEditor);
            }
        }
        if (application.getCurrentModalityState() != ModalityState.NON_MODAL) {
            List<FileEditor> list2 = activeTextEditors;
            if (list2 == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(75);
            }
            return list2;
        }
        HashSet<FileEditor> result2 = new HashSet<FileEditor>(activeTextEditors.size());
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>(activeTextEditors.size());
        if (!application.isUnitTestMode()) {
            for (FileEditor tabEditor : this.getFileEditorManager().getSelectedEditorWithRemotes()) {
                if (!tabEditor.isValid()) continue;
                VirtualFile file2 = tabEditor.getFile();
                if (file2 != null) {
                    files2.add(file2);
                }
                result2.add(tabEditor);
            }
        }
        if (!activeTextEditors.isEmpty()) {
            for (FileEditor fileEditor : activeTextEditors) {
                VirtualFile file3 = fileEditor.getFile();
                if (file3 != null && (files2.contains(file3) || !file3.isValid())) continue;
                result2.add(fileEditor);
            }
        }
        HashSet<FileEditor> hashSet = result2;
        if (hashSet == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(76);
        }
        return hashSet;
    }

    @ApiStatus.Internal
    public void serializeCodeInsightPasses(boolean flag2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.setUpdateByTimerEnabled(false);
        try {
            this.cancelAllUpdateProgresses(false, "serializeCodeInsightPasses");
            TextEditorHighlightingPassRegistrarImpl registrar = (TextEditorHighlightingPassRegistrarImpl)TextEditorHighlightingPassRegistrar.getInstance(this.myProject);
            registrar.serializeCodeInsightPasses(flag2);
        }
        finally {
            this.setUpdateByTimerEnabled(true);
        }
    }

    void restartToCompleteEssentialHighlighting() {
        this.restart();
        this.completeEssentialHighlightingRequested = true;
    }

    public boolean isRestartToCompleteEssentialHighlightingRequested() {
        return this.completeEssentialHighlightingRequested;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 16, 34, 37, 53, 54, 55, 71, 74, 75, 76 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: 
            case 19: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: 
            case 51: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 6: 
            case 16: 
            case 34: 
            case 37: 
            case 53: 
            case 54: 
            case 55: 
            case 71: 
            case 74: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl";
                break;
            }
            case 5: 
            case 8: 
            case 18: 
            case 26: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_TAG;
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: 
            case 59: 
            case 65: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: 
            case 57: 
            case 62: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditor";
                break;
            }
            case 21: 
            case 23: 
            case 60: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passesToIgnore";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWhile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 31: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 42: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSeverity";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 50: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 58: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundEditorHighlighter";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlights";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileLevelHighlights";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "runMainPasses";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassesToShowProgressFor";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatusMap";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMarkers";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateProgress";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateProgress";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHighlights";
                break;
            }
            case 3: 
            case 6: 
            case 16: 
            case 34: 
            case 37: 
            case 53: 
            case 54: 
            case 55: 
            case 71: 
            case 74: 
            case 75: 
            case 76: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileLevelHighlights";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assertMyFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cleanFileLevelHighlights";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFileLevelHighlight";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runMainPasses";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mustWaitForSmartMode";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runPasses";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doRunPasses";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "waitInOtherThread";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "disableUpdateByTimer";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setImportHintsEnabled";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightingEnabled";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isHighlightingAvailable";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isImportHintsEnabled";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isAutohintsAvailable";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "stopProcessAndRestartAllFiles";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "restart";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPassesToShowProgressFor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isAllAnalysisFinished";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isErrorAnalyzingFinished";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "stopProcess";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "cancelAllUpdateProgresses";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processHighlightsNearOffset";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findHighlightByOffset";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findHighlightsByOffset";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "waitForUnresolvedReferencesQuickFixesUnderCaret";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkers";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "queuePassesCreation";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "findFileToHighlight";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "submitInBackground";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateProgress";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "autoImportReferenceAtCursor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 6, 16, 34, 37, 53, 54, 55, 71, 74, 75, 76 -> new IllegalStateException(string2);
        };
    }

    private static final class UpdateRunnable
    implements Runnable {
        private Project myProject;

        private UpdateRunnable(@NotNull Project project2) {
            if (project2 == null) {
                UpdateRunnable.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DaemonCodeAnalyzerImpl dca;
            block18: {
                block17: {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    Project project2 = this.myProject;
                    if (project2 == null || project2.isDefault() || !project2.isInitialized() || project2.isDisposed() || LightEdit.owns((Project)project2)) break block17;
                    dca = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2);
                    if (!dca.myDisposed) break block18;
                }
                return;
            }
            DaemonCodeAnalyzerImpl daemonCodeAnalyzerImpl = dca;
            synchronized (daemonCodeAnalyzerImpl) {
                long actualDelay = dca.myScheduledUpdateTimestamp - System.nanoTime();
                if (actualDelay > 0L) {
                    dca.scheduleUpdateRunnable(actualDelay);
                    return;
                }
            }
            Collection<FileEditor> activeEditors = dca.getSelectedEditors();
            boolean updateByTimerEnabled = dca.isUpdateByTimerEnabled();
            if (PassExecutorService.LOG.isDebugEnabled()) {
                PassExecutorService.log(null, null, "Update Runnable. myUpdateByTimerEnabled:", updateByTimerEnabled, " something disposed:", PowerSaveMode.isEnabled() || !this.myProject.isInitialized(), " activeEditors:", activeEditors);
            }
            if (!updateByTimerEnabled) {
                return;
            }
            if (activeEditors.isEmpty()) {
                return;
            }
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                return;
            }
            if (dca.myPsiDocumentManager.hasEventSystemEnabledUncommittedDocuments()) {
                dca.myPsiDocumentManager.performLaterWhenAllCommitted(this);
                return;
            }
            try {
                boolean submitted = false;
                for (FileEditor fileEditor : activeEditors) {
                    VirtualFile virtualFile2 = UpdateRunnable.getVirtualFile(fileEditor);
                    PsiFile psiFile = virtualFile2 == null ? null : DaemonCodeAnalyzerImpl.findFileToHighlight(dca.myProject, virtualFile2);
                    if (psiFile == null) continue;
                    submitted |= dca.queuePassesCreation(fileEditor, virtualFile2, psiFile, ArrayUtil.EMPTY_INT_ARRAY) != null;
                }
                if (!submitted) {
                    dca.stopProcess(true, "Couldn't create session for " + activeEditors);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }

        private static VirtualFile getVirtualFile(@NotNull FileEditor fileEditor) {
            if (fileEditor == null) {
                UpdateRunnable.$$$reportNull$$$0(1);
            }
            VirtualFile virtualFile2 = fileEditor.getFile();
            for (BackedVirtualFileProvider provider2 : BackedVirtualFileProvider.EP_NAME.getExtensionList()) {
                VirtualFile replacedVirtualFile = provider2.getReplacedVirtualFile(virtualFile2);
                if (replacedVirtualFile == null) continue;
                virtualFile2 = replacedVirtualFile;
                break;
            }
            return virtualFile2;
        }

        private void clearFieldsOnDispose() {
            this.myProject = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$UpdateRunnable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVirtualFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class HighlightByOffsetProcessor
    implements Processor<HighlightInfo> {
        private final List<HighlightInfo> foundInfoList = new SmartList<HighlightInfo>();
        private final boolean highestPriorityOnly;

        HighlightByOffsetProcessor(boolean highestPriorityOnly) {
            this.highestPriorityOnly = highestPriorityOnly;
        }

        @Override
        public boolean process(@NotNull HighlightInfo info2) {
            if (info2 == null) {
                HighlightByOffsetProcessor.$$$reportNull$$$0(0);
            }
            if (info2.getSeverity() == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY || info2.type == HighlightInfoType.TODO) {
                return true;
            }
            if (!this.foundInfoList.isEmpty() && this.highestPriorityOnly) {
                HighlightInfo foundInfo = this.foundInfoList.get(0);
                int compare = foundInfo.getSeverity().compareTo(info2.getSeverity());
                if (compare < 0) {
                    this.foundInfoList.clear();
                } else if (compare > 0) {
                    return true;
                }
            }
            this.foundInfoList.add(info2);
            return true;
        }

        @Nullable
        HighlightInfo getResult() {
            if (this.foundInfoList.isEmpty()) {
                return null;
            }
            if (this.foundInfoList.size() == 1) {
                return this.foundInfoList.get(0);
            }
            this.foundInfoList.sort(Comparator.comparing(HighlightInfo::getSeverity).reversed());
            return HighlightInfoComposite.create(this.foundInfoList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$HighlightByOffsetProcessor", "process"));
        }
    }

    private static final class MyDaemonProgressIndicator
    extends DaemonProgressIndicator {
        private final Project myProject;
        private FileEditor myFileEditor;

        MyDaemonProgressIndicator(@NotNull Project project2, @NotNull FileEditor fileEditor) {
            if (project2 == null) {
                MyDaemonProgressIndicator.$$$reportNull$$$0(0);
            }
            if (fileEditor == null) {
                MyDaemonProgressIndicator.$$$reportNull$$$0(1);
            }
            this.myFileEditor = fileEditor;
            this.myProject = project2;
        }

        @Override
        boolean stopIfRunning() {
            boolean wasStopped = super.stopIfRunning();
            if (wasStopped) {
                DaemonCodeAnalyzerImpl daemon = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(this.myProject);
                daemon.myDaemonListenerPublisher.daemonFinished(List.of(this.myFileEditor));
                this.myFileEditor = null;
                HighlightingSessionImpl.clearProgressIndicator(this);
                daemon.completeEssentialHighlightingRequested = false;
            }
            return wasStopped;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileEditor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$MyDaemonProgressIndicator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

