/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonFusCollector;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/daemon/impl/DaemonFusReporter;", "Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzer$DaemonListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "daemonStartTime", "", "daemonFinished", "", "fileEditors", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "daemonStarting", "roundToThreeMostSignificantBits", "", "i", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDaemonFusReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DaemonFusReporter.kt\ncom/intellij/codeInsight/daemon/impl/DaemonFusReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n800#2,11:83\n1#3:94\n*S KotlinDebug\n*F\n+ 1 DaemonFusReporter.kt\ncom/intellij/codeInsight/daemon/impl/DaemonFusReporter\n*L\n25#1:83,11\n*E\n"})
final class DaemonFusReporter
implements DaemonCodeAnalyzer.DaemonListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private long daemonStartTime;
    @NotNull
    private static final Key<Long> lastReportedDaemonFinishedTimestamp = new Key("lastReportedDaemonFinishedTimestamp");

    public DaemonFusReporter(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.daemonStartTime = -1L;
    }

    @Override
    public void daemonStarting(@NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        this.daemonStartTime = System.currentTimeMillis();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        $this$filterIsInstance$iv = fileEditors;
        $i$f$filterIsInstance = false;
        var6_6 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextEditor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        v0 = (TextEditor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        v1 = editor = v0 != null ? v0.getEditor() : null;
        v2 = document = v1 != null ? v1.getDocument() : null;
        if (document != null) {
            v3 = lastReportedTimestamp = document.getUserData(DaemonFusReporter.lastReportedDaemonFinishedTimestamp);
            $i$f$filterIsInstance = document.getModificationStamp();
            if (v3 != null && v3 == $i$f$filterIsInstance) {
                return;
            }
            document.putUserData(DaemonFusReporter.lastReportedDaemonFinishedTimestamp, document.getModificationStamp());
        }
        v4 = editor;
        destination$iv$iv = v4 != null ? v4.getMarkupModel() : null;
        v5 = destination$iv$iv instanceof EditorMarkupModel != false ? (EditorMarkupModel)destination$iv$iv : null;
        $i$f$filterIsInstance = v5 != null ? v5.getErrorStripeRenderer() : null;
        v6 = analyzer = $i$f$filterIsInstance instanceof TrafficLightRenderer != false ? (TrafficLightRenderer)$i$f$filterIsInstance : null;
        errorCounts = (int[])(v6 != null ? v6.getErrorCounts() : null);
        v7 = SeverityRegistrar.getSeverityRegistrar(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getSeverityRegistrar(project)");
        registrar = v7;
        errorIndex = registrar.getSeverityIdx(HighlightSeverity.ERROR);
        warningIndex = registrar.getSeverityIdx(HighlightSeverity.WARNING);
        v8 = errorCounts;
        if (errorCounts == null) ** GOTO lbl-1000
        v9 = ArraysKt.getOrNull((int[])v8, (int)errorIndex);
        v8 = v9;
        if (v9 != null) {
            v10 = v8.intValue();
        } else lbl-1000:
        // 2 sources

        {
            v10 = -1;
        }
        errorCount = v10;
        v11 = errorCounts;
        if (errorCounts == null) ** GOTO lbl-1000
        v12 = ArraysKt.getOrNull((int[])v11, (int)warningIndex);
        v11 = v12;
        if (v12 != null) {
            v13 = v11.intValue();
        } else lbl-1000:
        // 2 sources

        {
            v13 = -1;
        }
        warningCount = v13;
        v14 = document;
        lines = v14 == null ? -1 : this.roundToThreeMostSignificantBits(v14.getLineCount());
        elapsedTime = System.currentTimeMillis() - this.daemonStartTime;
        v15 = document;
        if (v15 != null) {
            it = v15;
            $i$a$-let-DaemonFusReporter$daemonFinished$fileType$1 = false;
            v16 = FileDocumentManager.getInstance().getFile(it);
            v17 = v16 != null ? v16.getFileType() : null;
        } else {
            v17 = null;
        }
        fileType = v17;
        var15_21 = new EventPair[]{EventFields.DurationMs.with((Object)elapsedTime), DaemonFusCollector.Companion.getERRORS().with((Object)errorCount), DaemonFusCollector.Companion.getWARNINGS().with((Object)warningCount), DaemonFusCollector.Companion.getLINES().with((Object)lines), EventFields.FileType.with((Object)fileType)};
        DaemonFusCollector.Companion.getFINISHED().log(this.project, var15_21);
    }

    private final int roundToThreeMostSignificantBits(int i2) {
        int norm = i2 == 0 ? 0 : Math.max(i2, 8);
        return norm & Integer.MIN_VALUE >> Integer.numberOfLeadingZeros(norm) + 2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/daemon/impl/DaemonFusReporter$Companion;", "", "()V", "lastReportedDaemonFinishedTimestamp", "Lcom/intellij/openapi/util/Key;", "", "getLastReportedDaemonFinishedTimestamp", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Long> getLastReportedDaemonFinishedTimestamp() {
            return lastReportedDaemonFinishedTimestamp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

