/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.internal.statistic.service.fus.collectors.TooltipActionsLogger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/daemon/impl/DaemonTooltipAction;", "Lcom/intellij/openapi/editor/ex/TooltipAction;", "myFixText", "", "myActionText", "myActualOffset", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "equals", "", "other", "", "execute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "inputEvent", "Ljava/awt/event/InputEvent;", "getText", "hashCode", "showAllActions", "intellij.platform.lang.impl"})
final class DaemonTooltipAction
implements TooltipAction {
    @NotNull
    private final String myFixText;
    @NotNull
    private final String myActionText;
    private final int myActualOffset;

    public DaemonTooltipAction(@NlsActions.ActionText @NotNull String myFixText, @NlsContexts.Command @NotNull String myActionText, int myActualOffset) {
        Intrinsics.checkNotNullParameter((Object)myFixText, (String)"myFixText");
        Intrinsics.checkNotNullParameter((Object)myActionText, (String)"myActionText");
        this.myFixText = myFixText;
        this.myActionText = myActionText;
        this.myActualOffset = myActualOffset;
    }

    @NotNull
    public String getText() {
        return this.myFixText;
    }

    public void execute(@NotNull Editor editor2, @Nullable InputEvent inputEvent) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        TooltipActionsLogger.Companion.logExecute(project3, inputEvent);
        PsiFile psiFile = PsiDocumentManager.getInstance(project3).getPsiFile(editor2.getDocument());
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        List<HighlightInfo.IntentionActionDescriptor> list2 = ShowIntentionsPass.getAvailableFixes(editor2, psiFile2, -1, this.myActualOffset);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAvailableFixes(editor\u2026File, -1, myActualOffset)");
        List<HighlightInfo.IntentionActionDescriptor> intentions = list2;
        for (HighlightInfo.IntentionActionDescriptor descriptor2 : intentions) {
            IntentionAction action2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptor2.getAction(), (String)"descriptor.action");
            if (!Intrinsics.areEqual((Object)action2.getText(), (Object)this.myActionText)) continue;
            editor2.getCaretModel().moveToOffset(this.myActualOffset);
            ShowIntentionActionsHandler.chooseActionAndInvoke(psiFile2, editor2, action2, this.myActionText);
            return;
        }
    }

    public void showAllActions(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        editor2.getCaretModel().moveToOffset(this.myActualOffset);
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        TooltipActionsLogger.Companion.getShowAllEvent().log(project3);
        PsiFile psiFile = PsiDocumentManager.getInstance(project3).getPsiFile(editor2.getDocument());
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        new ShowIntentionActionsHandler().invoke(project3, editor2, psiFile2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        DaemonTooltipAction info2 = (DaemonTooltipAction)other;
        return this.myActualOffset == info2.myActualOffset && Intrinsics.areEqual((Object)this.myFixText, (Object)info2.myFixText);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.myFixText, this.myActualOffset};
        return Objects.hash(objectArray);
    }
}

