/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"extractMostPriorityFixFromHighlightInfo", "Lcom/intellij/codeInsight/intention/IntentionAction;", "highlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getFirstAvailableAction", "intentionsInfo", "Lcom/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo;", "wrapIntentionToTooltipAction", "Lcom/intellij/openapi/editor/ex/TooltipAction;", "intention", "info", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDaemonTooltipActionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DaemonTooltipActionProvider.kt\ncom/intellij/codeInsight/daemon/impl/DaemonTooltipActionProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1855#2,2:144\n*S KotlinDebug\n*F\n+ 1 DaemonTooltipActionProvider.kt\ncom/intellij/codeInsight/daemon/impl/DaemonTooltipActionProviderKt\n*L\n108#1:144,2\n*E\n"})
public final class DaemonTooltipActionProviderKt {
    @Nullable
    public static final IntentionAction extractMostPriorityFixFromHighlightInfo(@NotNull HighlightInfo highlightInfo, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)highlightInfo, (String)"highlightInfo");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List fixes = new ArrayList();
        highlightInfo.findRegisteredQuickFix((arg_0, arg_1) -> DaemonTooltipActionProviderKt.extractMostPriorityFixFromHighlightInfo$lambda$0((Function2)new Function2<HighlightInfo.IntentionActionDescriptor, TextRange, Object>((List<HighlightInfo.IntentionActionDescriptor>)fixes){
            final /* synthetic */ List<HighlightInfo.IntentionActionDescriptor> $fixes;
            {
                this.$fixes = $fixes;
                super(2);
            }

            @Nullable
            public final Object invoke(@NotNull HighlightInfo.IntentionActionDescriptor desc, @NotNull TextRange textRange) {
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                Intrinsics.checkNotNullParameter((Object)textRange, (String)"<anonymous parameter 1>");
                this.$fixes.add(desc);
                return null;
            }
        }, arg_0, arg_1));
        ShowIntentionsPass.IntentionsInfo intentionsInfo = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.fillIntentionsInfoForHighlightInfo(highlightInfo, intentionsInfo, fixes);
        intentionsInfo.filterActions(psiFile);
        return DaemonTooltipActionProviderKt.getFirstAvailableAction(psiFile, editor2, intentionsInfo);
    }

    @Nullable
    public static final IntentionAction getFirstAvailableAction(@NotNull PsiFile psiFile, @NotNull Editor editor2, @NotNull ShowIntentionsPass.IntentionsInfo intentionsInfo) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)intentionsInfo, (String)"intentionsInfo");
        Project project2 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
        Project project3 = project2;
        CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project3, psiFile, editor2, intentionsInfo);
        Intrinsics.checkNotNullExpressionValue((Object)cachedIntentions, (String)"createAndUpdateActions(p\u2026, editor, intentionsInfo)");
        CachedIntentions cachedIntentions2 = cachedIntentions;
        List<IntentionActionWithTextCaching> list2 = cachedIntentions2.getAllActions();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"cachedIntentions.allActions");
        List<IntentionActionWithTextCaching> allActions = list2;
        if (allActions.isEmpty()) {
            return null;
        }
        Iterable $this$forEach$iv = allActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String text2;
            IntentionAction action2;
            IntentionActionWithTextCaching it = (IntentionActionWithTextCaching)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)IntentionActionDelegate.unwrap(it.getAction()), (String)"unwrap(it.action)");
            if (action2 instanceof AbstractEmptyIntentionAction || !action2.isAvailable(project3, editor2, psiFile)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it.getText(), (String)"it.text");
            if (XmlStringUtil.isWrappedInHtml(text2)) continue;
            return action2;
        }
        return null;
    }

    @NotNull
    public static final TooltipAction wrapIntentionToTooltipAction(@NotNull IntentionAction intention, @NotNull HighlightInfo info2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)intention, (String)"intention");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        int editorOffset = editor2.getCaretModel().getOffset();
        CustomizableIntentionAction customizableIntentionAction = intention instanceof CustomizableIntentionAction ? (CustomizableIntentionAction)intention : null;
        String string2 = customizableIntentionAction != null ? customizableIntentionAction.getTooltipText() : null;
        if (string2 == null) {
            String string3 = intention.getText();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"intention.text");
        }
        String text2 = string2;
        if (new IntRange(info2.getActualStartOffset(), info2.getActualEndOffset()).contains(editorOffset)) {
            String string4 = intention.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"intention.text");
            return new DaemonTooltipAction(text2, string4, editorOffset);
        }
        Integer n = info2.findRegisteredQuickFix((arg_0, arg_1) -> DaemonTooltipActionProviderKt.wrapIntentionToTooltipAction$lambda$2((Function2)new Function2<HighlightInfo.IntentionActionDescriptor, TextRange, Integer>(intention){
            final /* synthetic */ IntentionAction $intention;
            {
                this.$intention = $intention;
                super(2);
            }

            @Nullable
            public final Integer invoke(@NotNull HighlightInfo.IntentionActionDescriptor descriptor2, @NotNull TextRange range) {
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                return Intrinsics.areEqual((Object)descriptor2.getAction(), (Object)this.$intention) ? Integer.valueOf(range.getStartOffset()) : null;
            }
        }, arg_0, arg_1));
        int offset2 = n == null ? info2.getActualStartOffset() : n.intValue();
        String string5 = intention.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"intention.text");
        return new DaemonTooltipAction(text2, string5, offset2);
    }

    private static final Object extractMostPriorityFixFromHighlightInfo$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0, p1);
    }

    private static final Integer wrapIntentionToTooltipAction$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }
}

