/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInspection.ui.InspectionNodeInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DaemonTooltipRenderer
extends LineTooltipRenderer {
    @NonNls
    protected static final String END_MARKER = "<!-- end marker -->";

    DaemonTooltipRenderer(@NlsContexts.Tooltip String text2, Object[] comparable) {
        super(text2, comparable);
    }

    DaemonTooltipRenderer(@NlsContexts.Tooltip String text2, int width, Object[] comparable) {
        super(text2, width, comparable);
    }

    @NotNull
    @NlsContexts.Tooltip
    protected String dressDescription(@NotNull Editor editor2, @NotNull @NlsContexts.Tooltip String tooltipText, boolean expand) {
        if (editor2 == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(0);
        }
        if (tooltipText == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(1);
        }
        if (!expand) {
            String string2 = super.dressDescription(editor2, tooltipText, false);
            if (string2 == null) {
                DaemonTooltipRenderer.$$$reportNull$$$0(2);
            }
            return string2;
        }
        List<@NlsContexts.Tooltip String> problems = this.getProblems(tooltipText);
        @NlsContexts.Tooltip StringBuilder text2 = new StringBuilder();
        for (String problem : problems) {
            String ref = DaemonTooltipRenderer.getLinkRef(problem);
            if (ref != null) {
                String description = TooltipLinkHandlerEP.getDescription((String)ref, (Editor)editor2);
                if (description == null) continue;
                description = InspectionNodeInfo.stripUIRefsFromInspectionDescription(UIUtil.getHtmlBody(new Html(description).setKeepFont(true)));
                text2.append(this.getHtmlForProblemWithLink(problem)).append(END_MARKER).append("<p>").append("<span style=\"color:").append(ColorUtil.toHex(this.getDescriptionTitleColor())).append("\">").append(TooltipLinkHandlerEP.getDescriptionTitle((String)ref, (Editor)editor2)).append(":</span>").append(description).append("<hr size=1 noshade>");
                continue;
            }
            text2.append(UIUtil.getHtmlBody(new Html(problem).setKeepFont(true))).append("<hr size=1 noshade>");
        }
        if (text2.length() > 0) {
            String string3 = XmlStringUtil.wrapInHtml(StringUtil.trimEnd(text2.toString(), "<hr size=1 noshade>"));
            if (string3 == null) {
                DaemonTooltipRenderer.$$$reportNull$$$0(3);
            }
            return string3;
        }
        String string4 = super.dressDescription(editor2, tooltipText, true);
        if (string4 == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(4);
        }
        return string4;
    }

    protected @NotNull List<@NlsContexts.Tooltip String> getProblems(@NotNull @NlsContexts.Tooltip String tooltipText) {
        if (tooltipText == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(5);
        }
        List<String> list2 = StringUtil.split(UIUtil.getHtmlBody(new Html(tooltipText).setKeepFont(true)), "<hr size=1 noshade>");
        if (list2 == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    @NlsContexts.Tooltip
    protected String getHtmlForProblemWithLink(@NotNull @NlsContexts.Tooltip String problem) {
        if (problem == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(7);
        }
        Html html = new Html(problem).setKeepFont(true);
        String string2 = UIUtil.getHtmlBody(html).replace(DaemonBundle.message("inspection.extended.description", new Object[0]), DaemonBundle.message("inspection.collapse.description", new Object[0]));
        if (string2 == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Nullable
    protected static String getLinkRef(@NonNls String text2) {
        String ref;
        int quoteIdx;
        String linkWithRef = "<a href=\"";
        int linkStartIdx = text2.indexOf("<a href=\"");
        if (linkStartIdx >= 0 && (quoteIdx = (ref = text2.substring(linkStartIdx + "<a href=\"".length())).indexOf(34)) > 0) {
            return ref.substring(0, quoteIdx);
        }
        return null;
    }

    @NotNull
    protected Color getDescriptionTitleColor() {
        JBColor jBColor = JBColor.namedColor("ToolTip.infoForeground", new JBColor(0x919191, 0x919191));
        if (jBColor == null) {
            DaemonTooltipRenderer.$$$reportNull$$$0(9);
        }
        return jBColor;
    }

    @NotNull
    public LineTooltipRenderer createRenderer(@Nullable String text2, int width) {
        return new DaemonTooltipRenderer(text2, width, this.getEqualityObjects());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRenderer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRenderer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "dressDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlForProblemWithLink";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionTitleColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dressDescription";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProblems";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlForProblemWithLink";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 6, 8, 9 -> new IllegalStateException(string2);
        };
    }
}

