/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipRenderer;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipWithActionRenderer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.tooltips.TooltipActionProvider;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonTooltipRendererProvider
implements ErrorStripTooltipRendererProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;

    DaemonTooltipRendererProvider(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myEditor = editor2;
    }

    public TooltipRenderer calcTooltipRenderer(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        if (highlighters == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(2);
        }
        DaemonTooltipRenderer bigRenderer = null;
        SmartList<HighlightInfo> infos = new SmartList<HighlightInfo>();
        HashSet<String> tooltips = new HashSet<String>();
        for (RangeHighlighter rangeHighlighter : highlighters) {
            Object tooltipObject = rangeHighlighter.getErrorStripeTooltip();
            if (tooltipObject == null) continue;
            if (tooltipObject instanceof HighlightInfo) {
                HighlightInfo info2 = (HighlightInfo)tooltipObject;
                if (info2.getToolTip() == null || !tooltips.add(info2.getToolTip())) continue;
                infos.add(info2);
                continue;
            }
            @NlsContexts.Tooltip String text2 = tooltipObject.toString();
            if (!tooltips.add(text2)) continue;
            if (bigRenderer == null) {
                bigRenderer = new DaemonTooltipRenderer(text2, new Object[]{highlighters});
                continue;
            }
            bigRenderer.addBelow(text2);
        }
        if (!infos.isEmpty()) {
            Object[] objectArray;
            ContainerUtil.quickSort(infos, (o1, o2) -> {
                int i2 = SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(o2.getSeverity(), o1.getSeverity());
                if (i2 != 0) {
                    return i2;
                }
                return StringUtil.compare(o1.getToolTip(), o2.getToolTip(), false);
            });
            HighlightInfoComposite composite2 = HighlightInfoComposite.create(infos);
            String string2 = composite2.getToolTip();
            TooltipAction action2 = TooltipActionProvider.calcTooltipAction(composite2, this.myProject, this.myEditor);
            if (action2 == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = string2;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = string2;
                objectArray = objectArray3;
                objectArray3[1] = action2;
            }
            DaemonTooltipWithActionRenderer myRenderer = new DaemonTooltipWithActionRenderer(string2, action2, 0, objectArray);
            if (bigRenderer != null) {
                myRenderer.addBelow(bigRenderer.getText());
            }
            bigRenderer = myRenderer;
        }
        return bigRenderer;
    }

    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(3);
        }
        return new DaemonTooltipRenderer(text2, new Object[]{text2});
    }

    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2, int width) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(4);
        }
        return new DaemonTooltipRenderer(text2, width, new Object[]{text2});
    }

    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2, @Nullable TooltipAction action2, int width) {
        Object[] objectArray;
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(5);
        }
        if (action2 == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = text2;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = text2;
            objectArray = objectArray3;
            objectArray3[1] = action2;
        }
        return new DaemonTooltipWithActionRenderer(text2, action2, width, objectArray);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "calcTooltipRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

