/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.AnnotatorStatisticsCollector;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class DefaultHighlightVisitor
implements HighlightVisitor,
DumbAware {
    private static final Logger LOG = Logger.getInstance(DefaultHighlightVisitor.class);
    private AnnotationHolderImpl myAnnotationHolder;
    private final Map<Language, List<Annotator>> myAnnotators;
    private final Project myProject;
    private final boolean myHighlightErrorElements;
    private final boolean myRunAnnotators;
    private final DumbService myDumbService;
    private HighlightInfoHolder myHolder;
    private final boolean myBatchMode;
    private boolean myDumb;
    private final AnnotatorStatisticsCollector myAnnotatorStatisticsCollector;

    DefaultHighlightVisitor(@NotNull Project project2) {
        if (project2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(0);
        }
        this(project2, true, true, false);
    }

    DefaultHighlightVisitor(@NotNull Project project2, boolean highlightErrorElements, boolean runAnnotators, boolean batchMode) {
        if (project2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(1);
        }
        this.myAnnotators = ConcurrentFactoryMap.createMap(language -> this.createAnnotators((Language)language));
        this.myAnnotatorStatisticsCollector = new AnnotatorStatisticsCollector();
        this.myProject = project2;
        this.myHighlightErrorElements = highlightErrorElements;
        this.myRunAnnotators = runAnnotators;
        this.myDumbService = DumbService.getInstance(project2);
        this.myBatchMode = batchMode;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, final @NotNull HighlightInfoHolder holder, @NotNull Runnable action2) {
        if (file2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(5);
        }
        this.myDumb = this.myDumbService.isDumb();
        this.myHolder = holder;
        this.myAnnotationHolder = new AnnotationHolderImpl(holder.getAnnotationSession(), this.myBatchMode){

            @Override
            void queueToUpdateIncrementally() {
                if (!this.isEmpty()) {
                    DefaultHighlightVisitor.this.myAnnotatorStatisticsCollector.reportAnnotationProduced(this.myCurrentAnnotator, (Annotation)this.get(0));
                    for (int i2 = 0; i2 < this.size(); ++i2) {
                        Annotation annotation = (Annotation)this.get(i2);
                        holder.add(HighlightInfo.fromAnnotation(annotation, DefaultHighlightVisitor.this.myBatchMode));
                    }
                    this.clear();
                }
            }
        };
        try {
            action2.run();
            this.myAnnotationHolder.assertAllAnnotationsCreated();
        }
        finally {
            this.myAnnotators.clear();
            this.myHolder = null;
            this.myAnnotationHolder = null;
            this.myAnnotatorStatisticsCollector.reportAnalysisFinished(this.myProject, holder.getAnnotationSession(), file2);
        }
        return true;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(6);
        }
        if (this.myRunAnnotators) {
            this.runAnnotators(element);
        }
        if (element instanceof PsiErrorElement && this.myHighlightErrorElements) {
            this.visitErrorElement((PsiErrorElement)element);
        }
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        return new DefaultHighlightVisitor(this.myProject, this.myHighlightErrorElements, this.myRunAnnotators, this.myBatchMode);
    }

    private void runAnnotators(@NotNull PsiElement element) {
        List<Annotator> annotators;
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(7);
        }
        if (!(annotators = this.myAnnotators.get(element.getLanguage())).isEmpty()) {
            AnnotationHolderImpl holder = this.myAnnotationHolder;
            holder.myCurrentElement = element;
            for (Annotator annotator : annotators) {
                if (this.myDumb && !DumbService.isDumbAware(annotator)) continue;
                ProgressManager.checkCanceled();
                holder.myCurrentAnnotator = annotator;
                annotator.annotate(element, holder);
                holder.queueToUpdateIncrementally();
            }
        }
    }

    private void visitErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(8);
        }
        if (HighlightErrorFilter.EP_NAME.findFirstSafe(this.myProject, filter2 -> !filter2.shouldHighlightErrorElement(element)) != null) {
            return;
        }
        this.myHolder.add(DefaultHighlightVisitor.createErrorElementInfo(element));
    }

    private static HighlightInfo createErrorElementInfo(@NotNull PsiErrorElement element) {
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(9);
        }
        HighlightInfo.Builder builder2 = DefaultHighlightVisitor.createInfoWithoutFixes(element);
        List<ErrorQuickFixProvider> providers = DumbService.getInstance(element.getProject()).filterByDumbAwareness(ErrorQuickFixProvider.EP_NAME.getExtensionList());
        for (ErrorQuickFixProvider provider2 : providers) {
            provider2.registerErrorQuickFix(element, builder2);
        }
        HighlightInfo info2 = builder2.create();
        if (info2 != null) {
            for (ErrorQuickFixProvider provider3 : providers) {
                provider3.registerErrorQuickFix(element, info2);
            }
        }
        return info2;
    }

    @NotNull
    private static HighlightInfo.Builder createInfoWithoutFixes(@NotNull PsiErrorElement element) {
        int end;
        int start;
        String text2;
        if (element == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(10);
        }
        TextRange range = element.getTextRange();
        String errorDescription = element.getErrorDescription();
        if (!range.isEmpty()) {
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(errorDescription);
            if (builder2 == null) {
                DefaultHighlightVisitor.$$$reportNull$$$0(11);
            }
            return builder2;
        }
        int offset2 = range.getStartOffset();
        PsiFile containingFile = element.getContainingFile();
        int fileLength = containingFile.getTextLength();
        FileViewProvider viewProvider = containingFile.getViewProvider();
        PsiElement elementAtOffset = viewProvider.findElementAt(offset2, LanguageUtil.getRootLanguage(element));
        String string2 = text2 = elementAtOffset == null ? null : elementAtOffset.getText();
        if (offset2 < fileLength && text2 != null && !StringUtil.startsWithChar(text2, '\n') && !StringUtil.startsWithChar(text2, '\r')) {
            HighlightInfo.Builder builder3 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(offset2, offset2 + 1);
            builder3.descriptionAndTooltip(errorDescription);
            HighlightInfo.Builder builder4 = builder3;
            if (builder4 == null) {
                DefaultHighlightVisitor.$$$reportNull$$$0(12);
            }
            return builder4;
        }
        if (offset2 > 0) {
            start = offset2;
            end = offset2;
        } else {
            start = offset2;
            end = offset2 < fileLength ? offset2 + 1 : offset2;
        }
        HighlightInfo.Builder builder5 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element, start, end);
        builder5.descriptionAndTooltip(errorDescription);
        builder5.endOfLine();
        HighlightInfo.Builder builder6 = builder5;
        if (builder6 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(13);
        }
        return builder6;
    }

    @NotNull
    private List<Annotator> cloneTemplates(@NotNull Collection<? extends Annotator> templates) {
        if (templates == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(14);
        }
        ArrayList<Annotator> result2 = new ArrayList<Annotator>(templates.size());
        for (Annotator annotator : templates) {
            Annotator annotator2;
            try {
                annotator2 = (Annotator)ReflectionUtil.newInstance(annotator.getClass());
            }
            catch (Exception e) {
                LOG.error(PluginException.createByClass(e, annotator.getClass()));
                continue;
            }
            result2.add(annotator2);
            this.myAnnotatorStatisticsCollector.reportNewAnnotatorCreated(annotator2);
        }
        ArrayList<Annotator> arrayList = result2;
        if (arrayList == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private List<Annotator> createAnnotators(@NotNull Language language) {
        if (language == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(16);
        }
        return this.cloneTemplates(LanguageAnnotators.INSTANCE.allForLanguageOrAny(language));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoWithoutFixes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotators";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitErrorElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createErrorElementInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createInfoWithoutFixes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cloneTemplates";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotators";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 11, 12, 13, 15 -> new IllegalStateException(string2);
        };
    }
}

