/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTracker
implements Disposable {
    private static final Logger LOG = Logger.getInstance(EditorTracker.class);
    protected final Project project;
    private final Map<Window, List<Editor>> myWindowToEditorsMap;
    private final Map<Window, WindowAdapter> myWindowToWindowFocusListenerMap;
    private final Map<Editor, Window> myEditorToWindowMap;
    private List<? extends Editor> myActiveEditors;
    private Window myActiveWindow;
    private final Map<Editor, Runnable> myExecuteOnEditorRelease;

    public EditorTracker(@NotNull Project project2) {
        if (project2 == null) {
            EditorTracker.$$$reportNull$$$0(0);
        }
        this.myWindowToEditorsMap = new HashMap<Window, List<Editor>>();
        this.myWindowToWindowFocusListenerMap = new HashMap<Window, WindowAdapter>();
        this.myEditorToWindowMap = new HashMap<Editor, Window>();
        this.myActiveEditors = Collections.emptyList();
        this.myExecuteOnEditorRelease = new HashMap<Editor, Runnable>();
        this.project = project2;
    }

    public static EditorTracker getInstance(@NotNull Project project2) {
        if (project2 == null) {
            EditorTracker.$$$reportNull$$$0(1);
        }
        return project2.getService(EditorTracker.class);
    }

    private void registerEditor(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            EditorTracker.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            EditorTracker.$$$reportNull$$$0(3);
        }
        this.unregisterEditor(editor2);
        final Window window = EditorTracker.windowByEditor(editor2, project2);
        if (window == null) {
            return;
        }
        this.myEditorToWindowMap.put(editor2, window);
        List<Editor> list2 = this.myWindowToEditorsMap.get(window);
        if (list2 == null) {
            list2 = new ArrayList<Editor>();
            this.myWindowToEditorsMap.put(window, list2);
            if (!(window instanceof IdeFrameImpl)) {
                WindowAdapter listener2 = new WindowAdapter(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowGainedFocus:" + window);
                        }
                        EditorTracker.this.setActiveWindow(window);
                    }

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowLostFocus:" + window);
                        }
                        EditorTracker.this.setActiveWindow(null);
                    }

                    @Override
                    public void windowClosed(WindowEvent event) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowClosed:" + window);
                        }
                        EditorTracker.this.setActiveWindow(null);
                    }
                };
                this.myWindowToWindowFocusListenerMap.put(window, listener2);
                window.addWindowFocusListener(listener2);
                window.addWindowListener(listener2);
                if (window.isFocused()) {
                    this.setActiveWindow(window);
                }
            }
        }
        list2.add(editor2);
        if (this.myActiveWindow == window) {
            this.setActiveWindow(window);
        }
    }

    private void unregisterEditor(@NotNull Editor editor2) {
        Window oldWindow;
        if (editor2 == null) {
            EditorTracker.$$$reportNull$$$0(4);
        }
        if ((oldWindow = this.myEditorToWindowMap.get(editor2)) != null) {
            this.myEditorToWindowMap.remove(editor2);
            List<Editor> editorsList = this.myWindowToEditorsMap.get(oldWindow);
            boolean removed = editorsList.remove(editor2);
            LOG.assertTrue(removed);
            if (oldWindow == this.myActiveWindow) {
                this.updateActiveEditors(this.myActiveWindow);
            }
            if (editorsList.isEmpty()) {
                this.myWindowToEditorsMap.remove(oldWindow);
                WindowAdapter listener2 = this.myWindowToWindowFocusListenerMap.remove(oldWindow);
                if (listener2 != null) {
                    oldWindow.removeWindowFocusListener(listener2);
                    oldWindow.removeWindowListener(listener2);
                }
            }
        }
    }

    @Nullable
    private static Window windowByEditor(@NotNull Editor editor2, @NotNull Project project2) {
        Window window;
        ProjectFrameHelper frameHelper;
        if (editor2 == null) {
            EditorTracker.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            EditorTracker.$$$reportNull$$$0(6);
        }
        return (frameHelper = ProjectFrameHelper.getFrameHelper((Window)(window = SwingUtilities.windowForComponent(editor2.getComponent())))) != null && frameHelper.getProject() != project2 ? null : window;
    }

    @NotNull
    public List<? extends Editor> getActiveEditors() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<? extends Editor> list2 = this.myActiveEditors;
        if (list2 == null) {
            EditorTracker.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private void setActiveWindow(@Nullable Window window) {
        this.myActiveWindow = window;
        this.updateActiveEditors(window);
    }

    private void updateActiveEditors(@Nullable Window window) {
        List<Editor> list2;
        List<Editor> list3 = list2 = window == null ? null : this.myWindowToEditorsMap.get(window);
        if (list2 == null || list2.isEmpty()) {
            this.setActiveEditors(Collections.emptyList());
        } else {
            SmartList<Editor> editors2 = new SmartList<Editor>();
            for (Editor editor2 : list2) {
                if (!editor2.getContentComponent().isShowing() || editor2.isDisposed()) continue;
                editors2.add(editor2);
            }
            this.setActiveEditors(editors2);
        }
    }

    public void setActiveEditors(@NotNull List<? extends Editor> editors2) {
        if (editors2 == null) {
            EditorTracker.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (editors2.equals(this.myActiveEditors)) {
            return;
        }
        this.myActiveEditors = editors2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("active editors changed:");
            for (Editor editor2 : editors2) {
                PsiFile psiFile = PsiDocumentManager.getInstance(this.project).getPsiFile(editor2.getDocument());
                LOG.debug("    " + psiFile);
            }
        }
        this.project.getMessageBus().syncPublisher(EditorTrackerListener.TOPIC).activeEditorsChanged(editors2);
    }

    private void editorCreated(@NotNull EditorFactoryEvent event, @NotNull Project project2) {
        if (event == null) {
            EditorTracker.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            EditorTracker.$$$reportNull$$$0(10);
        }
        Editor editor2 = event.getEditor();
        PsiFile psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (psiFile != null) {
            this.createEditorImpl(editor2, project2);
        }
    }

    protected void createEditorImpl(final @NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            EditorTracker.$$$reportNull$$$0(11);
        }
        if (project2 == null) {
            EditorTracker.$$$reportNull$$$0(12);
        }
        JComponent component2 = editor2.getComponent();
        JComponent contentComponent = editor2.getContentComponent();
        PropertyChangeListener propertyChangeListener = evt -> {
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                this.registerEditor(editor2, project2);
            }
        };
        component2.addPropertyChangeListener("ancestor", propertyChangeListener);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                Window window = EditorTracker.this.myEditorToWindowMap.get(editor2);
                if (window == null) {
                    return;
                }
                List<Editor> list2 = EditorTracker.this.myWindowToEditorsMap.get(window);
                int index2 = list2.indexOf(editor2);
                LOG.assertTrue(index2 >= 0);
                if (list2.isEmpty()) {
                    return;
                }
                for (int i2 = index2 - 1; i2 >= 0; --i2) {
                    list2.set(i2 + 1, list2.get(i2));
                }
                list2.set(0, editor2);
                EditorTracker.this.setActiveWindow(window);
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/EditorTracker$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        contentComponent.addFocusListener(focusListener);
        this.myExecuteOnEditorRelease.put(editor2, () -> {
            component2.removePropertyChangeListener("ancestor", propertyChangeListener);
            contentComponent.removeFocusListener(focusListener);
        });
    }

    private void editorReleased(@NotNull EditorFactoryEvent event, @NotNull Project project2) {
        if (event == null) {
            EditorTracker.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            EditorTracker.$$$reportNull$$$0(14);
        }
        this.editorReleasedImpl(event.getEditor(), project2);
    }

    protected void editorReleasedImpl(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            EditorTracker.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            EditorTracker.$$$reportNull$$$0(16);
        }
        this.unregisterEditor(editor2);
        this.executeOnRelease(editor2);
    }

    @Override
    public void dispose() {
        this.executeOnRelease(null);
    }

    private void executeOnRelease(@Nullable Editor editor2) {
        if (editor2 == null) {
            for (Runnable r : this.myExecuteOnEditorRelease.values()) {
                r.run();
            }
            this.myExecuteOnEditorRelease.clear();
        } else {
            Runnable runnable = this.myExecuteOnEditorRelease.get(editor2);
            if (runnable != null) {
                runnable.run();
                this.myExecuteOnEditorRelease.remove(editor2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/EditorTracker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/EditorTracker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregisterEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "windowByEditor";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setActiveEditors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "editorCreated";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "editorReleased";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "editorReleasedImpl";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }

    static final class MyAppLevelEditorFactoryListener
    implements EditorFactoryListener {
        MyAppLevelEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Project project2;
            if (event == null) {
                MyAppLevelEditorFactoryListener.$$$reportNull$$$0(0);
            }
            if ((project2 = event.getEditor().getProject()) != null && !project2.isDisposed()) {
                EditorTracker.getInstance(project2).editorCreated(event, project2);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Project project2;
            if (event == null) {
                MyAppLevelEditorFactoryListener.$$$reportNull$$$0(1);
            }
            if ((project2 = event.getEditor().getProject()) != null && !project2.isDisposed()) {
                EditorTracker.getInstance(project2).editorReleased(event, project2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/EditorTracker$MyAppLevelEditorFactoryListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyAppLevelFileEditorManagerListener
    implements FileEditorManagerListener {
        MyAppLevelFileEditorManagerListener() {
        }

        @Override
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyAppLevelFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            Project project2 = event.getManager().getProject();
            JFrame frame = WindowManager.getInstance().getFrame(project2);
            if (frame != null && frame.getFocusOwner() != null) {
                EditorTracker.getInstance(project2).setActiveWindow(frame);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/EditorTracker$MyAppLevelFileEditorManagerListener", "selectionChanged"));
        }
    }
}

