/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipRendererProvider;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficLightRendererContributor;
import com.intellij.ide.impl.ProjectUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PopupHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorStripeUpdateManager
implements Disposable {
    private final Project myProject;
    private final PsiDocumentManager myPsiDocumentManager;

    public static ErrorStripeUpdateManager getInstance(Project project2) {
        return project2.getService(ErrorStripeUpdateManager.class);
    }

    public ErrorStripeUpdateManager(Project project2) {
        this.myProject = project2;
        this.myPsiDocumentManager = PsiDocumentManager.getInstance(this.myProject);
        TrafficLightRendererContributor.EP_NAME.addChangeListener(() -> {
            for (FileEditor fileEditor : FileEditorManager.getInstance(project2).getAllEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Editor editor2 = ((TextEditor)fileEditor).getEditor();
                PsiFile file2 = this.myPsiDocumentManager.getCachedPsiFile(editor2.getDocument());
                this.repaintErrorStripePanel(editor2, file2);
            }
        }, this);
    }

    @Override
    public void dispose() {
    }

    public void repaintErrorStripePanel(@NotNull Editor editor2, @Nullable PsiFile psiFile) {
        if (editor2 == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myProject.isInitialized()) {
            return;
        }
        EditorMarkupModel markup = (EditorMarkupModel)editor2.getMarkupModel();
        markup.setErrorPanelPopupHandler((PopupHandler)new DaemonEditorPopup(this.myProject, editor2));
        markup.setErrorStripTooltipRendererProvider((ErrorStripTooltipRendererProvider)new DaemonTooltipRendererProvider(this.myProject, editor2));
        markup.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().getErrorStripeMarkMinHeight());
        this.setOrRefreshErrorStripeRenderer(markup, psiFile);
    }

    void setOrRefreshErrorStripeRenderer(@NotNull EditorMarkupModel editorMarkupModel, @Nullable PsiFile file2) {
        if (editorMarkupModel == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!editorMarkupModel.isErrorStripeVisible() || file2 == null || !DaemonCodeAnalyzer.getInstance(this.myProject).isHighlightingAvailable(file2)) {
            return;
        }
        ErrorStripeRenderer renderer = editorMarkupModel.getErrorStripeRenderer();
        if (renderer instanceof TrafficLightRenderer) {
            TrafficLightRenderer tlr = (TrafficLightRenderer)renderer;
            EditorMarkupModelImpl markupModelImpl = (EditorMarkupModelImpl)editorMarkupModel;
            tlr.refresh(markupModelImpl);
            markupModelImpl.repaintTrafficLightIcon();
            if (tlr.isValid()) {
                return;
            }
        }
        ModalityState modality = ModalityState.defaultModalityState();
        ProjectUtilKt.executeOnPooledThread((Project)this.myProject, () -> {
            Editor editor2 = editorMarkupModel.getEditor();
            if (editor2.isDisposed()) {
                return;
            }
            TrafficLightRenderer tlRenderer = this.createRenderer(editor2, file2);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (editor2.isDisposed()) {
                    Disposer.dispose(tlRenderer);
                    return;
                }
                editorMarkupModel.setErrorStripeRenderer((ErrorStripeRenderer)tlRenderer);
            }, modality, this.myProject.getDisposed());
        });
    }

    @NotNull
    private TrafficLightRenderer createRenderer(@NotNull Editor editor2, @Nullable PsiFile file2) {
        if (editor2 == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        for (TrafficLightRendererContributor contributor : TrafficLightRendererContributor.EP_NAME.getExtensionList()) {
            TrafficLightRenderer renderer = contributor.createRenderer(editor2, file2);
            if (renderer == null) continue;
            TrafficLightRenderer trafficLightRenderer = renderer;
            if (trafficLightRenderer == null) {
                ErrorStripeUpdateManager.$$$reportNull$$$0(3);
            }
            return trafficLightRenderer;
        }
        return new TrafficLightRenderer(this.myProject, editor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorMarkupModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ErrorStripeUpdateManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ErrorStripeUpdateManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "repaintErrorStripePanel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setOrRefreshErrorStripeRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

