/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.DynamicBundle;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class FileIncludeContextHectorPanel
extends HectorComponentPanel {
    private ComboboxWithBrowseButton myContextFile;
    private JPanel myPanel;
    private final PsiFile myFile;
    private final FileIncludeManager myIncludeManager;

    public FileIncludeContextHectorPanel(PsiFile file2, FileIncludeManager includeManager) {
        this.myFile = file2;
        this.myIncludeManager = includeManager;
        this.$$$setupUI$$$();
        this.myPanel.setBackground(UIUtil.getToolTipActionBackground());
        this.myContextFile.setBackground(UIUtil.getToolTipActionBackground());
        this.reset();
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
        JComboBox comboBox = this.myContextFile.getComboBox();
        comboBox.setRenderer(new MyListCellRenderer(comboBox));
        VirtualFile[] includingFiles = this.myIncludeManager.getIncludingFiles(this.myFile.getVirtualFile(), false);
        comboBox.setModel(new DefaultComboBoxModel<VirtualFile>(includingFiles));
        this.myContextFile.setTextFieldPreferredWidth(30);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle("messages/CodeInsightBundle", FileIncludeContextHectorPanel.class).getString("label.file.included.into"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myContextFile = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c2 = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private final JComboBox myComboBox;
        private int myMaxWidth;

        MyListCellRenderer(JComboBox comboBox) {
            this.myComboBox = comboBox;
            this.myMaxWidth = comboBox.getPreferredSize().width;
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
            Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value, index2, isSelected, cellHasFocus);
            String path2 = this.getPath(value);
            if (path2 != null) {
                int max = index2 == -1 ? this.myComboBox.getWidth() - FileIncludeContextHectorPanel.this.myContextFile.getButton().getWidth() : this.myComboBox.getWidth() * 3;
                path2 = this.trimPath(path2, this.myComboBox, "/", max);
                this.setText(path2);
            }
            return rendererComponent;
        }

        @Nullable
        @NlsSafe
        protected String getPath(Object value) {
            VirtualFile file2 = (VirtualFile)value;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(FileIncludeContextHectorPanel.this.myFile.getProject()).getFileIndex();
            if (file2 != null) {
                VirtualFile root = fileIndex.getSourceRootForFile(file2);
                if (root == null) {
                    root = fileIndex.getContentRootForFile(file2);
                }
                if (root != null) {
                    return VfsUtilCore.getRelativePath(file2, root, '/');
                }
            }
            return null;
        }

        @NlsSafe
        private String trimPath(String path2, Component component2, String separator, int length) {
            FontMetrics fontMetrics = component2.getFontMetrics(component2.getFont());
            int maxWidth = fontMetrics.stringWidth(path2);
            if (maxWidth <= length) {
                this.myMaxWidth = Math.max(maxWidth, this.myMaxWidth);
                return path2;
            }
            StringBuilder result2 = new StringBuilder(path2);
            if (path2.startsWith(separator)) {
                result2.delete(0, 1);
            }
            String[] strings2 = result2.toString().split(separator);
            result2.replace(0, strings2[0].length(), "...");
            for (int i2 = 1; i2 < strings2.length; ++i2) {
                String clipped = result2.toString();
                int width = fontMetrics.stringWidth(clipped);
                if (width <= length) {
                    this.myMaxWidth = Math.max(width, this.myMaxWidth);
                    return clipped;
                }
                result2.delete(4, 5 + strings2[i2].length());
            }
            return result2.toString();
        }
    }
}

