/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FileStatusMap
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FileStatusMap.class);
    public static final String CHANGES_NOT_ALLOWED_DURING_HIGHLIGHTING = "PSI/document/model changes are not allowed during highlighting";
    private final Project myProject;
    private final Map<@NotNull Document, FileStatus> myDocumentToStatusMap;
    private volatile boolean myAllowDirt;
    private static final RangeMarker WHOLE_FILE_DIRTY_MARKER = new RangeMarker(){

        @Override
        @NotNull
        public Document getDocument() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getStartOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void setGreedyToLeft(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setGreedyToRight(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGreedyToRight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGreedyToLeft() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void dispose() {
        }

        @Override
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                1.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        @NonNls
        public String toString() {
            return "WHOLE_FILE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/FileStatusMap$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final ConcurrentMap<Thread, Integer> threads = CollectionFactory.createConcurrentWeakMap();

    FileStatusMap(@NotNull Project project2) {
        if (project2 == null) {
            FileStatusMap.$$$reportNull$$$0(0);
        }
        this.myDocumentToStatusMap = new WeakHashMap<Document, FileStatus>();
        this.myAllowDirt = true;
        this.myProject = project2;
    }

    @Override
    public void dispose() {
        this.markAllFilesDirty("FileStatusMap dispose");
    }

    @Nullable(value="null means the file is clean")
    public static @Nullable(value="null means the file is clean") TextRange getDirtyTextRange(@NotNull Editor editor2, int passId) {
        if (editor2 == null) {
            FileStatusMap.$$$reportNull$$$0(1);
        }
        Document document = editor2.getDocument();
        FileStatusMap me = DaemonCodeAnalyzerEx.getInstanceEx(editor2.getProject()).getFileStatusMap();
        TextRange dirtyScope = me.getFileDirtyScope(document, passId);
        if (dirtyScope == null) {
            return null;
        }
        TextRange documentRange = TextRange.from(0, document.getTextLength());
        return documentRange.intersection(dirtyScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorFoundFlag(@NotNull Project project2, @NotNull Document document, boolean errorFound) {
        if (project2 == null) {
            FileStatusMap.$$$reportNull$$$0(2);
        }
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(3);
        }
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                if (!errorFound) {
                    return;
                }
                status = new FileStatus(project2);
                this.myDocumentToStatusMap.put(document, status);
            }
            status.errorFound = errorFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wasErrorFound(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(4);
        }
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            return status != null && status.errorFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAllFilesDirty(@NotNull @NonNls Object reason) {
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(5);
        }
        this.assertAllowModifications();
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            if (!this.myDocumentToStatusMap.isEmpty()) {
                FileStatusMap.log("Mark all dirty: ", reason);
            }
            this.myDocumentToStatusMap.clear();
        }
    }

    private void assertAllowModifications() {
        if (!this.myAllowDirt) {
            this.myAllowDirt = true;
            throw new AssertionError((Object)CHANGES_NOT_ALLOWED_DURING_HIGHLIGHTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileUpToDate(@NotNull Document document, int passId) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(6);
        }
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.computeIfAbsent(document, __ -> new FileStatus(this.myProject));
            status.defensivelyMarked = false;
            if (passId == 9) {
                status.wolfPassFinished = true;
            } else if (status.dirtyScopes.containsKey(passId)) {
                status.setDirtyScope(passId, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TextRange getFileDirtyScopeForAllPassesCombined(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(7);
        }
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return null;
            }
            int start = Integer.MAX_VALUE;
            int end = Integer.MIN_VALUE;
            for (RangeMarker marker : status.dirtyScopes.values()) {
                if (marker == null || marker == WHOLE_FILE_DIRTY_MARKER || !marker.isValid()) continue;
                start = Math.min(start, marker.getStartOffset());
                end = Math.max(end, marker.getEndOffset());
            }
            return start == Integer.MAX_VALUE ? null : new TextRange(start, end);
        }
    }

    @Deprecated
    @Nullable
    public TextRange getFileDirtyScope(@NotNull Document document, int passId) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(8);
        }
        return this.getFileDirtyScope(document, PsiDocumentManager.getInstance(this.myProject).getPsiFile(document), passId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TextRange getFileDirtyScope(@NotNull Document document, @Nullable PsiFile file2, int passId) {
        RangeMarker marker;
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(9);
        }
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                marker = WHOLE_FILE_DIRTY_MARKER;
            } else {
                if (status.defensivelyMarked) {
                    status.markWholeFileDirty(this.myProject);
                    status.defensivelyMarked = false;
                }
                FileStatusMap.assertRegisteredPass(passId, status);
                marker = (RangeMarker)status.dirtyScopes.get(passId);
            }
        }
        if (marker == null) {
            return null;
        }
        if (marker == WHOLE_FILE_DIRTY_MARKER) {
            return file2 == null ? null : file2.getTextRange();
        }
        return marker.isValid() ? marker.getTextRange() : new TextRange(0, document.getTextLength());
    }

    private static void assertRegisteredPass(int passId, @NotNull FileStatus status) {
        if (status == null) {
            FileStatusMap.$$$reportNull$$$0(10);
        }
        if (!status.dirtyScopes.containsKey(passId)) {
            throw new IllegalStateException("Unknown pass " + passId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFileScopeDirtyDefensively(@NotNull PsiFile file2, @NotNull @NonNls Object reason) {
        if (file2 == null) {
            FileStatusMap.$$$reportNull$$$0(11);
        }
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(12);
        }
        this.assertAllowModifications();
        FileStatusMap.log("Mark dirty file defensively: ", file2.getName(), reason);
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            Document document = PsiDocumentManager.getInstance(this.myProject).getCachedDocument(file2);
            if (document == null) {
                return;
            }
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            status.defensivelyMarked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFileScopeDirty(@NotNull Document document, @NotNull TextRange scope, int fileLength, @NotNull @NonNls Object reason) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            FileStatusMap.$$$reportNull$$$0(14);
        }
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(15);
        }
        this.assertAllowModifications();
        FileStatusMap.log("Mark scope dirty: ", scope, reason);
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            if (status.defensivelyMarked) {
                status.defensivelyMarked = false;
            }
            status.combineScopesWith(scope, fileLength, document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allDirtyScopesAreNull(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(16);
        }
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            return status != null && !status.defensivelyMarked && status.wolfPassFinished && status.allDirtyScopesAreNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void assertAllDirtyScopesAreNull(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(17);
        }
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            assert (status != null && !status.defensivelyMarked && status.wolfPassFinished && status.allDirtyScopesAreNull()) : status;
        }
    }

    @TestOnly
    boolean allowDirt(boolean allow) {
        boolean old = this.myAllowDirt;
        this.myAllowDirt = allow;
        return old;
    }

    private static int getThreadNum() {
        return threads.computeIfAbsent(Thread.currentThread(), thread -> threads.size());
    }

    public static void log(Object ... info2) {
        if (info2 == null) {
            FileStatusMap.$$$reportNull$$$0(18);
        }
        if (LOG.isDebugEnabled()) {
            StringJoiner joiner = new StringJoiner(", ", " ".repeat(FileStatusMap.getThreadNum() * 4) + "[", "]\n");
            for (Object o : info2) {
                joiner.add(String.valueOf(o));
            }
            LOG.debug(joiner.toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/FileStatusMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirtyTextRange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setErrorFoundFlag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "wasErrorFound";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "markAllFilesDirty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "markFileUpToDate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileDirtyScopeForAllPassesCombined";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileDirtyScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "assertRegisteredPass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "markFileScopeDirtyDefensively";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "markFileScopeDirty";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "allDirtyScopesAreNull";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "assertAllDirtyScopesAreNull";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "log";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FileStatus {
        private boolean defensivelyMarked;
        private boolean wolfPassFinished;
        private final Int2ObjectMap<RangeMarker> dirtyScopes;
        private boolean errorFound;

        private FileStatus(@NotNull Project project2) {
            if (project2 == null) {
                FileStatus.$$$reportNull$$$0(0);
            }
            this.dirtyScopes = new Int2ObjectOpenHashMap<RangeMarker>();
            this.markWholeFileDirty(project2);
        }

        private void markWholeFileDirty(@NotNull Project project2) {
            if (project2 == null) {
                FileStatus.$$$reportNull$$$0(1);
            }
            this.setDirtyScope(4, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(8, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(7, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(11, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(13, WHOLE_FILE_DIRTY_MARKER);
            TextEditorHighlightingPassRegistrarEx registrar = (TextEditorHighlightingPassRegistrarEx)TextEditorHighlightingPassRegistrar.getInstance(project2);
            for (DirtyScopeTrackingHighlightingPassFactory factory2 : registrar.getDirtyScopeTrackingFactories()) {
                this.setDirtyScope(factory2.getPassId(), WHOLE_FILE_DIRTY_MARKER);
            }
        }

        private boolean allDirtyScopesAreNull() {
            for (Object o : this.dirtyScopes.values()) {
                if (o == null) continue;
                return false;
            }
            return true;
        }

        private void combineScopesWith(@NotNull TextRange scope, int fileLength, @NotNull Document document) {
            if (scope == null) {
                FileStatus.$$$reportNull$$$0(2);
            }
            if (document == null) {
                FileStatus.$$$reportNull$$$0(3);
            }
            this.dirtyScopes.replaceAll((__, oldScope) -> {
                RangeMarker newScope = FileStatus.combineScopes(oldScope, scope, fileLength, document);
                if (newScope != oldScope && oldScope != null) {
                    oldScope.dispose();
                }
                return newScope;
            });
        }

        @NotNull
        private static RangeMarker combineScopes(@Nullable RangeMarker old, @NotNull TextRange scope, int textLength, @NotNull Document document) {
            if (scope == null) {
                FileStatus.$$$reportNull$$$0(4);
            }
            if (document == null) {
                FileStatus.$$$reportNull$$$0(5);
            }
            if (old == null) {
                if (scope.equalsToRange(0, textLength)) {
                    RangeMarker rangeMarker = WHOLE_FILE_DIRTY_MARKER;
                    if (rangeMarker == null) {
                        FileStatus.$$$reportNull$$$0(6);
                    }
                    return rangeMarker;
                }
                RangeMarker rangeMarker = document.createRangeMarker(scope);
                if (rangeMarker == null) {
                    FileStatus.$$$reportNull$$$0(7);
                }
                return rangeMarker;
            }
            if (old == WHOLE_FILE_DIRTY_MARKER) {
                RangeMarker rangeMarker = old;
                if (rangeMarker == null) {
                    FileStatus.$$$reportNull$$$0(8);
                }
                return rangeMarker;
            }
            TextRange oldRange = old.getTextRange();
            TextRange union = scope.union(oldRange);
            if (old.isValid() && union.equals(oldRange)) {
                RangeMarker rangeMarker = old;
                if (rangeMarker == null) {
                    FileStatus.$$$reportNull$$$0(9);
                }
                return rangeMarker;
            }
            if (union.getEndOffset() > textLength) {
                union = union.intersection(new TextRange(0, textLength));
            }
            assert (union != null);
            RangeMarker rangeMarker = document.createRangeMarker(union);
            if (rangeMarker == null) {
                FileStatus.$$$reportNull$$$0(10);
            }
            return rangeMarker;
        }

        public String toString() {
            @NonNls StringBuilder s = new StringBuilder();
            s.append("defensivelyMarked = ").append(this.defensivelyMarked);
            s.append("; wolfPassFinished = ").append(this.wolfPassFinished);
            s.append("; errorFound = ").append(this.errorFound);
            s.append("; dirtyScopes: (");
            this.dirtyScopes.forEach((passId, rangeMarker) -> s.append(" pass: ").append(passId).append(" -> ").append(rangeMarker == WHOLE_FILE_DIRTY_MARKER ? "Whole file" : rangeMarker).append(";"));
            s.append(")");
            return s.toString();
        }

        private void setDirtyScope(int passId, @Nullable RangeMarker scope) {
            RangeMarker marker = (RangeMarker)this.dirtyScopes.get(passId);
            if (marker != scope) {
                if (marker != null) {
                    marker.dispose();
                }
                this.dirtyScopes.put(passId, scope);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/FileStatusMap$FileStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/FileStatusMap$FileStatus";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "combineScopes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "markWholeFileDirty";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "combineScopesWith";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "combineScopes";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 6, 7, 8, 9, 10 -> new IllegalStateException(string2);
            };
        }
    }
}

