/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.PsiTodoSearchHelperImpl;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.CommonProcessors;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LongStack;
import com.intellij.util.containers.Stack;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GeneralHighlightingPass
extends ProgressableTextEditorHighlightingPass
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(GeneralHighlightingPass.class);
    private static final Key<Boolean> HAS_ERROR_ELEMENT = Key.create("HAS_ERROR_ELEMENT");
    static final Predicate<PsiFile> SHOULD_HIGHLIGHT_FILTER = file2 -> {
        HighlightingLevelManager manager = HighlightingLevelManager.getInstance(file2.getProject());
        return manager != null && manager.shouldHighlight((PsiElement)file2);
    };
    private static final Random RESTART_DAEMON_RANDOM = new Random();
    final boolean myUpdateAll;
    @NotNull
    final ProperTextRange myPriorityRange;
    final List<HighlightInfo> myHighlights;
    protected volatile boolean myHasErrorElement;
    private volatile boolean myHasErrorSeverity;
    private volatile boolean myErrorFound;
    final EditorColorsScheme myGlobalScheme;
    private volatile NotNullProducer<HighlightVisitor[]> myHighlightVisitorProducer;
    private static final Key<AtomicInteger> HIGHLIGHT_VISITOR_INSTANCE_COUNT = new Key("HIGHLIGHT_VISITOR_INSTANCE_COUNT");
    public static final int POST_UPDATE_ALL = 5;
    private static final AtomicInteger RESTART_REQUESTS = new AtomicInteger();

    GeneralHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor2, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (file2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(2);
        }
        if (highlightInfoProcessor == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(3);
        }
        super(file2.getProject(), document, GeneralHighlightingPass.getPresentableNameText(), file2, editor2, TextRange.create(startOffset, endOffset), true, highlightInfoProcessor);
        this.myHighlights = new ArrayList<HighlightInfo>();
        this.myHighlightVisitorProducer = this::cloneHighlightVisitors;
        this.myUpdateAll = updateAll;
        this.myPriorityRange = priorityRange;
        PsiUtilCore.ensureValid(file2);
        boolean wholeFileHighlighting = this.isWholeFileHighlighting();
        this.myHasErrorElement = !wholeFileHighlighting && Boolean.TRUE.equals(this.getFile().getUserData(HAS_ERROR_ELEMENT));
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        this.myErrorFound = !wholeFileHighlighting && fileStatusMap.wasErrorFound(this.getDocument());
        this.setProgressLimit(document.getTextLength() / 2);
        this.myGlobalScheme = editor2 != null ? editor2.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    private HighlightVisitor @NotNull [] cloneHighlightVisitors() {
        int oldCount = this.incVisitorUsageCount(1);
        HighlightVisitor[] highlightVisitors = HighlightVisitor.EP_HIGHLIGHT_VISITOR.getExtensions(this.myProject);
        if (oldCount != 0) {
            HighlightVisitor[] clones = new HighlightVisitor[highlightVisitors.length];
            for (int i2 = 0; i2 < highlightVisitors.length; ++i2) {
                HighlightVisitor highlightVisitor = highlightVisitors[i2];
                HighlightVisitor cloned = highlightVisitor.clone();
                assert (cloned.getClass() == highlightVisitor.getClass()) : highlightVisitor.getClass() + ".clone() must return a copy of " + highlightVisitor.getClass() + "; but got: " + cloned + " of " + cloned.getClass();
                clones[i2] = cloned;
            }
            highlightVisitors = clones;
        }
        if (highlightVisitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(5);
        }
        return highlightVisitors;
    }

    private HighlightVisitor @NotNull [] filterVisitors(HighlightVisitor @NotNull [] highlightVisitors, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(6);
        }
        if (highlightVisitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(7);
        }
        ArrayList<HighlightVisitor> visitors = new ArrayList<HighlightVisitor>(highlightVisitors.length);
        List<HighlightVisitor> list2 = Arrays.asList(highlightVisitors);
        for (HighlightVisitor visitor2 : DumbService.getInstance(this.myProject).filterByDumbAwareness(list2)) {
            if (visitor2 instanceof RainbowVisitor && !RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)this.getColorsScheme(), psiFile.getLanguage()) || !visitor2.suitableForFile(psiFile)) continue;
            visitors.add(visitor2);
        }
        if (visitors.isEmpty()) {
            LOG.error("No visitors registered. list=" + list2 + "; all visitors are:" + HighlightVisitor.EP_HIGHLIGHT_VISITOR.getExtensionList(this.myProject));
        }
        HighlightVisitor[] highlightVisitorArray = visitors.toArray(new HighlightVisitor[0]);
        if (highlightVisitorArray == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(8);
        }
        return highlightVisitorArray;
    }

    void setHighlightVisitorProducer(@NotNull NotNullProducer<HighlightVisitor[]> highlightVisitorProducer) {
        if (highlightVisitorProducer == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(9);
        }
        this.myHighlightVisitorProducer = highlightVisitorProducer;
    }

    HighlightVisitor @NotNull [] getHighlightVisitors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(10);
        }
        return this.filterVisitors(this.myHighlightVisitorProducer.produce(), psiFile);
    }

    int incVisitorUsageCount(int delta) {
        AtomicInteger count2 = this.myProject.getUserData(HIGHLIGHT_VISITOR_INSTANCE_COUNT);
        if (count2 == null) {
            count2 = ((UserDataHolderEx)((Object)this.myProject)).putUserDataIfAbsent(HIGHLIGHT_VISITOR_INSTANCE_COUNT, new AtomicInteger(0));
        }
        int old = count2.getAndAdd(delta);
        assert (old + delta >= 0) : old + ";" + delta;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ArrayList outsideResult = new ArrayList(100);
        ArrayList<HighlightInfo> insideResult = new ArrayList<HighlightInfo>(100);
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        HighlightVisitor[] filteredVisitors = this.getHighlightVisitors(this.getFile());
        try {
            ArrayList dividedElements = new ArrayList();
            Divider.divideInsideAndOutsideAllRoots(this.getFile(), this.myRestrictRange, this.myPriorityRange, SHOULD_HIGHLIGHT_FILTER, new CommonProcessors.CollectProcessor(dividedElements));
            List allInsideElements = ContainerUtil.concat(ContainerUtil.map(dividedElements, dividedForRoot -> {
                List<PsiElement> inside = dividedForRoot.inside;
                PsiElement lastInside = ContainerUtil.getLastItem(inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? inside.subList(0, inside.size() - 1) : inside;
            }));
            List<LongList> map2 = ContainerUtil.map(dividedElements, dividedForRoot -> {
                LongList insideRanges = dividedForRoot.insideRanges;
                PsiElement lastInside = ContainerUtil.getLastItem(dividedForRoot.inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? insideRanges.subList(0, insideRanges.size() - 1) : insideRanges;
            });
            LongList allInsideRanges = ContainerUtil.reduce(map2, new LongArrayList(map2.isEmpty() ? 1 : map2.get(0).size()), (l1, l2) -> {
                l1.addAll((LongList)l2);
                return l1;
            });
            List allOutsideElements = ContainerUtil.concat(ContainerUtil.map(dividedElements, dividedForRoot -> {
                List<PsiElement> outside = dividedForRoot.outside;
                PsiElement lastInside = ContainerUtil.getLastItem(dividedForRoot.inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? ContainerUtil.append(outside, lastInside) : outside;
            }));
            List<LongList> map1 = ContainerUtil.map(dividedElements, dividedForRoot -> {
                long lastInsideRange;
                LongList outsideRanges = dividedForRoot.outsideRanges;
                PsiElement lastInside = ContainerUtil.getLastItem(dividedForRoot.inside);
                long l = lastInsideRange = dividedForRoot.insideRanges.isEmpty() ? -1L : dividedForRoot.insideRanges.getLong(dividedForRoot.insideRanges.size() - 1);
                if (lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) && lastInsideRange != -1L) {
                    LongArrayList r = new LongArrayList(outsideRanges);
                    r.add(lastInsideRange);
                    return r;
                }
                return outsideRanges;
            });
            LongList allOutsideRanges = ContainerUtil.reduce(map1, new LongArrayList(map1.isEmpty() ? 1 : map1.get(0).size()), (l1, l2) -> {
                l1.addAll((LongList)l2);
                return l1;
            });
            this.setProgressLimit(allInsideElements.size() + allOutsideElements.size());
            boolean forceHighlightParents = this.forceHighlightParents();
            if (!this.isDumbMode() && this.getEditor() != null) {
                GeneralHighlightingPass.highlightTodos(this.getFile(), this.getDocument().getCharsSequence(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myPriorityRange, insideResult, outsideResult);
            }
            boolean success = this.collectHighlights(allInsideElements, allInsideRanges, allOutsideElements, allOutsideRanges, filteredVisitors, insideResult, outsideResult, forceHighlightParents);
            this.myHighlights.addAll(insideResult);
            this.myHighlights.addAll(outsideResult);
            if (success) {
                this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), outsideResult, this.myPriorityRange, this.myRestrictRange, this.getId());
                if (this.myUpdateAll) {
                    daemonCodeAnalyzer.getFileStatusMap().setErrorFoundFlag(this.myProject, this.getDocument(), this.myErrorFound);
                    this.reportErrorsToWolf(this.myHasErrorSeverity);
                }
            } else {
                GeneralHighlightingPass.cancelAndRestartDaemonLater(progress, this.myProject);
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
        }
    }

    private boolean isWholeFileHighlighting() {
        return this.myUpdateAll && this.myRestrictRange.equalsToRange(0, this.getDocument().getTextLength());
    }

    @Override
    protected void applyInformationWithProgress() {
        this.getFile().putUserData(HAS_ERROR_ELEMENT, this.myHasErrorElement);
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        return new ArrayList<HighlightInfo>(this.myHighlights);
    }

    private boolean collectHighlights(@NotNull List<? extends PsiElement> elements1, @NotNull LongList ranges1, @NotNull List<? extends PsiElement> elements2, @NotNull LongList ranges2, HighlightVisitor @NotNull [] visitors, @NotNull List<HighlightInfo> insideResult, @NotNull List<? super HighlightInfo> outsideResult, boolean forceHighlightParents) {
        if (elements1 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(12);
        }
        if (ranges1 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(13);
        }
        if (elements2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(14);
        }
        if (ranges2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(15);
        }
        if (insideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(16);
        }
        if (outsideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(17);
        }
        if (visitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(18);
        }
        HashSet skipParentsSet = new HashSet();
        HighlightInfoHolder holder = this.createInfoHolder(this.getFile());
        holder.getAnnotationSession().setVR(this.myPriorityRange);
        int chunkSize = Math.max(1, (elements1.size() + elements2.size()) / 100);
        boolean success = this.analyzeByVisitors(visitors, holder, 0, () -> {
            LongStack nestedRange = new LongStack();
            Stack<List<HighlightInfo>> nestedInfos = new Stack<List<HighlightInfo>>();
            this.runVisitors(elements1, ranges1, chunkSize, skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors, nestedRange, nestedInfos);
            boolean priorityIntersectionHasElements = this.myPriorityRange.intersectsStrict(this.myRestrictRange);
            if (!(elements1.isEmpty() && insideResult.isEmpty() || !priorityIntersectionHasElements)) {
                this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), insideResult, this.myPriorityRange, this.myRestrictRange, this.getId());
            }
            this.runVisitors(elements2, ranges2, chunkSize, skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors, nestedRange, nestedInfos);
        });
        ArrayList<HighlightInfo> postInfos = new ArrayList<HighlightInfo>(holder.size());
        for (int j = 0; j < holder.size(); ++j) {
            HighlightInfo info2 = holder.get(j);
            postInfos.add(info2);
            insideResult.add(info2);
        }
        this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), postInfos, this.getFile().getTextRange(), this.getFile().getTextRange(), 5);
        return success;
    }

    private boolean analyzeByVisitors(HighlightVisitor @NotNull [] visitors, @NotNull HighlightInfoHolder holder, int i2, @NotNull Runnable action2) {
        if (holder == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(19);
        }
        if (action2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(20);
        }
        if (visitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(21);
        }
        boolean[] success = new boolean[]{true};
        if (i2 == visitors.length) {
            action2.run();
        } else if (!visitors[i2].analyze(this.getFile(), this.myUpdateAll, holder, () -> {
            success[0] = this.analyzeByVisitors(visitors, holder, i2 + 1, action2);
        })) {
            success[0] = false;
        }
        return success[0];
    }

    private void runVisitors(@NotNull List<? extends PsiElement> elements, @NotNull LongList ranges2, int chunkSize, @NotNull Set<? super PsiElement> skipParentsSet, @NotNull HighlightInfoHolder holder, @NotNull List<? super HighlightInfo> insideResult, @NotNull List<? super HighlightInfo> outsideResult, boolean forceHighlightParents, HighlightVisitor @NotNull [] visitors, @NotNull LongStack nestedRange, @NotNull Stack<List<HighlightInfo>> nestedInfos) {
        if (elements == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(22);
        }
        if (ranges2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(23);
        }
        if (skipParentsSet == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(24);
        }
        if (holder == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(25);
        }
        if (insideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(26);
        }
        if (outsideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(27);
        }
        if (nestedRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(28);
        }
        if (nestedInfos == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(29);
        }
        if (visitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(30);
        }
        boolean failed = false;
        int nextLimit = chunkSize;
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            PsiElement element = elements.get(i2);
            ProgressManager.checkCanceled();
            PsiElement parent2 = element.getParent();
            if (element != this.getFile() && !skipParentsSet.isEmpty() && element.getFirstChild() != null && skipParentsSet.contains(element) && parent2 != null) {
                skipParentsSet.add(parent2);
                continue;
            }
            if (element instanceof PsiErrorElement) {
                this.myHasErrorElement = true;
            }
            for (HighlightVisitor visitor2 : visitors) {
                try {
                    visitor2.visit(element);
                }
                catch (ProcessCanceledException | IndexNotReadyException | AlreadyDisposedException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!failed) {
                        LOG.error("In file: " + this.getFile().getViewProvider().getVirtualFile(), e);
                    }
                    failed = true;
                }
            }
            if (i2 == nextLimit) {
                this.advanceProgress(chunkSize);
                nextLimit = i2 + chunkSize;
            }
            long elementRange = ranges2.getLong(i2);
            List<Object> infosForThisRange = holder.size() == 0 ? null : new ArrayList(holder.size());
            for (int j = 0; j < holder.size(); ++j) {
                boolean isError;
                HighlightInfo info2 = holder.get(j);
                if (!this.myRestrictRange.contains(info2)) continue;
                List<? super HighlightInfo> result2 = this.myPriorityRange.contains(info2) && !(element instanceof PsiFile) ? insideResult : outsideResult;
                result2.add(info2);
                boolean bl = isError = info2.getSeverity() == HighlightSeverity.ERROR;
                if (isError) {
                    if (!forceHighlightParents && parent2 != null) {
                        skipParentsSet.add(parent2);
                    }
                    this.myErrorFound = true;
                }
                info2.setVisitingTextRange(elementRange);
                infosForThisRange.add(info2);
            }
            holder.clear();
            while (!nestedRange.empty() && TextRangeScalarUtil.contains(elementRange, nestedRange.peek())) {
                long oldRange = nestedRange.pop();
                List<HighlightInfo> oldInfos = nestedInfos.pop();
                if (elementRange != oldRange) continue;
                if (infosForThisRange == null) {
                    infosForThisRange = oldInfos;
                    continue;
                }
                if (oldInfos == null) continue;
                infosForThisRange.addAll(oldInfos);
            }
            nestedRange.push(elementRange);
            nestedInfos.push(infosForThisRange);
            if (parent2 != null && GeneralHighlightingPass.hasSameRangeAsParent(parent2, element)) continue;
            this.myHighlightInfoProcessor.allHighlightsForRangeAreProduced(this.myHighlightingSession, elementRange, infosForThisRange);
        }
        this.advanceProgress(elements.size() - (nextLimit - chunkSize));
    }

    private static boolean hasSameRangeAsParent(@NotNull PsiElement parent2, @NotNull PsiElement element) {
        if (parent2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(31);
        }
        if (element == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(32);
        }
        return element.getStartOffsetInParent() == 0 && element.getTextLength() == parent2.getTextLength();
    }

    @TestOnly
    static boolean isRestartPending() {
        return RESTART_REQUESTS.get() > 0;
    }

    private static void cancelAndRestartDaemonLater(@NotNull ProgressIndicator progress, @NotNull Project project2) throws ProcessCanceledException {
        if (progress == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(33);
        }
        if (project2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(34);
        }
        RESTART_REQUESTS.incrementAndGet();
        progress.cancel();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            RESTART_REQUESTS.decrementAndGet();
            if (!project2.isDisposed()) {
                DaemonCodeAnalyzer.getInstance(project2).restart();
            }
        } else {
            int delay = RESTART_DAEMON_RANDOM.nextInt(100);
            EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
                RESTART_REQUESTS.decrementAndGet();
                if (!project2.isDisposed()) {
                    DaemonCodeAnalyzer.getInstance(project2).restart();
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }
        throw new ProcessCanceledException();
    }

    private boolean forceHighlightParents() {
        boolean forceHighlightParents = false;
        for (HighlightRangeExtension extension2 : HighlightRangeExtension.EP_NAME.getExtensionList()) {
            if (!extension2.isForceHighlightParents(this.getFile())) continue;
            forceHighlightParents = true;
            break;
        }
        return forceHighlightParents;
    }

    @NotNull
    protected HighlightInfoHolder createInfoHolder(@NotNull PsiFile file2) {
        if (file2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(35);
        }
        HighlightInfoFilter[] filters = HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions();
        final EditorColorsScheme actualScheme = this.getColorsScheme() == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.getColorsScheme();
        return new HighlightInfoHolder(file2, filters){

            @Override
            @NotNull
            public TextAttributesScheme getColorsScheme() {
                EditorColorsScheme editorColorsScheme = actualScheme;
                if (editorColorsScheme == null) {
                    1.$$$reportNull$$$0(0);
                }
                return editorColorsScheme;
            }

            @Override
            public boolean add(@Nullable HighlightInfo info2) {
                boolean added = super.add(info2);
                if (info2 != null && added) {
                    GeneralHighlightingPass.this.queueInfoToUpdateIncrementally(info2, info2.getGroup() == 0 ? 4 : info2.getGroup());
                }
                return added;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass$1", "getColorsScheme"));
            }
        };
    }

    void queueInfoToUpdateIncrementally(@NotNull HighlightInfo info2, int group2) {
        if (info2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(36);
        }
        if (info2.getSeverity() == HighlightSeverity.ERROR) {
            this.myHasErrorSeverity = true;
        }
        this.myHighlightInfoProcessor.infoIsAvailable(this.myHighlightingSession, info2, this.myPriorityRange, this.myRestrictRange, group2);
    }

    static void highlightTodos(@NotNull PsiFile file2, @NotNull CharSequence text2, int startOffset, int endOffset, @NotNull ProperTextRange priorityRange, @NotNull Collection<? super HighlightInfo> insideResult, @NotNull Collection<? super HighlightInfo> outsideResult) {
        TodoItem[] todoItems;
        PsiTodoSearchHelper helper;
        if (file2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(37);
        }
        if (text2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(38);
        }
        if (priorityRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(39);
        }
        if (insideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(40);
        }
        if (outsideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(41);
        }
        if ((helper = PsiTodoSearchHelper.getInstance((Project)file2.getProject())) == null || !GeneralHighlightingPass.shouldHighlightTodos(helper, file2)) {
            return;
        }
        for (TodoItem todoItem : todoItems = helper.findTodoItems(file2, startOffset, endOffset)) {
            ProgressManager.checkCanceled();
            TextRange textRange = todoItem.getTextRange();
            List additionalRanges = todoItem.getAdditionalTextRanges();
            String description = GeneralHighlightingPass.formatDescription(text2, textRange, additionalRanges);
            String tooltip = XmlStringUtil.escapeString(StringUtil.shortenPathWithEllipsis(description, 1024)).replace("\n", "<br>");
            TextAttributes attributes = todoItem.getPattern().getAttributes().getTextAttributes();
            GeneralHighlightingPass.addTodoItem(startOffset, endOffset, priorityRange, insideResult, outsideResult, attributes, description, tooltip, textRange);
            if (additionalRanges.isEmpty()) continue;
            TextAttributes attributesForAdditionalLines = attributes.clone();
            attributesForAdditionalLines.setErrorStripeColor(null);
            for (TextRange range : additionalRanges) {
                GeneralHighlightingPass.addTodoItem(startOffset, endOffset, priorityRange, insideResult, outsideResult, attributesForAdditionalLines, description, tooltip, range);
            }
        }
    }

    @NlsSafe
    private static String formatDescription(@NotNull CharSequence text2, @NotNull TextRange textRange, @NotNull List<? extends TextRange> additionalRanges) {
        if (text2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(42);
        }
        if (textRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(43);
        }
        if (additionalRanges == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(44);
        }
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add(textRange.subSequence(text2));
        for (TextRange textRange2 : additionalRanges) {
            joiner.add(textRange2.subSequence(text2));
        }
        return joiner.toString();
    }

    private static void addTodoItem(int restrictStartOffset, int restrictEndOffset, @NotNull ProperTextRange priorityRange, @NotNull Collection<? super HighlightInfo> insideResult, @NotNull Collection<? super HighlightInfo> outsideResult, @NotNull TextAttributes attributes, @NotNull @NlsContexts.DetailedDescription String description, @NotNull @NlsContexts.Tooltip String tooltip, @NotNull TextRange range) {
        if (priorityRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(45);
        }
        if (insideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(46);
        }
        if (outsideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(47);
        }
        if (attributes == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(48);
        }
        if (description == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(49);
        }
        if (tooltip == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(50);
        }
        if (range == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(51);
        }
        if (range.getStartOffset() >= restrictEndOffset || range.getEndOffset() <= restrictStartOffset) {
            return;
        }
        HighlightInfo info2 = HighlightInfo.newHighlightInfo(HighlightInfoType.TODO).range(range).textAttributes(attributes).description(description).escapedToolTip(tooltip).createUnconditionally();
        Collection<? super HighlightInfo> result2 = priorityRange.containsRange(info2.getStartOffset(), info2.getEndOffset()) ? insideResult : outsideResult;
        result2.add(info2);
    }

    private static boolean shouldHighlightTodos(@NotNull PsiTodoSearchHelper helper, @NotNull PsiFile file2) {
        if (helper == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(52);
        }
        if (file2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(53);
        }
        return helper instanceof PsiTodoSearchHelperImpl && ((PsiTodoSearchHelperImpl)helper).shouldHighlightInEditor(file2);
    }

    private void reportErrorsToWolf(boolean hasErrors) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!this.getFile().getViewProvider().isPhysical()) {
            return;
        }
        Project project2 = this.getFile().getProject();
        if (!PsiManager.getInstance(project2).isInProject(this.getFile())) {
            return;
        }
        VirtualFile file2 = this.getFile().getVirtualFile();
        if (file2 == null) {
            return;
        }
        List<Problem> problems = GeneralHighlightingPass.convertToProblems(this.getInfos(), file2, this.myHasErrorElement);
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance(project2);
        if (!hasErrors || this.isWholeFileHighlighting()) {
            wolf.reportProblems(file2, problems);
        } else {
            wolf.weHaveGotProblems(file2, problems);
        }
    }

    @NotNull
    private static List<Problem> convertToProblems(@NotNull Collection<? extends HighlightInfo> infos, @NotNull VirtualFile file2, boolean hasErrorElement) {
        if (infos == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(54);
        }
        if (file2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(55);
        }
        SmartList<Problem> problems = new SmartList<Problem>();
        for (HighlightInfo highlightInfo : infos) {
            if (highlightInfo.getSeverity() != HighlightSeverity.ERROR) continue;
            ProblemImpl problem = new ProblemImpl(file2, highlightInfo, hasErrorElement);
            problems.add(problem);
        }
        SmartList<Problem> smartList = problems;
        if (smartList == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(56);
        }
        return smartList;
    }

    @Override
    public String toString() {
        return super.toString() + " updateAll=" + this.myUpdateAll + " range=" + this.myRestrictRange;
    }

    @Nls
    private static String getPresentableNameText() {
        return AnalysisBundle.message("pass.syntax", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 56 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightVisitors";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightVisitorProducer";
                break;
            }
            case 11: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges2";
                break;
            }
            case 16: 
            case 26: 
            case 40: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insideResult";
                break;
            }
            case 17: 
            case 27: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outsideResult";
                break;
            }
            case 18: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitors";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipParentsSet";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedRange";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedInfos";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalRanges";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneHighlightVisitors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filterVisitors";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToProblems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 56: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterVisitors";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightVisitorProducer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightVisitors";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlights";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "analyzeByVisitors";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runVisitors";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasSameRangeAsParent";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRestartDaemonLater";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createInfoHolder";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "queueInfoToUpdateIncrementally";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "highlightTodos";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "formatDescription";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addTodoItem";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightTodos";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblems";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 8, 56 -> new IllegalStateException(string2);
        };
    }
}

