/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorMouseHoverPopupManager;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoNextErrorHandler
implements CodeInsightActionHandler {
    private final boolean myGoForward;

    public GotoNextErrorHandler(boolean goForward) {
        this.myGoForward = goForward;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(2);
        }
        int caretOffset = editor2.getCaretModel().getOffset();
        this.gotoNextError(project2, editor2, file2, caretOffset);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private void gotoNextError(Project project2, Editor editor2, PsiFile file2, int caretOffset) {
        int maxSeverity;
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        for (int idx = maxSeverity = (settings = DaemonCodeAnalyzerSettings.getInstance()).isNextErrorActionGoesToErrorsFirst() ? severityRegistrar.getSeveritiesCount() - 1 : 2; idx >= 2; --idx) {
            HighlightInfo infoToGo;
            HighlightSeverity minSeverity = severityRegistrar.getSeverityByIndex(idx);
            if (minSeverity == null || (infoToGo = this.findInfo(project2, editor2, caretOffset, minSeverity)) == null) continue;
            GotoNextErrorHandler.navigateToError(project2, editor2, infoToGo, () -> {
                if (Registry.is("error.navigation.show.tooltip")) {
                    HighlightInfo fullInfo = ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2)).findHighlightByOffset(editor2.getDocument(), editor2.getCaretModel().getOffset(), false);
                    HighlightInfo info2 = fullInfo != null ? fullInfo : infoToGo;
                    EditorMouseHoverPopupManager.getInstance().showInfoTooltip(editor2, info2, editor2.getCaretModel().getOffset(), false, true);
                }
            });
            return;
        }
        this.showMessageWhenNoHighlights(project2, file2, editor2, caretOffset);
    }

    private HighlightInfo findInfo(@NotNull Project project2, @NotNull Editor editor2, int caretOffset, @NotNull HighlightSeverity minSeverity) {
        if (project2 == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(4);
        }
        if (minSeverity == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(5);
        }
        Document document = editor2.getDocument();
        HighlightInfo[][] infoToGo = new HighlightInfo[2][2];
        int caretOffsetIfNoLuck = this.myGoForward ? -1 : document.getTextLength();
        DaemonCodeAnalyzerEx.processHighlights(document, project2, minSeverity, 0, document.getTextLength(), info2 -> {
            int startOffset = GotoNextErrorHandler.getNavigationPositionFor(info2, document);
            if (SeverityRegistrar.isGotoBySeverityEnabled(info2.getSeverity())) {
                infoToGo[0][0] = this.getBetterInfoThan(infoToGo[0][0], caretOffset, startOffset, (HighlightInfo)info2);
                infoToGo[1][0] = this.getBetterInfoThan(infoToGo[1][0], caretOffsetIfNoLuck, startOffset, (HighlightInfo)info2);
            }
            infoToGo[0][1] = this.getBetterInfoThan(infoToGo[0][1], caretOffset, startOffset, (HighlightInfo)info2);
            infoToGo[1][1] = this.getBetterInfoThan(infoToGo[1][1], caretOffsetIfNoLuck, startOffset, (HighlightInfo)info2);
            return true;
        });
        if (infoToGo[0][0] == null) {
            infoToGo[0][0] = infoToGo[1][0];
        }
        if (infoToGo[0][1] == null) {
            infoToGo[0][1] = infoToGo[1][1];
        }
        if (infoToGo[0][0] == null) {
            infoToGo[0][0] = infoToGo[0][1];
        }
        return infoToGo[0][0];
    }

    private HighlightInfo getBetterInfoThan(HighlightInfo infoToGo, int caretOffset, int startOffset, HighlightInfo info2) {
        if (this.isBetterThan(infoToGo, caretOffset, startOffset)) {
            infoToGo = info2;
        }
        return infoToGo;
    }

    private boolean isBetterThan(HighlightInfo oldInfo, int caretOffset, int newOffset) {
        if (oldInfo == null) {
            return true;
        }
        int oldOffset = GotoNextErrorHandler.getNavigationPositionFor(oldInfo, oldInfo.getHighlighter().getDocument());
        if (this.myGoForward) {
            return caretOffset < oldOffset != caretOffset < newOffset ? caretOffset < newOffset : newOffset < oldOffset;
        }
        return caretOffset <= oldOffset != caretOffset <= newOffset ? caretOffset > newOffset : newOffset > oldOffset;
    }

    private void showMessageWhenNoHighlights(final Project project2, final PsiFile file2, final Editor editor2, final int caretOffset) {
        DaemonCodeAnalyzerImpl codeHighlighter = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        if (codeHighlighter.isErrorAnalyzingFinished(file2)) {
            hintManager.showInformationHint(editor2, InspectionsBundle.message("no.errors.found.in.this.file", new Object[0]));
            return;
        }
        JComponent component2 = HintUtil.createInformationLabel((String)InspectionsBundle.message("error.analysis.is.in.progress", new Object[0]), null, null, null);
        AccessibleContextUtil.setName((Component)component2, IdeBundle.message((String)"information.hint.accessible.context.name", (Object[])new Object[0]));
        final LightweightHint hint = new LightweightHint(component2);
        Point p = hintManager.getHintPosition(hint, editor2, (short)1);
        Disposable hintDisposable = Disposer.newDisposable("GotoNextErrorHandler.showMessageWhenNoHighlights");
        Disposer.register(project2, hintDisposable);
        hint.addHintListener(eventObject -> Disposer.dispose(hintDisposable));
        MessageBusConnection busConnection = project2.getMessageBus().connect(hintDisposable);
        busConnection.subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, new DaemonCodeAnalyzer.DaemonListener(){

            @Override
            public void daemonFinished() {
                hint.hide();
                GotoNextErrorHandler.this.gotoNextError(project2, editor2, file2, caretOffset);
            }
        });
        hintManager.showEditorHint(hint, editor2, p, 42, 0, false, (short)1);
    }

    static void navigateToError(@NotNull Project project2, @NotNull Editor editor2, @NotNull HighlightInfo info2, @Nullable Runnable postNavigateRunnable) {
        if (project2 == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(7);
        }
        if (info2 == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(8);
        }
        int oldOffset = editor2.getCaretModel().getOffset();
        int offset2 = GotoNextErrorHandler.getNavigationPositionFor(info2, editor2.getDocument());
        int endOffset = info2.getActualEndOffset();
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        if (offset2 != oldOffset) {
            ScrollType scrollType = offset2 > oldOffset ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
            editor2.getSelectionModel().removeSelection();
            editor2.getCaretModel().removeSecondaryCarets();
            editor2.getCaretModel().moveToOffset(offset2);
            scrollingModel.scrollToCaret(scrollType);
            FoldRegion regionAtOffset = editor2.getFoldingModel().getCollapsedRegionAtOffset(offset2);
            if (regionAtOffset != null) {
                editor2.getFoldingModel().runBatchFoldingOperation(() -> regionAtOffset.setExpanded(true));
            }
        }
        scrollingModel.runActionOnScrollingFinished(() -> {
            int maxOffset = editor2.getDocument().getTextLength() - 1;
            if (maxOffset == -1) {
                return;
            }
            scrollingModel.scrollTo(editor2.offsetToLogicalPosition(Math.min(maxOffset, endOffset)), ScrollType.MAKE_VISIBLE);
            scrollingModel.scrollTo(editor2.offsetToLogicalPosition(Math.min(maxOffset, offset2)), ScrollType.MAKE_VISIBLE);
            if (postNavigateRunnable != null) {
                postNavigateRunnable.run();
            }
        });
        IdeDocumentHistory.getInstance((Project)project2).includeCurrentCommandAsNavigation();
        RangeHighlighterEx highlighter = info2.getHighlighter();
        if (highlighter != null) {
            ProblemsView.selectHighlighterIfVisible(project2, highlighter);
        }
    }

    private static int getNavigationPositionFor(HighlightInfo info2, Document document) {
        int start = info2.getActualStartOffset();
        if (start >= document.getTextLength()) {
            return document.getTextLength();
        }
        char c2 = document.getCharsSequence().charAt(start);
        int shift = info2.isAfterEndOfLine() && c2 != '\n' ? 1 : info2.navigationShift;
        int offset2 = info2.getActualStartOffset() + shift;
        return Math.min(offset2, document.getTextLength());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSeverity";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/GotoNextErrorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findInfo";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

