/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GutterTooltipBuilder {
    private static final JBColor SEPARATOR_COLOR = JBColor.namedColor("GutterTooltip.lineSeparatorColor", HintUtil.INFORMATION_BORDER_COLOR);
    private static final JBColor CONTEXT_HELP_FOREGROUND = JBColor.namedColor("GutterTooltip.infoForeground", new JBColor(0x787878, 0x878787));

    @NotNull
    protected abstract String getLinkProtocol();

    @Nullable
    protected abstract String getLinkReferenceText(@NotNull PsiElement var1);

    @Nullable
    protected abstract PsiElement getContainingElement(@NotNull PsiElement var1);

    protected abstract boolean shouldSkipAsFirstElement(@NotNull PsiElement var1);

    @Nullable
    protected abstract String getPresentableName(@NotNull PsiElement var1);

    @Nullable
    protected String getLocationString(@NotNull PsiElement element) {
        if (element == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(0);
        }
        return null;
    }

    @NotNull
    public <E extends PsiElement> String buildTooltipText(@NotNull Collection<E> elements, @NotNull String prefix, boolean skipFirstMember, @Nullable String actionId) {
        if (elements == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(2);
        }
        String string2 = this.buildTooltipText(elements, prefix, skipFirstMember, actionId, "press.to.navigate");
        if (string2 == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    protected <E extends PsiElement> String buildTooltipText(@NotNull Collection<E> elements, @NotNull String prefix, boolean skipFirstMember, @Nullable String actionId, @NotNull String pressMessageKey) {
        if (elements == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(5);
        }
        if (pressMessageKey == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(6);
        }
        String firstDivider = GutterTooltipBuilder.getElementDivider(true, true, elements.size());
        String nextDivider = GutterTooltipBuilder.getElementDivider(false, true, elements.size());
        AtomicReference<String> reference2 = new AtomicReference<String>(firstDivider);
        String string2 = this.buildTooltipText(prefix, elements, e -> reference2.getAndSet(nextDivider), e -> skipFirstMember, actionId, pressMessageKey);
        if (string2 == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(7);
        }
        return string2;
    }

    public static String getElementDivider(boolean firstElement, boolean marginLeft, int elementsCount) {
        if (elementsCount <= 1) {
            return " ";
        }
        StringBuilder sb = new StringBuilder("</p><p style='margin-top:2pt");
        if (marginLeft) {
            sb.append(";margin-left:20pt");
        }
        if (!firstElement) {
            sb.append(";border-top:thin solid #").append(ColorUtil.toHex(SEPARATOR_COLOR));
        }
        return sb.append(";'>").toString();
    }

    @NotNull
    public <E extends PsiElement> String buildTooltipText(@NotNull Collection<? extends E> elements, @NotNull Function<? super E, String> elementToPrefix, @NotNull Predicate<? super E> skipFirstMemberOfElement, @Nullable String actionId) {
        if (elements == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(8);
        }
        if (elementToPrefix == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(9);
        }
        if (skipFirstMemberOfElement == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(10);
        }
        String string2 = this.buildTooltipText(null, elements, elementToPrefix, skipFirstMemberOfElement, actionId, "press.to.navigate");
        if (string2 == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    protected <E extends PsiElement> String buildTooltipText(@Nullable String prefix, @NotNull Collection<? extends E> elements, @NotNull Function<? super E, String> elementToPrefix, @NotNull Predicate<? super E> skipFirstMemberOfElement, @Nullable String actionId, @NotNull String pressMessageKey) {
        if (elements == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(12);
        }
        if (elementToPrefix == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(13);
        }
        if (skipFirstMemberOfElement == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(14);
        }
        if (pressMessageKey == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(15);
        }
        StringBuilder sb = new StringBuilder("<html><body><p>");
        if (prefix != null) {
            sb.append(prefix);
        }
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element : elements) {
            StringBuilder elementBuilder = new StringBuilder();
            this.appendElement(elementBuilder, element, skipFirstMemberOfElement.test(element));
            if (!names.add(elementBuilder.toString())) continue;
            String elementPrefix = elementToPrefix.apply(element);
            if (elementPrefix != null) {
                sb.append(elementPrefix);
            }
            sb.append((CharSequence)elementBuilder);
        }
        GutterTooltipBuilder.appendContextHelp(sb, actionId, pressMessageKey);
        sb.append("</p></body></html>");
        String string2 = sb.toString();
        if (string2 == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(16);
        }
        return string2;
    }

    protected void appendElement(@NotNull StringBuilder sb, @NotNull PsiElement element, boolean skip) {
        boolean useSingleLink;
        if (sb == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(17);
        }
        if (element == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(18);
        }
        boolean addedSingleLink = (useSingleLink = Registry.is("gutter.tooltip.single.link")) && this.appendLink(sb, element);
        String locationString = this.getLocationString(element);
        PsiElement original = element;
        if (skip && this.shouldSkipAsFirstElement(element)) {
            element = this.getContainingElement(element);
        }
        while (element != null) {
            PsiElement parent2;
            String name = this.getPresentableName(element);
            if (name != null) {
                boolean addedLink = !useSingleLink && this.appendLink(sb, original != null ? original : element);
                original = null;
                sb.append(name);
                if (addedLink) {
                    sb.append("</code></a>");
                }
            }
            PsiElement psiElement = parent2 = element instanceof PsiFile ? null : this.getContainingElement(element);
            if (parent2 == null || parent2 instanceof PsiFile) {
                if (locationString == null) break;
                sb.append(locationString);
                break;
            }
            if (name != null) {
                sb.append(" ").append(LangBundle.message("tooltip.in", new Object[0])).append(" ");
            }
            element = parent2;
        }
        if (addedSingleLink) {
            sb.append("</code></a>");
        }
    }

    protected static void appendPackageName(@NotNull StringBuilder sb, @Nullable String name) {
        if (sb == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(19);
        }
        if (StringUtil.isEmpty(name)) {
            return;
        }
        sb.append(" <font color='#").append(ColorUtil.toHex(CONTEXT_HELP_FOREGROUND));
        sb.append("'><code>(").append(name).append(")</code></font>");
    }

    private static void appendContextHelp(@NotNull StringBuilder sb, @Nullable String actionId, String key) {
        if (sb == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(20);
        }
        if (actionId == null) {
            return;
        }
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        if (action2 == null) {
            return;
        }
        String text2 = KeymapUtil.getPreferredShortcutText((Shortcut[])action2.getShortcutSet().getShortcuts());
        if (StringUtil.isEmpty(text2)) {
            return;
        }
        sb.append("</p><p style='margin-top:8px;'><font size='2' color='#");
        sb.append(ColorUtil.toHex(CONTEXT_HELP_FOREGROUND));
        sb.append("'>").append(LangBundle.message(key, text2)).append("</font>");
    }

    protected boolean appendLink(@NotNull StringBuilder sb, @NotNull PsiElement element) {
        if (sb == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(21);
        }
        if (element == null) {
            GutterTooltipBuilder.$$$reportNull$$$0(22);
        }
        try {
            String name = this.getLinkReferenceText(element);
            if (!StringUtil.isEmpty(name)) {
                sb.append("<a href=\"#").append(this.getLinkProtocol()).append("/").append(name).append("\"><code>");
                return true;
            }
            VirtualFile file2 = PsiUtilCore.getVirtualFile(element);
            if (file2 == null) {
                return false;
            }
            int offset2 = element.getTextOffset();
            sb.append("<a href=\"#navigation/");
            sb.append(FileUtil.toSystemIndependentName(file2.getPath()));
            sb.append(":").append(offset2).append("\"><code>");
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/GutterTooltipBuilder";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pressMessageKey";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToPrefix";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipFirstMemberOfElement";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/GutterTooltipBuilder";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocationString";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildTooltipText";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 16: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendPackageName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendContextHelp";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendLink";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 7, 11, 16 -> new IllegalStateException(string2);
        };
    }
}

