/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoB;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitorBasedInspection;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.actions.DisableHighlightingIntentionAction;
import com.intellij.codeInsight.daemon.impl.actions.IntentionActionWithFixAllOption;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class HighlightInfo
implements Segment {
    private static final Logger LOG = Logger.getInstance(HighlightInfo.class);
    private static final String DESCRIPTION_PLACEHOLDER = "\u0000";
    private static final byte HAS_HINT_MASK = 1;
    private static final byte FROM_INJECTION_MASK = 2;
    private static final byte AFTER_END_OF_LINE_MASK = 4;
    private static final byte FILE_LEVEL_ANNOTATION_MASK = 8;
    private static final byte NEEDS_UPDATE_ON_TYPING_MASK = 16;
    private static final byte UNRESOLVED_REFERENCE_QUICK_FIXES_COMPUTED_MASK = 32;
    private int visitingRangeDeltaStartOffset;
    private int visitingRangeDeltaEndOffset;
    public final TextAttributes forcedTextAttributes;
    public final TextAttributesKey forcedTextAttributesKey;
    @NotNull
    public final HighlightInfoType type;
    public final int startOffset;
    public final int endOffset;
    @Deprecated
    public List<Pair<IntentionActionDescriptor, TextRange>> quickFixActionRanges;
    @Deprecated
    public List<Pair<IntentionActionDescriptor, RangeMarker>> quickFixActionMarkers;
    private final @NlsContexts.DetailedDescription String description;
    private final @NlsContexts.Tooltip String toolTip;
    @NotNull
    private final HighlightSeverity severity;
    private final GutterMark gutterIconRenderer;
    private final ProblemGroup myProblemGroup;
    private final String inspectionToolId;
    private int group;
    private long fixRange;
    private volatile byte myFlags;
    final int navigationShift;
    @Nullable
    private Object fileLevelComponentsStorage;
    @Nullable(value="null means it the same as highlighter")
    private @Nullable(value="null means it the same as highlighter") RangeMarker fixMarker;
    volatile RangeHighlighterEx highlighter;
    @Nullable
    final PsiElement psiElement;
    final PsiReference unresolvedReference;

    public synchronized <T> T findRegisteredQuickFix(@NotNull @NotNull BiFunction<? super @NotNull IntentionActionDescriptor, ? super @NotNull TextRange, ? extends @Nullable T> predicate2) {
        HashSet processed2;
        T result2;
        if (predicate2 == null) {
            HighlightInfo.$$$reportNull$$$0(0);
        }
        if ((result2 = HighlightInfo.find(this.quickFixActionMarkers, processed2 = new HashSet(), predicate2)) != null) {
            return result2;
        }
        return HighlightInfo.find(this.quickFixActionRanges, processed2, predicate2);
    }

    @Nullable
    private static <T> T find(@Nullable List<? extends Pair<IntentionActionDescriptor, ? extends Segment>> markers, @NotNull Set<? super IntentionActionDescriptor> processed2, @NotNull @NotNull BiFunction<? super @NotNull IntentionActionDescriptor, ? super @NotNull TextRange, ? extends T> predicate2) {
        if (processed2 == null) {
            HighlightInfo.$$$reportNull$$$0(1);
        }
        if (predicate2 == null) {
            HighlightInfo.$$$reportNull$$$0(2);
        }
        if (markers != null) {
            for (Pair<IntentionActionDescriptor, ? extends Segment> pair : markers) {
                IntentionActionDescriptor result2;
                IntentionActionDescriptor descriptor2;
                Segment segment = (Segment)pair.second;
                TextRange range = segment instanceof RangeMarker ? (((RangeMarker)segment).isValid() ? ((RangeMarker)segment).getTextRange() : null) : (TextRange)segment;
                if (range == null || !processed2.add(descriptor2 = (IntentionActionDescriptor)pair.first) || (result2 = predicate2.apply(descriptor2, range)) == null) continue;
                return (T)result2;
            }
        }
        return null;
    }

    @Deprecated
    @ApiStatus.Internal
    protected HighlightInfo(@Nullable TextAttributes forcedTextAttributes, @Nullable TextAttributesKey forcedTextAttributesKey, @NotNull HighlightInfoType type, int startOffset, int endOffset, @Nullable @NlsContexts.DetailedDescription String escapedDescription, @Nullable @NlsContexts.Tooltip String escapedToolTip, @NotNull HighlightSeverity severity, boolean afterEndOfLine, @Nullable Boolean needsUpdateOnTyping, boolean isFileLevelAnnotation, int navigationShift, ProblemGroup problemGroup, @Nullable String inspectionToolId, GutterMark gutterIconRenderer, int group2, @Nullable PsiReference unresolvedReference, @Nullable PsiElement psiElement) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(3);
        }
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(4);
        }
        if (startOffset < 0 || startOffset > endOffset) {
            LOG.error("Incorrect highlightInfo bounds. description=" + escapedDescription + "; startOffset=" + startOffset + "; endOffset=" + endOffset + ";type=" + type);
        }
        this.forcedTextAttributes = forcedTextAttributes;
        this.forcedTextAttributesKey = forcedTextAttributesKey;
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.fixRange = TextRangeScalarUtil.toScalarRange(startOffset, endOffset);
        this.description = escapedDescription;
        this.toolTip = HighlightInfo.encodeTooltip(escapedToolTip, escapedDescription);
        this.severity = severity;
        this.myFlags = (byte)((afterEndOfLine ? 4 : 0) | (HighlightInfo.calcNeedUpdateOnTyping(needsUpdateOnTyping, type) ? 16 : 0) | (isFileLevelAnnotation ? 8 : 0));
        this.navigationShift = navigationShift;
        this.myProblemGroup = problemGroup;
        this.gutterIconRenderer = gutterIconRenderer;
        this.inspectionToolId = inspectionToolId;
        this.group = group2;
        this.unresolvedReference = unresolvedReference;
        this.psiElement = psiElement;
    }

    @Nullable
    public static HighlightInfo fromRangeHighlighter(@NotNull RangeHighlighter highlighter) {
        Object errorStripeTooltip;
        if (highlighter == null) {
            HighlightInfo.$$$reportNull$$$0(5);
        }
        return (errorStripeTooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo ? (HighlightInfo)errorStripeTooltip : null;
    }

    @NotNull
    TextRange getFixTextRange() {
        TextRange textRange = TextRangeScalarUtil.create(this.fixRange);
        if (textRange == null) {
            HighlightInfo.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    void markFromInjection() {
        this.setFlag((byte)2, true);
    }

    void addFileLeverComponent(@NotNull FileEditor fileEditor, @NotNull JComponent component2) {
        if (fileEditor == null) {
            HighlightInfo.$$$reportNull$$$0(7);
        }
        if (component2 == null) {
            HighlightInfo.$$$reportNull$$$0(8);
        }
        if (this.fileLevelComponentsStorage == null) {
            this.fileLevelComponentsStorage = new Pair<FileEditor, JComponent>(fileEditor, component2);
        } else if (this.fileLevelComponentsStorage instanceof Pair) {
            Pair pair = (Pair)this.fileLevelComponentsStorage;
            HashMap<FileEditor, JComponent> map2 = new HashMap<FileEditor, JComponent>();
            map2.put((FileEditor)pair.first, (JComponent)pair.second);
            map2.put(fileEditor, component2);
            this.fileLevelComponentsStorage = map2;
        } else if (this.fileLevelComponentsStorage instanceof Map) {
            ((Map)this.fileLevelComponentsStorage).put(fileEditor, component2);
        } else {
            LOG.error(new IllegalStateException("fileLevelComponents=" + this.fileLevelComponentsStorage));
        }
    }

    void removeFileLeverComponent(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            HighlightInfo.$$$reportNull$$$0(9);
        }
        if (this.fileLevelComponentsStorage instanceof Pair) {
            Pair pair = (Pair)this.fileLevelComponentsStorage;
            if (pair.first == fileEditor) {
                this.fileLevelComponentsStorage = null;
            }
        } else if (this.fileLevelComponentsStorage instanceof Map) {
            ((Map)this.fileLevelComponentsStorage).remove(fileEditor);
        }
    }

    @Nullable
    JComponent getFileLevelComponent(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            HighlightInfo.$$$reportNull$$$0(10);
        }
        if (this.fileLevelComponentsStorage == null) {
            return null;
        }
        if (this.fileLevelComponentsStorage instanceof Pair) {
            Pair pair = (Pair)this.fileLevelComponentsStorage;
            return pair.first == fileEditor ? (JComponent)pair.second : null;
        }
        if (this.fileLevelComponentsStorage instanceof Map) {
            return (JComponent)((Map)this.fileLevelComponentsStorage).get(fileEditor);
        }
        LOG.error(new IllegalStateException("fileLevelComponents=" + this.fileLevelComponentsStorage));
        return null;
    }

    @Nullable
    @NlsContexts.Tooltip
    public String getToolTip() {
        String toolTip = this.toolTip;
        String description = this.description;
        if (toolTip == null || description == null || !toolTip.contains(DESCRIPTION_PLACEHOLDER)) {
            return toolTip;
        }
        String decoded = StringUtil.replace(toolTip, DESCRIPTION_PLACEHOLDER, XmlStringUtil.escapeString(description));
        return XmlStringUtil.wrapInHtml(decoded);
    }

    @NlsContexts.Tooltip
    private static String encodeTooltip(@NlsContexts.Tooltip String tooltip, @NlsContexts.DetailedDescription String description) {
        if (tooltip == null || description == null || description.isEmpty()) {
            return tooltip;
        }
        String encoded = StringUtil.replace(tooltip, XmlStringUtil.escapeString(description), DESCRIPTION_PLACEHOLDER);
        if (Strings.areSameInstance(encoded, tooltip)) {
            return tooltip;
        }
        if (encoded.equals(DESCRIPTION_PLACEHOLDER)) {
            encoded = DESCRIPTION_PLACEHOLDER;
        }
        return XmlStringUtil.stripHtml(encoded);
    }

    @NlsContexts.DetailedDescription
    public String getDescription() {
        return this.description;
    }

    @Nullable
    @NonNls
    public String getInspectionToolId() {
        return this.inspectionToolId;
    }

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet(this.myFlags, mask);
    }

    private void setFlag(@FlagConstant byte mask, boolean value) {
        this.myFlags = BitUtil.set(this.myFlags, mask, value);
    }

    boolean isFileLevelAnnotation() {
        return this.isFlagSet((byte)8);
    }

    void setVisitingTextRange(long range) {
        this.visitingRangeDeltaStartOffset = TextRangeScalarUtil.startOffset(range) - this.getStartOffset();
        this.visitingRangeDeltaEndOffset = TextRangeScalarUtil.endOffset(range) - this.getEndOffset();
    }

    long getVisitingTextRange() {
        int visitEnd;
        int visitStart = this.getActualStartOffset() + this.visitingRangeDeltaStartOffset;
        return TextRange.isProperRange(visitStart, visitEnd = this.getActualEndOffset() + this.visitingRangeDeltaEndOffset) ? TextRangeScalarUtil.toScalarRange(visitStart, visitEnd) : -1L;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.severity;
        if (highlightSeverity == null) {
            HighlightInfo.$$$reportNull$$$0(11);
        }
        return highlightSeverity;
    }

    public RangeHighlighterEx getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(@Nullable RangeHighlighterEx highlighter) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.highlighter = highlighter;
    }

    public boolean isAfterEndOfLine() {
        return this.isFlagSet((byte)4);
    }

    @Nullable
    public TextAttributes getTextAttributes(@Nullable PsiElement element, @Nullable EditorColorsScheme editorColorsScheme) {
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes;
        }
        EditorColorsScheme colorsScheme = HighlightInfo.getColorsScheme(editorColorsScheme);
        if (this.forcedTextAttributesKey != null) {
            return colorsScheme.getAttributes(this.forcedTextAttributesKey);
        }
        return HighlightInfo.getAttributesByType(element, this.type, (TextAttributesScheme)colorsScheme);
    }

    public static TextAttributes getAttributesByType(@Nullable PsiElement element, @NotNull HighlightInfoType type, @NotNull TextAttributesScheme colorsScheme) {
        SeverityRegistrar severityRegistrar;
        TextAttributes textAttributes;
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(12);
        }
        if (colorsScheme == null) {
            HighlightInfo.$$$reportNull$$$0(13);
        }
        if ((textAttributes = (severityRegistrar = SeverityRegistrar.getSeverityRegistrar(element != null ? element.getProject() : null)).getTextAttributesBySeverity(type.getSeverity(element))) != null) {
            return textAttributes;
        }
        TextAttributesKey key = type.getAttributesKey();
        return colorsScheme.getAttributes(key);
    }

    @Nullable
    Color getErrorStripeMarkColor(@NotNull PsiElement element, @Nullable(value="when null, the global scheme will be used") @Nullable(value="when null, the global scheme will be used") EditorColorsScheme colorsScheme) {
        Color errorStripeColor;
        TextAttributes forcedTextAttributes;
        if (element == null) {
            HighlightInfo.$$$reportNull$$$0(14);
        }
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes.getErrorStripeColor();
        }
        EditorColorsScheme scheme = HighlightInfo.getColorsScheme(colorsScheme);
        if (this.forcedTextAttributesKey != null && (forcedTextAttributes = scheme.getAttributes(this.forcedTextAttributesKey)) != null && (errorStripeColor = forcedTextAttributes.getErrorStripeColor()) != null) {
            return errorStripeColor;
        }
        if (this.getSeverity() == HighlightSeverity.ERROR) {
            return scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WARNING) {
            return scheme.getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.INFO) {
            return scheme.getAttributes(CodeInsightColors.INFO_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WEAK_WARNING) {
            return scheme.getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) {
            return scheme.getAttributes(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING).getErrorStripeColor();
        }
        TextAttributes attributes = HighlightInfo.getAttributesByType(element, this.type, (TextAttributesScheme)scheme);
        return attributes == null ? null : attributes.getErrorStripeColor();
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        EditorColorsScheme editorColorsScheme = customScheme != null ? customScheme : EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            HighlightInfo.$$$reportNull$$$0(15);
        }
        return editorColorsScheme;
    }

    public boolean needUpdateOnTyping() {
        return this.isFlagSet((byte)16);
    }

    private static boolean calcNeedUpdateOnTyping(@Nullable Boolean needsUpdateOnTyping, HighlightInfoType type) {
        if (needsUpdateOnTyping != null) {
            return needsUpdateOnTyping;
        }
        if (type instanceof HighlightInfoType.UpdateOnTypingSuppressible) {
            return ((HighlightInfoType.UpdateOnTypingSuppressible)((Object)type)).needsUpdateOnTyping();
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HighlightInfo)) {
            return false;
        }
        HighlightInfo info2 = (HighlightInfo)obj;
        return info2.getSeverity() == this.getSeverity() && info2.startOffset == this.startOffset && info2.endOffset == this.endOffset && Comparing.equal(info2.type, this.type) && Comparing.equal(info2.gutterIconRenderer, this.gutterIconRenderer) && Comparing.equal(info2.forcedTextAttributes, this.forcedTextAttributes) && Comparing.equal(info2.forcedTextAttributesKey, this.forcedTextAttributesKey) && Comparing.strEqual(info2.getDescription(), this.getDescription());
    }

    protected boolean equalsByActualOffset(@NotNull HighlightInfo info2) {
        if (info2 == null) {
            HighlightInfo.$$$reportNull$$$0(16);
        }
        if (info2 == this) {
            return true;
        }
        return info2.getSeverity() == this.getSeverity() && info2.getActualStartOffset() == this.getActualStartOffset() && info2.getActualEndOffset() == this.getActualEndOffset() && Comparing.equal(info2.type, this.type) && Comparing.equal(info2.gutterIconRenderer, this.gutterIconRenderer) && Comparing.equal(info2.forcedTextAttributes, this.forcedTextAttributes) && Comparing.equal(info2.forcedTextAttributesKey, this.forcedTextAttributesKey) && Comparing.strEqual(info2.getDescription(), this.getDescription());
    }

    public int hashCode() {
        return this.startOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNls
    public String toString() {
        String s = "HighlightInfo(" + this.startOffset + "," + this.endOffset + ")";
        if (this.getActualStartOffset() != this.startOffset || this.getActualEndOffset() != this.endOffset) {
            s = s + "; actual: (" + this.getActualStartOffset() + "," + this.getActualEndOffset() + ")";
        }
        if (this.highlighter != null) {
            s = s + " text='" + this.getText() + "'";
        }
        if (this.getDescription() != null) {
            s = s + ", description='" + this.getDescription() + "'";
        }
        s = s + "; severity=" + this.getSeverity();
        s = s + "; group=" + this.getGroup();
        HighlightInfo highlightInfo = this;
        synchronized (highlightInfo) {
            if (this.quickFixActionRanges != null) {
                s = s + "; quickFixes: " + this.quickFixActionRanges;
            }
        }
        if (this.gutterIconRenderer != null) {
            s = s + "; gutter: " + this.gutterIconRenderer;
        }
        return s;
    }

    @NotNull
    public static Builder newHighlightInfo(@NotNull HighlightInfoType type) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(17);
        }
        return new HighlightInfoB(type);
    }

    void setGroup(int group2) {
        this.group = group2;
    }

    public GutterMark getGutterIconRenderer() {
        return this.gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(18);
        }
        return HighlightInfo.fromAnnotation(annotation, false);
    }

    @NotNull
    static HighlightInfo fromAnnotation(@NotNull Annotation annotation, boolean batchMode) {
        List<Annotation.QuickFixInfo> fixes;
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(19);
        }
        TextAttributes forcedAttributes = annotation.getEnforcedTextAttributes();
        TextAttributesKey key = annotation.getTextAttributes();
        TextAttributesKey forcedAttributesKey = forcedAttributes == null && key != HighlighterColors.NO_HIGHLIGHTING ? key : null;
        PsiReference unresolvedReference = annotation.getUnresolvedReference();
        PsiElement psiElement = unresolvedReference == null ? null : unresolvedReference.getElement();
        HighlightInfo info2 = new HighlightInfo(forcedAttributes, forcedAttributesKey, HighlightInfo.convertType(annotation), annotation.getStartOffset(), annotation.getEndOffset(), annotation.getMessage(), annotation.getTooltip(), annotation.getSeverity(), annotation.isAfterEndOfLine(), annotation.needsUpdateOnTyping(), annotation.isFileLevelAnnotation(), 0, annotation.getProblemGroup(), null, (GutterMark)annotation.getGutterIconRenderer(), 4, unresolvedReference, psiElement);
        List<Annotation.QuickFixInfo> list2 = fixes = batchMode ? annotation.getBatchFixes() : annotation.getQuickFixes();
        if (fixes != null) {
            for (Annotation.QuickFixInfo quickFixInfo : fixes) {
                TextRange range = quickFixInfo.textRange;
                HighlightDisplayKey k = quickFixInfo.key != null ? quickFixInfo.key : HighlightDisplayKey.find("Annotator");
                info2.registerFix(quickFixInfo.quickFix, null, HighlightDisplayKey.getDisplayNameByKey(k), range, k);
            }
        }
        HighlightInfo highlightInfo = info2;
        if (highlightInfo == null) {
            HighlightInfo.$$$reportNull$$$0(20);
        }
        return highlightInfo;
    }

    @NotNull
    private static HighlightInfoType convertType(@NotNull Annotation annotation) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(21);
        }
        ProblemHighlightType type = annotation.getHighlightType();
        HighlightSeverity severity = annotation.getSeverity();
        return HighlightInfo.toHighlightInfoType(type, severity);
    }

    @NotNull
    private static HighlightInfoType toHighlightInfoType(ProblemHighlightType problemHighlightType, @NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(22);
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(23);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.WRONG_REF;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(24);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            HighlightInfoType highlightInfoType = HighlightInfoType.DEPRECATED;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(25);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.MARKED_FOR_REMOVAL;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(26);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.POSSIBLE_PROBLEM) {
            HighlightInfoType highlightInfoType = HighlightInfoType.POSSIBLE_PROBLEM;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(27);
            }
            return highlightInfoType;
        }
        return HighlightInfo.convertSeverity(severity);
    }

    @NotNull
    public static HighlightInfoType convertSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(28);
        }
        HighlightInfoType highlightInfoType = severity == HighlightSeverity.ERROR ? HighlightInfoType.ERROR : (severity == HighlightSeverity.WARNING ? HighlightInfoType.WARNING : (severity == HighlightSeverity.INFO ? HighlightInfoType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? HighlightInfoType.WEAK_WARNING : (severity == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING ? HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER : HighlightInfoType.INFORMATION))));
        if (highlightInfoType == null) {
            HighlightInfo.$$$reportNull$$$0(29);
        }
        return highlightInfoType;
    }

    @NotNull
    public static ProblemHighlightType convertType(@NotNull HighlightInfoType infoType) {
        if (infoType == null) {
            HighlightInfo.$$$reportNull$$$0(30);
        }
        if (infoType == HighlightInfoType.ERROR || infoType == HighlightInfoType.WRONG_REF) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.ERROR;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(31);
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.WARNING) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.WARNING;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(32);
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.INFORMATION) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.INFORMATION;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(33);
            }
            return problemHighlightType;
        }
        ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
        if (problemHighlightType == null) {
            HighlightInfo.$$$reportNull$$$0(34);
        }
        return problemHighlightType;
    }

    @NotNull
    public static ProblemHighlightType convertSeverityToProblemHighlight(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(35);
        }
        ProblemHighlightType problemHighlightType = severity == HighlightSeverity.ERROR ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.WARNING ? ProblemHighlightType.WARNING : (severity == HighlightSeverity.INFO ? ProblemHighlightType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION)));
        if (problemHighlightType == null) {
            HighlightInfo.$$$reportNull$$$0(36);
        }
        return problemHighlightType;
    }

    public boolean hasHint() {
        return this.isFlagSet((byte)1);
    }

    void setHint(boolean hasHint) {
        this.setFlag((byte)1, hasHint);
    }

    public int getActualStartOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.startOffset : h.getStartOffset();
    }

    public int getActualEndOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.endOffset : h.getEndOffset();
    }

    @Override
    public int getStartOffset() {
        return this.getActualStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.getActualEndOffset();
    }

    int getGroup() {
        return this.group;
    }

    boolean isFromInjection() {
        return this.isFlagSet((byte)2);
    }

    @NotNull
    public String getText() {
        if (this.isFileLevelAnnotation()) {
            return "";
        }
        RangeHighlighterEx highlighter = this.highlighter;
        if (highlighter == null) {
            throw new RuntimeException("info not applied yet");
        }
        if (!highlighter.isValid()) {
            return "";
        }
        String string2 = highlighter.getDocument().getText(highlighter.getTextRange());
        if (string2 == null) {
            HighlightInfo.$$$reportNull$$$0(37);
        }
        return string2;
    }

    @Deprecated
    public synchronized void registerFix(@Nullable IntentionAction action2, @Nullable List<? extends IntentionAction> options2, @Nullable @Nls String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        RangeHighlighterEx myHighlighter;
        if (action2 == null) {
            return;
        }
        if (fixRange == null) {
            fixRange = new TextRange(this.getActualStartOffset(), this.getActualEndOffset());
        }
        if (this.quickFixActionRanges == null) {
            this.quickFixActionRanges = ContainerUtil.createLockFreeCopyOnWriteList();
        }
        IntentionActionDescriptor desc = new IntentionActionDescriptor(action2, options2, displayName, null, key, this.getProblemGroup(), this.getSeverity());
        this.quickFixActionRanges.add(Pair.create(desc, fixRange));
        if (this.fixMarker != null && this.fixMarker.isValid()) {
            this.fixRange = TextRangeScalarUtil.toScalarRange(this.fixMarker);
        } else {
            Document document;
            RangeMarker fixMarker = this.fixMarker;
            RangeHighlighterEx highlighter = this.highlighter;
            Document document2 = fixMarker != null ? fixMarker.getDocument() : (highlighter != null ? highlighter.getDocument() : (document = this.quickFixActionMarkers != null && !this.quickFixActionMarkers.isEmpty() && this.quickFixActionMarkers.get(0).getSecond() != null ? this.quickFixActionMarkers.get(0).getSecond().getDocument() : null));
            if (document != null) {
                int newEnd = Math.min(document.getTextLength(), TextRangeScalarUtil.endOffset(this.fixRange));
                int newStart = Math.min(newEnd, TextRangeScalarUtil.startOffset(this.fixRange));
                this.fixRange = TextRangeScalarUtil.toScalarRange(newStart, newEnd);
            }
        }
        this.fixRange = TextRangeScalarUtil.union(this.fixRange, TextRangeScalarUtil.toScalarRange(fixRange));
        if (action2 instanceof HintAction) {
            this.setHint(true);
        }
        if ((myHighlighter = this.highlighter) != null && myHighlighter.isValid()) {
            long highlighterRange = TextRangeScalarUtil.toScalarRange((Segment)myHighlighter);
            Long2ObjectMap<RangeMarker> cache2 = this.reuseRangeMarkerCacheIfCreated(highlighterRange);
            this.updateQuickFixFields(myHighlighter.getDocument(), cache2, highlighterRange);
        }
    }

    @NotNull
    private Long2ObjectMap<RangeMarker> reuseRangeMarkerCacheIfCreated(long targetRange) {
        Long2ObjectOpenHashMap<RangeMarker> cache2 = new Long2ObjectOpenHashMap<RangeMarker>();
        if (this.quickFixActionMarkers != null) {
            for (Pair<IntentionActionDescriptor, RangeMarker> pair : this.quickFixActionMarkers) {
                RangeMarker marker = pair.getSecond();
                if (!marker.isValid() || TextRangeScalarUtil.toScalarRange(marker) != targetRange) continue;
                cache2.put(targetRange, marker);
                break;
            }
        }
        Long2ObjectOpenHashMap<RangeMarker> long2ObjectOpenHashMap = cache2;
        if (long2ObjectOpenHashMap == null) {
            HighlightInfo.$$$reportNull$$$0(38);
        }
        return long2ObjectOpenHashMap;
    }

    public synchronized void unregisterQuickFix(@NotNull Condition<? super IntentionAction> condition) {
        if (condition == null) {
            HighlightInfo.$$$reportNull$$$0(39);
        }
        if (this.quickFixActionRanges != null) {
            this.quickFixActionRanges.removeIf(pair -> condition.value(((IntentionActionDescriptor)pair.first).getAction()));
        }
        if (this.quickFixActionMarkers != null) {
            this.quickFixActionMarkers.removeIf(pair -> condition.value(((IntentionActionDescriptor)pair.first).getAction()));
        }
    }

    public synchronized IntentionAction getSameFamilyFix(@NotNull IntentionActionWithFixAllOption action2) {
        if (action2 == null) {
            HighlightInfo.$$$reportNull$$$0(40);
        }
        if (this.quickFixActionRanges == null) {
            return null;
        }
        for (Pair<IntentionActionDescriptor, TextRange> range : this.quickFixActionRanges) {
            IntentionAction other = IntentionActionDelegate.unwrap(((IntentionActionDescriptor)range.first).myAction);
            if (!(other instanceof IntentionActionWithFixAllOption) || !action2.belongsToMyFamily((IntentionActionWithFixAllOption)other)) continue;
            return other;
        }
        return null;
    }

    boolean containsOffset(int offset2, boolean includeFixRange) {
        RangeHighlighterEx highlighter = this.getHighlighter();
        if (highlighter == null || !highlighter.isValid()) {
            return false;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        if (startOffset <= offset2 && offset2 <= endOffset) {
            return true;
        }
        if (!includeFixRange) {
            return false;
        }
        RangeMarker fixMarker = this.fixMarker;
        if (fixMarker != null) {
            if (!fixMarker.isValid()) {
                return false;
            }
            startOffset = fixMarker.getStartOffset();
            endOffset = fixMarker.getEndOffset();
            return startOffset <= offset2 && offset2 <= endOffset;
        }
        return TextRangeScalarUtil.containsOffset(this.fixRange, offset2);
    }

    @NotNull
    private static RangeMarker getOrCreate(@NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> ranges2markersCache, long textRange) {
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(41);
        }
        if (ranges2markersCache == null) {
            HighlightInfo.$$$reportNull$$$0(42);
        }
        RangeMarker rangeMarker = ranges2markersCache.computeIfAbsent(textRange, __ -> document.createRangeMarker(TextRangeScalarUtil.startOffset(textRange), TextRangeScalarUtil.endOffset(textRange)));
        if (rangeMarker == null) {
            HighlightInfo.$$$reportNull$$$0(43);
        }
        return rangeMarker;
    }

    synchronized void updateQuickFixFields(@NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> ranges2markersCache, long finalHighlighterRange) {
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(44);
        }
        if (ranges2markersCache == null) {
            HighlightInfo.$$$reportNull$$$0(45);
        }
        if (this.quickFixActionMarkers != null && this.quickFixActionRanges != null && this.quickFixActionRanges.size() == this.quickFixActionMarkers.size() + 1) {
            Pair<IntentionActionDescriptor, TextRange> last2 = ContainerUtil.getLastItem(this.quickFixActionRanges);
            Segment textRange = last2.getSecond();
            RangeMarker marker = HighlightInfo.getOrCreate(document, ranges2markersCache, TextRangeScalarUtil.toScalarRange(textRange));
            this.quickFixActionMarkers.add(Pair.create(last2.getFirst(), marker));
            return;
        }
        if (this.quickFixActionRanges != null && this.quickFixActionMarkers == null) {
            ArrayList<Pair<IntentionActionDescriptor, RangeMarker>> list2 = new ArrayList<Pair<IntentionActionDescriptor, RangeMarker>>(this.quickFixActionRanges.size());
            for (Pair<IntentionActionDescriptor, TextRange> pair : this.quickFixActionRanges) {
                TextRange textRange = (TextRange)pair.second;
                RangeMarker marker = HighlightInfo.getOrCreate(document, ranges2markersCache, TextRangeScalarUtil.toScalarRange(textRange));
                list2.add(Pair.create((IntentionActionDescriptor)pair.first, marker));
            }
            this.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList(list2);
        }
        this.fixMarker = this.fixRange == finalHighlighterRange ? null : HighlightInfo.getOrCreate(document, ranges2markersCache, this.fixRange);
    }

    @ApiStatus.Internal
    boolean isUnresolvedReference() {
        return this.unresolvedReference != null || this.type.getAttributesKey().equals(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
    }

    boolean isUnresolvedReferenceQuickFixesComputed() {
        return this.isFlagSet((byte)32);
    }

    void setUnresolvedReferenceQuickFixesComputed() {
        this.setFlag((byte)32, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 15, 20, 23, 24, 25, 26, 27, 29, 31, 32, 33, 34, 36, 37, 38, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 3: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 22: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoType";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges2markersCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixTextRange";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotation";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "toHighlightInfoType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeverity";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "convertType";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeverityToProblemHighlight";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "reuseRangeMarkerCacheIfCreated";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromRangeHighlighter";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 43: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFileLeverComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFileLeverComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileLevelComponent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesByType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getErrorStripeMarkColor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "equalsByActualOffset";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "newHighlightInfo";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fromAnnotation";
                break;
            }
            case 21: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "convertType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "toHighlightInfoType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "convertSeverity";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "convertSeverityToProblemHighlight";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "unregisterQuickFix";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSameFamilyFix";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateQuickFixFields";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 11, 15, 20, 23, 24, 25, 26, 27, 29, 31, 32, 33, 34, 36, 37, 38, 43 -> new IllegalStateException(string2);
        };
    }

    public static class IntentionActionDescriptor {
        private final IntentionAction myAction;
        volatile List<? extends IntentionAction> myOptions;
        volatile HighlightDisplayKey myKey;
        private final ProblemGroup myProblemGroup;
        private final HighlightSeverity mySeverity;
        @Nls
        private final String myDisplayName;
        private final Icon myIcon;
        private Boolean myCanCleanup;

        public IntentionActionDescriptor(@NotNull IntentionAction action2, @Nullable List<? extends IntentionAction> options2, @Nullable @Nls String displayName, @Nullable Icon icon2, @Nullable HighlightDisplayKey key, @Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity) {
            if (action2 == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(0);
            }
            this.myAction = action2;
            this.myOptions = options2;
            this.myDisplayName = displayName;
            this.myIcon = icon2;
            this.myKey = key;
            this.myProblemGroup = problemGroup;
            this.mySeverity = severity;
        }

        @Nullable
        IntentionActionDescriptor copyWithEmptyAction() {
            if (this.myKey == null || this.myKey.getID().equals("Annotator")) {
                return null;
            }
            String displayName = HighlightDisplayKey.getDisplayNameByKey(this.myKey);
            if (displayName == null) {
                return null;
            }
            return new IntentionActionDescriptor(new EmptyIntentionAction(displayName), this.myOptions, this.myDisplayName, this.myIcon, this.myKey, this.myProblemGroup, this.mySeverity);
        }

        @NotNull
        public IntentionAction getAction() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(1);
            }
            return intentionAction;
        }

        boolean isError() {
            return this.mySeverity == null || this.mySeverity.compareTo(HighlightSeverity.ERROR) >= 0;
        }

        boolean isInformation() {
            return HighlightSeverity.INFORMATION.equals(this.mySeverity);
        }

        boolean canCleanup(@NotNull PsiElement element) {
            if (element == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(2);
            }
            if (this.myCanCleanup == null) {
                InspectionToolWrapper toolWrapper;
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
                HighlightDisplayKey key = this.myKey;
                this.myCanCleanup = key == null ? Boolean.valueOf(false) : Boolean.valueOf((toolWrapper = profile.getInspectionTool(key.toString(), element)) != null && toolWrapper.isCleanupTool());
            }
            return this.myCanCleanup;
        }

        @NotNull
        public Iterable<? extends IntentionAction> getOptions(@NotNull PsiElement element, @Nullable Editor editor2) {
            HighlightDisplayKey idKey;
            IntentionAction action2;
            if (element == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(3);
            }
            if (editor2 != null && Boolean.FALSE.equals(editor2.getUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY))) {
                List list2 = Collections.emptyList();
                if (list2 == null) {
                    IntentionActionDescriptor.$$$reportNull$$$0(4);
                }
                return list2;
            }
            List<? extends IntentionAction> options2 = this.myOptions;
            if (options2 != null) {
                List<? extends IntentionAction> list3 = options2;
                if (list3 == null) {
                    IntentionActionDescriptor.$$$reportNull$$$0(5);
                }
                return list3;
            }
            HighlightDisplayKey key = this.myKey;
            if (this.myProblemGroup != null) {
                HighlightDisplayKey problemGroupKey;
                String problemName = this.myProblemGroup.getProblemName();
                HighlightDisplayKey highlightDisplayKey = problemGroupKey = problemName != null ? HighlightDisplayKey.findById(problemName) : null;
                if (problemGroupKey != null) {
                    key = problemGroupKey;
                }
            }
            if ((action2 = IntentionActionDelegate.unwrap(this.myAction)) instanceof IntentionActionWithOptions) {
                IntentionActionWithOptions wo = (IntentionActionWithOptions)action2;
                if (!(key != null && wo.getCombiningPolicy() != IntentionActionWithOptions.CombiningPolicy.IntentionOptionsOnly || (options2 = wo.getOptions()).isEmpty())) {
                    return this.updateOptions(options2);
                }
            }
            if (key == null) {
                List list4 = Collections.emptyList();
                if (list4 == null) {
                    IntentionActionDescriptor.$$$reportNull$$$0(6);
                }
                return list4;
            }
            IntentionManager intentionManager = IntentionManager.getInstance();
            List<IntentionAction> newOptions = intentionManager.getStandardIntentionOptions(key, element);
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
            InspectionToolWrapper toolWrapper = profile.getInspectionTool(key.toString(), element);
            if (!(toolWrapper instanceof LocalInspectionToolWrapper) && (idKey = HighlightDisplayKey.findById(key.toString())) != null) {
                toolWrapper = profile.getInspectionTool(idKey.toString(), element);
            }
            if (toolWrapper != null) {
                Object wrappedTool;
                this.myCanCleanup = toolWrapper.isCleanupTool();
                IntentionAction fixAllIntention = intentionManager.createFixAllIntention(toolWrapper, this.myAction);
                Object t = wrappedTool = toolWrapper instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)toolWrapper).getTool() : ((GlobalInspectionToolWrapper)toolWrapper).getTool();
                if (wrappedTool instanceof HighlightVisitorBasedInspection) {
                    List<Object> actions = Collections.emptyList();
                    if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                        actions = Arrays.asList(((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element));
                    }
                    if (fixAllIntention != null) {
                        if (actions.isEmpty()) {
                            List<IntentionAction> list5 = Collections.singletonList(fixAllIntention);
                            if (list5 == null) {
                                IntentionActionDescriptor.$$$reportNull$$$0(7);
                            }
                            return list5;
                        }
                        actions = new ArrayList(actions);
                        actions.add(fixAllIntention);
                    }
                    List list6 = actions;
                    if (list6 == null) {
                        IntentionActionDescriptor.$$$reportNull$$$0(8);
                    }
                    return list6;
                }
                if (!(action2 instanceof EmptyIntentionAction)) {
                    newOptions.add(new DisableHighlightingIntentionAction(toolWrapper.getShortName()));
                }
                ContainerUtil.addIfNotNull(newOptions, fixAllIntention);
                if (wrappedTool instanceof CustomSuppressableInspectionTool) {
                    SuppressIntentionAction[] suppressActions = ((CustomSuppressableInspectionTool)wrappedTool).getSuppressActions(element);
                    if (suppressActions != null) {
                        ContainerUtil.addAll(newOptions, suppressActions);
                    }
                } else {
                    SuppressQuickFix[] suppressFixes = ((InspectionProfileEntry)wrappedTool).getBatchSuppressActions(element);
                    if (suppressFixes.length > 0) {
                        newOptions.addAll(ContainerUtil.map(suppressFixes, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction));
                    }
                }
            }
            if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                SuppressIntentionAction[] suppressActions = ((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element);
                ContainerUtil.addAll(newOptions, suppressActions);
            }
            return this.updateOptions(newOptions);
        }

        @NotNull
        private synchronized List<? extends IntentionAction> updateOptions(@NotNull List<? extends IntentionAction> newOptions) {
            List<? extends IntentionAction> options2;
            if (newOptions == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(9);
            }
            if ((options2 = this.myOptions) == null) {
                this.myOptions = options2 = newOptions;
            }
            this.myKey = null;
            List<? extends IntentionAction> list2 = options2;
            if (list2 == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(10);
            }
            return list2;
        }

        @Nullable
        @Nls
        public String getDisplayName() {
            return this.myDisplayName;
        }

        public String toString() {
            String text2 = this.getAction().getText();
            return "IntentionActionDescriptor: " + (text2.isEmpty() ? IntentionActionDelegate.unwrap(this.getAction()).getClass() : text2 + " (" + IntentionActionDelegate.unwrap(this.getAction()).getClass() + ")");
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        public boolean equals(Object obj) {
            return obj instanceof IntentionActionDescriptor && this.myAction.equals(((IntentionActionDescriptor)obj).myAction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 5, 6, 7, 8, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canCleanup";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getOptions";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "updateOptions";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 4, 5, 6, 7, 8, 10 -> new IllegalStateException(string2);
            };
        }
    }

    @ApiStatus.NonExtendable
    public static interface Builder {
        @NotNull
        public Builder range(@NotNull TextRange var1);

        @NotNull
        public Builder range(@NotNull ASTNode var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1, @NotNull TextRange var2);

        @NotNull
        public Builder range(@NotNull PsiElement var1, int var2, int var3);

        @NotNull
        public Builder range(int var1, int var2);

        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer var1);

        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup var1);

        @NotNull
        public Builder inspectionToolId(@NotNull String var1);

        @NotNull
        public Builder description(@NlsContexts.DetailedDescription @NotNull String var1);

        @NotNull
        public Builder descriptionAndTooltip(@NlsContexts.DetailedDescription @NotNull String var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributes var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey var1);

        @NotNull
        public Builder unescapedToolTip(@NlsContexts.Tooltip @NotNull String var1);

        @NotNull
        public Builder escapedToolTip(@NlsContexts.Tooltip @NotNull String var1);

        @NotNull
        public Builder endOfLine();

        @NotNull
        public Builder needsUpdateOnTyping(boolean var1);

        @NotNull
        public Builder severity(@NotNull HighlightSeverity var1);

        @NotNull
        public Builder fileLevelAnnotation();

        @NotNull
        public Builder navigationShift(int var1);

        @NotNull
        public Builder group(int var1);

        @NotNull
        public Builder registerFix(@NotNull IntentionAction var1, @Nullable List<? extends IntentionAction> var2, @Nullable @Nls String var3, @Nullable TextRange var4, @Nullable HighlightDisplayKey var5);

        @Nullable(value="null means filtered out")
        public @Nullable(value="null means filtered out") HighlightInfo create();

        @NotNull
        public HighlightInfo createUnconditionally();
    }

    private static @interface FlagConstant {
    }
}

