/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HighlightInfoB
implements HighlightInfo.Builder {
    private static final Logger LOG = Logger.getInstance(HighlightInfoB.class);
    private Boolean myNeedsUpdateOnTyping;
    private TextAttributes forcedTextAttributes;
    private TextAttributesKey forcedTextAttributesKey;
    private final HighlightInfoType type;
    private int startOffset;
    private int endOffset;
    private @NlsContexts.DetailedDescription String escapedDescription;
    private @NlsContexts.Tooltip String escapedToolTip;
    private HighlightSeverity severity;
    private boolean isAfterEndOfLine;
    private boolean isFileLevelAnnotation;
    private int navigationShift;
    private GutterIconRenderer gutterIconRenderer;
    private ProblemGroup problemGroup;
    private String inspectionToolId;
    private PsiElement psiElement;
    private int group;
    private final List<FixInfo> fixes;
    private boolean created;
    private PsiReference unresolvedReference;

    HighlightInfoB(@NotNull HighlightInfoType type) {
        if (type == null) {
            HighlightInfoB.$$$reportNull$$$0(0);
        }
        this.startOffset = -1;
        this.endOffset = -1;
        this.fixes = new ArrayList<FixInfo>();
        this.type = type;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
        if (gutterIconRenderer == null) {
            HighlightInfoB.$$$reportNull$$$0(1);
        }
        this.assertNotCreated();
        assert (this.gutterIconRenderer == null) : "gutterIconRenderer already set";
        this.gutterIconRenderer = gutterIconRenderer;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(2);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder problemGroup(@NotNull ProblemGroup problemGroup) {
        if (problemGroup == null) {
            HighlightInfoB.$$$reportNull$$$0(3);
        }
        this.assertNotCreated();
        assert (this.problemGroup == null) : "problemGroup already set";
        this.problemGroup = problemGroup;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(4);
        }
        return highlightInfoB;
    }

    private void assertNotCreated() {
        assert (!this.created) : "Must not call this method after Builder.create() was called";
    }

    @Override
    @NotNull
    public HighlightInfo.Builder inspectionToolId(@NotNull String inspectionToolId) {
        if (inspectionToolId == null) {
            HighlightInfoB.$$$reportNull$$$0(5);
        }
        this.assertNotCreated();
        assert (this.inspectionToolId == null) : "inspectionToolId already set";
        this.inspectionToolId = inspectionToolId;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(6);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder description(@NotNull String description) {
        if (description == null) {
            HighlightInfoB.$$$reportNull$$$0(7);
        }
        this.assertNotCreated();
        assert (this.escapedDescription == null) : "description already set";
        this.escapedDescription = description;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(8);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder descriptionAndTooltip(@NotNull String description) {
        if (description == null) {
            HighlightInfoB.$$$reportNull$$$0(9);
        }
        HighlightInfo.Builder builder2 = this.description(description).unescapedToolTip(description);
        if (builder2 == null) {
            HighlightInfoB.$$$reportNull$$$0(10);
        }
        return builder2;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder textAttributes(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            HighlightInfoB.$$$reportNull$$$0(11);
        }
        this.assertNotCreated();
        assert (this.forcedTextAttributes == null) : "textAttributes already set";
        this.forcedTextAttributes = attributes;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(12);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder textAttributes(@NotNull TextAttributesKey attributesKey) {
        if (attributesKey == null) {
            HighlightInfoB.$$$reportNull$$$0(13);
        }
        this.assertNotCreated();
        assert (this.forcedTextAttributesKey == null) : "textAttributesKey already set";
        this.forcedTextAttributesKey = attributesKey;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(14);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder unescapedToolTip(@NotNull String unescapedToolTip) {
        if (unescapedToolTip == null) {
            HighlightInfoB.$$$reportNull$$$0(15);
        }
        this.assertNotCreated();
        assert (this.escapedToolTip == null) : "Tooltip was already set";
        this.escapedToolTip = HighlightInfoB.htmlEscapeToolTip(unescapedToolTip);
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(16);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder escapedToolTip(@NotNull String escapedToolTip) {
        if (escapedToolTip == null) {
            HighlightInfoB.$$$reportNull$$$0(17);
        }
        this.assertNotCreated();
        assert (this.escapedToolTip == null) : "Tooltip was already set";
        this.escapedToolTip = escapedToolTip;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(18);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(int start, int end) {
        this.assertNotCreated();
        assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
        this.startOffset = start;
        this.endOffset = end;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(19);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(@NotNull TextRange textRange) {
        if (textRange == null) {
            HighlightInfoB.$$$reportNull$$$0(20);
        }
        this.assertNotCreated();
        assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
        this.startOffset = textRange.getStartOffset();
        this.endOffset = textRange.getEndOffset();
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(21);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(@NotNull ASTNode node2) {
        if (node2 == null) {
            HighlightInfoB.$$$reportNull$$$0(22);
        }
        HighlightInfo.Builder builder2 = this.range(node2.getPsi());
        if (builder2 == null) {
            HighlightInfoB.$$$reportNull$$$0(23);
        }
        return builder2;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(@NotNull PsiElement element) {
        if (element == null) {
            HighlightInfoB.$$$reportNull$$$0(24);
        }
        this.assertNotCreated();
        assert (this.psiElement == null) : " psiElement already set";
        this.psiElement = element;
        HighlightInfo.Builder builder2 = this.range(element.getTextRange());
        if (builder2 == null) {
            HighlightInfoB.$$$reportNull$$$0(25);
        }
        return builder2;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(@NotNull PsiElement element, @NotNull TextRange rangeInElement) {
        if (element == null) {
            HighlightInfoB.$$$reportNull$$$0(26);
        }
        if (rangeInElement == null) {
            HighlightInfoB.$$$reportNull$$$0(27);
        }
        TextRange absoluteRange = rangeInElement.shiftRight(element.getTextRange().getStartOffset());
        HighlightInfo.Builder builder2 = this.range(element, absoluteRange.getStartOffset(), absoluteRange.getEndOffset());
        if (builder2 == null) {
            HighlightInfoB.$$$reportNull$$$0(28);
        }
        return builder2;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(@NotNull PsiElement element, int start, int end) {
        if (element == null) {
            HighlightInfoB.$$$reportNull$$$0(29);
        }
        this.assertNotCreated();
        assert (this.psiElement == null) : " psiElement already set";
        this.psiElement = element;
        HighlightInfo.Builder builder2 = this.range(start, end);
        if (builder2 == null) {
            HighlightInfoB.$$$reportNull$$$0(30);
        }
        return builder2;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder endOfLine() {
        this.assertNotCreated();
        this.isAfterEndOfLine = true;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(31);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder needsUpdateOnTyping(boolean update2) {
        this.assertNotCreated();
        assert (this.myNeedsUpdateOnTyping == null) : " needsUpdateOnTyping already set";
        this.myNeedsUpdateOnTyping = update2;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(32);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder severity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfoB.$$$reportNull$$$0(33);
        }
        this.assertNotCreated();
        assert (this.severity == null) : " severity already set";
        this.severity = severity;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(34);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder fileLevelAnnotation() {
        this.assertNotCreated();
        this.isFileLevelAnnotation = true;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(35);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder navigationShift(int navigationShift) {
        this.assertNotCreated();
        this.navigationShift = navigationShift;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(36);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder group(int group2) {
        this.assertNotCreated();
        this.group = group2;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(37);
        }
        return highlightInfoB;
    }

    void setUnresolvedReference(@NotNull PsiReference ref) {
        if (ref == null) {
            HighlightInfoB.$$$reportNull$$$0(38);
        }
        this.unresolvedReference = ref;
    }

    @Override
    public @NotNull HighlightInfo.Builder registerFix(@NotNull IntentionAction action2, @Nullable List<? extends IntentionAction> options2, @Nls @Nullable String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        if (action2 == null) {
            HighlightInfoB.$$$reportNull$$$0(39);
        }
        this.assertNotCreated();
        this.fixes.add(new FixInfo(action2, options2, displayName, fixRange, key));
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(40);
        }
        return highlightInfoB;
    }

    @Override
    @Nullable
    public HighlightInfo create() {
        HighlightInfo info2 = this.createUnconditionally();
        LOG.assertTrue(this.psiElement != null || this.severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY || this.severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || ArrayUtil.find(HighlightSeverity.DEFAULT_SEVERITIES, this.severity) != -1, "Custom type requires not-null element to detect its text attributes");
        return HighlightInfoB.isAcceptedByFilters(info2, this.psiElement) ? info2 : null;
    }

    @Override
    @NotNull
    public HighlightInfo createUnconditionally() {
        this.assertNotCreated();
        this.created = true;
        if (this.severity == null) {
            this.severity = this.type.getSeverity(this.psiElement);
        }
        HighlightInfo info2 = new HighlightInfo(this.forcedTextAttributes, this.forcedTextAttributesKey, this.type, this.startOffset, this.endOffset, this.escapedDescription, this.escapedToolTip, this.severity, this.isAfterEndOfLine, this.myNeedsUpdateOnTyping, this.isFileLevelAnnotation, this.navigationShift, this.problemGroup, this.inspectionToolId, (GutterMark)this.gutterIconRenderer, this.group, this.unresolvedReference, this.psiElement);
        for (FixInfo fix2 : this.fixes) {
            info2.registerFix(fix2.action(), fix2.options(), fix2.displayName(), fix2.fixRange(), fix2.key());
        }
        HighlightInfo highlightInfo = info2;
        if (highlightInfo == null) {
            HighlightInfoB.$$$reportNull$$$0(41);
        }
        return highlightInfo;
    }

    @Nullable
    @NlsContexts.Tooltip
    private static String htmlEscapeToolTip(@Nullable @NlsContexts.Tooltip String unescapedTooltip) {
        return unescapedTooltip == null ? null : XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(unescapedTooltip));
    }

    private static boolean isAcceptedByFilters(@NotNull HighlightInfo info2, @Nullable PsiElement psiElement) {
        if (info2 == null) {
            HighlightInfoB.$$$reportNull$$$0(42);
        }
        PsiFile file2 = psiElement == null ? null : psiElement.getContainingFile();
        for (HighlightInfoFilter filter2 : HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions()) {
            if (filter2.accept(info2, file2)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 10, 12, 14, 16, 18, 19, 21, 23, 25, 28, 30, 31, 32, 34, 35, 36, 37, 40, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutterIconRenderer";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfoB";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolId";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unescapedToolTip";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedToolTip";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoB";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "gutterIconRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "problemGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectionToolId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "description";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "descriptionAndTooltip";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "textAttributes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapedToolTip";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "escapedToolTip";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "range";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "endOfLine";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "needsUpdateOnTyping";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "severity";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "fileLevelAnnotation";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "navigationShift";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFix";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnconditionally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "gutterIconRenderer";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "problemGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inspectionToolId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "description";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "descriptionAndTooltip";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "textAttributes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unescapedToolTip";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "escapedToolTip";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "range";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "severity";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setUnresolvedReference";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "registerFix";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedByFilters";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4, 6, 8, 10, 12, 14, 16, 18, 19, 21, 23, 25, 28, 30, 31, 32, 34, 35, 36, 37, 40, 41 -> new IllegalStateException(string2);
        };
    }

    private record FixInfo(@NotNull IntentionAction action, @Nullable List<? extends IntentionAction> options, @Nls @Nullable String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        @NotNull
        private final IntentionAction action;

        private FixInfo(@NotNull IntentionAction action2, @Nullable List<? extends IntentionAction> options2, @Nls @Nullable String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
            if (action2 == null) {
                FixInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public IntentionAction action() {
            IntentionAction intentionAction = this.action;
            if (intentionAction == null) {
                FixInfo.$$$reportNull$$$0(1);
            }
            return intentionAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfoB$FixInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoB$FixInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

