/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitor;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.diagnostic.telemetry.IJTracer;
import com.intellij.diagnostic.telemetry.TraceKt;
import com.intellij.diagnostic.telemetry.TraceManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import io.opentelemetry.api.trace.Tracer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HighlightVisitorBasedInspection
extends GlobalSimpleInspectionTool {
    public static final String SHORT_NAME = "Annotator";
    public boolean highlightErrorElements = true;
    public boolean runAnnotators = true;
    public boolean runVisitors = false;

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane(OptPane.checkbox("highlightErrorElements", InspectionsBundle.message("inspection.annotator.option.highlight.syntax", new Object[0]), new OptRegularComponent[0]), OptPane.checkbox("runAnnotators", InspectionsBundle.message("inspection.annotator.option.run.annotators", new Object[0]), new OptRegularComponent[0]), OptPane.checkbox("runVisitors", InspectionsBundle.message("inspection.annotator.option.run.highlight.visitors", new Object[0]), new OptRegularComponent[0]));
        if (optPane == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public HighlightVisitorBasedInspection setHighlightErrorElements(boolean value) {
        this.highlightErrorElements = value;
        HighlightVisitorBasedInspection highlightVisitorBasedInspection = this;
        if (highlightVisitorBasedInspection == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(1);
        }
        return highlightVisitorBasedInspection;
    }

    @NotNull
    public HighlightVisitorBasedInspection setRunAnnotators(boolean value) {
        this.runAnnotators = value;
        HighlightVisitorBasedInspection highlightVisitorBasedInspection = this;
        if (highlightVisitorBasedInspection == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(2);
        }
        return highlightVisitorBasedInspection;
    }

    @NotNull
    public HighlightVisitorBasedInspection setRunVisitors(boolean value) {
        this.runVisitors = value;
        HighlightVisitorBasedInspection highlightVisitorBasedInspection = this;
        if (highlightVisitorBasedInspection == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(3);
        }
        return highlightVisitorBasedInspection;
    }

    @Override
    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    @Override
    public void checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (psiFile == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(6);
        }
        if (problemsHolder == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(8);
        }
        if (problemDescriptionsProcessor == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(9);
        }
        for (HighlightInfo info2 : HighlightVisitorBasedInspection.runAnnotatorsInGeneralHighlighting(psiFile, this.highlightErrorElements, this.runAnnotators, this.runVisitors)) {
            PsiElement element;
            TextRange range = new TextRange(info2.startOffset, info2.endOffset);
            for (element = psiFile.findElementAt(info2.startOffset); element != null && !element.getTextRange().contains(range); element = element.getParent()) {
            }
            if (element == null) {
                element = psiFile;
            }
            GlobalInspectionUtil.createProblem(element, info2, range.shiftRight(-element.getNode().getStartOffset()), info2.getProblemGroup(), manager, problemDescriptionsProcessor, globalContext);
        }
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string2 = HighlightVisitorBasedInspection.getGeneralGroupName();
        if (string2 == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    private static List<HighlightInfo> runAnnotatorsInGeneralHighlighting(@NotNull PsiFile file2, boolean highlightErrorElements, boolean runAnnotators, boolean runVisitors) {
        Project project2;
        Document document;
        if (file2 == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(11);
        }
        if ((document = PsiDocumentManager.getInstance(project2 = file2.getProject()).getDocument(file2)) == null) {
            List<HighlightInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                HighlightVisitorBasedInspection.$$$reportNull$$$0(12);
            }
            return list2;
        }
        ProgressIndicator progress = ProgressManager.getGlobalProgressIndicator();
        DaemonProgressIndicator daemonProgressIndicator = GlobalInspectionContextBase.assertUnderDaemonProgress();
        HighlightingSessionImpl.getOrCreateHighlightingSession(file2, daemonProgressIndicator, ProperTextRange.create(file2.getTextRange()));
        TextEditorHighlightingPassRegistrarEx passRegistrarEx = TextEditorHighlightingPassRegistrarEx.getInstanceEx(project2);
        List<TextEditorHighlightingPass> passes = passRegistrarEx.instantiateMainPasses(file2, document, HighlightInfoProcessor.getEmpty());
        List<GeneralHighlightingPass> gpasses = ContainerUtil.filterIsInstance(passes, GeneralHighlightingPass.class);
        if (!runVisitors) {
            for (GeneralHighlightingPass gpass : gpasses) {
                gpass.setHighlightVisitorProducer(() -> {
                    gpass.incVisitorUsageCount(1);
                    DefaultHighlightVisitor visitor2 = new DefaultHighlightVisitor(project2, highlightErrorElements, runAnnotators, true);
                    return new HighlightVisitor[]{visitor2};
                });
            }
        }
        String fileName = file2.getName();
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>();
        IJTracer tracer2 = TraceManager.INSTANCE.getTracer("highlightVisitor", true);
        for (TextEditorHighlightingPass textEditorHighlightingPass : gpasses) {
            TraceKt.runWithSpan((Tracer)tracer2, (String)textEditorHighlightingPass.getClass().getSimpleName(), span -> {
                span.setAttribute("file", fileName);
                pass2.doCollectInformation(progress);
                List<HighlightInfo> infos = pass2.getInfos();
                for (HighlightInfo info2 : infos) {
                    if (info2 == null || info2.getSeverity().compareTo(HighlightSeverity.INFORMATION) <= 0) continue;
                    result2.add(info2);
                }
            });
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 7, 8, 9, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightVisitorBasedInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setHighlightErrorElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setRunAnnotators";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setRunVisitors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightVisitorBasedInspection";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "runAnnotatorsInGeneralHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotatorsInGeneralHighlighting";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 5, 6, 7, 8, 9, 11 -> new IllegalArgumentException(string2);
        };
    }
}

